/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.TagFactory;
import com.compomics.util.experiment.identification.protein_inference.proteintree.Node;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ProteinTree {
    private int memoryAllocation;
    private static final long cacheScale = 12000L;
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private HashMap<String, Node> tree = new HashMap();
    private ArrayList<String> tagsInTree = new ArrayList();
    private long treeSize = 0L;
    private boolean debugSpeed = false;
    private BufferedWriter debugSpeedWriter = null;
    private ProteinTreeComponentsFactory componentsFactory = null;
    private int cacheSize = 10000;
    private HashMap<String, HashMap<String, ArrayList<Integer>>> lastQueriedPeptidesCache = new HashMap(this.cacheSize);
    private ArrayList<String> lastQueriedPeptidesCacheContent = new ArrayList(this.cacheSize);
    private int queryTimeThreshold = 50;
    private HashMap<String, HashMap<String, ArrayList<Integer>>> lastSlowQueriedPeptidesCache = new HashMap(this.cacheSize);
    private ArrayList<String> lastSlowQueriedPeptidesCacheContent = new ArrayList(this.cacheSize);
    public static final String version = "1.0.0";

    public ProteinTree(int memoryAllocation) throws IOException {
        this.memoryAllocation = memoryAllocation;
        if (this.debugSpeed) {
            try {
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File("dbSpeed.txt")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initiateTree(int initialTagSize, int maxNodeSize, int maxPeptideSize, WaitingHandler waitingHandler, boolean printExpectedImportTime) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        this.initiateTree(initialTagSize, maxNodeSize, maxPeptideSize, null, waitingHandler, printExpectedImportTime);
    }

    public void initiateTree(int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean printExpectedImportTime) throws IOException, IllegalArgumentException, InterruptedException, IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        this.tree.clear();
        this.componentsFactory = ProteinTreeComponentsFactory.getInstance();
        try {
            boolean needImport;
            try {
                boolean bl = needImport = !this.componentsFactory.initiate();
                if (!needImport) {
                    this.componentsFactory.loadParameters();
                    if (this.componentsFactory.isCorrupted()) {
                        throw new IllegalArgumentException("Database is corrupted. Tree will be reindexed.");
                    }
                    if (!this.componentsFactory.importComplete()) {
                        throw new IllegalArgumentException("Database import was not successfully completed. Tree will be reindexed.");
                    }
                    String tempVersion = this.componentsFactory.getVersion();
                    if (tempVersion == null || !tempVersion.equals(version)) {
                        throw new IllegalArgumentException("Database version " + tempVersion + " obsolete. Tree will be reindexed.");
                    }
                    if (initialTagSize != this.componentsFactory.getInitialSize()) {
                        throw new IllegalArgumentException("Different initial size. Tree will be reindexed.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                needImport = true;
                this.componentsFactory.delete();
                this.componentsFactory.initiate();
            }
            if (needImport) {
                this.importDb(initialTagSize, maxNodeSize, maxPeptideSize, enzyme, waitingHandler, printExpectedImportTime);
            } else {
                this.componentsFactory.loadProteinLenths();
            }
        }
        catch (IOException e) {
            this.componentsFactory.delete();
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.componentsFactory.delete();
            throw e;
        }
        catch (InterruptedException e) {
            this.componentsFactory.delete();
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.componentsFactory.delete();
            throw e;
        }
        catch (SQLException e) {
            this.componentsFactory.delete();
            throw e;
        }
    }

    private void importDb(int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean printExpectedImportTime) throws IOException, IllegalArgumentException, InterruptedException, IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        int nTags;
        long capacity;
        long tagsSize;
        long criticalSize;
        long estimatedTreeSize;
        int ratio;
        ArrayList<Object> accessions;
        if (printExpectedImportTime && waitingHandler != null && waitingHandler.isReport() && (initialTagSize == 3 || initialTagSize == 4)) {
            String report = "Expected import time: ";
            int nSeconds = initialTagSize == 3 ? this.sequenceFactory.getNTargetSequences() * 15 / 1000 : this.sequenceFactory.getNTargetSequences() * 2 / 10;
            if (nSeconds < 120) {
                report = report + nSeconds + " seconds. (First time only.)";
            } else {
                int nMinutes = nSeconds / 60;
                if (nMinutes < 120) {
                    report = report + nMinutes + " minutes. (First time only.)";
                } else {
                    int nHours = nMinutes / 60;
                    report = report + nHours + " hours. (First time only.)";
                }
            }
            waitingHandler.appendReport(report, true, true);
        }
        this.componentsFactory.saveInitialSize(initialTagSize);
        ArrayList<String> tags = TagFactory.getAminoAcidCombinations(initialTagSize);
        if (this.sequenceFactory.isDefaultReversed()) {
            accessions = new ArrayList();
            for (String accession : this.sequenceFactory.getAccessions()) {
                if (this.sequenceFactory.isDecoyAccession(accession)) continue;
                accessions.add(accession);
            }
        } else {
            accessions = this.sequenceFactory.getAccessions();
        }
        if ((ratio = (int)((estimatedTreeSize = 6L * (criticalSize = (tagsSize = 500L) * (long)accessions.size())) / (capacity = (long)this.memoryAllocation * 12000L))) == 0) {
            ratio = 1;
        }
        int nPassages = ratio;
        if (tags.size() % ratio != 0) {
            ++nPassages;
        }
        if (ratio > 0) {
            nTags = tags.size() / ratio;
            if (nTags == 0) {
                nTags = 1;
            }
        } else {
            nTags = tags.size();
        }
        if (nPassages > 1) {
            // empty if block
        }
        if (this.debugSpeed) {
            this.debugSpeedWriter.write("Critical size: " + criticalSize);
            System.out.println("Critical size: " + criticalSize);
            this.debugSpeedWriter.write("Estimated tree size: " + (estimatedTreeSize /= 100L));
            System.out.println("Estimated tree size: " + estimatedTreeSize);
            this.debugSpeedWriter.write(new Date() + " " + nPassages + " passages needed (" + nTags + " tags of " + tags.size() + " per passage)");
            System.out.println(new Date() + " " + nPassages + " passages needed (" + nTags + " tags of " + tags.size() + " per passage)");
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            int totalProgress = nPassages * accessions.size() + tags.size();
            waitingHandler.setMaxSecondaryProgressCounter(totalProgress);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        long time0 = System.currentTimeMillis();
        ArrayList<String> tempTags = new ArrayList<String>(nTags);
        int tagsLoaded = 0;
        ArrayList<String> loadedAccessions = new ArrayList<String>();
        for (String tag : tags) {
            if (tempTags.size() == nTags) {
                this.loadTags(tempTags, accessions, waitingHandler, initialTagSize, maxNodeSize, maxPeptideSize, enzyme, loadedAccessions);
                tagsLoaded += tempTags.size();
                tempTags.clear();
                if (this.sequenceFactory.getnCache() < accessions.size()) {
                    Collections.reverse(accessions);
                }
                if (this.debugSpeed) {
                    this.debugSpeedWriter.write(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                    System.out.println(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                    this.debugSpeedWriter.newLine();
                    this.debugSpeedWriter.flush();
                }
            }
            tempTags.add(tag);
        }
        if (!tempTags.isEmpty()) {
            this.loadTags(tempTags, accessions, waitingHandler, initialTagSize, maxNodeSize, maxPeptideSize, enzyme, loadedAccessions);
            if (this.debugSpeed) {
                this.debugSpeedWriter.write(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                System.out.println(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                this.debugSpeedWriter.newLine();
                this.debugSpeedWriter.flush();
            }
        }
        this.tagsInTree.addAll(this.tree.keySet());
        for (Node node : this.tree.values()) {
            this.treeSize += node.getSize();
        }
        this.componentsFactory.setVersion(version);
        this.componentsFactory.setImportComplete(true);
        if (this.debugSpeed) {
            long time1 = System.currentTimeMillis();
            long initiationTime = time1 - time0;
            this.debugSpeedWriter.write("tree initiation: " + initiationTime + " ms.");
            System.out.println("tree initiation: " + initiationTime + " ms.");
            this.debugSpeedWriter.write("tree size: " + this.tree.size() + " tags, " + this.treeSize + " node.accession loaded and saved.");
            System.out.println("tree size: " + this.tree.size() + " tags, " + this.treeSize + " node.accession loaded and saved.");
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
    }

    private void loadTags(ArrayList<String> tags, ArrayList<String> accessions, WaitingHandler waitingHandler, int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, ArrayList<String> loadedAccessions) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        for (String accession : accessions) {
            String sequence = this.sequenceFactory.getProtein(accession).getSequence();
            if (!loadedAccessions.contains(accession)) {
                this.componentsFactory.saveProteinLength(accession, sequence.length());
                loadedAccessions.add(accession);
            }
            HashMap<String, ArrayList<Integer>> tagToIndexesMap = this.getTagToIndexesMap(sequence, tags, enzyme);
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            for (String tag : tagToIndexesMap.keySet()) {
                ArrayList<Integer> indexes = tagToIndexesMap.get(tag);
                if (indexes.isEmpty()) continue;
                Node node = this.tree.get(tag);
                if (node == null) {
                    node = new Node(initialTagSize);
                    this.tree.put(tag, node);
                }
                node.addAccession(accession, tagToIndexesMap.get(tag));
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.increaseSecondaryProgressCounter();
        }
        for (String tag : tags) {
            Node node = this.tree.get(tag);
            if (node != null) {
                node.splitNode(maxNodeSize, maxPeptideSize);
                this.componentsFactory.saveNode(tag, node);
                this.tree.remove(tag);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.increaseSecondaryProgressCounter();
        }
    }

    private HashMap<String, ArrayList<Integer>> getTagToIndexesMap(String sequence, ArrayList<String> tags, Enzyme enzyme) throws SQLException, IOException, ClassNotFoundException {
        HashMap<String, ArrayList<Integer>> tagToIndexesMap = new HashMap<String, ArrayList<Integer>>(tags.size());
        Integer initialTagSize = this.componentsFactory.getInitialSize();
        for (String tag : tags) {
            tagToIndexesMap.put(tag, new ArrayList());
        }
        for (int i = 0; i < sequence.length() - initialTagSize; ++i) {
            if (enzyme != null && i != 0 && !enzyme.isCleavageSite(sequence.charAt(i - 1), sequence.charAt(i))) continue;
            char[] tagValue = new char[initialTagSize.intValue()];
            for (int j = 0; j < initialTagSize; ++j) {
                char aa;
                tagValue[j] = aa = sequence.charAt(i + j);
            }
            String tag = new String(tagValue);
            ArrayList<Integer> indexes = tagToIndexesMap.get(tag);
            if (indexes == null) continue;
            indexes.add(i);
        }
        return tagToIndexesMap;
    }

    public HashMap<String, ArrayList<Integer>> getProteinMapping(String peptideSequence) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        long time0 = 0L;
        if (this.debugSpeed) {
            time0 = System.currentTimeMillis();
        }
        HashMap<String, ArrayList<Integer>> result = this.getProteinMapping(peptideSequence, false);
        if (this.debugSpeed) {
            long time1 = System.currentTimeMillis();
            long queryTime = time1 - time0;
            this.debugSpeedWriter.write(peptideSequence + "\t" + result.size() + "\t" + queryTime);
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
        return result;
    }

    private HashMap<String, ArrayList<Integer>> getProteinMapping(String peptideSequence, boolean reversed) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        HashMap<String, ArrayList<Integer>> result = this.lastQueriedPeptidesCache.get(peptideSequence);
        if (result != null) {
            this.lastQueriedPeptidesCacheContent.remove(peptideSequence);
            this.lastQueriedPeptidesCacheContent.add(peptideSequence);
        } else {
            result = this.lastSlowQueriedPeptidesCache.get(peptideSequence);
            if (result != null) {
                this.lastSlowQueriedPeptidesCacheContent.remove(peptideSequence);
                this.lastSlowQueriedPeptidesCacheContent.add(peptideSequence);
            } else {
                if (this.sequenceFactory.isDefaultReversed()) {
                    String reversedSequence = SequenceFactory.reverseSequence(peptideSequence);
                    result = this.lastQueriedPeptidesCache.get(reversedSequence);
                    if (result != null) {
                        this.lastQueriedPeptidesCacheContent.remove(peptideSequence);
                        this.lastQueriedPeptidesCacheContent.add(peptideSequence);
                    } else {
                        result = this.lastSlowQueriedPeptidesCache.get(reversedSequence);
                        if (result != null) {
                            this.lastSlowQueriedPeptidesCacheContent.remove(peptideSequence);
                            this.lastSlowQueriedPeptidesCacheContent.add(peptideSequence);
                        }
                    }
                    if (result != null) {
                        return this.getReversedResults(result, peptideSequence);
                    }
                }
                long timeStart = System.currentTimeMillis();
                int initialTagSize = this.componentsFactory.getInitialSize();
                if (peptideSequence.length() < initialTagSize) {
                    throw new IllegalArgumentException("Peptide (" + peptideSequence + ") should be at least of length " + initialTagSize + ".");
                }
                result = new HashMap();
                String tag = peptideSequence.substring(0, initialTagSize);
                Node node = this.getNode(tag);
                if (node != null) {
                    result.putAll(node.getProteinMapping(peptideSequence));
                }
                if (this.sequenceFactory.isDefaultReversed() && !reversed) {
                    String reversedSequence = SequenceFactory.reverseSequence(peptideSequence);
                    if (!peptideSequence.equals(reversedSequence)) {
                        HashMap<String, ArrayList<Integer>> reversedResult = this.getProteinMapping(reversedSequence, true);
                        result.putAll(this.getReversedResults(reversedResult, reversedSequence));
                    } else {
                        result.putAll(this.getReversedResults(result, reversedSequence));
                    }
                }
                if (!reversed) {
                    long timeEnd = System.currentTimeMillis();
                    long queryTime = timeEnd - timeStart;
                    if (queryTime <= (long)this.queryTimeThreshold) {
                        this.lastQueriedPeptidesCache.put(peptideSequence, result);
                        this.lastQueriedPeptidesCacheContent.add(peptideSequence);
                        if (this.lastQueriedPeptidesCacheContent.size() > this.cacheSize) {
                            String key = this.lastQueriedPeptidesCacheContent.get(0);
                            this.lastQueriedPeptidesCache.remove(key);
                            this.lastQueriedPeptidesCacheContent.remove(0);
                        }
                    } else {
                        this.lastSlowQueriedPeptidesCache.put(peptideSequence, result);
                        this.lastSlowQueriedPeptidesCacheContent.add(peptideSequence);
                        if (this.lastSlowQueriedPeptidesCacheContent.size() > this.cacheSize) {
                            String key = this.lastSlowQueriedPeptidesCacheContent.get(0);
                            this.lastSlowQueriedPeptidesCache.remove(key);
                            this.lastSlowQueriedPeptidesCacheContent.remove(0);
                        }
                    }
                }
            }
        }
        return result;
    }

    private HashMap<String, ArrayList<Integer>> getReversedResults(HashMap<String, ArrayList<Integer>> forwardResults, String peptideSequence) throws SQLException, ClassNotFoundException, IOException {
        int peptideLength = peptideSequence.length();
        HashMap<String, ArrayList<Integer>> results = new HashMap<String, ArrayList<Integer>>(forwardResults.keySet().size());
        for (String accession : forwardResults.keySet()) {
            Integer proteinLength;
            String newAccession;
            if (accession.endsWith(SequenceFactory.getDefaultDecoyAccessionSuffix())) {
                newAccession = SequenceFactory.getDefaultTargetAccession(accession);
                proteinLength = this.componentsFactory.getProteinLength(newAccession);
                if (proteinLength == null) {
                    throw new IllegalArgumentException("Length of protein " + newAccession + " not found.");
                }
            } else {
                newAccession = SequenceFactory.getDefaultDecoyAccession(accession);
                proteinLength = this.componentsFactory.getProteinLength(accession);
                if (proteinLength == null) {
                    throw new IllegalArgumentException("Length of protein " + accession + " not found.");
                }
            }
            ArrayList<Integer> reversedIndexes = new ArrayList<Integer>();
            for (int index : forwardResults.get(accession)) {
                int reversedIndex = proteinLength - index - peptideLength;
                if (reversedIndex < 0 || reversedIndex >= proteinLength) {
                    throw new IllegalArgumentException("Wrong index found for peptide " + peptideSequence + " in protein " + newAccession + ": " + reversedIndex + ".");
                }
                reversedIndexes.add(reversedIndex);
            }
            results.put(newAccession, reversedIndexes);
        }
        return results;
    }

    private Node getNode(String tag) throws SQLException, ClassNotFoundException, IOException {
        Node result = this.tree.get(tag);
        if (result == null && (result = this.componentsFactory.getNode(tag)) != null) {
            long capacity = (long)this.memoryAllocation * 12000L;
            while (this.treeSize > capacity && !this.tagsInTree.isEmpty()) {
                int index = this.tagsInTree.size() - 1;
                String tempTag = this.tagsInTree.get(index);
                Node tempNode = this.tree.get(tempTag);
                this.treeSize -= tempNode.getSize();
                this.tree.remove(tempTag);
                this.tagsInTree.remove(index);
            }
            this.tree.put(tag, result);
            this.treeSize += result.getSize();
            this.tagsInTree.add(0, tag);
        }
        return result;
    }

    public void close() throws IOException, SQLException {
        if (this.debugSpeed) {
            try {
                this.debugSpeedWriter.flush();
                this.debugSpeedWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.emptyCache();
        this.componentsFactory.close();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void emptyCache() {
        this.tree.clear();
        this.tagsInTree.clear();
        this.lastQueriedPeptidesCache.clear();
        this.lastQueriedPeptidesCacheContent.clear();
        this.lastSlowQueriedPeptidesCache.clear();
        this.lastSlowQueriedPeptidesCacheContent.clear();
    }

    public PeptideIterator getPeptideIterator() throws SQLException, IOException, ClassNotFoundException {
        return new PeptideIterator();
    }

    public class PeptideIterator
    implements Iterator {
        private Integer initialTagSize;
        private ArrayList<String> tags;
        private Node currentNode = null;
        private Node parentNode = null;
        private String currentSequence = null;
        private ArrayList<Character> aas = null;
        private int i = -1;
        private int j = 0;

        private PeptideIterator() throws SQLException, IOException, ClassNotFoundException {
            this.initialTagSize = ProteinTree.this.componentsFactory.getInitialSize();
            this.tags = TagFactory.getAminoAcidCombinations(this.initialTagSize);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.currentNode != null && this.currentNode.getDepth() == this.initialTagSize.intValue() && this.currentNode.getAccessions() != null && this.i < this.tags.size() - 1) {
                    this.parentNode = null;
                    this.aas = null;
                    this.j = 0;
                    this.currentSequence = this.tags.get(++this.i);
                    this.currentNode = ProteinTree.this.getNode(this.currentSequence);
                }
                while (++this.i < this.tags.size() && this.currentNode == null && this.parentNode == null) {
                    this.currentSequence = this.tags.get(this.i);
                    this.currentNode = ProteinTree.this.getNode(this.currentSequence);
                }
                if (this.i < this.tags.size()) {
                    if (this.aas != null) {
                        int parentDepth = this.currentSequence.length() - 1;
                        this.currentSequence = this.currentSequence.substring(0, parentDepth);
                        if (++this.j == this.aas.size()) {
                            if (!this.parentNode.getTermini().isEmpty()) {
                                this.currentNode = null;
                                return true;
                            }
                            ++this.j;
                        }
                        if (this.j == this.aas.size() + 1) {
                            if (parentDepth <= this.initialTagSize) {
                                this.currentSequence = null;
                                this.currentNode = null;
                                this.parentNode = null;
                                this.aas = null;
                                this.j = 0;
                            } else {
                                parentDepth = this.currentSequence.length() - 1;
                                String parentSequence = this.currentSequence.substring(0, parentDepth);
                                char aa = this.currentSequence.charAt(parentDepth);
                                if (parentDepth == this.initialTagSize) {
                                    this.parentNode = ProteinTree.this.getNode(parentSequence);
                                } else {
                                    String tag = parentSequence.substring(0, this.initialTagSize);
                                    this.parentNode = ProteinTree.this.getNode(tag).getSubNode(parentSequence);
                                }
                                this.currentNode = this.parentNode.getSubtree().get(Character.valueOf(aa));
                                this.aas = new ArrayList<Character>(this.parentNode.getSubtree().keySet());
                                Collections.sort(this.aas);
                                this.j = this.aas.indexOf(Character.valueOf(aa));
                            }
                            return this.hasNext();
                        }
                        char aa = this.aas.get(this.j).charValue();
                        this.currentSequence = this.currentSequence + aa;
                        this.currentNode = this.parentNode.getSubtree().get(Character.valueOf(aa));
                    }
                    if (this.currentNode == null) {
                        boolean debug = true;
                    }
                    while (this.currentNode.getAccessions() == null) {
                        this.j = 0;
                        this.aas = new ArrayList<Character>(this.currentNode.getSubtree().keySet());
                        this.parentNode = this.currentNode;
                        if (!this.aas.isEmpty()) {
                            Collections.sort(this.aas);
                            char aa = this.aas.get(this.j).charValue();
                            this.currentSequence = this.currentSequence + aa;
                            this.currentNode = this.currentNode.getSubtree().get(Character.valueOf(aa));
                            continue;
                        }
                        this.currentNode = null;
                        return true;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("An error occurred while iterating the tree. See previous exception.");
            }
        }

        public Object next() {
            return this.currentSequence;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ProteinTrees are not editable.");
        }

        public HashMap<String, ArrayList<Integer>> getMapping() {
            if (this.currentNode != null) {
                return this.currentNode.getAccessions();
            }
            return this.parentNode.getTermini();
        }
    }
}

