/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.util.ArrayList;
import java.util.HashMap;

public class PtmtableContent {
    private HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> map = new HashMap();
    private double totalIntensity = 0.0;
    private double maxIntensity = 0.0;

    public void addIntensity(int nMod, Integer peptideFragmentIonType, int aa, double intensity) {
        if (!this.map.containsKey(nMod)) {
            this.map.put(nMod, new HashMap());
        }
        if (!this.map.get(nMod).containsKey(peptideFragmentIonType)) {
            this.map.get(nMod).put(peptideFragmentIonType, new HashMap());
        }
        if (!this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            this.map.get(nMod).get(peptideFragmentIonType).put(aa, new ArrayList());
        }
        this.map.get(nMod).get(peptideFragmentIonType).get(aa).add(intensity);
        this.totalIntensity += intensity;
        if (intensity > this.maxIntensity) {
            this.maxIntensity = intensity;
        }
    }

    public ArrayList<Double> getIntensities(int nMod, Integer peptideFragmentIonType, int aa) {
        if (this.map.containsKey(nMod) && this.map.get(nMod).containsKey(peptideFragmentIonType) && this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            return this.map.get(nMod).get(peptideFragmentIonType).get(aa);
        }
        return new ArrayList<Double>();
    }

    public Double getQuantile(int nMod, Integer peptideFragmentIonType, int aa, double quantile) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        if (intensities.size() > 0) {
            int index = (int)(quantile * (double)intensities.size());
            return intensities.get(index);
        }
        return 0.0;
    }

    public int[] getHistogram(int nMod, Integer peptideFragmentIonType, int aa, int bins) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        int[] values = new int[bins];
        if (intensities.size() > 0) {
            for (int i = 0; i < intensities.size(); ++i) {
                double currentIntensity = intensities.get(i);
                for (int j = 0; j < bins; ++j) {
                    double index = j;
                    if (!(index / (double)bins < currentIntensity) || !(currentIntensity < (index + 1.0) / (double)bins)) continue;
                    int n = j;
                    values[n] = values[n] + 1;
                }
                if (currentIntensity != 1.0) continue;
                int n = values.length - 1;
                values[n] = values[n] + 1;
            }
            return values;
        }
        return values;
    }

    public HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> getMap() {
        return this.map;
    }

    public void addAll(PtmtableContent anotherContent) {
        for (int nPTM : anotherContent.getMap().keySet()) {
            for (Integer peptideFragmentIonType : anotherContent.getMap().get(nPTM).keySet()) {
                for (int nAA : anotherContent.getMap().get(nPTM).get(peptideFragmentIonType).keySet()) {
                    for (double intensity : anotherContent.getIntensities(nPTM, peptideFragmentIonType, nAA)) {
                        this.addIntensity(nPTM, peptideFragmentIonType, nAA, intensity);
                    }
                }
            }
        }
    }

    public void normalize() {
        if (this.totalIntensity > 0.0) {
            double normalization = this.totalIntensity;
            this.totalIntensity = 0.0;
            this.maxIntensity = 0.0;
            for (int nPTM : this.map.keySet()) {
                for (Integer peptideFragmentIonType : this.map.get(nPTM).keySet()) {
                    for (int nAA : this.map.get(nPTM).get(peptideFragmentIonType).keySet()) {
                        ArrayList<Double> tempIntensities = new ArrayList<Double>();
                        for (double intensity : this.getIntensities(nPTM, peptideFragmentIonType, nAA)) {
                            tempIntensities.add(intensity / normalization);
                        }
                        this.map.get(nPTM).get(peptideFragmentIonType).put(nAA, tempIntensities);
                    }
                }
            }
        }
    }

    public double getMaxIntensity() {
        return this.maxIntensity;
    }

    public static HashMap<PeptideFragmentIon, ArrayList<IonMatch>> getPTMPlotData(Peptide peptide, PTM ptm, int nPTM, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, double intensityLimit) {
        Peptide noModPeptide = new Peptide(peptide.getSequence(), peptide.getParentProteins(), new ArrayList<ModificationMatch>());
        for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
            if (modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
            noModPeptide.addModificationMatch(modificationMatch);
        }
        SpectrumAnnotator spectrumAnnotator = new SpectrumAnnotator();
        HashMap<Integer, ArrayList<Ion>> fragmentIons = spectrumAnnotator.getExpectedIons(iontypes, neutralLosses, charges, precursorCharge, noModPeptide);
        HashMap<PeptideFragmentIon, ArrayList<IonMatch>> map = new HashMap<PeptideFragmentIon, ArrayList<IonMatch>>();
        for (int i = 0; i <= nPTM; ++i) {
            spectrumAnnotator.setMassShift((double)i * ptm.getMass());
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, precursorCharge, spectrum, noModPeptide, intensityLimit, mzTolerance, false);
            block2: for (IonMatch ionMatch : matches) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                for (Ion noModIon : fragmentIons.get(ionMatch.charge.value)) {
                    if (noModIon.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !peptideFragmentIon.isSameAs(noModIon)) continue;
                    PeptideFragmentIon noModFragmentIon = (PeptideFragmentIon)noModIon;
                    if (!map.containsKey(noModFragmentIon)) {
                        map.put(noModFragmentIon, new ArrayList());
                    }
                    map.get(noModFragmentIon).add(ionMatch);
                    continue block2;
                }
            }
        }
        return map;
    }

    public static PtmtableContent getPTMTableContent(Peptide peptide, PTM ptm, int nPTM, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, double intensityLimit) {
        PtmtableContent ptmTableContent = new PtmtableContent();
        Peptide noModPeptide = new Peptide(peptide.getSequence(), peptide.getParentProteins(), new ArrayList<ModificationMatch>());
        for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
            if (modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
            noModPeptide.addModificationMatch(modificationMatch);
        }
        NeutralLossesMap lossesMap = new NeutralLossesMap();
        for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
            if (!(Math.abs(neutralLoss.mass - ptm.getMass()) > mzTolerance)) continue;
            lossesMap.addNeutralLoss(neutralLoss, 1, 1);
        }
        SpectrumAnnotator spectrumAnnotator = new SpectrumAnnotator();
        spectrumAnnotator.setPeptide(noModPeptide, precursorCharge);
        for (int i = 0; i <= nPTM; ++i) {
            spectrumAnnotator.setMassShift((double)i * ptm.getMass());
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, lossesMap, charges, precursorCharge, spectrum, noModPeptide, intensityLimit, mzTolerance, false);
            for (IonMatch ionMatch : matches) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                if (peptideFragmentIon.getSubType() == 0 || peptideFragmentIon.getSubType() == 1 || peptideFragmentIon.getSubType() == 2) {
                    ptmTableContent.addIntensity(i, peptideFragmentIon.getSubType(), peptideFragmentIon.getNumber(), ionMatch.peak.intensity);
                    continue;
                }
                if (peptideFragmentIon.getSubType() != 3 && peptideFragmentIon.getSubType() != 4 && peptideFragmentIon.getSubType() != 5) continue;
                ptmTableContent.addIntensity(i, peptideFragmentIon.getSubType(), peptide.getSequence().length() - peptideFragmentIon.getNumber() + 1, ionMatch.peak.intensity);
            }
        }
        return ptmTableContent;
    }
}

