/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications;

import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.preferences.ModificationProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.xmlpull.v1.XmlPullParserException;

public class IdentificationParametersReader {
    public static final String DATABASE_FILE = "DATABASE_FILE";
    public static final String ENZYME = "ENZYME";
    public static final String MODIFICATION_SEPARATOR = "//";
    public static final String MODIFICATION_USE_SEPARATOR = "_";
    public static final String FIXED_MODIFICATIONS = "FIXED_MODIFICATIONS";
    public static final String VARIABLE_MODIFICATIONS = "VARIABLE_MODIFICATIONS";
    public static final String MISSED_CLEAVAGES = "MISSED_CLEAVAGES";
    public static final String PRECURSOR_MASS_TOLERANCE = "PRECURSOR_MASS_TOLERANCE";
    public static final String PRECURSOR_MASS_ACCURACY_UNIT = "PRECURSOR_MASS_TOLERANCE_UNIT";
    public static final String FRAGMENT_ION_MASS_ACCURACY = "FRAGMENT_MASS_TOLERANCE";
    public static final String PRECURSOR_CHARGE_LOWER_BOUND = "PRECURSOR_CHARGE_LOWER_BOUND";
    public static final String PRECURSOR_CHARGE_UPPER_BOUND = "PRECURSOR_CHARGE_UPPER_BOUND";
    public static final String FRAGMENT_ION_TYPE_1 = "FRAGMENT_ION_TYPE_1";
    public static final String FRAGMENT_ION_TYPE_2 = "FRAGMENT_ION_TYPE_2";
    public static final String EVALUE_CUTOFF = "EVALUE_CUTOFF";
    public static final String MAXIMUM_HITLIST_LENGTH = "MAXIMUM_HITLIST_LENGTH";
    public static final String PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS = "OMSSA_PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS";
    public static final String PRECURSOR_ELIMINATION = "OMSSA_PRECURSOR_ELIMINATION";
    public static final String PRECURSOR_SCALING = "OMSSA_PRECURSOR_SCALING";
    public static final String MIN_PEPTIDE_SIZE = "OMSSA_MINIMAL_PEPTIDE_SIZE";
    public static final String MAX_PEPTIDE_SIZE = "OMSSA_MAXIMAL_PEPTIDE_SIZE";
    public static final String CHARGE_ESTIMATION = "OMSSA_CHARGE_ESTIMATION";

    public static Properties loadProperties(File aFile) throws FileNotFoundException, IOException {
        Properties screenProps = new Properties();
        FileInputStream fis = new FileInputStream(aFile);
        if (fis == null) {
            throw new IllegalArgumentException("Could not read the file you specified ('" + aFile.getAbsolutePath() + "').");
        }
        screenProps.load(fis);
        fis.close();
        return screenProps;
    }

    public static ArrayList<String> parseModificationLine(String aLine) {
        int start;
        ArrayList<String> result = new ArrayList<String>();
        while ((start = aLine.indexOf(MODIFICATION_SEPARATOR)) >= 0) {
            String name = aLine.substring(0, start);
            aLine = aLine.substring(start + 2);
            if (name.trim().equals("")) continue;
            result.add(name);
        }
        if (!aLine.trim().equals("")) {
            result.add(aLine);
        }
        return result;
    }

    public static SearchParameters getSearchParameters(Properties aProps, File userModsFile) throws XmlPullParserException, FileNotFoundException, IOException {
        EnzymeFactory enzymeFactory;
        Integer index;
        PTMFactory ptmFactory;
        SearchParameters searchParameters = new SearchParameters();
        String temp = aProps.getProperty(DATABASE_FILE);
        if (temp != null && !temp.equals("")) {
            searchParameters.setFastaFile(new File(temp.trim()));
        }
        ModificationProfile modificationProfile = searchParameters.getModificationProfile();
        temp = aProps.getProperty(FIXED_MODIFICATIONS);
        HashMap<String, Integer> userIndexes = null;
        if (temp != null && !temp.trim().equals("")) {
            ptmFactory = PTMFactory.getInstance();
            ArrayList<String> fixedMods = IdentificationParametersReader.parseModificationLine(temp.trim());
            for (String ptmName : fixedMods) {
                modificationProfile.addFixedModification(ptmFactory.getPTM(ptmName));
                index = ptmFactory.getDefaultOMSSAIndex(ptmName);
                if (index == null) {
                    if (userIndexes == null) {
                        userIndexes = PTMFactory.getOMSSAIndexes(userModsFile);
                    }
                    if (userIndexes != null) {
                        index = userIndexes.get(ptmName);
                    }
                }
                modificationProfile.setOmssaIndex(ptmName, index);
            }
        }
        if ((temp = aProps.getProperty(VARIABLE_MODIFICATIONS)) != null && !temp.trim().equals("")) {
            ptmFactory = PTMFactory.getInstance();
            ArrayList<String> variableMods = IdentificationParametersReader.parseModificationLine(temp.trim());
            for (String ptmName : variableMods) {
                modificationProfile.addVariableModification(ptmFactory.getPTM(ptmName));
                index = ptmFactory.getDefaultOMSSAIndex(ptmName);
                if (index == null) {
                    if (userIndexes == null) {
                        userIndexes = PTMFactory.getOMSSAIndexes(userModsFile);
                    }
                    if (userIndexes != null) {
                        index = userIndexes.get(ptmName);
                    }
                }
                modificationProfile.setOmssaIndex(ptmName, index);
            }
        }
        if ((temp = aProps.getProperty(ENZYME)) != null && !temp.equals("") && (enzymeFactory = EnzymeFactory.getInstance()).enzymeLoaded(temp)) {
            searchParameters.setEnzyme(enzymeFactory.getEnzyme(temp.trim()));
        }
        if ((temp = aProps.getProperty(FRAGMENT_ION_TYPE_1)) != null && !temp.equals("")) {
            searchParameters.setIonSearched1(temp.trim());
        }
        if ((temp = aProps.getProperty(FRAGMENT_ION_TYPE_2)) != null && !temp.equals("")) {
            searchParameters.setIonSearched2(temp.trim());
        }
        if ((temp = aProps.getProperty(MISSED_CLEAVAGES)) != null) {
            try {
                searchParameters.setnMissedCleavages(new Integer(temp.trim()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((temp = aProps.getProperty(PRECURSOR_MASS_TOLERANCE)) != null) {
            try {
                searchParameters.setPrecursorAccuracy(new Double(temp.trim()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((temp = aProps.getProperty(PRECURSOR_MASS_ACCURACY_UNIT)) != null) {
            if (temp.equals("ppm")) {
                searchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.PPM);
            } else if (temp.equals("Da")) {
                searchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.DA);
            }
        }
        if ((temp = aProps.getProperty(FRAGMENT_ION_MASS_ACCURACY)) != null) {
            try {
                searchParameters.setFragmentIonAccuracy(new Double(temp.trim()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        temp = aProps.getProperty(PRECURSOR_CHARGE_LOWER_BOUND);
        try {
            int charge = new Integer(temp.trim());
            searchParameters.setMinChargeSearched(new Charge(1, charge));
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(PRECURSOR_CHARGE_UPPER_BOUND);
        try {
            int charge = new Integer(temp.trim());
            searchParameters.setMaxChargeSearched(new Charge(1, charge));
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(EVALUE_CUTOFF);
        if (temp != null) {
            try {
                searchParameters.setMaxEValue(new Double(temp.trim()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        temp = aProps.getProperty(MAXIMUM_HITLIST_LENGTH);
        try {
            int length = new Integer(temp.trim());
            searchParameters.setHitListLength(length);
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS);
        try {
            int charge = new Integer(temp.trim());
            searchParameters.setMinimalChargeForMultipleChargedFragments(new Charge(1, charge));
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(MIN_PEPTIDE_SIZE);
        try {
            int length = new Integer(temp.trim());
            searchParameters.setMinPeptideLength(length);
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(MAX_PEPTIDE_SIZE);
        try {
            int length = new Integer(temp.trim());
            searchParameters.setMaxPeptideLength(length);
        }
        catch (Exception e) {
            // empty catch block
        }
        temp = aProps.getProperty(PRECURSOR_ELIMINATION);
        if (temp != null) {
            if ((temp = temp.trim()).equals("Yes")) {
                searchParameters.setRemovePrecursor(true);
            } else if (temp.equals("No")) {
                searchParameters.setRemovePrecursor(false);
            }
        }
        if ((temp = aProps.getProperty(PRECURSOR_SCALING)) != null) {
            if ((temp = temp.trim()).equals("Yes")) {
                searchParameters.setScalePrecursor(true);
            } else if (temp.equals("No")) {
                searchParameters.setScalePrecursor(false);
            }
        }
        if ((temp = aProps.getProperty(CHARGE_ESTIMATION)) != null) {
            if ((temp = temp.trim()).equals("Yes")) {
                searchParameters.setEstimateCharge(true);
            } else if (temp.equals("No")) {
                searchParameters.setEstimateCharge(false);
            }
        }
        return searchParameters;
    }
}

