/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications;

import com.compomics.util.Util;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class IdfileReaderFactory {
    static Logger logger = Logger.getLogger(IdfileReaderFactory.class);
    private static IdfileReaderFactory singleton = null;
    private static HashMap<String, Class> idFileReaders = new HashMap();

    private IdfileReaderFactory() {
    }

    public static IdfileReaderFactory getInstance() {
        if (singleton == null) {
            singleton = new IdfileReaderFactory();
        }
        return singleton;
    }

    public static Class registerIdFileReader(Class aReader, String aExtension) {
        Class result = null;
        if (IdfileReader.class.isAssignableFrom(aReader)) {
            try {
                aReader.getConstructor(File.class);
                result = idFileReaders.put(aExtension, aReader);
                logger.info((Object)("Registered IdfileReader implementation '" + aReader.getCanonicalName() + "' for extension '" + aExtension + "'."));
                if (result != null) {
                    logger.warn((Object)("Overwrite occurred for extension '" + aExtension + "'; replaced old IdfileReader '" + result.getCanonicalName() + "' with new IdfileReader '" + aReader.getCanonicalName() + "'!"));
                }
            }
            catch (NoSuchMethodException nsme) {
                logger.warn((Object)("Unable to find required constructor with single java.io.File parameter in IdfileReader implementation '" + aReader.getCanonicalName() + "'! IdfileReader is ignored!"));
                nsme.printStackTrace();
            }
        } else {
            logger.warn((Object)("Was expecting an implementation of '" + IdfileReader.class.getCanonicalName() + "', but got class '" + aReader.getCanonicalName() + "' instead! Ignoring IdfileReader!"));
        }
        return result;
    }

    public IdfileReader getFileReader(File aFile, WaitingHandler waitingHandler) throws SAXException, FileNotFoundException, IOException {
        IdfileReader result = null;
        String name = aFile.getName().toLowerCase();
        for (String key : idFileReaders.keySet()) {
            String extension = key.toLowerCase();
            if (!name.endsWith(extension)) continue;
            Class idfileReaderClass = idFileReaders.get(key);
            try {
                result = (IdfileReader)idfileReaderClass.getConstructor(File.class).newInstance(aFile);
                break;
            }
            catch (NoSuchMethodException nsme) {
                logger.error((Object)("Unable to find required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "'!"), (Throwable)nsme);
                nsme.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                logger.error((Object)("Required public constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' has incorrect access modifier!"), (Throwable)iae);
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                logger.error((Object)("Required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' threw an exception!"), (Throwable)ite);
                ite.printStackTrace();
            }
            catch (InstantiationException ie) {
                logger.error((Object)("Required constructor with single java.io.File parameter in IdfileReader implementation '" + idfileReaderClass.getCanonicalName() + "', matching query extension '" + extension + "' inaccessible; probably abstract class?!"), (Throwable)ie);
                ie.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int getSearchEngine(File aFile) {
        String fileName = Util.getFileName(aFile);
        if (fileName.endsWith(".dat")) {
            return 0;
        }
        if (fileName.endsWith(".omx")) {
            return 1;
        }
        if (fileName.endsWith(".t.xml")) {
            if (!fileName.equals("mods.xml") && !fileName.equals("usermods.xml")) {
                return 2;
            }
        } else {
            if (fileName.endsWith(".out")) {
                return 6;
            }
            if (fileName.endsWith(".res")) {
                return 4;
            }
        }
        return -1;
    }

    static {
        ServiceLoader<IdfileReader> ifdrServiceLoader = ServiceLoader.load(IdfileReader.class);
        for (IdfileReader idfileReader : ifdrServiceLoader) {
            logger.info((Object)("Found IdfileReader '" + idfileReader.getClass().getCanonicalName() + "' in Java service loader."));
            IdfileReaderFactory.registerIdFileReader(idfileReader.getClass(), idfileReader.getExtension());
        }
    }
}

