/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.matches;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.quantification.QuantificationMatch;
import java.util.HashMap;

public class PsmQuantification
extends QuantificationMatch {
    private String spectrumKey;
    private String spectrumMatchKey;
    private HashMap<Integer, IonMatch> reporterMatches = new HashMap();
    private HashMap<Integer, Double> deisotopedIntensities = new HashMap();
    private double referenceIntensity;

    public PsmQuantification(String spectrumKey, String spectrumMatchKey) {
        this.spectrumKey = spectrumKey;
        this.spectrumMatchKey = spectrumMatchKey;
    }

    public void addIonMatch(int reporterIndex, IonMatch match) {
        this.reporterMatches.put(reporterIndex, match);
    }

    @Override
    public String getKey() {
        return this.spectrumKey;
    }

    public String getSpectrumMatchKey() {
        return this.spectrumMatchKey;
    }

    public HashMap<Integer, IonMatch> getReporterMatches() {
        return this.reporterMatches;
    }

    public HashMap<Integer, Double> getDeisotopedIntensities() {
        return this.deisotopedIntensities;
    }

    public void setDeisotopedIntensities(HashMap<Integer, Double> deisotopedIntensities) {
        this.deisotopedIntensities = deisotopedIntensities;
    }

    public double getReferenceIntensity() {
        return this.referenceIntensity;
    }

    public void setReferenceIntensity(double referenceIntensity) {
        this.referenceIntensity = referenceIntensity;
    }

    @Override
    public QuantificationMatch.MatchType getType() {
        return QuantificationMatch.MatchType.Spectrum;
    }
}

