/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.VennDiagramLegendLocationDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export_graphics.ExportGraphicsDialog;
import com.compomics.util.gui.export_graphics.ExportGraphicsDialogParent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import no.uib.jsparklines.data.XYDataPoint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYBoxAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYAnnotationEntity;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.TextAnchor;

public class VennDiagramDialog
extends JDialog
implements ExportGraphicsDialogParent {
    private VennDiagramType currentVennDiagramType = VennDiagramType.THREE_WAY;
    private HashMap<String, String> tooltipToDatasetMap;
    private HashMap<String, ArrayList<String>> vennDiagramResults;
    private HashMap<String, String> groupNames;
    private ChartPanel chartPanel;
    private Frame dialogParent;
    private String lastSelectedFolder = "user.home";
    private Image normalIcon;
    private Image waitingIcon;
    private int fontSizeValues = 17;
    private int fontSizeLegend = 14;
    private boolean showLegend = true;
    private XYDataPoint legendDatasetAThreeWay = new XYDataPoint(0.86, 0.86);
    private XYDataPoint legendDatasetBThreeWay = new XYDataPoint(1.15, 0.86);
    private XYDataPoint legendDatasetCThreeWay = new XYDataPoint(1.0, 1.22);
    private XYDataPoint legendDatasetAFourWay = new XYDataPoint(0.13, 0.53);
    private XYDataPoint legendDatasetBFourWay = new XYDataPoint(0.23, 0.43);
    private XYDataPoint legendDatasetCFourWay = new XYDataPoint(0.33, 0.33);
    private XYDataPoint legendDatasetDFourWay = new XYDataPoint(0.43, 0.23);
    private JPanel backgroundPanel;
    private JPanel contextMenuPlotBackgroundPanel;
    private JPanel dataPanel;
    private JPanel datasetAColorJPanel;
    private JScrollPane datasetAScrollPane;
    private JTextArea datasetATextArea;
    private JTextField datasetATextField;
    private JPanel datasetBColorJPanel;
    private JScrollPane datasetBScrollPane;
    private JTextArea datasetBTextArea;
    private JTextField datasetBTextField;
    private JPanel datasetCColorJPanel;
    private JScrollPane datasetCScrollPane;
    private JTextArea datasetCTextArea;
    private JTextField datasetCTextField;
    private JPanel datasetDColorJPanel;
    private JScrollPane datasetDScrollPane;
    private JTextArea datasetDTextArea;
    private JTextField datasetDTextField;
    private JMenuItem exportPlotMenuItem;
    private JMenu fontSizeMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JCheckBoxMenuItem legendCheckBoxMenuItem;
    private JMenuItem legendFontSizeMenuItem;
    private JMenuItem legendLocationMenuItem;
    private JButton plotHelpJButton;
    private JLayeredPane plotLayeredPane;
    private JButton plotOptionsJButton;
    private JPanel plotPanel;
    private JPopupMenu plotPopupMenu;
    private JMenuItem valueFontSizeMenuItem;
    private JPanel xyPlotPanel;

    public VennDiagramDialog(Frame dialogParent, Image normalIcon, Image waitingIcon, boolean modal) {
        super(dialogParent, modal);
        this.initComponents();
        this.dialogParent = dialogParent;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        int alphaLevel = 150;
        this.datasetAColorJPanel.setBackground(new Color(0, 0, 255, alphaLevel));
        this.datasetBColorJPanel.setBackground(new Color(0, 255, 0, alphaLevel));
        this.datasetCColorJPanel.setBackground(new Color(255, 255, 0, alphaLevel));
        this.datasetDColorJPanel.setBackground(new Color(255, 0, 0, alphaLevel));
        this.setUpGUI();
        this.setLocationRelativeTo(dialogParent);
        this.plotLayeredPaneComponentResized(null);
        this.setVisible(true);
        this.updatePlot();
    }

    public static void main(String[] args) {
        try {
            UtilitiesGUIDefaults.setLookAndFeel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new VennDiagramDialog((Frame)new JFrame(), null, null, true);
    }

    private void setUpGUI() {
        String datasetD;
        String datasetC;
        String datasetB;
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        ArrayList<String> c = new ArrayList<String>();
        ArrayList<String> d = new ArrayList<String>();
        String datasetA = this.datasetATextArea.getText();
        if (datasetA.trim().length() > 0) {
            String[] lines = datasetA.split("\n");
            a.addAll(Arrays.asList(lines));
        }
        if ((datasetB = this.datasetBTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetB.split("\n");
            b.addAll(Arrays.asList(lines));
        }
        if ((datasetC = this.datasetCTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetC.split("\n");
            c.addAll(Arrays.asList(lines));
        }
        if ((datasetD = this.datasetDTextArea.getText()).trim().length() > 0) {
            String[] lines = datasetD.split("\n");
            d.addAll(Arrays.asList(lines));
        }
        this.groupNames = new HashMap();
        this.groupNames.put("a", this.datasetATextField.getText());
        this.groupNames.put("b", this.datasetBTextField.getText());
        this.groupNames.put("c", this.datasetCTextField.getText());
        this.groupNames.put("d", this.datasetDTextField.getText());
        this.vennDiagramResults = this.vennDiagramMaker(a, b, c, d);
        this.currentVennDiagramType = b.isEmpty() && c.isEmpty() && d.isEmpty() ? VennDiagramType.ONE_WAY : (c.isEmpty() && d.isEmpty() ? VennDiagramType.TWO_WAY : (d.isEmpty() ? VennDiagramType.THREE_WAY : VennDiagramType.FOUR_WAY));
    }

    private void initComponents() {
        this.plotPopupMenu = new JPopupMenu();
        this.exportPlotMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.legendCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.legendLocationMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.fontSizeMenu = new JMenu();
        this.valueFontSizeMenuItem = new JMenuItem();
        this.legendFontSizeMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.plotLayeredPane = new JLayeredPane();
        this.xyPlotPanel = new JPanel();
        this.plotPanel = new JPanel();
        this.plotOptionsJButton = new JButton();
        this.plotHelpJButton = new JButton();
        this.contextMenuPlotBackgroundPanel = new JPanel();
        this.dataPanel = new JPanel();
        this.datasetAScrollPane = new JScrollPane();
        this.datasetATextArea = new JTextArea();
        this.datasetBScrollPane = new JScrollPane();
        this.datasetBTextArea = new JTextArea();
        this.datasetCScrollPane = new JScrollPane();
        this.datasetCTextArea = new JTextArea();
        this.datasetDScrollPane = new JScrollPane();
        this.datasetDTextArea = new JTextArea();
        this.datasetATextField = new JTextField();
        this.datasetBTextField = new JTextField();
        this.datasetCTextField = new JTextField();
        this.datasetDTextField = new JTextField();
        this.datasetAColorJPanel = new JPanel();
        this.datasetBColorJPanel = new JPanel();
        this.datasetCColorJPanel = new JPanel();
        this.datasetDColorJPanel = new JPanel();
        this.exportPlotMenuItem.setText("Export");
        this.exportPlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.exportPlotMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.exportPlotMenuItem);
        this.plotPopupMenu.add(this.jSeparator1);
        this.legendCheckBoxMenuItem.setSelected(true);
        this.legendCheckBoxMenuItem.setText("Show Legend");
        this.legendCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.legendCheckBoxMenuItem);
        this.legendLocationMenuItem.setText("Legend Location");
        this.legendLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendLocationMenuItemActionPerformed(evt);
            }
        });
        this.plotPopupMenu.add(this.legendLocationMenuItem);
        this.plotPopupMenu.add(this.jSeparator2);
        this.fontSizeMenu.setText("Font Size");
        this.valueFontSizeMenuItem.setText("Values");
        this.valueFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.valueFontSizeMenuItemActionPerformed(evt);
            }
        });
        this.fontSizeMenu.add(this.valueFontSizeMenuItem);
        this.legendFontSizeMenuItem.setText("Legend");
        this.legendFontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.legendFontSizeMenuItemActionPerformed(evt);
            }
        });
        this.fontSizeMenu.add(this.legendFontSizeMenuItem);
        this.plotPopupMenu.add(this.fontSizeMenu);
        this.setDefaultCloseOperation(2);
        this.setTitle("Statistics");
        this.setModal(true);
        this.setPreferredSize(new Dimension(600, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VennDiagramDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.setPreferredSize(new Dimension(600, 600));
        this.plotLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                VennDiagramDialog.this.plotLayeredPaneComponentResized(evt);
            }
        });
        this.xyPlotPanel.setBorder(BorderFactory.createTitledBorder("Venn Diagram"));
        this.xyPlotPanel.setOpaque(false);
        this.xyPlotPanel.setLayout(new BoxLayout(this.xyPlotPanel, 3));
        this.plotPanel.setBackground(new Color(255, 255, 255));
        this.plotPanel.setLayout(new BoxLayout(this.plotPanel, 2));
        this.xyPlotPanel.add(this.plotPanel);
        this.xyPlotPanel.setBounds(0, 0, 580, 360);
        this.plotLayeredPane.add((Component)this.xyPlotPanel, JLayeredPane.DEFAULT_LAYER);
        this.plotOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.plotOptionsJButton.setToolTipText("Plot Options");
        this.plotOptionsJButton.setBorder(null);
        this.plotOptionsJButton.setBorderPainted(false);
        this.plotOptionsJButton.setContentAreaFilled(false);
        this.plotOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.plotOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VennDiagramDialog.this.plotOptionsJButtonMouseReleased(evt);
            }
        });
        this.plotOptionsJButton.setBounds(550, 5, 10, 19);
        this.plotLayeredPane.add((Component)this.plotOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.plotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.plotHelpJButton.setToolTipText("Help");
        this.plotHelpJButton.setBorder(null);
        this.plotHelpJButton.setBorderPainted(false);
        this.plotHelpJButton.setContentAreaFilled(false);
        this.plotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.plotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonMouseExited(evt);
            }
        });
        this.plotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VennDiagramDialog.this.plotHelpJButtonActionPerformed(evt);
            }
        });
        this.plotHelpJButton.setBounds(570, 0, 10, 19);
        this.plotLayeredPane.add((Component)this.plotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.contextMenuPlotBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPlotBackgroundPanelLayout = new GroupLayout(this.contextMenuPlotBackgroundPanel);
        this.contextMenuPlotBackgroundPanel.setLayout(contextMenuPlotBackgroundPanelLayout);
        contextMenuPlotBackgroundPanelLayout.setHorizontalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPlotBackgroundPanelLayout.setVerticalGroup(contextMenuPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.contextMenuPlotBackgroundPanel.setBounds(550, 0, 30, 19);
        this.plotLayeredPane.add((Component)this.contextMenuPlotBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setOpaque(false);
        this.datasetATextArea.setTabSize(4);
        this.datasetATextArea.setText("1\n2\n3\n4\n5");
        this.datasetATextArea.setToolTipText("");
        this.datasetATextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetATextAreaKeyReleased(evt);
            }
        });
        this.datasetAScrollPane.setViewportView(this.datasetATextArea);
        this.datasetBTextArea.setTabSize(4);
        this.datasetBTextArea.setText("3\n5\n6");
        this.datasetBTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetBTextAreaKeyReleased(evt);
            }
        });
        this.datasetBScrollPane.setViewportView(this.datasetBTextArea);
        this.datasetCTextArea.setColumns(2);
        this.datasetCTextArea.setTabSize(4);
        this.datasetCTextArea.setText("3\n6\n7");
        this.datasetCTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetCTextAreaKeyReleased(evt);
            }
        });
        this.datasetCScrollPane.setViewportView(this.datasetCTextArea);
        this.datasetDTextArea.setColumns(2);
        this.datasetDTextArea.setTabSize(4);
        this.datasetDTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetDTextAreaKeyReleased(evt);
            }
        });
        this.datasetDScrollPane.setViewportView(this.datasetDTextArea);
        this.datasetATextField.setText("Dataset A");
        this.datasetATextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetATextFieldKeyReleased(evt);
            }
        });
        this.datasetBTextField.setText("Dataset B");
        this.datasetBTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetBTextFieldKeyReleased(evt);
            }
        });
        this.datasetCTextField.setText("Dataset C");
        this.datasetCTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetCTextFieldKeyReleased(evt);
            }
        });
        this.datasetDTextField.setText("Dataset D");
        this.datasetDTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VennDiagramDialog.this.datasetDTextFieldKeyReleased(evt);
            }
        });
        this.datasetAColorJPanel.setBackground(new Color(0, 0, 255));
        this.datasetAColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetAColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetAColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetAColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetAColorJPanelLayout = new GroupLayout(this.datasetAColorJPanel);
        this.datasetAColorJPanel.setLayout(datasetAColorJPanelLayout);
        datasetAColorJPanelLayout.setHorizontalGroup(datasetAColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetAColorJPanelLayout.setVerticalGroup(datasetAColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetBColorJPanel.setBackground(new Color(0, 255, 0));
        this.datasetBColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetBColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetBColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetBColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetBColorJPanelLayout = new GroupLayout(this.datasetBColorJPanel);
        this.datasetBColorJPanel.setLayout(datasetBColorJPanelLayout);
        datasetBColorJPanelLayout.setHorizontalGroup(datasetBColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetBColorJPanelLayout.setVerticalGroup(datasetBColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetCColorJPanel.setBackground(new Color(255, 255, 0));
        this.datasetCColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetCColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetCColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetCColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetCColorJPanelLayout = new GroupLayout(this.datasetCColorJPanel);
        this.datasetCColorJPanel.setLayout(datasetCColorJPanelLayout);
        datasetCColorJPanelLayout.setHorizontalGroup(datasetCColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetCColorJPanelLayout.setVerticalGroup(datasetCColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        this.datasetDColorJPanel.setBackground(new Color(255, 0, 0));
        this.datasetDColorJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.datasetDColorJPanel.setToolTipText("The color used for Peptide A");
        this.datasetDColorJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VennDiagramDialog.this.datasetDColorJPanelMouseClicked(evt);
            }
        });
        GroupLayout datasetDColorJPanelLayout = new GroupLayout(this.datasetDColorJPanel);
        this.datasetDColorJPanel.setLayout(datasetDColorJPanelLayout);
        datasetDColorJPanelLayout.setHorizontalGroup(datasetDColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 13, Short.MAX_VALUE));
        datasetDColorJPanelLayout.setVerticalGroup(datasetDColorJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 12, Short.MAX_VALUE));
        GroupLayout dataPanelLayout = new GroupLayout(this.dataPanel);
        this.dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetAScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetATextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetAColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetBScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetBTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetBColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetCScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetCTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetCColorJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetDScrollPane).addGroup(dataPanelLayout.createSequentialGroup().addComponent(this.datasetDTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetDColorJPanel, -2, -1, -2))).addContainerGap()));
        dataPanelLayout.setVerticalGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataPanelLayout.createSequentialGroup().addContainerGap().addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.datasetATextField).addComponent(this.datasetAColorJPanel, -2, -1, -2).addComponent(this.datasetBTextField).addComponent(this.datasetCTextField).addComponent(this.datasetDTextField).addComponent(this.datasetBColorJPanel, -2, -1, -2).addComponent(this.datasetCColorJPanel, -2, -1, -2).addComponent(this.datasetDColorJPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetAScrollPane, -2, 137, -2).addComponent(this.datasetBScrollPane, -2, 137, -2).addComponent(this.datasetCScrollPane, -2, 137, -2).addComponent(this.datasetDScrollPane, GroupLayout.Alignment.TRAILING, -2, 137, -2)).addContainerGap()));
        dataPanelLayout.linkSize(1, this.datasetATextField, this.datasetBTextField, this.datasetCTextField, this.datasetDTextField);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotLayeredPane, -1, 580, Short.MAX_VALUE).addComponent(this.dataPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotLayeredPane, -1, 364, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataPanel, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void plotOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotOptionsJButtonMouseReleased(MouseEvent evt) {
        this.plotPopupMenu.show(this.plotOptionsJButton, evt.getX(), evt.getY());
    }

    private void exportPlotMenuItemActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JDialog)this, (ExportGraphicsDialogParent)this, true, this.chartPanel);
    }

    private void plotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/VennDiagramDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Statistics - Help");
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        System.exit(0);
    }

    private void plotLayeredPaneComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VennDiagramDialog.this.plotLayeredPane.getComponent(0).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(0).getWidth() - 22, -2, VennDiagramDialog.this.plotLayeredPane.getComponent(0).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(0).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(1).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(1).getWidth() - 10, -4, VennDiagramDialog.this.plotLayeredPane.getComponent(1).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(1).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(2).setBounds(VennDiagramDialog.this.plotLayeredPane.getWidth() - VennDiagramDialog.this.plotLayeredPane.getComponent(2).getWidth() - 5, -3, VennDiagramDialog.this.plotLayeredPane.getComponent(2).getWidth(), VennDiagramDialog.this.plotLayeredPane.getComponent(2).getHeight());
                VennDiagramDialog.this.plotLayeredPane.getComponent(3).setBounds(0, 0, VennDiagramDialog.this.plotLayeredPane.getWidth(), VennDiagramDialog.this.plotLayeredPane.getHeight());
                if (VennDiagramDialog.this.getCurrentVennDiagramType() != VennDiagramType.FOUR_WAY) {
                    int min = Math.min(VennDiagramDialog.this.plotLayeredPane.getWidth(), VennDiagramDialog.this.plotLayeredPane.getHeight());
                    VennDiagramDialog.this.plotPanel.setMaximumSize(new Dimension(min, min));
                    VennDiagramDialog.this.plotPanel.setPreferredSize(new Dimension(min, min));
                    VennDiagramDialog.this.updatePlot();
                } else {
                    VennDiagramDialog.this.plotPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                    VennDiagramDialog.this.updatePlot();
                }
                VennDiagramDialog.this.plotLayeredPane.revalidate();
                VennDiagramDialog.this.plotLayeredPane.repaint();
            }
        });
    }

    private void datasetATextAreaKeyReleased(KeyEvent evt) {
        this.setUpGUI();
        this.updatePlot();
        this.plotLayeredPaneComponentResized(null);
    }

    private void datasetCTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetDTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetATextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetBTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetCTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetDTextFieldKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void datasetAColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetAColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetAColorJPanel.setBackground(newColor);
            this.updatePlot();
        }
    }

    private void datasetBColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetBColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetBColorJPanel.setBackground(newColor);
            this.updatePlot();
        }
    }

    private void datasetCColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetCColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetCColorJPanel.setBackground(newColor);
            this.updatePlot();
        }
    }

    private void datasetDColorJPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.datasetDColorJPanel.getBackground());
        if (newColor != null) {
            this.datasetDColorJPanel.setBackground(newColor);
            this.updatePlot();
        }
    }

    private void legendCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.showLegend = this.legendCheckBoxMenuItem.isSelected();
        this.updatePlot();
    }

    private void valueFontSizeMenuItemActionPerformed(ActionEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Values Font Size:", this.fontSizeValues);
        if (value != null) {
            try {
                this.fontSizeValues = Integer.parseInt(value);
                this.updatePlot();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", 1);
            }
        }
    }

    private void legendFontSizeMenuItemActionPerformed(ActionEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Legend Font Size:", this.fontSizeLegend);
        if (value != null) {
            try {
                this.fontSizeLegend = Integer.parseInt(value);
                this.updatePlot();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", 1);
            }
        }
    }

    private void datasetBTextAreaKeyReleased(KeyEvent evt) {
        this.datasetATextAreaKeyReleased(null);
    }

    private void legendLocationMenuItemActionPerformed(ActionEvent evt) {
        new VennDiagramLegendLocationDialog(this, true);
    }

    public void updatePlot() {
        this.plotPanel.removeAll();
        this.tooltipToDatasetMap = new HashMap();
        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
        JFreeChart chart = ChartFactory.createBubbleChart(null, (String)"X", (String)"Y", (XYZDataset)xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        if (this.currentVennDiagramType == VennDiagramType.ONE_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else if (this.currentVennDiagramType == VennDiagramType.TWO_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            plot.getRangeAxis().setRange(0.86, 1.24);
            plot.getDomainAxis().setRange(0.85, 1.25);
        } else {
            plot.getRangeAxis().setRange(-0.04, 0.6);
            plot.getDomainAxis().setRange(-0.08, 0.7);
        }
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        double radius = 0.1;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(1.0 - radius, 1.0 - radius, radius + radius, radius + radius);
        XYShapeAnnotation xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetAColorJPanel.getBackground());
        plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        if (this.currentVennDiagramType == VennDiagramType.TWO_WAY || this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            ellipse = new Ellipse2D.Double(1.0 - radius + 0.1, 1.0 - radius, radius + radius, radius + radius);
            xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetBColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        }
        if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            ellipse = new Ellipse2D.Double(1.0 - radius + 0.05, 1.0 - radius + 0.1, radius + radius, radius + radius);
            xyShapeAnnotation = new XYShapeAnnotation((Shape)ellipse, (Stroke)new BasicStroke(2.0f), (Paint)new Color(140, 140, 140, 150), (Paint)this.datasetCColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)xyShapeAnnotation);
        }
        if (this.currentVennDiagramType == VennDiagramType.ONE_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 1.0, 1.0);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.TWO_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.96, 1.0);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 1.14, 1.0);
            anotation.setToolTipText(this.groupNames.get("b"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 1.05, 1.0);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBThreeWay.getX(), this.legendDatasetBThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.THREE_WAY) {
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.96, 0.97);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 1.14, 0.97);
            anotation.setToolTipText(this.groupNames.get("b"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 1.05, 0.97);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("c").size(), 1.05, 1.14);
            anotation.setToolTipText(this.groupNames.get("c"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "c");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ac").size(), 0.99, 1.065);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + "  &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ac");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bc").size(), 1.11, 1.065);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abc").size(), 1.05, 1.036);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + "  &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abc");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAThreeWay.getX(), this.legendDatasetAThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBThreeWay.getX(), this.legendDatasetBThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("c"), this.legendDatasetCThreeWay.getX(), this.legendDatasetCThreeWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        } else if (this.currentVennDiagramType == VennDiagramType.FOUR_WAY) {
            XYBoxAnnotation anotation2 = new XYBoxAnnotation(0.0, 0.0, 0.2, 0.5, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetAColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.1, 0.0, 0.3, 0.4, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetBColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.0, 0.1, 0.4, 0.3, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetCColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)anotation2);
            anotation2 = new XYBoxAnnotation(0.0, 0.0, 0.5, 0.2, (Stroke)new BasicStroke(2.0f), (Paint)Color.LIGHT_GRAY, (Paint)this.datasetDColorJPanel.getBackground());
            plot.addAnnotation((XYAnnotation)anotation2);
            XYTextAnnotation anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("a").size(), 0.15, 0.45);
            anotation.setToolTipText(this.groupNames.get("a"));
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "a");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ab").size(), 0.15, 0.35);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ab");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abc").size(), 0.15, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abcd").size(), 0.15, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abcd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("abd").size(), 0.15, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "abd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ac").size(), 0.05, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ac");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("acd").size(), 0.05, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "acd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("ad").size(), 0.05, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("a") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "ad");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("b").size(), 0.25, 0.35);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "b");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bc").size(), 0.25, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bc");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bcd").size(), 0.25, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bcd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("bd").size(), 0.25, 0.05);
            anotation.setToolTipText("<html>" + this.groupNames.get("b") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "bd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("c").size(), 0.35, 0.25);
            anotation.setToolTipText("<html>" + this.groupNames.get("c") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "c");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("cd").size(), 0.35, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("c") + " &#8745; " + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "cd");
            anotation = new XYTextAnnotation("" + this.vennDiagramResults.get("d").size(), 0.45, 0.15);
            anotation.setToolTipText("<html>" + this.groupNames.get("d") + "</html>");
            anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeValues));
            plot.addAnnotation((XYAnnotation)anotation);
            this.tooltipToDatasetMap.put(anotation.getToolTipText(), "d");
            if (this.showLegend) {
                anotation = new XYTextAnnotation(this.groupNames.get("a"), this.legendDatasetAFourWay.getX(), this.legendDatasetAFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("b"), this.legendDatasetBFourWay.getX(), this.legendDatasetBFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("c"), this.legendDatasetCFourWay.getX(), this.legendDatasetCFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
                anotation = new XYTextAnnotation(this.groupNames.get("d"), this.legendDatasetDFourWay.getX(), this.legendDatasetDFourWay.getY());
                anotation.setTextAnchor(TextAnchor.BASELINE_LEFT);
                anotation.setFont(new Font(anotation.getFont().getFontName(), 1, this.fontSizeLegend));
                plot.addAnnotation((XYAnnotation)anotation);
            }
        }
        XYBubbleRenderer renderer = new XYBubbleRenderer(2);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYZToolTipGenerator());
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setForegroundAlpha(0.5f);
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        chart.getPlot().setOutlineVisible(false);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPopupMenu(null);
        this.chartPanel.setBackground(Color.WHITE);
        this.plotPanel.add((Component)this.chartPanel);
        this.plotPanel.revalidate();
        this.plotPanel.repaint();
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                VennDiagramDialog.this.mouseClickedInChart(cme);
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
                VennDiagramDialog.this.mouseMovedInChart(cme);
            }
        });
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mouseClicked(e);
            }
        });
    }

    public void mouseClickedInChart(ChartMouseEvent event) {
        ArrayList<ChartEntity> entities = this.getEntitiesForPoint(event.getTrigger().getPoint().x, event.getTrigger().getPoint().y);
        if (entities.isEmpty()) {
            return;
        }
        boolean dataPointFound = false;
        String dataPointTooltip = "";
        for (ChartEntity tempEntity : entities) {
            if (!(tempEntity instanceof XYAnnotationEntity) || ((XYAnnotationEntity)tempEntity).getToolTipText() == null) continue;
            dataPointFound = true;
            dataPointTooltip = ((XYAnnotationEntity)tempEntity).getToolTipText();
        }
        if (dataPointFound) {
            String dataset = this.tooltipToDatasetMap.get(dataPointTooltip);
            JOptionPane.showMessageDialog(this, dataPointTooltip + ":\n" + this.vennDiagramResults.get(dataset), "Selected Values", 1);
        }
    }

    public void mouseMovedInChart(ChartMouseEvent event) {
        ArrayList<ChartEntity> entities = this.getEntitiesForPoint(event.getTrigger().getPoint().x, event.getTrigger().getPoint().y);
        boolean dataPointFound = false;
        for (ChartEntity tempEntity : entities) {
            if (!(tempEntity instanceof XYAnnotationEntity) || ((XYAnnotationEntity)tempEntity).getToolTipText() == null) continue;
            dataPointFound = true;
        }
        if (dataPointFound) {
            this.chartPanel.setCursor(new Cursor(12));
        } else {
            this.chartPanel.setCursor(new Cursor(0));
        }
    }

    public ArrayList<ChartEntity> getEntitiesForPoint(int viewX, int viewY) {
        ArrayList<ChartEntity> entitiesForPoint = new ArrayList<ChartEntity>();
        ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
        if (info != null) {
            Insets insets = this.chartPanel.getInsets();
            double x = (double)(viewX - insets.left) / this.chartPanel.getScaleX();
            double y = (double)(viewY - insets.top) / this.chartPanel.getScaleY();
            EntityCollection allEntities = info.getEntityCollection();
            int numEntities = allEntities.getEntityCount();
            for (int i = 0; i < numEntities; ++i) {
                ChartEntity entity = allEntities.getEntity(i);
                if (!entity.getArea().contains(x, y)) continue;
                entitiesForPoint.add(entity);
            }
        }
        return entitiesForPoint;
    }

    @Override
    public void setSelectedExportFolder(String selectedFolder) {
        this.lastSelectedFolder = selectedFolder;
    }

    @Override
    public String getDefaultExportFolder() {
        return this.lastSelectedFolder;
    }

    public HashMap<String, ArrayList<String>> vennDiagramMaker(ArrayList<String> groupA, ArrayList<String> groupB, ArrayList<String> groupC, ArrayList<String> groupD) {
        boolean inGroupB;
        boolean inGroupA;
        boolean inGroupD;
        boolean inGroupC;
        HashMap<String, ArrayList<String>> tempVennDiagramResults = new HashMap<String, ArrayList<String>>();
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        ArrayList<String> c = new ArrayList<String>();
        ArrayList<String> d = new ArrayList<String>();
        ArrayList<String> ab = new ArrayList<String>();
        ArrayList<String> ac = new ArrayList<String>();
        ArrayList<String> ad = new ArrayList<String>();
        ArrayList<String> bc = new ArrayList<String>();
        ArrayList<String> bd = new ArrayList<String>();
        ArrayList<String> cd = new ArrayList<String>();
        ArrayList<String> abc = new ArrayList<String>();
        ArrayList<String> abd = new ArrayList<String>();
        ArrayList<String> acd = new ArrayList<String>();
        ArrayList<String> bcd = new ArrayList<String>();
        ArrayList<String> abcd = new ArrayList<String>();
        ArrayList<String> allDataPoints = new ArrayList<String>();
        for (String temp : groupA) {
            if (allDataPoints.contains(temp)) continue;
            boolean inGroupB2 = groupB.contains(temp);
            inGroupC = groupC.contains(temp);
            inGroupD = groupD.contains(temp);
            if (!(inGroupB2 || inGroupC || inGroupD)) {
                a.add(temp);
            } else if (inGroupB2 && !inGroupC && !inGroupD) {
                ab.add(temp);
            } else if (!inGroupB2 && inGroupC && !inGroupD) {
                ac.add(temp);
            } else if (!inGroupB2 && !inGroupC && inGroupD) {
                ad.add(temp);
            } else if (inGroupB2 && inGroupC && !inGroupD) {
                abc.add(temp);
            } else if (inGroupB2 && !inGroupC && inGroupD) {
                abd.add(temp);
            } else if (!inGroupB2 && inGroupC && inGroupD) {
                acd.add(temp);
            } else {
                abcd.add(temp);
            }
            allDataPoints.add(temp);
        }
        for (String temp : groupB) {
            if (allDataPoints.contains(temp)) continue;
            inGroupA = groupA.contains(temp);
            inGroupC = groupC.contains(temp);
            inGroupD = groupD.contains(temp);
            if (!(inGroupA || inGroupC || inGroupD)) {
                b.add(temp);
            } else if (inGroupA && !inGroupC && !inGroupD) {
                ab.add(temp);
            } else if (!inGroupA && inGroupC && !inGroupD) {
                bc.add(temp);
            } else if (!inGroupA && !inGroupC && inGroupD) {
                bd.add(temp);
            } else if (inGroupA && inGroupC && !inGroupD) {
                abc.add(temp);
            } else if (inGroupA && !inGroupC && inGroupD) {
                abd.add(temp);
            } else if (!inGroupA && inGroupC && inGroupD) {
                bcd.add(temp);
            } else {
                abcd.add(temp);
            }
            allDataPoints.add(temp);
        }
        for (String temp : groupC) {
            if (allDataPoints.contains(temp)) continue;
            inGroupA = groupA.contains(temp);
            inGroupB = groupB.contains(temp);
            inGroupD = groupD.contains(temp);
            if (!(inGroupA || inGroupB || inGroupD)) {
                c.add(temp);
            } else if (inGroupA && !inGroupB && !inGroupD) {
                ac.add(temp);
            } else if (!inGroupA && inGroupB && !inGroupD) {
                bc.add(temp);
            } else if (!inGroupA && !inGroupB && inGroupD) {
                cd.add(temp);
            } else if (inGroupA && inGroupB && !inGroupD) {
                abc.add(temp);
            } else if (inGroupA && !inGroupB && inGroupD) {
                acd.add(temp);
            } else if (!inGroupA && inGroupB && inGroupD) {
                bcd.add(temp);
            } else {
                abcd.add(temp);
            }
            allDataPoints.add(temp);
        }
        for (String temp : groupD) {
            if (allDataPoints.contains(temp)) continue;
            inGroupA = groupA.contains(temp);
            inGroupB = groupB.contains(temp);
            boolean inGroupC2 = groupC.contains(temp);
            if (!(inGroupA || inGroupB || inGroupC2)) {
                d.add(temp);
            } else if (inGroupA && !inGroupB && !inGroupC2) {
                ad.add(temp);
            } else if (!inGroupA && inGroupB && !inGroupC2) {
                bd.add(temp);
            } else if (!inGroupA && !inGroupB && inGroupC2) {
                cd.add(temp);
            } else if (inGroupA && inGroupB && !inGroupC2) {
                abd.add(temp);
            } else if (inGroupA && !inGroupB && inGroupC2) {
                acd.add(temp);
            } else if (!inGroupA && inGroupB && inGroupC2) {
                bcd.add(temp);
            } else {
                abcd.add(temp);
            }
            allDataPoints.add(temp);
        }
        tempVennDiagramResults.put("a", a);
        tempVennDiagramResults.put("b", b);
        tempVennDiagramResults.put("c", c);
        tempVennDiagramResults.put("d", d);
        tempVennDiagramResults.put("ab", ab);
        tempVennDiagramResults.put("ac", ac);
        tempVennDiagramResults.put("ad", ad);
        tempVennDiagramResults.put("bc", bc);
        tempVennDiagramResults.put("bd", bd);
        tempVennDiagramResults.put("cd", cd);
        tempVennDiagramResults.put("abc", abc);
        tempVennDiagramResults.put("abd", abd);
        tempVennDiagramResults.put("acd", abd);
        tempVennDiagramResults.put("bcd", bcd);
        tempVennDiagramResults.put("abcd", abcd);
        boolean debug = false;
        if (debug) {
            System.out.print("a: ");
            for (String temp : a) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("b: ");
            for (String temp : b) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("c: ");
            for (String temp : c) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("d: ");
            for (String temp : d) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("ab: ");
            for (String temp : ab) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("ac: ");
            for (String temp : ac) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("ad: ");
            for (String temp : ad) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("bc: ");
            for (String temp : bc) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("bd: ");
            for (String temp : bd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("cd: ");
            for (String temp : cd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("abc: ");
            for (String temp : abc) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("abd: ");
            for (String temp : abd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("bcd: ");
            for (String temp : bcd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("acd: ");
            for (String temp : acd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
            System.out.print("abcd: ");
            for (String temp : abcd) {
                System.out.print(temp + ", ");
            }
            System.out.println();
        }
        return tempVennDiagramResults;
    }

    @Override
    public Image getNormalIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png"));
    }

    @Override
    public Image getWaitingIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/compomics-utilities.png"));
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public HashMap<String, String> getGroupNames() {
        return this.groupNames;
    }

    public XYDataPoint getLegendDatasetAThreeWay() {
        return this.legendDatasetAThreeWay;
    }

    public void setLegendDatasetAThreeWay(XYDataPoint legendDatasetAThreeWay) {
        this.legendDatasetAThreeWay = legendDatasetAThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetBThreeWay() {
        return this.legendDatasetBThreeWay;
    }

    public void setLegendDatasetBThreeWay(XYDataPoint legendDatasetBThreeWay) {
        this.legendDatasetBThreeWay = legendDatasetBThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetCThreeWay() {
        return this.legendDatasetCThreeWay;
    }

    public void setLegendDatasetCThreeWay(XYDataPoint legendDatasetCThreeWay) {
        this.legendDatasetCThreeWay = legendDatasetCThreeWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetAFourWay() {
        return this.legendDatasetAFourWay;
    }

    public void setLegendDatasetAFourWay(XYDataPoint legendDatasetAFourWay) {
        this.legendDatasetAFourWay = legendDatasetAFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetBFourWay() {
        return this.legendDatasetBFourWay;
    }

    public void setLegendDatasetBFourWay(XYDataPoint legendDatasetBFourWay) {
        this.legendDatasetBFourWay = legendDatasetBFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetCFourWay() {
        return this.legendDatasetCFourWay;
    }

    public void setLegendDatasetCFourWay(XYDataPoint legendDatasetCFourWay) {
        this.legendDatasetCFourWay = legendDatasetCFourWay;
        this.updatePlot();
    }

    public XYDataPoint getLegendDatasetDFourWay() {
        return this.legendDatasetDFourWay;
    }

    public void setLegendDatasetDFourWay(XYDataPoint legendDatasetDFourWay) {
        this.legendDatasetDFourWay = legendDatasetDFourWay;
        this.updatePlot();
    }

    public VennDiagramType getCurrentVennDiagramType() {
        return this.currentVennDiagramType;
    }

    public static enum VennDiagramType {
        ONE_WAY,
        TWO_WAY,
        THREE_WAY,
        FOUR_WAY;

    }
}

