/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.io.identifications.IdentificationParametersReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.protein.SequenceDbDetailsDialog;
import com.compomics.util.gui.ptm.ModificationsDialog;
import com.compomics.util.gui.ptm.PtmDialogParent;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.searchsettings.SearchSettingsDialogParent;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.ModificationProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class SearchSettingsDialog
extends JDialog
implements PtmDialogParent {
    private static ProgressDialogX progressDialog;
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private String[] forwardIons = new String[]{"a", "b", "c"};
    private String[] rewindIons = new String[]{"x", "y", "z"};
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private File parametersFile = null;
    private SearchSettingsDialogParent searchSettingsDialogParent;
    private SearchParameters searchParameters;
    private ArrayList<String> modificationTableToolTips;
    private JFrame parentFrame;
    private Image normalIcon;
    private Image waitingIcon;
    public static final String MODIFICATION_SEPARATOR = "//";
    private JButton addFixedModification;
    private JButton addVariableModification;
    private JPanel availableModsPanel;
    private JPanel backgroundPanel;
    private JButton browseConfigurationButton2;
    private JButton cancelButton;
    private JLabel configurationFileLbl2;
    private JPanel configurationFilePanelSettings;
    private JTextField configurationFileTxt_parameters;
    private JPanel dataBasePanelSettings;
    private JLabel databaseSettingsLbl;
    private JTextField databaseSettingsTxt;
    private JButton editDatabaseSettings;
    private JLabel enzymeLabel;
    private JComboBox enzymesCmb;
    private JLabel fixedModificationsLabel;
    private JScrollPane fixedModsJScrollPane;
    private JTable fixedModsTable;
    private JComboBox fragmentIon1Cmb;
    private JComboBox fragmentIon2Cmb;
    private JTextField fragmentIonAccuracyTxt;
    private JLabel fragmentIonLbl;
    private JLabel fragmentIonType1Lbl;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel maxMissedCleavagesLabel;
    private JTextField maxPrecursorChargeTxt;
    private JTextField minPrecursorChargeTxt;
    private JTextField missedCleavagesTxt;
    private JSplitPane modificationTypesSplitPane;
    private JScrollPane modificationsJScrollPane;
    private JLayeredPane modificationsLayeredPane;
    private JComboBox modificationsListCombo;
    private JPanel modificationsPanel;
    private JTable modificationsTable;
    private JButton okButton;
    private JButton openDialogHelpJButton1;
    private JButton openModificationSettingsJButton;
    private JLabel precursorChargeLbl;
    private JLabel precursorChargeRangeLabel;
    private JTextField precursorIonAccuracyTxt;
    private JLabel precursorIonLbl;
    private JComboBox precursorIonUnit;
    private JPanel proteaseAndFragmentationPanel;
    private JButton removeFixedModification;
    private JButton removeVariableModification;
    private JButton saveConfiguration;
    private JButton saveConfigurationAs;
    private JLabel variableModificationsLabel;
    private JScrollPane variableModsJScrollPane;
    private JTable variableModsTable;

    public SearchSettingsDialog(JFrame parentFrame, SearchSettingsDialogParent searchSettingsDialogParent, SearchParameters searchParameters, Image normalIcon, Image waitingIcon, boolean setVisible, boolean modal) {
        super((Frame)parentFrame, modal);
        this.parentFrame = parentFrame;
        this.searchSettingsDialogParent = searchSettingsDialogParent;
        this.searchParameters = searchParameters;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setUpGUI();
        this.formComponentResized(null);
        this.setLocationRelativeTo(parentFrame);
        if (setVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchSettingsDialog.this.setVisible(true);
                }
            });
        }
    }

    private void setUpGUI() {
        this.setScreenProps();
        this.validateParametersInput(false);
        this.modificationTypesSplitPane.setDividerLocation(0.5);
        this.modificationsListCombo.setRenderer(new AlignedListCellRenderer(0));
        this.enzymesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentIon1Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentIon2Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.precursorIonUnit.setRenderer(new AlignedListCellRenderer(0));
        ((TitledBorder)this.configurationFilePanelSettings.getBorder()).setTitle("Configuration File");
        ((TitledBorder)this.dataBasePanelSettings.getBorder()).setTitle("Database");
        ((TitledBorder)this.modificationsPanel.getBorder()).setTitle("Modifications");
        ((TitledBorder)this.proteaseAndFragmentationPanel.getBorder()).setTitle("Protease & Fragmentation");
        this.fixedModsJScrollPane.getViewport().setOpaque(false);
        this.variableModsJScrollPane.getViewport().setOpaque(false);
        this.modificationsJScrollPane.getViewport().setOpaque(false);
        this.fixedModsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.variableModsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.modificationsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.fixedModsTable.getColumn(" ").setMaxWidth(35);
        this.fixedModsTable.getColumn(" ").setMinWidth(35);
        this.variableModsTable.getColumn(" ").setMaxWidth(35);
        this.variableModsTable.getColumn(" ").setMinWidth(35);
        this.modificationsTable.getColumn(" ").setMaxWidth(35);
        this.modificationsTable.getColumn(" ").setMinWidth(35);
        this.modificationsTable.getColumn("  ").setMaxWidth(30);
        this.modificationsTable.getColumn("  ").setMinWidth(30);
        this.fixedModsTable.getColumn("Mass").setMaxWidth(100);
        this.fixedModsTable.getColumn("Mass").setMinWidth(100);
        this.variableModsTable.getColumn("Mass").setMaxWidth(100);
        this.variableModsTable.getColumn("Mass").setMinWidth(100);
        this.modificationsTable.getColumn("Mass").setMaxWidth(100);
        this.modificationsTable.getColumn("Mass").setMinWidth(100);
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add(null);
        this.modificationTableToolTips.add("Modification Name");
        this.modificationTableToolTips.add("Modification Mass");
        this.modificationTableToolTips.add("Default Modification");
        this.loadModificationsInGUI();
    }

    private void loadModificationsInGUI() {
        this.updateModificationList();
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.configurationFilePanelSettings = new JPanel();
        this.configurationFileLbl2 = new JLabel();
        this.browseConfigurationButton2 = new JButton();
        this.configurationFileTxt_parameters = new JTextField();
        this.saveConfiguration = new JButton();
        this.saveConfigurationAs = new JButton();
        this.proteaseAndFragmentationPanel = new JPanel();
        this.enzymeLabel = new JLabel();
        this.enzymesCmb = new JComboBox();
        this.maxMissedCleavagesLabel = new JLabel();
        this.missedCleavagesTxt = new JTextField();
        this.precursorIonLbl = new JLabel();
        this.precursorIonAccuracyTxt = new JTextField();
        this.precursorIonUnit = new JComboBox();
        this.fragmentIonLbl = new JLabel();
        this.fragmentIonAccuracyTxt = new JTextField();
        this.fragmentIonType1Lbl = new JLabel();
        this.fragmentIon1Cmb = new JComboBox();
        this.fragmentIon2Cmb = new JComboBox();
        this.precursorChargeLbl = new JLabel();
        this.minPrecursorChargeTxt = new JTextField();
        this.maxPrecursorChargeTxt = new JTextField();
        this.precursorChargeRangeLabel = new JLabel();
        this.dataBasePanelSettings = new JPanel();
        this.databaseSettingsLbl = new JLabel();
        this.databaseSettingsTxt = new JTextField();
        this.editDatabaseSettings = new JButton();
        this.modificationsLayeredPane = new JLayeredPane();
        this.modificationsPanel = new JPanel();
        this.modificationTypesSplitPane = new JSplitPane();
        this.jPanel8 = new JPanel();
        this.fixedModificationsLabel = new JLabel();
        this.addFixedModification = new JButton();
        this.removeFixedModification = new JButton();
        this.fixedModsJScrollPane = new JScrollPane();
        this.fixedModsTable = new JTable();
        this.jPanel9 = new JPanel();
        this.variableModificationsLabel = new JLabel();
        this.addVariableModification = new JButton();
        this.removeVariableModification = new JButton();
        this.variableModsJScrollPane = new JScrollPane();
        this.variableModsTable = new JTable();
        this.availableModsPanel = new JPanel();
        this.modificationsListCombo = new JComboBox();
        this.modificationsJScrollPane = new JScrollPane();
        this.modificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)SearchSettingsDialog.this.modificationTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.openModificationSettingsJButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.openDialogHelpJButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Search Settings");
        this.setMinimumSize(new Dimension(800, 700));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchSettingsDialog.this.formComponentResized(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.configurationFilePanelSettings.setBorder(BorderFactory.createTitledBorder("Settings File"));
        this.configurationFilePanelSettings.setOpaque(false);
        this.configurationFileLbl2.setText("Settings File");
        this.browseConfigurationButton2.setText("Load");
        this.browseConfigurationButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.browseConfigurationButton2ActionPerformed(evt);
            }
        });
        this.configurationFileTxt_parameters.setEditable(false);
        this.saveConfiguration.setText("Save");
        this.saveConfiguration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.saveConfigurationActionPerformed(evt);
            }
        });
        this.saveConfigurationAs.setText("Save As");
        this.saveConfigurationAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.saveConfigurationAsActionPerformed(evt);
            }
        });
        GroupLayout configurationFilePanelSettingsLayout = new GroupLayout(this.configurationFilePanelSettings);
        this.configurationFilePanelSettings.setLayout(configurationFilePanelSettingsLayout);
        configurationFilePanelSettingsLayout.setHorizontalGroup(configurationFilePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, configurationFilePanelSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.configurationFileLbl2, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationFileTxt_parameters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseConfigurationButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveConfiguration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveConfigurationAs, -2, 79, -2).addContainerGap()));
        configurationFilePanelSettingsLayout.linkSize(0, this.browseConfigurationButton2, this.saveConfiguration, this.saveConfigurationAs);
        configurationFilePanelSettingsLayout.setVerticalGroup(configurationFilePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationFilePanelSettingsLayout.createSequentialGroup().addContainerGap().addGroup(configurationFilePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationFileLbl2).addComponent(this.configurationFileTxt_parameters, -2, -1, -2).addComponent(this.saveConfigurationAs).addComponent(this.saveConfiguration).addComponent(this.browseConfigurationButton2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.proteaseAndFragmentationPanel.setBorder(BorderFactory.createTitledBorder("Enzyme & Fragmentation"));
        this.proteaseAndFragmentationPanel.setOpaque(false);
        this.enzymeLabel.setText("Enzyme");
        this.enzymesCmb.setModel(new DefaultComboBoxModel<String>(this.loadEnzymes()));
        this.enzymesCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.enzymesCmbActionPerformed(evt);
            }
        });
        this.maxMissedCleavagesLabel.setText("Max Missed Cleavages");
        this.missedCleavagesTxt.setHorizontalAlignment(0);
        this.missedCleavagesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchSettingsDialog.this.missedCleavagesTxtKeyReleased(evt);
            }
        });
        this.precursorIonLbl.setText("Precursor Mass Tolerance");
        this.precursorIonAccuracyTxt.setHorizontalAlignment(0);
        this.precursorIonAccuracyTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchSettingsDialog.this.precursorIonAccuracyTxtKeyReleased(evt);
            }
        });
        this.precursorIonUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "Da"}));
        this.fragmentIonLbl.setText("Fragment Mass Tolerance (Da)");
        this.fragmentIonAccuracyTxt.setHorizontalAlignment(0);
        this.fragmentIonAccuracyTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchSettingsDialog.this.fragmentIonAccuracyTxtKeyReleased(evt);
            }
        });
        this.fragmentIonType1Lbl.setText("Fragment Ion Types");
        this.fragmentIon1Cmb.setModel(new DefaultComboBoxModel<String>(this.forwardIons));
        this.fragmentIon2Cmb.setModel(new DefaultComboBoxModel<String>(this.rewindIons));
        this.precursorChargeLbl.setText("Precursor Charge");
        this.minPrecursorChargeTxt.setHorizontalAlignment(0);
        this.minPrecursorChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchSettingsDialog.this.minPrecursorChargeTxtKeyReleased(evt);
            }
        });
        this.maxPrecursorChargeTxt.setHorizontalAlignment(0);
        this.maxPrecursorChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SearchSettingsDialog.this.maxPrecursorChargeTxtKeyReleased(evt);
            }
        });
        this.precursorChargeRangeLabel.setText("-");
        GroupLayout proteaseAndFragmentationPanelLayout = new GroupLayout(this.proteaseAndFragmentationPanel);
        this.proteaseAndFragmentationPanel.setLayout(proteaseAndFragmentationPanelLayout);
        proteaseAndFragmentationPanelLayout.setHorizontalGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentIonType1Lbl).addComponent(this.enzymeLabel).addComponent(this.precursorIonLbl)).addGap(18, 18, 18).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enzymesCmb, 0, -1, Short.MAX_VALUE).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.precursorIonAccuracyTxt).addComponent(this.fragmentIon1Cmb, 0, 110, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentIon2Cmb, 0, 110, Short.MAX_VALUE).addComponent(this.precursorIonUnit, 0, -1, Short.MAX_VALUE)))).addGap(50, 50, 50).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentIonLbl).addComponent(this.maxMissedCleavagesLabel).addComponent(this.precursorChargeLbl)).addGap(18, 18, 18).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.missedCleavagesTxt).addComponent(this.fragmentIonAccuracyTxt).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addComponent(this.minPrecursorChargeTxt, -1, 70, Short.MAX_VALUE).addGap(19, 19, 19).addComponent(this.precursorChargeRangeLabel).addGap(18, 18, 18).addComponent(this.maxPrecursorChargeTxt, -1, 69, Short.MAX_VALUE))).addContainerGap()));
        proteaseAndFragmentationPanelLayout.setVerticalGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteaseAndFragmentationPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.missedCleavagesTxt, -2, -1, -2).addComponent(this.enzymeLabel).addComponent(this.enzymesCmb, -2, -1, -2).addComponent(this.maxMissedCleavagesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentIonLbl).addComponent(this.precursorIonLbl).addComponent(this.precursorIonAccuracyTxt, -2, -1, -2).addComponent(this.fragmentIonAccuracyTxt, -2, -1, -2).addComponent(this.precursorIonUnit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteaseAndFragmentationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentIonType1Lbl).addComponent(this.fragmentIon2Cmb, -2, -1, -2).addComponent(this.fragmentIon1Cmb, -2, -1, -2).addComponent(this.precursorChargeLbl).addComponent(this.minPrecursorChargeTxt, -2, -1, -2).addComponent(this.maxPrecursorChargeTxt, -2, -1, -2).addComponent(this.precursorChargeRangeLabel)).addContainerGap()));
        this.dataBasePanelSettings.setBorder(BorderFactory.createTitledBorder("Database"));
        this.dataBasePanelSettings.setOpaque(false);
        this.databaseSettingsLbl.setText("Database (FASTA)*");
        this.databaseSettingsTxt.setEditable(false);
        this.editDatabaseSettings.setText("Edit");
        this.editDatabaseSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.editDatabaseSettingsActionPerformed(evt);
            }
        });
        GroupLayout dataBasePanelSettingsLayout = new GroupLayout(this.dataBasePanelSettings);
        this.dataBasePanelSettings.setLayout(dataBasePanelSettingsLayout);
        dataBasePanelSettingsLayout.setHorizontalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.databaseSettingsLbl, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.databaseSettingsTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editDatabaseSettings, -2, 80, -2).addContainerGap()));
        dataBasePanelSettingsLayout.setVerticalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseSettingsLbl).addComponent(this.editDatabaseSettings).addComponent(this.databaseSettingsTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.modificationsPanel.setBorder(BorderFactory.createTitledBorder("Modifications"));
        this.modificationsPanel.setOpaque(false);
        this.modificationTypesSplitPane.setBorder(null);
        this.modificationTypesSplitPane.setDividerSize(0);
        this.modificationTypesSplitPane.setOrientation(0);
        this.modificationTypesSplitPane.setResizeWeight(0.5);
        this.modificationTypesSplitPane.setOpaque(false);
        this.modificationTypesSplitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchSettingsDialog.this.modificationTypesSplitPaneComponentResized(evt);
            }
        });
        this.jPanel8.setOpaque(false);
        this.fixedModificationsLabel.setFont(this.fixedModificationsLabel.getFont().deriveFont(this.fixedModificationsLabel.getFont().getStyle() | 2));
        this.fixedModificationsLabel.setText("Fixed Modifications");
        this.addFixedModification.setText("<<");
        this.addFixedModification.setToolTipText("Add as fixed modification");
        this.addFixedModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.addFixedModificationActionPerformed(evt);
            }
        });
        this.removeFixedModification.setText(">>");
        this.removeFixedModification.setToolTipText("Remove as fixed modification");
        this.removeFixedModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.removeFixedModificationActionPerformed(evt);
            }
        });
        this.fixedModsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.fixedModsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fixedModsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchSettingsDialog.this.fixedModsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchSettingsDialog.this.fixedModsTableMouseReleased(evt);
            }
        });
        this.fixedModsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchSettingsDialog.this.fixedModsTableMouseMoved(evt);
            }
        });
        this.fixedModsJScrollPane.setViewportView(this.fixedModsTable);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.fixedModificationsLabel, -1, 123, Short.MAX_VALUE).addGap(242, 242, 242)).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.fixedModsJScrollPane, -1, -1, Short.MAX_VALUE).addGap(7, 7, 7))).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeFixedModification, -2, 54, -2).addComponent(this.addFixedModification, -2, 54, -2))));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.fixedModificationsLabel).addGap(6, 6, 6).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.addFixedModification).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeFixedModification).addContainerGap(59, Short.MAX_VALUE)).addComponent(this.fixedModsJScrollPane, -1, -1, Short.MAX_VALUE))));
        this.modificationTypesSplitPane.setLeftComponent(this.jPanel8);
        this.jPanel9.setOpaque(false);
        this.variableModificationsLabel.setFont(this.variableModificationsLabel.getFont().deriveFont(this.variableModificationsLabel.getFont().getStyle() | 2));
        this.variableModificationsLabel.setText("Variable Modifications");
        this.addVariableModification.setText("<<");
        this.addVariableModification.setToolTipText("Add as variable modification");
        this.addVariableModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.addVariableModificationActionPerformed(evt);
            }
        });
        this.removeVariableModification.setText(">>");
        this.removeVariableModification.setToolTipText("Remove as variable modification");
        this.removeVariableModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.removeVariableModificationActionPerformed(evt);
            }
        });
        this.variableModsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.variableModsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.variableModsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchSettingsDialog.this.variableModsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchSettingsDialog.this.variableModsTableMouseReleased(evt);
            }
        });
        this.variableModsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchSettingsDialog.this.variableModsTableMouseMoved(evt);
            }
        });
        this.variableModsJScrollPane.setViewportView(this.variableModsTable);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.variableModificationsLabel).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.variableModsJScrollPane, -1, 358, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addVariableModification, -2, 54, -2).addComponent(this.removeVariableModification, -2, 54, -2))));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.variableModificationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.addVariableModification).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeVariableModification).addContainerGap(59, Short.MAX_VALUE)).addComponent(this.variableModsJScrollPane, -1, -1, Short.MAX_VALUE))));
        this.modificationTypesSplitPane.setRightComponent(this.jPanel9);
        this.availableModsPanel.setOpaque(false);
        this.modificationsListCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Most Used Modifications", "All Modifications"}));
        this.modificationsListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.modificationsListComboActionPerformed(evt);
            }
        });
        this.modificationsJScrollPane.setPreferredSize(new Dimension(100, 60));
        this.modificationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Name", "Mass", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Double.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.modificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchSettingsDialog.this.modificationsTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchSettingsDialog.this.modificationsTableMouseExited(evt);
            }
        });
        this.modificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SearchSettingsDialog.this.modificationsTableMouseMoved(evt);
            }
        });
        this.modificationsJScrollPane.setViewportView(this.modificationsTable);
        this.openModificationSettingsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.openModificationSettingsJButton.setToolTipText("Edit Modifications");
        this.openModificationSettingsJButton.setBorder(null);
        this.openModificationSettingsJButton.setBorderPainted(false);
        this.openModificationSettingsJButton.setContentAreaFilled(false);
        this.openModificationSettingsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.openModificationSettingsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchSettingsDialog.this.openModificationSettingsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchSettingsDialog.this.openModificationSettingsJButtonMouseExited(evt);
            }
        });
        this.openModificationSettingsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.openModificationSettingsJButtonActionPerformed(evt);
            }
        });
        GroupLayout availableModsPanelLayout = new GroupLayout(this.availableModsPanel);
        this.availableModsPanel.setLayout(availableModsPanelLayout);
        availableModsPanelLayout.setHorizontalGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsJScrollPane, -1, 343, Short.MAX_VALUE).addGroup(availableModsPanelLayout.createSequentialGroup().addComponent(this.modificationsListCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openModificationSettingsJButton).addGap(2, 2, 2)));
        availableModsPanelLayout.setVerticalGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(availableModsPanelLayout.createSequentialGroup().addGroup(availableModsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.modificationsListCombo, -2, -1, -2).addComponent(this.openModificationSettingsJButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsJScrollPane, -1, -1, Short.MAX_VALUE)));
        GroupLayout modificationsPanelLayout = new GroupLayout(this.modificationsPanel);
        this.modificationsPanel.setLayout(modificationsPanelLayout);
        modificationsPanelLayout.setHorizontalGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationTypesSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.availableModsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        modificationsPanelLayout.setVerticalGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsPanelLayout.createSequentialGroup().addGroup(modificationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationTypesSplitPane).addComponent(this.availableModsPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        this.modificationsPanel.setBounds(0, 0, 800, 318);
        this.modificationsLayeredPane.add((Component)this.modificationsPanel, JLayeredPane.DEFAULT_LAYER);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton1.setToolTipText("Help");
        this.openDialogHelpJButton1.setBorder(null);
        this.openDialogHelpJButton1.setBorderPainted(false);
        this.openDialogHelpJButton1.setContentAreaFilled(false);
        this.openDialogHelpJButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchSettingsDialog.this.openDialogHelpJButton1MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchSettingsDialog.this.openDialogHelpJButton1MouseExited(evt);
            }
        });
        this.openDialogHelpJButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSettingsDialog.this.openDialogHelpJButton1ActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationFilePanelSettings, -1, -1, Short.MAX_VALUE).addComponent(this.dataBasePanelSettings, -1, -1, Short.MAX_VALUE).addComponent(this.proteaseAndFragmentationPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.modificationsLayeredPane, -2, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.configurationFilePanelSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataBasePanelSettings, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsLayeredPane, -1, 327, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteaseAndFragmentationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton1).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void browseConfigurationButton2ActionPerformed(ActionEvent evt) {
        File startLocation = new File(this.searchSettingsDialogParent.getLastSelectedFolder());
        if (this.configurationFileTxt_parameters.getText() != null && new File(this.configurationFileTxt_parameters.getText()).exists()) {
            File temp = new File(this.configurationFileTxt_parameters.getText());
            startLocation = temp.getParentFile();
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".properties") || myFile.getName().toLowerCase().endsWith(".parameters") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "SearchGUI search parameters";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            this.searchSettingsDialogParent.setLastSelectedFolder(file.getAbsolutePath());
            try {
                this.searchParameters = SearchParameters.getIdentificationParameters(file);
                this.loadModifications();
                this.setScreenProps();
            }
            catch (Exception e) {
                try {
                    Properties props = this.loadProperties(file);
                    this.searchParameters = IdentificationParametersReader.getSearchParameters(props, this.searchSettingsDialogParent.getUserModificationsFile());
                    this.setScreenProps();
                    String fileName = file.getName();
                    if (fileName.endsWith(".properties")) {
                        String newName = fileName.substring(0, fileName.lastIndexOf(".")) + ".parameters";
                        try {
                            file.delete();
                        }
                        catch (Exception deleteException) {
                            deleteException.printStackTrace();
                        }
                        file = new File(file.getParentFile(), newName);
                    }
                    SearchParameters.saveIdentificationParameters(this.searchParameters, file);
                }
                catch (Exception saveException) {
                    e.printStackTrace();
                    saveException.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error occured while reading " + file + ". Please verify the search paramters.", "File Error", 0);
                }
            }
            this.parametersFile = file;
            this.configurationFileTxt_parameters.setText(this.parametersFile.getAbsolutePath());
            this.searchParameters = this.getSearchParameters();
            this.searchParameters.setParametersFile(this.parametersFile);
            this.searchSettingsDialogParent.setSearchParameters(this.searchParameters);
            this.validateParametersInput(true);
        }
    }

    private void saveConfigurationActionPerformed(ActionEvent evt) {
        this.savePressed();
    }

    private void saveConfigurationAsActionPerformed(ActionEvent evt) {
        this.saveAsPressed();
    }

    private void missedCleavagesTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void precursorIonAccuracyTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void fragmentIonAccuracyTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void minPrecursorChargeTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void maxPrecursorChargeTxtKeyReleased(KeyEvent evt) {
        this.validateParametersInput(false);
    }

    private void editDatabaseSettingsActionPerformed(ActionEvent evt) {
        SequenceDbDetailsDialog sequenceDbDetailsDialog;
        boolean success;
        if (this.databaseSettingsTxt.getText().trim().length() == 0) {
            try {
                this.sequenceFactory.clearFactory();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to clear the sequence factory.", "File Error", 0);
            }
        }
        if (success = (sequenceDbDetailsDialog = new SequenceDbDetailsDialog(this.parentFrame, this.searchSettingsDialogParent.getLastSelectedFolder(), true, this.normalIcon, this.waitingIcon)).selectDB(true)) {
            sequenceDbDetailsDialog.setVisible(true);
        }
        this.searchSettingsDialogParent.setLastSelectedFolder(sequenceDbDetailsDialog.getLastSelectedFolder());
        if (this.sequenceFactory.getCurrentFastaFile() != null) {
            this.databaseSettingsTxt.setText(this.sequenceFactory.getCurrentFastaFile().getAbsolutePath());
        }
        this.validateParametersInput(false);
    }

    private void addFixedModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.fixedModsTable.getRowCount();
        int nNew = this.modificationsTable.getSelectedRows().length;
        String[] fixedModifications = new String[nSelected + nNew];
        int cpt = 0;
        for (int i = 0; i < nSelected; ++i) {
            fixedModifications[cpt] = (String)this.fixedModsTable.getValueAt(i, 1);
            ++cpt;
        }
        for (int selectedRow : this.modificationsTable.getSelectedRows()) {
            String name = (String)this.modificationsTable.getValueAt(selectedRow, 1);
            boolean found = false;
            for (int i = 0; i < this.fixedModsTable.getModel().getRowCount(); ++i) {
                if (!((String)this.fixedModsTable.getValueAt(i, 1)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            fixedModifications[cpt] = name;
            ++cpt;
            if (this.searchSettingsDialogParent.getModificationUse().contains(name)) continue;
            this.searchSettingsDialogParent.getModificationUse().add(name);
        }
        DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
        fixedModel.getDataVector().removeAllElements();
        for (String fixedMod : fixedModifications) {
            ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(fixedMod), fixedMod, this.ptmFactory.getPTM(fixedMod).getMass()});
        }
        ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
        this.fixedModsTable.repaint();
        this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedModifications.length + ")");
        this.updateModificationList();
    }

    private void removeFixedModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.fixedModsTable.getRowCount();
        int nToRemove = this.fixedModsTable.getSelectedRows().length;
        String[] fixedModifications = new String[nSelected - nToRemove];
        int cpt = 0;
        for (int i = 0; i < this.fixedModsTable.getRowCount(); ++i) {
            boolean found = false;
            for (int selectedRow : this.fixedModsTable.getSelectedRows()) {
                if (!((String)this.fixedModsTable.getValueAt(i, 1)).equals((String)this.fixedModsTable.getValueAt(selectedRow, 1))) continue;
                found = true;
                break;
            }
            if (found) continue;
            fixedModifications[cpt] = (String)this.fixedModsTable.getValueAt(i, 1);
            ++cpt;
        }
        DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
        fixedModel.getDataVector().removeAllElements();
        for (String fixedMod : fixedModifications) {
            ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(fixedMod), fixedMod, this.ptmFactory.getPTM(fixedMod).getMass()});
        }
        ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
        this.fixedModsTable.repaint();
        this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedModifications.length + ")");
        this.updateModificationList();
    }

    private void addVariableModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.variableModsTable.getRowCount();
        int nNew = this.modificationsTable.getSelectedRows().length;
        String[] variableModifications = new String[nSelected + nNew];
        int cpt = 0;
        for (int i = 0; i < nSelected; ++i) {
            variableModifications[cpt] = (String)this.variableModsTable.getValueAt(i, 1);
            ++cpt;
        }
        for (int selectedRow : this.modificationsTable.getSelectedRows()) {
            String name = (String)this.modificationsTable.getValueAt(selectedRow, 1);
            boolean found = false;
            for (int i = 0; i < this.variableModsTable.getRowCount(); ++i) {
                if (!((String)this.variableModsTable.getValueAt(i, 1)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            variableModifications[cpt] = name;
            ++cpt;
            if (this.searchSettingsDialogParent.getModificationUse().contains(name)) continue;
            this.searchSettingsDialogParent.getModificationUse().add(name);
        }
        DefaultTableModel variableModel = (DefaultTableModel)this.variableModsTable.getModel();
        variableModel.getDataVector().removeAllElements();
        for (String variabledMod : variableModifications) {
            ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(variabledMod), variabledMod, this.ptmFactory.getPTM(variabledMod).getMass()});
        }
        ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
        this.variableModsTable.repaint();
        this.variableModificationsLabel.setText("Variable Modifications (" + variableModifications.length + ")");
        if (variableModifications.length > 6) {
            JOptionPane.showMessageDialog(this, "It is not recommended to use more than 6 variable modifications in the same search.", "Warning", 2);
        }
        this.updateModificationList();
    }

    private void removeVariableModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.variableModsTable.getRowCount();
        int nToRemove = this.variableModsTable.getSelectedRows().length;
        String[] variableModifications = new String[nSelected - nToRemove];
        int cpt = 0;
        for (int i = 0; i < this.variableModsTable.getRowCount(); ++i) {
            boolean found = false;
            for (int selectedRow : this.variableModsTable.getSelectedRows()) {
                if (!((String)this.variableModsTable.getValueAt(i, 1)).equals((String)this.variableModsTable.getValueAt(selectedRow, 1))) continue;
                found = true;
                break;
            }
            if (found) continue;
            variableModifications[cpt] = (String)this.variableModsTable.getValueAt(i, 1);
            ++cpt;
        }
        DefaultTableModel variableModel = (DefaultTableModel)this.variableModsTable.getModel();
        variableModel.getDataVector().removeAllElements();
        for (String variabledMod : variableModifications) {
            ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(variabledMod), variabledMod, this.ptmFactory.getPTM(variabledMod).getMass()});
        }
        ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
        this.variableModsTable.repaint();
        this.variableModificationsLabel.setText("Variable Modifications (" + variableModifications.length + ")");
        this.updateModificationList();
    }

    private void modificationTypesSplitPaneComponentResized(ComponentEvent evt) {
        this.modificationTypesSplitPane.setDividerLocation(0.5);
    }

    private void modificationsListComboActionPerformed(ActionEvent evt) {
        this.updateModificationList();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        SearchParameters tempSearchParameters = this.getSearchParameters();
        if (this.configurationFileTxt_parameters.getText().length() == 0) {
            tempSearchParameters.setParametersFile(null);
            this.searchSettingsDialogParent.setSearchParameters(tempSearchParameters);
            this.dispose();
        } else if (!this.searchSettingsDialogParent.getSearchParameters().equals(tempSearchParameters)) {
            int value = JOptionPane.showConfirmDialog(this, "The search parameters have been changed.\nDo you want to save the changes?", "Save Changes?", 1);
            if (value == 0) {
                try {
                    tempSearchParameters.setParametersFile(this.searchSettingsDialogParent.getSearchParameters().getParametersFile());
                    SearchParameters.saveIdentificationParameters(tempSearchParameters, this.searchSettingsDialogParent.getSearchParameters().getParametersFile());
                    this.searchSettingsDialogParent.setSearchParameters(tempSearchParameters);
                    this.dispose();
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(this, "An error occurred when saving the search parameter:\n" + e.getMessage(), "File Error", 0);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "An error occurred when saving the search parameter:\n" + e.getMessage(), "File Error", 0);
                    e.printStackTrace();
                }
            } else if (value == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void enzymesCmbActionPerformed(ActionEvent evt) {
        this.validateParametersInput(false);
    }

    private void formComponentResized(ComponentEvent evt) {
        this.modificationsLayeredPane.getComponent(0).setBounds(0, 0, this.modificationsLayeredPane.getWidth(), this.modificationsLayeredPane.getHeight());
        this.modificationsLayeredPane.revalidate();
        this.modificationsLayeredPane.repaint();
    }

    private void fixedModsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void fixedModsTableMouseMoved(MouseEvent evt) {
        int row = this.fixedModsTable.rowAtPoint(evt.getPoint());
        int column = this.fixedModsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.fixedModsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void fixedModsTableMouseReleased(MouseEvent evt) {
        Color newColor;
        int row = this.fixedModsTable.rowAtPoint(evt.getPoint());
        int column = this.fixedModsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.fixedModsTable.getColumn(" ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.fixedModsTable.getValueAt(row, column))) != null) {
            this.searchParameters.getModificationProfile().setColor((String)this.fixedModsTable.getValueAt(row, 1), newColor);
            this.fixedModsTable.setValueAt(newColor, row, 0);
            ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
            this.fixedModsTable.repaint();
        }
        this.enableAddRemoveButtons();
    }

    private void modificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsTableMouseMoved(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void modificationsTableMouseReleased(MouseEvent evt) {
        int row = this.modificationsTable.rowAtPoint(evt.getPoint());
        int column = this.modificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.modificationsTable.getColumn(" ").getModelIndex()) {
                Color newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.modificationsTable.getValueAt(row, column));
                if (newColor != null) {
                    this.ptmFactory.setColor((String)this.modificationsTable.getValueAt(row, 1), newColor);
                    this.modificationsTable.setValueAt(newColor, row, 0);
                    ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
                    this.modificationsTable.repaint();
                }
            } else if (column == this.modificationsTable.getColumn("  ").getModelIndex() && this.modificationsTable.getValueAt(row, column) != null) {
                boolean selected = (Boolean)this.modificationsTable.getValueAt(row, column);
                String ptmName = (String)this.modificationsTable.getValueAt(row, 1);
                if (this.modificationsListCombo.getSelectedIndex() == 0) {
                    this.searchSettingsDialogParent.getModificationUse().remove(ptmName);
                } else if (selected) {
                    if (!this.searchSettingsDialogParent.getModificationUse().contains(ptmName)) {
                        this.searchSettingsDialogParent.getModificationUse().add(ptmName);
                    }
                } else {
                    this.searchSettingsDialogParent.getModificationUse().remove(ptmName);
                }
                this.updateModificationList();
                if (row < this.modificationsTable.getRowCount()) {
                    this.modificationsTable.setRowSelectionInterval(row, row);
                } else if (row - 1 < this.modificationsTable.getRowCount() && row >= 0) {
                    this.modificationsTable.setRowSelectionInterval(row - 1, row - 1);
                }
            }
            this.enableAddRemoveButtons();
        }
    }

    private void variableModsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void variableModsTableMouseMoved(MouseEvent evt) {
        int row = this.variableModsTable.rowAtPoint(evt.getPoint());
        int column = this.variableModsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.variableModsTable.getColumn(" ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void variableModsTableMouseReleased(MouseEvent evt) {
        Color newColor;
        int row = this.variableModsTable.rowAtPoint(evt.getPoint());
        int column = this.variableModsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.variableModsTable.getColumn(" ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.variableModsTable.getValueAt(row, column))) != null) {
            this.searchParameters.getModificationProfile().setColor((String)this.variableModsTable.getValueAt(row, 1), newColor);
            this.variableModsTable.setValueAt(newColor, row, 0);
            ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
            this.variableModsTable.repaint();
        }
        this.enableAddRemoveButtons();
    }

    private void openModificationSettingsJButtonActionPerformed(ActionEvent evt) {
        new ModificationsDialog((Frame)this.parentFrame, this, true);
    }

    private void openModificationSettingsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openModificationSettingsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButton1ActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/Modifications.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), this.normalIcon, "Search Settings Help", 500, 100);
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButton1MouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButton1MouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private String[] loadEnzymes() {
        ArrayList<String> tempEnzymes = new ArrayList<String>();
        for (int i = 0; i < this.enzymeFactory.getEnzymes().size(); ++i) {
            tempEnzymes.add(this.enzymeFactory.getEnzymes().get(i).getName());
        }
        Collections.sort(tempEnzymes);
        String[] enzymes = new String[tempEnzymes.size() + 1];
        enzymes[0] = "--- Select ---";
        for (int i = 0; i < tempEnzymes.size(); ++i) {
            enzymes[i + 1] = (String)tempEnzymes.get(i);
        }
        return enzymes;
    }

    public void savePressed() {
        if (this.parametersFile == null) {
            this.saveAsPressed();
        } else if (this.validateParametersInput(true)) {
            try {
                this.searchParameters = this.getSearchParameters();
                SearchParameters.saveIdentificationParameters(this.searchParameters, this.parametersFile);
                this.searchSettingsDialogParent.setSearchParameters(this.searchParameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, new String[]{"An error occurred while witing: " + this.parametersFile.getName(), e.getMessage()}, "Error Saving File", 2);
            }
        }
    }

    private void loadModifications() {
        ArrayList<String> toCheck = this.ptmFactory.loadBackedUpModifications(this.searchParameters, false);
        if (!toCheck.isEmpty()) {
            String message = "The definition of the following PTM(s) seems to have change and was not loaded:\n";
            for (int i = 0; i < toCheck.size(); ++i) {
                if (i <= 0) continue;
                message = i < toCheck.size() - 1 ? message + ", " : message + " and ";
                message = message + toCheck.get(i);
            }
            message = message + ".\nPlease verify the definition of the PTM(s) in the modifications editor.";
            JOptionPane.showMessageDialog(null, message, "PTM definition obsolete", 0);
        }
    }

    private void setScreenProps() {
        Enzyme enzyme;
        File fastaFile;
        if (this.searchParameters.getParametersFile() != null) {
            this.configurationFileTxt_parameters.setText(this.searchParameters.getParametersFile().getAbsolutePath());
            this.parametersFile = this.searchParameters.getParametersFile();
        }
        if ((fastaFile = this.searchParameters.getFastaFile()) != null) {
            String fastaPath = fastaFile.getAbsolutePath();
            this.databaseSettingsTxt.setText(fastaPath);
            if (!fastaFile.equals(this.sequenceFactory.getCurrentFastaFile()) && fastaFile.exists()) {
                this.loadFastaFile(fastaFile);
            }
        }
        ArrayList<String> missingPtms = new ArrayList<String>();
        ModificationProfile modificationProfile = this.searchParameters.getModificationProfile();
        if (modificationProfile != null) {
            ArrayList<String> fixedMods = modificationProfile.getFixedModifications();
            for (String ptmName : fixedMods) {
                if (this.ptmFactory.containsPTM(ptmName)) continue;
                missingPtms.add(ptmName);
            }
            for (String missing : missingPtms) {
                fixedMods.remove(missing);
            }
            if (!missingPtms.isEmpty()) {
                if (missingPtms.size() == 1) {
                    JOptionPane.showMessageDialog(this, "The following modification is currently not recognized by SearchGUI: " + (String)missingPtms.get(0) + ".\nPlease import it in the Modification Editor.", "Modification Not Found", 2);
                } else {
                    String output = "The following modifications are currently not recognized by SearchGUI:\n";
                    boolean first = true;
                    for (String ptm : missingPtms) {
                        if (first) {
                            first = false;
                        } else {
                            output = output + ", ";
                        }
                        output = output + ptm;
                    }
                    output = output + ".\nPlease import them in the Modification Editor.";
                    JOptionPane.showMessageDialog(this, output, "Modification Not Found", 2);
                }
            }
            DefaultTableModel fixedModel = (DefaultTableModel)this.fixedModsTable.getModel();
            fixedModel.getDataVector().removeAllElements();
            for (String fixedMod : fixedMods) {
                ((DefaultTableModel)this.fixedModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(fixedMod), fixedMod, this.ptmFactory.getPTM(fixedMod).getMass()});
            }
            ((DefaultTableModel)this.fixedModsTable.getModel()).fireTableDataChanged();
            this.fixedModsTable.repaint();
            this.fixedModificationsLabel.setText("Fixed Modifications (" + fixedMods.size() + ")");
            ArrayList<String> variableMods = modificationProfile.getVariableModifications();
            for (String ptmName : variableMods) {
                if (this.ptmFactory.containsPTM(ptmName)) continue;
                missingPtms.add(ptmName);
            }
            for (String missing : missingPtms) {
                variableMods.remove(missing);
            }
            if (!missingPtms.isEmpty()) {
                if (missingPtms.size() == 1) {
                    JOptionPane.showMessageDialog(this, "The following modification is currently not recognized by SearchGUI: " + (String)missingPtms.get(0) + ".\nPlease import it in the Modification Editor.", "Modification Not Found", 2);
                } else {
                    String output = "The following modifications are currently not recognized by SearchGUI:\n";
                    boolean first = true;
                    for (String ptm : missingPtms) {
                        if (first) {
                            first = false;
                        } else {
                            output = output + ", ";
                        }
                        output = output + ptm;
                    }
                    output = output + ".\nPlease import them in the Modification Editor.";
                    JOptionPane.showMessageDialog(this, output, "Modification Not Found", 2);
                }
            }
            DefaultTableModel variableModel = (DefaultTableModel)this.variableModsTable.getModel();
            variableModel.getDataVector().removeAllElements();
            for (String variableMod : variableMods) {
                ((DefaultTableModel)this.variableModsTable.getModel()).addRow(new Object[]{this.searchParameters.getModificationProfile().getColor(variableMod), variableMod, this.ptmFactory.getPTM(variableMod).getMass()});
            }
            ((DefaultTableModel)this.variableModsTable.getModel()).fireTableDataChanged();
            this.variableModsTable.repaint();
            this.variableModificationsLabel.setText("Variable Modifications (" + variableMods.size() + ")");
            this.updateModificationList();
        }
        if ((enzyme = this.searchParameters.getEnzyme()) != null) {
            String enzymeName = enzyme.getName();
            if (!this.enzymeFactory.enzymeLoaded(enzymeName)) {
                this.enzymeFactory.addEnzyme(this.searchParameters.getEnzyme());
            }
            this.enzymesCmb.setSelectedItem(enzymeName);
        } else {
            this.enzymesCmb.setSelectedIndex(0);
        }
        if (this.searchParameters.getIonSearched1() != null) {
            this.fragmentIon1Cmb.setSelectedItem(PeptideFragmentIon.getSubTypeAsString(this.searchParameters.getIonSearched1()));
        }
        if (this.searchParameters.getIonSearched2() != null) {
            this.fragmentIon2Cmb.setSelectedItem(PeptideFragmentIon.getSubTypeAsString(this.searchParameters.getIonSearched2()));
        }
        if (this.searchParameters.getnMissedCleavages() != null) {
            this.missedCleavagesTxt.setText(this.searchParameters.getnMissedCleavages() + "");
        }
        if (this.searchParameters.getPrecursorAccuracy() != null) {
            this.precursorIonAccuracyTxt.setText(this.searchParameters.getPrecursorAccuracy() + "");
        }
        if (this.searchParameters.getPrecursorAccuracyType() != null) {
            if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.PrecursorAccuracyType.PPM) {
                this.precursorIonUnit.setSelectedItem("ppm");
            } else if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.PrecursorAccuracyType.DA) {
                this.precursorIonUnit.setSelectedItem("Da");
            }
        }
        if (this.searchParameters.getFragmentIonAccuracy() != null) {
            this.fragmentIonAccuracyTxt.setText(this.searchParameters.getFragmentIonAccuracy() + "");
        }
        if (this.searchParameters.getMinChargeSearched() != null) {
            this.minPrecursorChargeTxt.setText(this.searchParameters.getMinChargeSearched().value + "");
        }
        if (this.searchParameters.getMaxChargeSearched() != null) {
            this.maxPrecursorChargeTxt.setText(this.searchParameters.getMaxChargeSearched().value + "");
        }
    }

    private void loadFastaFile(File file) {
        final File finalFile = file;
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalIcon, this.waitingIcon, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Loading Database. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                try {
                    progressDialog.setTitle("Importing Database. Please Wait...");
                    progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    SearchSettingsDialog.this.sequenceFactory.loadFastaFile(finalFile, progressDialog);
                }
                catch (IOException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SearchSettingsDialog.this, new String[]{"FASTA Import Error.", "File " + finalFile.getAbsolutePath() + " not found."}, "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (ClassNotFoundException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SearchSettingsDialog.this, new String[]{"FASTA Import Error.", "File index of " + finalFile.getName() + " could not be imported. Please contact the developers."}, "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (StringIndexOutOfBoundsException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SearchSettingsDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (IllegalArgumentException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(SearchSettingsDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    private Properties loadProperties(File aFile) {
        Properties screenProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(aFile);
            if (fis == null) {
                throw new IllegalArgumentException("Could not read the file you specified ('" + aFile.getAbsolutePath() + "').");
            }
            screenProps.load(fis);
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(this, new String[]{"Unable to read file: " + aFile.getName(), ioe.getMessage()}, "Error Reading File", 2);
        }
        return screenProps;
    }

    public void saveAsPressed() {
        if (this.validateParametersInput(true)) {
            File startLocation = new File(this.searchSettingsDialogParent.getLastSelectedFolder());
            if (this.configurationFileTxt_parameters.getText() != null && !this.configurationFileTxt_parameters.getText().trim().equals("")) {
                File temp = new File(this.configurationFileTxt_parameters.getText());
                startLocation = temp.getParentFile();
            }
            boolean complete = false;
            while (!complete) {
                JFileChooser fc = new JFileChooser(startLocation);
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File myFile) {
                        return myFile.getName().toLowerCase().endsWith(".parameters") || myFile.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "SearchGUI search parameters";
                    }
                };
                fc.setFileFilter(filter);
                int result = fc.showSaveDialog(this);
                if (result == 0) {
                    int choice;
                    File selected = fc.getSelectedFile();
                    this.searchSettingsDialogParent.setLastSelectedFolder(selected.getAbsolutePath());
                    this.parametersFile = !selected.getName().toLowerCase().endsWith(".parameters") ? (selected = new File(selected.getParentFile(), selected.getName() + ".parameters")) : (selected = new File(selected.getParentFile(), selected.getName()));
                    complete = true;
                    if (!selected.exists() || (choice = JOptionPane.showConfirmDialog(this, new String[]{"The file " + selected.getName() + " already exists.", "Overwrite?"}, "File Already Exists", 0)) != 1) continue;
                    complete = false;
                    continue;
                }
                return;
            }
            this.savePressed();
            this.configurationFileTxt_parameters.setText(this.parametersFile.getPath());
            this.searchParameters.setParametersFile(this.parametersFile);
        }
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        this.precursorIonLbl.setForeground(Color.BLACK);
        this.maxMissedCleavagesLabel.setForeground(Color.BLACK);
        this.fragmentIonLbl.setForeground(Color.BLACK);
        this.precursorChargeLbl.setForeground(Color.BLACK);
        this.databaseSettingsLbl.setForeground(Color.BLACK);
        this.enzymeLabel.setForeground(Color.BLACK);
        this.precursorIonLbl.setToolTipText(null);
        this.maxMissedCleavagesLabel.setToolTipText(null);
        this.fragmentIonLbl.setToolTipText(null);
        this.precursorChargeLbl.setToolTipText(null);
        this.databaseSettingsLbl.setToolTipText(null);
        this.enzymeLabel.setToolTipText(null);
        if (this.databaseSettingsTxt.getText() == null || this.databaseSettingsTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a search database.", "Search Database Not Found", 2);
            }
            this.databaseSettingsLbl.setForeground(Color.RED);
            this.databaseSettingsLbl.setToolTipText("Please select a valid '.fasta' or '.fas' database file");
            valid = false;
        } else {
            File test = new File(this.databaseSettingsTxt.getText().trim());
            if (!test.exists()) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The database file could not be found.", "Search Database Not Found", 2);
                }
                this.databaseSettingsLbl.setForeground(Color.RED);
                this.databaseSettingsLbl.setToolTipText("Database file could not be found!");
                valid = false;
            }
        }
        if (this.missedCleavagesTxt.getText() == null || this.missedCleavagesTxt.getText().trim().equals("")) {
            if (showMessage) {
                JOptionPane.showMessageDialog(this, "You need to specify a number of allowed missed cleavages.", "Missed Cleavages Error", 2);
            }
            valid = false;
            this.maxMissedCleavagesLabel.setForeground(Color.RED);
            this.maxMissedCleavagesLabel.setToolTipText("Please select the number of allowed missed cleavages");
        }
        int missedCleavages = -1;
        try {
            missedCleavages = Integer.parseInt(this.missedCleavagesTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the allowed missed cleavages.", "Missed Cleavages Error", 2);
            }
            valid = false;
            this.maxMissedCleavagesLabel.setForeground(Color.RED);
            this.maxMissedCleavagesLabel.setToolTipText("Please select a positive integer");
        }
        if (missedCleavages < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the allowed missed cleavages.", "Missed Cleavages Error", 2);
                this.missedCleavagesTxt.requestFocus();
            }
            valid = false;
            this.maxMissedCleavagesLabel.setForeground(Color.RED);
            this.maxMissedCleavagesLabel.setToolTipText("Please select a positive integer");
        }
        if (this.precursorIonAccuracyTxt.getText() == null || this.precursorIonAccuracyTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a precursor mass tolerance.", "Precursor Mass Tolerance Error", 2);
            }
            valid = false;
            this.precursorIonLbl.setForeground(Color.RED);
            this.precursorIonLbl.setToolTipText("Please select a precursor mass tolerance");
        }
        float precursorTolerance = -1.0f;
        try {
            precursorTolerance = Float.parseFloat(this.precursorIonAccuracyTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number (zero or more) for the precursor mass tolerance.", "Precursor Mass Tolerance Error", 2);
            }
            valid = false;
            this.precursorIonLbl.setForeground(Color.RED);
            this.precursorIonLbl.setToolTipText("Please select a positive number");
        }
        if (precursorTolerance < 0.0f) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number (zero or more) for the precursor mass tolerance.", "Precursor Mass Tolerance Error", 2);
            }
            valid = false;
            this.precursorIonLbl.setForeground(Color.RED);
            this.precursorIonLbl.setToolTipText("Please select a positive number");
        }
        if (this.fragmentIonAccuracyTxt.getText() == null || this.fragmentIonAccuracyTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a fragment mass tolerance.", "Fragment Mass Tolerance Error", 2);
            }
            valid = false;
            this.fragmentIonLbl.setForeground(Color.RED);
            this.fragmentIonLbl.setToolTipText("Please select the fragment mass tolerance");
        }
        float fragmentTolerance = -1.0f;
        try {
            fragmentTolerance = Float.parseFloat(this.fragmentIonAccuracyTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number (zero or more) for the fragment mass tolerance.", "Fragment Mass Tolerance Error", 2);
            }
            valid = false;
            this.fragmentIonLbl.setForeground(Color.RED);
            this.fragmentIonLbl.setToolTipText("Please select a positive number");
        }
        if (fragmentTolerance < 0.0f) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number (zero or more) for the fragment mass tolerance.", "Fragment Mass Tolerance Error", 2);
            }
            valid = false;
            this.fragmentIonLbl.setForeground(Color.RED);
            this.fragmentIonLbl.setToolTipText("Please select a positive number");
        }
        if (this.minPrecursorChargeTxt.getText() == null || this.minPrecursorChargeTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a lower bound for the precursor charge first.", "Lower Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select a lower bound for the precursor charge");
        }
        int chargeLowerBound = -1;
        try {
            chargeLowerBound = Integer.parseInt(this.minPrecursorChargeTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the lower bound of the precursor charge.", "Lower Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select positive integers");
        }
        if (chargeLowerBound <= 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the lower bound of the precursor charge.", "Lower Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select positive integers");
        }
        if (this.maxPrecursorChargeTxt.getText() == null || this.maxPrecursorChargeTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify an upper bound for the precursor charge.", "Upper Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select an upper bound for the precursor charge");
        }
        int chargeUpperBound = -1;
        try {
            chargeUpperBound = Integer.parseInt(this.maxPrecursorChargeTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the upper bound of the precursor charge.", "Upper Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select positive integers");
        }
        if (chargeUpperBound <= 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive integer for the upper bound of the precursor charge.", "Upper Bound Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Please select positive integers");
        }
        if (chargeUpperBound < chargeLowerBound) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "The minimum precursor charge must be lower than or equal to the maximum precursor charge.", "Precursor Charge Error", 2);
            }
            valid = false;
            this.precursorChargeLbl.setForeground(Color.RED);
            this.precursorChargeLbl.setToolTipText("Minimum precursor charge > Maximum precursor charge!");
        }
        if (this.enzymesCmb.getSelectedIndex() == 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "Please select an enzyme.", "Enzyme Error", 2);
            }
            valid = false;
            this.enzymeLabel.setForeground(Color.RED);
            this.enzymeLabel.setToolTipText("No enzyme selected!");
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    public SearchParameters getSearchParameters() {
        String modName;
        int i;
        SearchParameters tempSearchParameters = new SearchParameters();
        String dbPath = this.databaseSettingsTxt.getText().trim();
        if (!dbPath.equals("")) {
            File fastaFile = new File(this.databaseSettingsTxt.getText().trim());
            tempSearchParameters.setFastaFile(fastaFile);
        }
        Enzyme enzyme = this.enzymeFactory.getEnzyme(this.enzymesCmb.getSelectedItem().toString());
        tempSearchParameters.setEnzyme(enzyme);
        ModificationProfile modificationProfile = new ModificationProfile();
        for (i = 0; i < this.fixedModsTable.getRowCount(); ++i) {
            modName = (String)this.fixedModsTable.getValueAt(i, 1);
            modificationProfile.addFixedModification(this.ptmFactory.getPTM(modName));
            modificationProfile.setColor(modName, (Color)this.fixedModsTable.getValueAt(i, 0));
        }
        for (i = 0; i < this.variableModsTable.getRowCount(); ++i) {
            modName = (String)this.variableModsTable.getValueAt(i, 1);
            modificationProfile.addVariableModification(this.ptmFactory.getPTM(modName));
            modificationProfile.setColor(modName, (Color)this.variableModsTable.getValueAt(i, 0));
        }
        tempSearchParameters.setModificationProfile(modificationProfile);
        tempSearchParameters.setnMissedCleavages(new Integer(this.missedCleavagesTxt.getText().trim()));
        tempSearchParameters.setPrecursorAccuracy(new Double(this.precursorIonAccuracyTxt.getText().trim()));
        if (this.precursorIonUnit.getSelectedIndex() == 0) {
            tempSearchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.PPM);
        } else {
            tempSearchParameters.setPrecursorAccuracyType(SearchParameters.PrecursorAccuracyType.DA);
        }
        tempSearchParameters.setFragmentIonAccuracy(new Double(this.fragmentIonAccuracyTxt.getText().trim()));
        tempSearchParameters.setIonSearched1(this.fragmentIon1Cmb.getSelectedItem().toString().trim());
        tempSearchParameters.setIonSearched2(this.fragmentIon2Cmb.getSelectedItem().toString().trim());
        int charge = new Integer(this.minPrecursorChargeTxt.getText().trim());
        tempSearchParameters.setMinChargeSearched(new Charge(1, charge));
        charge = new Integer(this.maxPrecursorChargeTxt.getText().trim());
        tempSearchParameters.setMaxChargeSearched(new Charge(1, charge));
        if (this.configurationFileTxt_parameters.getText().length() > 0) {
            tempSearchParameters.setParametersFile(new File(this.configurationFileTxt_parameters.getText()));
        }
        this.ptmFactory.setSearchedOMSSAIndexes(tempSearchParameters.getModificationProfile());
        return tempSearchParameters;
    }

    /*
     * WARNING - void declaration
     */
    private void updateModificationList() {
        void var6_10;
        ArrayList<Object> allModificationsList = new ArrayList();
        if (this.modificationsListCombo.getSelectedIndex() == 0) {
            for (String name : this.searchSettingsDialogParent.getModificationUse()) {
                if (!this.searchSettingsDialogParent.getModificationUse().contains(name)) continue;
                allModificationsList.add(name);
            }
        } else {
            allModificationsList = this.ptmFactory.getPTMs();
        }
        int nFixed = this.fixedModsTable.getRowCount();
        int nVariable = this.variableModsTable.getRowCount();
        ArrayList<String> allModifications = new ArrayList<String>();
        for (String string : allModificationsList) {
            int j;
            boolean found = false;
            for (j = 0; j < nFixed; ++j) {
                if (!((String)this.fixedModsTable.getValueAt(j, 1)).equals(string)) continue;
                found = true;
                break;
            }
            if (!found) {
                for (j = 0; j < nVariable; ++j) {
                    if (!((String)this.variableModsTable.getValueAt(j, 1)).equals(string)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            allModifications.add(string);
        }
        Object[] allModificationsAsArray = new String[allModifications.size()];
        boolean bl = false;
        while (var6_10 < allModifications.size()) {
            allModificationsAsArray[var6_10] = (String)allModifications.get((int)var6_10);
            ++var6_10;
        }
        Arrays.sort(allModificationsAsArray);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.modificationsTable.getModel();
        defaultTableModel.getDataVector().removeAllElements();
        for (Object mod : allModificationsAsArray) {
            ((DefaultTableModel)this.modificationsTable.getModel()).addRow(new Object[]{this.ptmFactory.getColor((String)mod), mod, this.ptmFactory.getPTM((String)mod).getMass(), this.searchSettingsDialogParent.getModificationUse().contains(mod)});
        }
        ((DefaultTableModel)this.modificationsTable.getModel()).fireTableDataChanged();
        this.modificationsTable.repaint();
        double maxMass = Double.MIN_VALUE;
        double minMass = Double.MAX_VALUE;
        for (String ptm : this.ptmFactory.getPTMs()) {
            if (this.ptmFactory.getPTM(ptm).getMass() > maxMass) {
                maxMass = this.ptmFactory.getPTM(ptm).getMass();
            }
            if (!(this.ptmFactory.getPTM(ptm).getMass() < minMass)) continue;
            minMass = this.ptmFactory.getPTM(ptm).getMass();
        }
        this.modificationsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.modificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.modificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        this.fixedModsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.fixedModsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        this.variableModsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)this.variableModsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        if (this.modificationsTable.getRowCount() > 0) {
            this.modificationsTable.setRowSelectionInterval(0, 0);
        }
        this.enableAddRemoveButtons();
    }

    private void enableAddRemoveButtons() {
        this.removeVariableModification.setEnabled(this.variableModsTable.getSelectedRow() != -1);
        this.addVariableModification.setEnabled(this.modificationsTable.getSelectedRow() != -1);
        this.removeFixedModification.setEnabled(this.fixedModsTable.getSelectedRow() != -1);
        this.addFixedModification.setEnabled(this.modificationsTable.getSelectedRow() != -1);
    }

    private void updateListToolTip(JList list, MouseEvent evt) {
        String toolTip = null;
        int index = list.locationToIndex(evt.getPoint());
        Rectangle bounds = list.getCellBounds(index, index);
        if (index != -1 && bounds.contains(evt.getPoint())) {
            String name = (String)list.getModel().getElementAt(index);
            PTM ptm = this.ptmFactory.getPTM(name);
            String residuesAsString = "";
            if (ptm.getType() == 1) {
                residuesAsString = residuesAsString + "protein N-term";
            } else if (ptm.getType() == 5) {
                residuesAsString = residuesAsString + "peptide N-term";
            } else if (ptm.getType() == 2) {
                residuesAsString = residuesAsString + "protein starting by " + ptm.getPattern().toString();
            } else if (ptm.getType() == 6) {
                residuesAsString = residuesAsString + "peptide starting by " + ptm.getPattern().toString();
            }
            if (ptm.getType() == 3) {
                residuesAsString = residuesAsString + "protein C-term";
            } else if (ptm.getType() == 7) {
                residuesAsString = residuesAsString + "peptide C-term";
            } else if (ptm.getType() == 4) {
                residuesAsString = residuesAsString + "protein ending by " + ptm.getPattern().toString();
            } else if (ptm.getType() == 8) {
                residuesAsString = residuesAsString + "peptide ending by " + ptm.getPattern().toString();
            } else if (ptm.getType() == 0) {
                residuesAsString = residuesAsString + ptm.getPattern().toString();
            }
            toolTip = "<html><table border=\"0\"><tr><td>Name:</td><td>" + ptm.getName() + "</td>" + "</tr>" + "<tr>" + "<td>Mass:</td>" + "<td>" + ptm.getMass() + "</td>" + "</tr>" + "<tr>" + "<td>Target:</td>" + "<td>" + residuesAsString + "</td>" + "</tr>" + "</table>" + "</html>";
        }
        list.setToolTipText(toolTip);
    }

    @Override
    public void updateModifications() {
        this.updateModificationList();
    }

    public static ArrayList<String> loadModificationsUse(File file) {
        String modificationLine = "";
        ArrayList<String> modificationUse = new ArrayList<String>();
        if (file.exists()) {
            try {
                int start;
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#") || !line.equals("Modification use:")) continue;
                    modificationLine = br.readLine().trim();
                }
                br.close();
                ArrayList<String> modificationUses = new ArrayList<String>();
                while ((start = modificationLine.indexOf(MODIFICATION_SEPARATOR)) >= 0) {
                    String name = modificationLine.substring(0, start);
                    modificationLine = modificationLine.substring(start + 2);
                    if (name.trim().equals("")) continue;
                    modificationUses.add(name);
                }
                for (String name : modificationUses) {
                    start = name.indexOf("_");
                    String modificationName = name;
                    if (start != -1) {
                        modificationName = name.substring(0, start);
                    }
                    if (!PTMFactory.getInstance().containsPTM(modificationName)) continue;
                    modificationUse.add(modificationName);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occured when trying to load the modifications preferences.", "Configuration Import Error", 0);
            }
        }
        return modificationUse;
    }

    public static String getModificationUseAsString(ArrayList<String> modificationUse) {
        String result = "";
        for (String name : modificationUse) {
            result = result + name + MODIFICATION_SEPARATOR;
        }
        return result;
    }
}

