/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class MassErrorPlot
extends JPanel {
    private ArrayList<IonMatch> annotations;
    private ArrayList<Integer> currentFragmentIons;
    private boolean includeSinglyCharge;
    private boolean includeDoublyCharge;
    private boolean includeMoreThanTwoCharges;
    private ArrayList<IonMatch> currentlyUsedIonMatches;
    private ChartPanel chartPanel;
    private boolean useRelativeError = false;

    public MassErrorPlot(ArrayList<IonMatch> annotations, ArrayList<Integer> currentFragmentIons, MSnSpectrum currentSpectrum, double massTolerance, boolean includeSinglyCharge, boolean includeDoublyCharge, boolean includeMoreThanTwoCharges) {
        this(annotations, currentFragmentIons, currentSpectrum, massTolerance, includeSinglyCharge, includeDoublyCharge, includeMoreThanTwoCharges, false);
    }

    public MassErrorPlot(ArrayList<IonMatch> annotations, ArrayList<Integer> currentFragmentIons, MSnSpectrum currentSpectrum, double massTolerance, boolean includeSinglyCharge, boolean includeDoublyCharge, boolean includeMoreThanTwoCharges, boolean useRelativeError) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        this.currentlyUsedIonMatches = new ArrayList();
        this.annotations = annotations;
        this.currentFragmentIons = currentFragmentIons;
        this.includeSinglyCharge = includeSinglyCharge;
        this.includeDoublyCharge = includeDoublyCharge;
        this.includeMoreThanTwoCharges = includeMoreThanTwoCharges;
        this.useRelativeError = useRelativeError;
        this.currentlyUsedIonMatches = this.getCurrentlyUsedIonMatches();
        if (this.currentlyUsedIonMatches.size() > 0) {
            boolean useIntensityGrading = false;
            DefaultXYDataset xyDataset = new DefaultXYDataset();
            ArrayList<Color> colors = new ArrayList<Color>();
            double maxAnnotatedIntensity = 0.0;
            for (int i = 0; i < this.currentlyUsedIonMatches.size(); ++i) {
                IonMatch ionMatch = this.currentlyUsedIonMatches.get(i);
                if (!(ionMatch.peak.intensity > maxAnnotatedIntensity)) continue;
                maxAnnotatedIntensity = ionMatch.peak.intensity;
            }
            double totalIntensity = currentSpectrum.getTotalIntensity();
            double maxError = 0.0;
            for (int i = 0; i < this.currentlyUsedIonMatches.size(); ++i) {
                double[][] dataXY = new double[2][1];
                IonMatch ionMatch = this.currentlyUsedIonMatches.get(i);
                dataXY[0][0] = ionMatch.peak.mz;
                dataXY[1][0] = useRelativeError ? ionMatch.getRelativeError() : ionMatch.getAbsoluteError();
                if (Math.abs(dataXY[1][0]) > maxError) {
                    maxError = Math.abs(dataXY[1][0]);
                }
                xyDataset.addSeries((Comparable)((Object)ionMatch.getPeakAnnotation(true)), dataXY);
                colors.add(SpectrumPanel.determineFragmentIonColor(ionMatch.ion, false));
            }
            JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            for (int i = 0; i < colors.size(); ++i) {
                if (useIntensityGrading) {
                    renderer.setSeriesPaint(i, (Paint)colors.get(i));
                    renderer.setSeriesShape(i, renderer.getBaseShape());
                    continue;
                }
                renderer.setSeriesPaint(i, (Paint)colors.get(i));
                renderer.setSeriesShape(i, renderer.getBaseShape());
            }
            plot.setRenderer((XYItemRenderer)renderer);
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            if (useRelativeError) {
                plot.getRangeAxis().setLowerBound(-maxError * 1.1);
                plot.getRangeAxis().setUpperBound(maxError * 1.1);
            } else {
                plot.getRangeAxis().setLowerBound(-massTolerance);
                plot.getRangeAxis().setUpperBound(massTolerance);
            }
            plot.setRangeGridlinePaint((Paint)Color.black);
            ValueAxis domainAxis = plot.getDomainAxis();
            domainAxis.setRange(0.0, currentSpectrum.getMaxMz());
            plot.setDomainGridlinesVisible(false);
            chart.getPlot().setOutlineVisible(false);
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            this.chartPanel = new ChartPanel(chart);
            this.chartPanel.setBackground(Color.WHITE);
            this.add((Component)this.chartPanel);
        }
    }

    private ArrayList<IonMatch> getCurrentlyUsedIonMatches() {
        this.currentlyUsedIonMatches = new ArrayList();
        for (IonMatch ionMatch : this.annotations) {
            int currentCharge;
            PeptideFragmentIon fragmentIon;
            if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || !this.currentFragmentIons.contains((fragmentIon = (PeptideFragmentIon)ionMatch.ion).getSubType()) || !((currentCharge = ionMatch.charge.value) == 1 && this.includeSinglyCharge || currentCharge == 2 && this.includeDoublyCharge) && (currentCharge <= 2 || !this.includeMoreThanTwoCharges)) continue;
            this.currentlyUsedIonMatches.add(ionMatch);
        }
        return this.currentlyUsedIonMatches;
    }

    public int getNumberOfDataPointsInPlot() {
        return this.currentlyUsedIonMatches.size();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

