/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.preferences.ModificationProfile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class SequenceFragmentationPanel
extends JPanel {
    private HashMap<String, Rectangle> tooltipRectangles;
    private String[] iSequenceComponents;
    private ArrayList<IonMatch> iIonMatches;
    private double[] bIons;
    private double[] yIons;
    private Font iBaseFont = new Font("Monospaced", 0, 14);
    private final double iMaxBarHeight = 40.0;
    private final int iBarWidth = 3;
    private final int iHorizontalSpace = 3;
    private final int iXStart = 10;
    private boolean isModifiedSequence;
    private boolean iHighlightModifications;
    private ModificationProfile modificationProfile;
    private int forwardIon;
    private int rewindIon;
    private Color forwardColor;
    private Color rewindColor;

    public SequenceFragmentationPanel(String aSequence, ArrayList<IonMatch> aIonMatches, boolean boolModifiedSequence, boolean aHighlightModifications, ModificationProfile modificationProfile) throws HeadlessException {
        this(aSequence, aIonMatches, boolModifiedSequence, aHighlightModifications, modificationProfile, 1, 4);
    }

    public SequenceFragmentationPanel(String aSequence, ArrayList<IonMatch> aIonMatches, boolean boolModifiedSequence, boolean aHighlightModifications, ModificationProfile modificationProfile, int forwardIon, int rewindIon) throws HeadlessException {
        this.forwardIon = forwardIon;
        this.forwardColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
        this.rewindIon = rewindIon;
        this.rewindColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, rewindIon), false);
        this.modificationProfile = modificationProfile;
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(aSequence);
        this.iIonMatches = aIonMatches;
        this.iHighlightModifications = aHighlightModifications;
        this.normalizeMatchedIons();
        this.setPreferredSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
        this.tooltipRectangles = new HashMap();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                SequenceFragmentationPanel.this.mouseMovedHandler(me);
            }
        });
    }

    public SequenceFragmentationPanel(String taggedModifiedSequence, ArrayList<IonMatch> aIonMatches, boolean aHighlightModifications, ModificationProfile modificationProfile, int forwardIon, int rewindIon) throws HeadlessException {
        this.forwardIon = forwardIon;
        this.forwardColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
        this.rewindIon = rewindIon;
        this.rewindColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, rewindIon), false);
        this.modificationProfile = modificationProfile;
        this.isModifiedSequence = true;
        this.iSequenceComponents = this.parseSequenceIntoComponents(taggedModifiedSequence);
        this.iIonMatches = aIonMatches;
        this.iHighlightModifications = aHighlightModifications;
        this.normalizeMatchedIons();
        this.setPreferredSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
        this.tooltipRectangles = new HashMap();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                SequenceFragmentationPanel.this.mouseMovedHandler(me);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.iBaseFont);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yLocation = 50;
        int xLocation = 10;
        int lFontHeight = g2.getFontMetrics().getHeight();
        Double lMidStringHeight = (double)yLocation - (double)lFontHeight * 0.2;
        for (int i = 0; i < this.iSequenceComponents.length; ++i) {
            Rectangle tempRectangle;
            boolean modified;
            g2.setColor(Color.black);
            String residue = this.iSequenceComponents[i];
            String modification = "";
            boolean bl = modified = residue.indexOf("<") != -1;
            if (modified && this.iHighlightModifications) {
                modification = residue.substring(residue.indexOf("<"), residue.lastIndexOf(">") + 1);
                residue = residue.substring(0, residue.indexOf("<")) + residue.substring(residue.lastIndexOf(">") + 1);
            }
            if (modified) {
                Color color = this.modificationProfile.getColor(modification);
                if (color == null) {
                    color = this.forwardColor;
                }
                g2.setColor(color);
                String ptmName = modification.substring(1, modification.length() - 1);
                if (i == 0) {
                    String nTerminal = residue.substring(0, residue.length() - 1);
                    Rectangle tempRectangle2 = new Rectangle(xLocation - 1 + g2.getFontMetrics().stringWidth(nTerminal), yLocation - g2.getFontMetrics().getHeight() / 2 - 1, g2.getFontMetrics().stringWidth(residue.substring(residue.length() - 1)) + 2, g2.getFontMetrics().getHeight() / 2 + 4);
                    g2.fill(tempRectangle2);
                    this.tooltipRectangles.put("<html>" + ptmName + " (" + (i + 1) + ")</html>", tempRectangle2);
                    g2.setColor(Color.BLACK);
                    g2.drawString(nTerminal, xLocation, yLocation);
                    g2.setColor(Color.WHITE);
                    g2.drawString(residue.substring(residue.length() - 1), xLocation + g2.getFontMetrics().stringWidth(nTerminal), yLocation);
                    g2.setColor(Color.BLACK);
                } else if (i == this.iSequenceComponents.length - 1) {
                    tempRectangle = new Rectangle(xLocation - 1, yLocation - g2.getFontMetrics().getHeight() / 2 - 1, g2.getFontMetrics().stringWidth(residue.substring(0, 1)) + 2, g2.getFontMetrics().getHeight() / 2 + 4);
                    g2.fill(tempRectangle);
                    this.tooltipRectangles.put("<html>" + ptmName + " (" + (i + 1) + ")</html>", tempRectangle);
                    g2.setColor(Color.WHITE);
                    g2.drawString(residue.substring(0, 1), xLocation, yLocation);
                    g2.setColor(Color.BLACK);
                    g2.drawString(residue.substring(1), xLocation + g2.getFontMetrics().stringWidth(residue.substring(0, 1)), yLocation);
                } else {
                    tempRectangle = new Rectangle(xLocation - 1, yLocation - g2.getFontMetrics().getHeight() / 2 - 1, g2.getFontMetrics().stringWidth(residue) + 2, g2.getFontMetrics().getHeight() / 2 + 4);
                    g2.fill(tempRectangle);
                    this.tooltipRectangles.put("<html>" + ptmName + " (" + (i + 1) + ")</html>", tempRectangle);
                    g2.setColor(Color.WHITE);
                    g2.drawString(residue, xLocation, yLocation);
                    g2.setColor(Color.BLACK);
                }
            } else {
                g2.drawString(residue, xLocation, yLocation);
            }
            xLocation += g2.getFontMetrics().stringWidth(residue) + 3;
            if (i <= this.bIons.length - 1 && this.bIons[i] != 0.0) {
                int lBarHeight = (int)(this.bIons[i] * 40.0);
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                g2.setColor(this.forwardColor);
                Rectangle tempRectangle3 = new Rectangle(xLocation, lMidStringHeight.intValue() + 1, 3, lBarHeight);
                g2.fill(tempRectangle3);
                this.tooltipRectangles.put("<html>" + PeptideFragmentIon.getSubTypeAsString(this.forwardIon) + "<sub>" + (i + 1) + "</sub></html>", tempRectangle3);
            }
            if (i <= this.yIons.length - 1 && this.yIons[this.yIons.length - (i + 1)] != 0.0) {
                int lBarHeight = (int)(this.yIons[this.yIons.length - (i + 1)] * 40.0);
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                g2.setColor(this.rewindColor);
                int yBarStart = lMidStringHeight.intValue() - 1 - lBarHeight;
                tempRectangle = new Rectangle(xLocation, yBarStart, 3, lBarHeight);
                g2.fill(tempRectangle);
                this.tooltipRectangles.put("<html>" + PeptideFragmentIon.getSubTypeAsString(this.rewindIon) + "<sub>" + (this.yIons.length - i) + "</sub></html>", tempRectangle);
            }
            xLocation = xLocation + 3 + 3;
        }
        this.setPreferredSize(new Dimension(xLocation, 200));
    }

    private String[] parseSequenceIntoComponents(String aSequence) {
        String[] result;
        if (this.isModifiedSequence) {
            ArrayList<String> parts = new ArrayList<String>();
            String temp = aSequence;
            int start = 0;
            if (temp.startsWith("#")) {
                int nterm = temp.indexOf("#", start + 1);
                start = temp.indexOf("-", nterm);
            } else {
                start = temp.indexOf("-");
            }
            String part = temp.substring(0, ++start).trim();
            temp = temp.substring(start).trim();
            int endIndex = 1;
            if (temp.charAt(endIndex) == '<') {
                ++endIndex;
                while (temp.charAt(endIndex) != '>') {
                    ++endIndex;
                }
                ++endIndex;
            }
            part = part + temp.substring(0, endIndex);
            temp = temp.substring(endIndex);
            parts.add(part);
            while (temp.length() > 0) {
                start = 0;
                endIndex = 1;
                if (temp.charAt(start + endIndex) == '<') {
                    ++endIndex;
                    while (temp.charAt(start + endIndex) != '>') {
                        ++endIndex;
                    }
                    ++endIndex;
                }
                if (temp.charAt(start + endIndex) == '-') {
                    endIndex = temp.length();
                }
                part = temp.substring(0, endIndex);
                temp = temp.substring(endIndex);
                parts.add(part);
            }
            result = new String[parts.size()];
            parts.toArray(result);
        } else {
            result = new String[aSequence.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Character.toString(aSequence.charAt(i));
            }
        }
        return result;
    }

    private int estimateWidth() {
        int i;
        int lEstimateX = 10;
        ArrayList<String> unmodifiedString = new ArrayList<String>();
        for (i = 0; i < this.iSequenceComponents.length; ++i) {
            boolean modified;
            String residue = this.iSequenceComponents[i];
            boolean bl = modified = residue.indexOf("<") != -1;
            if (modified) {
                residue = residue.substring(0, residue.indexOf("<")) + residue.substring(residue.lastIndexOf(">") + 1);
            }
            unmodifiedString.add(residue);
        }
        for (i = 0; i < unmodifiedString.size(); ++i) {
            lEstimateX += this.getFontMetrics(this.iBaseFont).stringWidth((String)unmodifiedString.get(i)) + 3;
            lEstimateX += 6;
        }
        return lEstimateX += 10;
    }

    private int estimateHeight() {
        int lEstimateY = 0;
        lEstimateY += 20;
        lEstimateY = (int)((double)lEstimateY + 72.0);
        return lEstimateY;
    }

    private void normalizeMatchedIons() {
        this.bIons = new double[this.iSequenceComponents.length - 1];
        this.yIons = new double[this.iSequenceComponents.length - 1];
        double lMaxIntensity = 0.0;
        for (IonMatch lMatch : this.iIonMatches) {
            if (!(lMaxIntensity < lMatch.peak.intensity)) continue;
            lMaxIntensity = lMatch.peak.intensity;
        }
        for (IonMatch lMatch : this.iIonMatches) {
            if (lMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            double lRatio = lMatch.peak.intensity / lMaxIntensity;
            PeptideFragmentIon lFragmentIon = (PeptideFragmentIon)lMatch.ion;
            if (lFragmentIon.getSubType() == this.rewindIon) {
                if (this.yIons[lFragmentIon.getNumber() - 1] != 0.0 && this.yIons[lFragmentIon.getNumber() - 1] > lRatio) {
                    lRatio = this.yIons[lFragmentIon.getNumber() - 1];
                }
                this.yIons[lFragmentIon.getNumber() - 1] = lRatio;
                continue;
            }
            if (lFragmentIon.getSubType() != this.forwardIon) continue;
            if (this.bIons[lFragmentIon.getNumber() - 1] != 0.0 && this.bIons[lFragmentIon.getNumber() - 1] > lRatio) {
                lRatio = this.bIons[lFragmentIon.getNumber() - 1];
            }
            this.bIons[lFragmentIon.getNumber() - 1] = lRatio;
        }
    }

    public void setSequence(String lSequence, boolean boolModifiedSequence) {
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(lSequence);
    }

    public void setIonMatches(ArrayList lIonMatches) {
        this.iIonMatches = lIonMatches;
        this.normalizeMatchedIons();
    }

    private void mouseMovedHandler(MouseEvent me) {
        String tooltip = null;
        Iterator<String> rectangles = this.tooltipRectangles.keySet().iterator();
        boolean matchFound = false;
        while (rectangles.hasNext() && !matchFound) {
            String key = rectangles.next();
            if (!this.tooltipRectangles.get(key).contains(me.getPoint())) continue;
            tooltip = key;
            matchFound = true;
        }
        this.setToolTipText(tooltip);
    }
}

