/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting.waitinghandlers;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.DummyFrame;
import com.compomics.util.waiting.WaitingActionListener;
import com.compomics.util.waiting.WaitingHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.border.DropShadowBorder;

public class WaitingDialog
extends JDialog
implements WaitingHandler {
    private JDialog dialog;
    private Point naturalLocation;
    private Timer shakeTimer;
    private boolean runFinished = false;
    private boolean runCanceled = false;
    private ArrayList<String> tips = new ArrayList();
    private int currentTipIndex = -1;
    private String lastSelectedFolder;
    private Image waitingIcon;
    private Image normalIcon;
    private Frame waitingHandlerParent;
    private boolean shakeWhenFinished;
    private String processName;
    private String toolName;
    private String toolVersion;
    private WaitingActionListener waitingActionListener = null;
    private JPanel backgroundPanel;
    private JCheckBox closeDialogWhenImportCompletesCheckBox;
    private JButton closeJButton;
    private JLayeredPane layeredPane;
    private JButton nextJButton;
    private JButton okButton;
    private JPanel processProgressPanel;
    private JProgressBar progressBar;
    private JTextArea reportArea;
    private JScrollPane reportAreaScrollPane;
    private JLabel saveReportLabel;
    private JProgressBar secondaryJProgressBar;
    private JSplitPane secondaryProgressBarSplitPane;
    private JCheckBox showTipOfTheDayCheckBox;
    private JProgressBar tempJProgressBar;
    private JEditorPane tipOfTheDayEditorPane;
    private JPanel tipOfTheDayJPanel;
    private JLayeredPane tipOfTheDayLayeredPane;
    private JScrollPane tipOfTheDayScrollPane;

    public WaitingDialog(Frame waitingHandlerParent, Image normalIcon, Image waitingIcon, boolean shakeWhenFinished, String processName, String toolName, String toolVersion, boolean modal) {
        this(waitingHandlerParent, normalIcon, waitingIcon, shakeWhenFinished, new ArrayList<String>(), processName, toolName, toolVersion, modal);
    }

    public WaitingDialog(Frame waitingHandlerParent, Image normalIcon, Image waitingIcon, boolean shakeWhenFinished, ArrayList<String> tips, String processName, String toolName, String toolVersion, boolean modal) {
        super(waitingHandlerParent, modal);
        this.initComponents();
        this.waitingHandlerParent = waitingHandlerParent;
        this.waitingIcon = waitingIcon;
        this.normalIcon = normalIcon;
        this.shakeWhenFinished = shakeWhenFinished;
        this.processName = processName;
        this.toolName = toolName;
        this.toolVersion = toolVersion;
        this.setTitle(processName + " - Please Wait...");
        this.setSecondaryProgressCounterIndeterminate(true);
        this.resizeLayeredPanes();
        if (tips != null && !tips.isEmpty()) {
            this.setTipOfTheDay(tips);
            this.tipOfTheDayEditorPane.setText(this.getTipOfTheDay());
        } else {
            this.tipOfTheDayJPanel.setVisible(false);
            this.showTipOfTheDayCheckBox.setSelected(false);
            this.showTipOfTheDayCheckBox.setEnabled(false);
        }
        if (waitingHandlerParent != null) {
            this.setLocationRelativeTo(waitingHandlerParent);
            if (waitingIcon != null) {
                waitingHandlerParent.setIconImage(waitingIcon);
            }
        }
    }

    public void closeWhenComplete(boolean close) {
        this.closeDialogWhenImportCompletesCheckBox.setSelected(close);
    }

    private void setTipOfTheDay(ArrayList<String> tips) {
        this.tips = tips;
        if (tips == null || tips.isEmpty()) {
            this.showTipOfTheDayCheckBox.setSelected(false);
            this.showTipOfTheDayCheckBox.setEnabled(false);
            this.tipOfTheDayJPanel.setVisible(false);
        }
    }

    @Override
    public void setMaxPrimaryProgressCounter(int maxProgressValue) {
        this.progressBar.setMaximum(maxProgressValue);
    }

    @Override
    public void increasePrimaryProgressCounter() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    @Override
    public void increasePrimaryProgressCounter(int amount) {
        this.progressBar.setValue(this.progressBar.getValue() + amount);
    }

    @Override
    public void setMaxSecondaryProgressCounter(int maxProgressValue) {
        this.secondaryJProgressBar.setValue(0);
        this.secondaryJProgressBar.setMaximum(maxProgressValue);
    }

    @Override
    public void resetSecondaryProgressCounter() {
        this.secondaryJProgressBar.setIndeterminate(false);
        this.secondaryJProgressBar.setStringPainted(true);
        this.secondaryJProgressBar.setValue(0);
    }

    @Override
    public void resetPrimaryProgressCounter() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
    }

    @Override
    public void increaseSecondaryProgressCounter() {
        this.secondaryJProgressBar.setValue(this.secondaryJProgressBar.getValue() + 1);
    }

    @Override
    public void setSecondaryProgressCounter(int value) {
        this.secondaryJProgressBar.setValue(value);
    }

    @Override
    public void increaseSecondaryProgressCounter(int amount) {
        this.secondaryJProgressBar.setValue(this.secondaryJProgressBar.getValue() + amount);
    }

    @Override
    public void setSecondaryProgressCounterIndeterminate(boolean indeterminate) {
        if (indeterminate) {
            this.secondaryProgressBarSplitPane.setDividerLocation(this.secondaryProgressBarSplitPane.getWidth());
        } else {
            this.secondaryProgressBarSplitPane.setDividerLocation(0);
        }
    }

    public String getLastSelectedFolder() {
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(String lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.processProgressPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.layeredPane = new JLayeredPane();
        this.reportAreaScrollPane = new JScrollPane();
        this.reportArea = new JTextArea();
        this.tipOfTheDayJPanel = new JPanel();
        this.tipOfTheDayLayeredPane = new JLayeredPane();
        this.tipOfTheDayScrollPane = new JScrollPane();
        this.tipOfTheDayEditorPane = new JEditorPane();
        this.closeJButton = new JButton();
        this.nextJButton = new JButton();
        this.secondaryProgressBarSplitPane = new JSplitPane();
        this.secondaryJProgressBar = new JProgressBar();
        this.tempJProgressBar = new JProgressBar();
        this.okButton = new JButton();
        this.saveReportLabel = new JLabel();
        this.showTipOfTheDayCheckBox = new JCheckBox();
        this.closeDialogWhenImportCompletesCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Importing Data - Please Wait...");
        this.setMinimumSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WaitingDialog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                WaitingDialog.this.formComponentResized(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.processProgressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        this.processProgressPanel.setOpaque(false);
        this.progressBar.setToolTipText("Total Progress");
        this.progressBar.setStringPainted(true);
        this.reportArea.setBackground(new Color(254, 254, 254));
        this.reportArea.setColumns(20);
        this.reportArea.setEditable(false);
        this.reportArea.setLineWrap(true);
        this.reportArea.setRows(5);
        this.reportAreaScrollPane.setViewportView(this.reportArea);
        this.reportAreaScrollPane.setBounds(0, 0, 842, 490);
        this.layeredPane.add((Component)this.reportAreaScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.tipOfTheDayJPanel.setOpaque(false);
        this.tipOfTheDayJPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                WaitingDialog.this.tipOfTheDayJPanelComponentResized(evt);
            }
        });
        this.tipOfTheDayScrollPane.setBorder((Border)new DropShadowBorder());
        this.tipOfTheDayScrollPane.setHorizontalScrollBarPolicy(31);
        this.tipOfTheDayScrollPane.setVerticalScrollBarPolicy(21);
        this.tipOfTheDayScrollPane.setOpaque(false);
        this.tipOfTheDayEditorPane.setEditable(false);
        this.tipOfTheDayEditorPane.setBorder(BorderFactory.createLineBorder(new Color(240, 240, 240), 20));
        this.tipOfTheDayEditorPane.setContentType("text/html");
        this.tipOfTheDayEditorPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n<body style=\"background-color:#F0F0F0;\">\n    <p style=\"margin-top: 0\">\r\n     <b> \rTip of the Day!</b>\n     <br><br>\n     Did you know that. Did you know that. Did you know that. Did you know that. Did you know that. \n     Did you know that.  Did you know that.  Did you know that.  Did you know that.  Did you know that.\n    <br><br>\n    Did you know that.  Did you know that.  Did you know that.  Did you know that.  Did you know that.\n    </p>\r\n  </body>\r\n</html>\r\n");
        this.tipOfTheDayEditorPane.setOpaque(false);
        this.tipOfTheDayEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                WaitingDialog.this.tipOfTheDayEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.tipOfTheDayScrollPane.setViewportView(this.tipOfTheDayEditorPane);
        this.tipOfTheDayScrollPane.setBounds(0, 2, 210, 260);
        this.tipOfTheDayLayeredPane.add((Component)this.tipOfTheDayScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.closeJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/close_grey.png")));
        this.closeJButton.setToolTipText("Close");
        this.closeJButton.setBorderPainted(false);
        this.closeJButton.setContentAreaFilled(false);
        this.closeJButton.setIconTextGap(0);
        this.closeJButton.setMargin(new Insets(2, 0, 2, 0));
        this.closeJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/close.png")));
        this.closeJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WaitingDialog.this.closeJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WaitingDialog.this.closeJButtonMouseExited(evt);
            }
        });
        this.closeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingDialog.this.closeJButtonActionPerformed(evt);
            }
        });
        this.closeJButton.setBounds(170, 0, 40, 33);
        this.tipOfTheDayLayeredPane.add((Component)this.closeJButton, JLayeredPane.POPUP_LAYER);
        this.nextJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/next_grey.png")));
        this.nextJButton.setToolTipText("Next Tip");
        this.nextJButton.setBorderPainted(false);
        this.nextJButton.setContentAreaFilled(false);
        this.nextJButton.setIconTextGap(0);
        this.nextJButton.setMargin(new Insets(2, 0, 2, 0));
        this.nextJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/next.png")));
        this.nextJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WaitingDialog.this.nextJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WaitingDialog.this.nextJButtonMouseExited(evt);
            }
        });
        this.nextJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingDialog.this.nextJButtonActionPerformed(evt);
            }
        });
        this.nextJButton.setBounds(170, 230, 40, 33);
        this.tipOfTheDayLayeredPane.add((Component)this.nextJButton, JLayeredPane.POPUP_LAYER);
        GroupLayout tipOfTheDayJPanelLayout = new GroupLayout(this.tipOfTheDayJPanel);
        this.tipOfTheDayJPanel.setLayout(tipOfTheDayJPanelLayout);
        tipOfTheDayJPanelLayout.setHorizontalGroup(tipOfTheDayJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tipOfTheDayLayeredPane, -1, 210, Short.MAX_VALUE));
        tipOfTheDayJPanelLayout.setVerticalGroup(tipOfTheDayJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tipOfTheDayLayeredPane, -1, 270, Short.MAX_VALUE));
        this.tipOfTheDayJPanel.setBounds(610, 200, 210, 270);
        this.layeredPane.add((Component)this.tipOfTheDayJPanel, JLayeredPane.POPUP_LAYER);
        this.secondaryProgressBarSplitPane.setBorder(null);
        this.secondaryProgressBarSplitPane.setDividerLocation(0);
        this.secondaryProgressBarSplitPane.setDividerSize(0);
        this.secondaryJProgressBar.setToolTipText("Current Process Progress");
        this.secondaryJProgressBar.setStringPainted(true);
        this.secondaryProgressBarSplitPane.setRightComponent(this.secondaryJProgressBar);
        this.tempJProgressBar.setToolTipText("Current Process Progress");
        this.tempJProgressBar.setIndeterminate(true);
        this.tempJProgressBar.setString("");
        this.secondaryProgressBarSplitPane.setLeftComponent(this.tempJProgressBar);
        GroupLayout processProgressPanelLayout = new GroupLayout(this.processProgressPanel);
        this.processProgressPanel.setLayout(processProgressPanelLayout);
        processProgressPanelLayout.setHorizontalGroup(processProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, processProgressPanelLayout.createSequentialGroup().addContainerGap().addGroup(processProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.layeredPane, GroupLayout.Alignment.LEADING, -1, 842, Short.MAX_VALUE).addGroup(processProgressPanelLayout.createSequentialGroup().addComponent(this.progressBar, -1, 591, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondaryProgressBarSplitPane, -2, 245, -2))).addContainerGap()));
        processProgressPanelLayout.setVerticalGroup(processProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processProgressPanelLayout.createSequentialGroup().addGroup(processProgressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.secondaryProgressBarSplitPane).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.layeredPane, -1, 491, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("Cancel");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.saveReportLabel.setText("<html><a href=\\\"dummy_link\"><i>Save Report</i></a></html>");
        this.saveReportLabel.setToolTipText("Save the report to a text file");
        this.saveReportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WaitingDialog.this.saveReportLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WaitingDialog.this.saveReportLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                WaitingDialog.this.saveReportLabelMouseReleased(evt);
            }
        });
        this.showTipOfTheDayCheckBox.setSelected(true);
        this.showTipOfTheDayCheckBox.setText("Show Tip of the Day");
        this.showTipOfTheDayCheckBox.setToolTipText("Show/Hide Tip of the Day");
        this.showTipOfTheDayCheckBox.setIconTextGap(10);
        this.showTipOfTheDayCheckBox.setOpaque(false);
        this.showTipOfTheDayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingDialog.this.showTipOfTheDayCheckBoxActionPerformed(evt);
            }
        });
        this.closeDialogWhenImportCompletesCheckBox.setText("Close this dialog when the process is complete.");
        this.closeDialogWhenImportCompletesCheckBox.setIconTextGap(10);
        this.closeDialogWhenImportCompletesCheckBox.setOpaque(false);
        this.closeDialogWhenImportCompletesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingDialog.this.closeDialogWhenImportCompletesCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.processProgressPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.saveReportLabel, -2, 70, -2).addGap(29, 29, 29).addComponent(this.showTipOfTheDayCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeDialogWhenImportCompletesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton, -2, 84, -2))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processProgressPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.saveReportLabel, -2, -1, -2).addComponent(this.showTipOfTheDayCheckBox).addComponent(this.closeDialogWhenImportCompletesCheckBox)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.runFinished || this.runCanceled) {
            if (this.waitingHandlerParent instanceof DummyFrame) {
                ((DummyFrame)this.waitingHandlerParent).dispose();
            }
            this.dispose();
        } else {
            this.setRunCanceled();
        }
    }

    private void saveReportLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void saveReportLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void saveReportLabelMouseReleased(MouseEvent evt) {
        int choice;
        File outputFile = null;
        JFileChooser fc = new JFileChooser(this.getLastSelectedFolder());
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("txt") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Supported formats: Text (.txt)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showSaveDialog(this);
        if (result == 0 && (outputFile = fc.getSelectedFile()).exists() && (choice = JOptionPane.showConfirmDialog(this, new String[]{"The file " + outputFile.getName() + " already exists!", "Overwrite?"}, "File Already Exists", 0)) == 1) {
            return;
        }
        if (outputFile != null) {
            this.saveReport(outputFile);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaitingDialog.this.resizeLayeredPanes();
            }
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        this.okButtonActionPerformed(null);
    }

    private void tipOfTheDayJPanelComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaitingDialog.this.resizeLayeredPanes();
            }
        });
    }

    private void closeJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void closeJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        this.tipOfTheDayJPanel.setVisible(false);
        this.showTipOfTheDayCheckBox.setSelected(false);
    }

    private void nextJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void nextJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nextJButtonActionPerformed(ActionEvent evt) {
        this.tipOfTheDayEditorPane.setText(this.getTipOfTheDay());
    }

    private void showTipOfTheDayCheckBoxActionPerformed(ActionEvent evt) {
        this.tipOfTheDayJPanel.setVisible(this.showTipOfTheDayCheckBox.isSelected());
    }

    private void tipOfTheDayEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(evt.getDescription());
            this.setCursor(new Cursor(0));
        }
    }

    private void closeDialogWhenImportCompletesCheckBoxActionPerformed(ActionEvent evt) {
    }

    @Override
    public void setRunFinished() {
        this.runFinished = true;
        this.okButton.setText("OK");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.setStringPainted(true);
        this.setTitle(this.processName + " - Completed!");
        this.secondaryProgressBarSplitPane.setDividerLocation(0);
        this.secondaryJProgressBar.setIndeterminate(false);
        this.secondaryJProgressBar.setValue(this.secondaryJProgressBar.getMaximum());
        this.secondaryJProgressBar.setString(this.processName + " Completed!");
        if (this.normalIcon != null && this.waitingHandlerParent != null) {
            this.waitingHandlerParent.setIconImage(this.normalIcon);
        }
        if (this.shakeWhenFinished) {
            this.startShake();
        }
        if (this.closeDialogWhenImportCompletesCheckBox.isSelected()) {
            this.dispose();
        } else {
            this.closeDialogWhenImportCompletesCheckBox.setEnabled(false);
        }
    }

    @Override
    public void setRunCanceled() {
        if (!this.runCanceled) {
            this.runCanceled = true;
            if (this.waitingActionListener != null) {
                this.waitingActionListener.cancelPressed();
            }
            this.appendReportEndLine();
            this.appendReport(this.processName + " Canceled!", true, true);
            this.okButton.setText("OK");
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.secondaryProgressBarSplitPane.setDividerLocation(0);
        this.secondaryJProgressBar.setIndeterminate(false);
        this.secondaryJProgressBar.setValue(0);
        this.secondaryJProgressBar.setString(this.processName + " Canceled!");
        this.setTitle(this.processName + " - Canceled");
        if (this.normalIcon != null && this.waitingHandlerParent != null) {
            this.waitingHandlerParent.setIconImage(this.normalIcon);
        }
    }

    @Override
    public void appendReport(String report, boolean includeDate, boolean addNewLine) {
        if (includeDate) {
            Date date = new Date();
            this.reportArea.append(date + "        " + report);
        } else {
            this.reportArea.append(report);
        }
        if (addNewLine) {
            this.reportArea.append("\n");
        }
        this.reportArea.setCaretPosition(this.reportArea.getText().length());
    }

    @Override
    public void appendReportNewLineNoDate() {
        this.reportArea.append("        ");
        this.reportArea.setCaretPosition(this.reportArea.getText().length());
    }

    @Override
    public void appendReportEndLine() {
        this.reportArea.append("\n");
        this.reportArea.setCaretPosition(this.reportArea.getText().length());
    }

    @Override
    public boolean isRunCanceled() {
        return this.runCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveReport(File aFile) {
        String report = this.getReport(aFile);
        BufferedWriter bw = null;
        String filePath = aFile.getAbsolutePath();
        if (!filePath.endsWith(".txt")) {
            filePath = filePath + ".txt";
        }
        bw = new BufferedWriter(new FileWriter(filePath));
        bw.write(report);
        bw.flush();
        JOptionPane.showMessageDialog(this, "Report written to file '" + filePath + "'.", "Report Saved", 1);
        if (bw == null) return;
        try {
            bw.close();
            return;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, new String[]{"Error writing report to file:", ioe.getMessage()}, "Save Failed", 0);
        }
        return;
        catch (IOException ioe) {
            try {
                JOptionPane.showMessageDialog(this, new String[]{"Error writing report to file:", ioe.getMessage()}, "Save Failed", 0);
                if (bw == null) return;
            }
            catch (Throwable throwable) {
                if (bw == null) throw throwable;
                try {
                    bw.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    JOptionPane.showMessageDialog(this, new String[]{"Error writing report to file:", ioe2.getMessage()}, "Save Failed", 0);
                }
                throw throwable;
            }
            try {
                bw.close();
                return;
            }
            catch (IOException ioe3) {
                JOptionPane.showMessageDialog(this, new String[]{"Error writing report to file:", ioe3.getMessage()}, "Save Failed", 0);
            }
            return;
        }
    }

    public void startShake() {
        this.naturalLocation = this.getLocation();
        final long startTime = System.currentTimeMillis();
        this.dialog = this;
        this.shakeTimer = new Timer(5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double TWO_PI = Math.PI * 2;
                double SHAKE_CYCLE = 50.0;
                long elapsed = System.currentTimeMillis() - startTime;
                double waveOffset = (double)elapsed % SHAKE_CYCLE / SHAKE_CYCLE;
                double angle = waveOffset * TWO_PI;
                int SHAKE_DISTANCE = 10;
                int shakenX = (int)(Math.sin(angle) * (double)SHAKE_DISTANCE + (double)((WaitingDialog)WaitingDialog.this).naturalLocation.x);
                WaitingDialog.this.dialog.setLocation(shakenX, ((WaitingDialog)WaitingDialog.this).naturalLocation.y);
                WaitingDialog.this.dialog.repaint();
                int SHAKE_DURATION = 1000;
                if (elapsed >= (long)SHAKE_DURATION) {
                    WaitingDialog.this.stopShake();
                }
            }
        });
        this.shakeTimer.start();
    }

    private void stopShake() {
        this.shakeTimer.stop();
        this.dialog.setLocation(this.naturalLocation);
        this.dialog.repaint();
        this.appendReport("Your peptides have been shaken!", true, true);
    }

    public JProgressBar getSecondaryProgressBar() {
        return this.secondaryJProgressBar;
    }

    private void resizeLayeredPanes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaitingDialog.this.layeredPane.getComponent(1).setBounds(0, 0, WaitingDialog.this.layeredPane.getWidth(), WaitingDialog.this.layeredPane.getHeight());
                WaitingDialog.this.layeredPane.getComponent(0).setBounds(WaitingDialog.this.layeredPane.getWidth() - 255, WaitingDialog.this.layeredPane.getHeight() - 300, 230, 280);
                WaitingDialog.this.layeredPane.revalidate();
                WaitingDialog.this.layeredPane.repaint();
                WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(2).setBounds(0, 0, WaitingDialog.this.tipOfTheDayLayeredPane.getWidth(), WaitingDialog.this.tipOfTheDayLayeredPane.getHeight());
                WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(0).setBounds(WaitingDialog.this.tipOfTheDayLayeredPane.getWidth() - 40, -2, WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(0).getWidth(), WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(0).getHeight());
                WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(1).setBounds(WaitingDialog.this.tipOfTheDayLayeredPane.getWidth() - 40, WaitingDialog.this.tipOfTheDayLayeredPane.getHeight() - 35, WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(1).getWidth(), WaitingDialog.this.tipOfTheDayLayeredPane.getComponent(1).getHeight());
                WaitingDialog.this.tipOfTheDayLayeredPane.revalidate();
                WaitingDialog.this.tipOfTheDayLayeredPane.repaint();
            }
        });
    }

    private String getTipOfTheDay() {
        String htmlStart = "<html><head></head><body style=\"background-color:#F0F0F0;\"> <p style=\"margin-top: 0\"><b>Tip of the Day!</b><br><br>";
        String htmlEnd = "</p></body></html>";
        int newTipIndex = (int)(Math.random() * (double)this.tips.size());
        while (newTipIndex == this.currentTipIndex) {
            newTipIndex = (int)(Math.random() * (double)this.tips.size());
        }
        this.currentTipIndex = newTipIndex;
        return htmlStart + this.tips.get(this.currentTipIndex) + htmlEnd;
    }

    @Override
    public void setWaitingText(String text) {
        this.setTitle(text);
    }

    @Override
    public boolean isRunFinished() {
        return this.runFinished;
    }

    public String getReport(File aFile) {
        StringBuffer output = new StringBuffer();
        String host = " @ ";
        try {
            host = host + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        output.append("# ------------------------------------------------------------------" + System.getProperty("line.separator") + "# " + this.toolName + " " + this.toolVersion + " Report File" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# Originally saved by: " + System.getProperty("user.name") + host + System.getProperty("line.separator") + "#                  on: " + sdf.format(new Date()));
        if (aFile != null) {
            output.append(System.getProperty("line.separator") + "#                  as: " + aFile.getName());
        }
        output.append(System.getProperty("line.separator") + "# ------------------------------------------------------------------" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        String report = this.reportArea.getText();
        report = report.replace("        ", "\t");
        output.append(report + System.getProperty("line.separator"));
        return output.toString();
    }

    @Override
    public void setPrimaryProgressCounterIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setStringPainted(!indeterminate);
    }

    public void setCloseDialogWhenImportCompletes(boolean closeWhenComplete, boolean enabled) {
        this.closeDialogWhenImportCompletesCheckBox.setSelected(closeWhenComplete);
        this.closeDialogWhenImportCompletesCheckBox.setEnabled(enabled);
    }

    public void setRunNotFinished() {
        this.runFinished = false;
        this.okButton.setText("Cancel");
        this.secondaryJProgressBar.setString(null);
        if (this.waitingIcon != null && this.waitingHandlerParent != null) {
            this.waitingHandlerParent.setIconImage(this.waitingIcon);
        }
    }

    @Override
    public boolean isReport() {
        return true;
    }

    public void addWaitingActionListener(WaitingActionListener waitingActionListener) {
        this.waitingActionListener = waitingActionListener;
    }

    @Override
    public void setSecondaryProgressText(String text) {
        this.secondaryJProgressBar.setString(text);
    }

    @Override
    public int getPrimaryProgressCounter() {
        return this.progressBar.getValue();
    }

    @Override
    public int getMaxPrimaryProgressCounter() {
        return this.progressBar.getMaximum();
    }

    @Override
    public int getSecondaryProgressCounter() {
        return this.secondaryJProgressBar.getValue();
    }

    @Override
    public int getMaxSecondaryProgressCounter() {
        return this.secondaryJProgressBar.getMaximum();
    }
}

