/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class AnnotationPreferences
implements Serializable {
    static final long serialVersionUID = -524156803097913546L;
    private boolean yAxisZoomExcludesBackgroundPeaks = true;
    private boolean intensityIonTable = true;
    private boolean showBars = false;
    private boolean showAllPeaks = false;
    private double intensityLimit = 0.75;
    private boolean automaticAnnotation = true;
    private HashMap<Ion.IonType, ArrayList<Integer>> selectedIons = new HashMap();
    private NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
    private boolean neutralLossesSequenceDependant = true;
    private ArrayList<Integer> selectedCharges = new ArrayList();
    private double fragmentIonAccuracy;
    private Peptide currentPeptide;
    private int currentPrecursorCharge = 0;
    private boolean showForwardIonDeNovoTags = false;
    private boolean showRewindIonDeNovoTags = false;
    private int deNovoCharge = 1;

    public void setPreferencesFromSearchParamaers(SearchParameters searchParameters) {
        this.clearIonTypes();
        this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, searchParameters.getIonSearched1());
        this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, searchParameters.getIonSearched2());
        this.addIonType(Ion.IonType.PRECURSOR_ION);
        this.addIonType(Ion.IonType.IMMONIUM_ION);
        this.addIonType(Ion.IonType.REPORTER_ION);
        this.setFragmentIonAccuracy(searchParameters.getFragmentIonAccuracy());
    }

    public void setCurrentSettings(Peptide currentPeptide, int currentPrecursorCharge, boolean newSpectrum) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.currentPeptide = currentPeptide;
        this.currentPrecursorCharge = currentPrecursorCharge;
        if (newSpectrum && this.automaticAnnotation) {
            this.resetAutomaticAnnotation();
        } else if (this.neutralLossesSequenceDependant) {
            this.neutralLossesMap = SpectrumAnnotator.getDefaultLosses(currentPeptide);
        }
    }

    public void resetAutomaticAnnotation() throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.selectedCharges.clear();
        if (this.currentPrecursorCharge == 1) {
            this.selectedCharges.add(this.currentPrecursorCharge);
        } else {
            for (int charge = 1; charge < this.currentPrecursorCharge; ++charge) {
                this.selectedCharges.add(charge);
            }
        }
        this.neutralLossesMap = SpectrumAnnotator.getDefaultLosses(this.currentPeptide);
    }

    public boolean areNeutralLossesSequenceDependant() {
        return this.neutralLossesSequenceDependant;
    }

    public void setNeutralLossesSequenceDependant(boolean neutralLossesSequenceDependant) {
        this.neutralLossesSequenceDependant = neutralLossesSequenceDependant;
    }

    public ArrayList<Integer> getValidatedCharges() {
        return this.selectedCharges;
    }

    public void clearCharges() {
        this.selectedCharges.clear();
    }

    public void addSelectedCharge(int selectedCharge) {
        if (!this.selectedCharges.contains(selectedCharge)) {
            this.selectedCharges.add(selectedCharge);
        }
    }

    public void clearNeutralLosses() {
        this.neutralLossesMap.clearNeutralLosses();
    }

    public NeutralLossesMap getNeutralLosses() {
        return this.neutralLossesMap;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLossesMap.addNeutralLoss(neutralLoss, 1, 1);
    }

    public HashMap<Ion.IonType, ArrayList<Integer>> getIonTypes() {
        return this.selectedIons;
    }

    public ArrayList<Integer> getFragmentIonTypes() {
        if (this.selectedIons.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) == null) {
            return new ArrayList<Integer>();
        }
        return this.selectedIons.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
    }

    public void clearIonTypes() {
        this.selectedIons.clear();
    }

    public void addIonType(Ion.IonType ionType, int subType) {
        if (!this.selectedIons.containsKey((Object)ionType)) {
            this.selectedIons.put(ionType, new ArrayList());
        }
        this.selectedIons.get((Object)ionType).add(subType);
    }

    public void addIonType(Ion.IonType ionType) {
        if (!this.selectedIons.containsKey((Object)ionType)) {
            this.selectedIons.put(ionType, new ArrayList());
        }
        for (int subType : Ion.getPossibleSubtypes(ionType)) {
            this.selectedIons.get((Object)ionType).add(subType);
        }
    }

    public void useAutomaticAnnotation(boolean automaticAnnotation) {
        this.automaticAnnotation = automaticAnnotation;
        if (automaticAnnotation) {
            this.neutralLossesSequenceDependant = true;
        }
    }

    public boolean useAutomaticAnnotation() {
        return this.automaticAnnotation;
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonAccuracy;
    }

    public void setFragmentIonAccuracy(double fragmentIonAccuracy) {
        this.fragmentIonAccuracy = fragmentIonAccuracy;
    }

    public int getCurrentPrecursorCharge() {
        return this.currentPrecursorCharge;
    }

    public double getAnnotationIntensityLimit() {
        return this.intensityLimit;
    }

    public void setAnnotationLevel(double intensityLimit) {
        this.intensityLimit = intensityLimit;
    }

    public boolean showAllPeaks() {
        return this.showAllPeaks;
    }

    public void setShowAllPeaks(boolean showAllPeaks) {
        this.showAllPeaks = showAllPeaks;
    }

    public boolean showBars() {
        return this.showBars;
    }

    public void setShowBars(boolean showBars) {
        this.showBars = showBars;
    }

    public boolean useIntensityIonTable() {
        return this.intensityIonTable;
    }

    public void setIntensityIonTable(boolean intensityIonTable) {
        this.intensityIonTable = intensityIonTable;
    }

    public boolean yAxisZoomExcludesBackgroundPeaks() {
        return this.yAxisZoomExcludesBackgroundPeaks;
    }

    public void setYAxisZoomExcludesBackgroundPeaks(boolean yAxisZoomExcludesBackgroundPeaks) {
        this.yAxisZoomExcludesBackgroundPeaks = yAxisZoomExcludesBackgroundPeaks;
    }

    public boolean showForwardIonDeNovoTags() {
        return this.showForwardIonDeNovoTags;
    }

    public void setShowForwardIonDeNovoTags(boolean showForwardIonDeNovoTags) {
        this.showForwardIonDeNovoTags = showForwardIonDeNovoTags;
    }

    public boolean showRewindIonDeNovoTags() {
        return this.showRewindIonDeNovoTags;
    }

    public void setShowRewindIonDeNovoTags(boolean showRewindIonDeNovoTags) {
        this.showRewindIonDeNovoTags = showRewindIonDeNovoTags;
    }

    public int getDeNovoCharge() {
        return this.deNovoCharge;
    }

    public void setDeNovoCharge(int deNovoCharge) {
        this.deNovoCharge = deNovoCharge;
    }
}

