/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.Util;
import com.compomics.util.experiment.annotation.gene.GeneFactory;
import com.compomics.util.experiment.annotation.go.GOFactory;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class GenePreferences
implements Serializable {
    static final long serialVersionUID = -1286840382594446279L;
    public static final String GENE_MAPPING_FOLDER = System.getProperty("user.home") + "/.compomics/gene_mappings/";
    public static final String GENE_MAPPING_FILE_SUFFIX = "_gene_mappings";
    public static final String GO_MAPPING_FILE_SUFFIX = "_go_mappings";
    private String currentSpecies = null;
    private String currentSpeciesType = null;
    private HashMap<String, String> goDomainMap;
    private HashMap<String, String> speciesMap;
    private HashMap<String, HashMap<String, String>> allSpeciesMap;
    private HashMap<String, String> ensemblVersionsMap;
    private ArrayList<String> availableSpecies;
    private HashMap<String, ArrayList<String>> allSpecies;
    private Vector<String> species;

    public GenePreferences() {
    }

    public GenePreferences(GenePreferences genePreferences) {
        if (genePreferences.getGoDomainMap() != null) {
            this.goDomainMap = new HashMap();
            this.goDomainMap.putAll(genePreferences.getGoDomainMap());
        }
        if (genePreferences.getEnsemblVersionsMap() != null) {
            this.ensemblVersionsMap = new HashMap();
            this.ensemblVersionsMap.putAll(genePreferences.getEnsemblVersionsMap());
        }
        if (genePreferences.getSpecies() != null || genePreferences.getSpeciesMap() != null) {
            this.allSpecies = this.getAllSpecies();
        }
        if (genePreferences.getCurrentSpecies() != null) {
            this.currentSpecies = genePreferences.getCurrentSpecies();
        }
    }

    public static String getProteinEvidencAsString(Integer type) {
        switch (type) {
            case 1: {
                return "Protein";
            }
            case 2: {
                return "Transcript";
            }
            case 3: {
                return "Homology";
            }
            case 4: {
                return "Predicted";
            }
            case 5: {
                return "Uncertain";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadGoMappings(String ensemblType, String ensemblSchemaName, String selectedSpecies, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        block21: {
            String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" >" + "<Dataset name = \"" + selectedSpecies + "\" interface = \"default\" >" + "<Attribute name = \"uniprot_swissprot_accession\" />" + "<Attribute name = \"goslim_goa_accession\" />" + "<Attribute name = \"goslim_goa_description\" />" + "</Dataset>" + "</Query>";
            if (!waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                try {
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler.isRunCanceled()) break block21;
                    waitingHandler.setWaitingText("Downloading GO Mappings. Please Wait...");
                    int counter = 0;
                    File tempFile = new File(this.getGeneMappingFolder(), selectedSpecies + GO_MAPPING_FILE_SUFFIX);
                    boolean fileCreated = tempFile.createNewFile();
                    if (fileCreated) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        try {
                            FileWriter w = new FileWriter(tempFile);
                            try {
                                BufferedWriter bw = new BufferedWriter(w);
                                try {
                                    String rowLine = br.readLine();
                                    if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                        if (rowLine.lastIndexOf("Attribute goslim_goa_accession NOT FOUND") != -1) {
                                            boolean bl = false;
                                            return bl;
                                        }
                                        throw new IllegalArgumentException("Query error: " + rowLine);
                                    }
                                    while (rowLine != null && !waitingHandler.isRunCanceled()) {
                                        waitingHandler.setWaitingText("Downloading GO Mappings. Please Wait... (" + counter++ + " rows downloaded)");
                                        bw.write(rowLine + System.getProperty("line.separator"));
                                        rowLine = br.readLine();
                                    }
                                    break block21;
                                }
                                finally {
                                    bw.close();
                                }
                            }
                            finally {
                                w.close();
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    waitingHandler.setRunCanceled();
                    throw new IllegalArgumentException("The mapping file could not be created.");
                }
                finally {
                    wr.close();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadGeneMappings(String ensemblType, String ensemblSchemaName, String selectedSpecies, String ensemblVersion, WaitingHandler waitingHandler) throws MalformedURLException, IOException, IllegalArgumentException {
        block17: {
            String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" >" + "<Dataset name = \"" + selectedSpecies + "\" interface = \"default\" >" + "<Attribute name = \"ensembl_gene_id\" />" + "<Attribute name = \"external_gene_id\" />" + "<Attribute name = \"chromosome_name\" />" + "</Dataset>" + "</Query>";
            if (!waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                try {
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler.isRunCanceled()) break block17;
                    waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait...");
                    int counter = 0;
                    File tempFile = new File(this.getGeneMappingFolder(), selectedSpecies + GENE_MAPPING_FILE_SUFFIX);
                    boolean fileCreated = tempFile.createNewFile();
                    if (fileCreated) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        try {
                            FileWriter w = new FileWriter(tempFile);
                            try {
                                BufferedWriter bw = new BufferedWriter(w);
                                try {
                                    String rowLine = br.readLine();
                                    if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                        throw new IllegalArgumentException("Query error on line: " + rowLine);
                                    }
                                    while (rowLine != null && !waitingHandler.isRunCanceled()) {
                                        waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait... (" + counter++ + " rows downloaded)");
                                        bw.write(rowLine + System.getProperty("line.separator"));
                                        rowLine = br.readLine();
                                    }
                                }
                                finally {
                                    bw.close();
                                }
                            }
                            finally {
                                w.close();
                            }
                        }
                        finally {
                            br.close();
                        }
                        if (!waitingHandler.isRunCanceled()) {
                            this.updateEnsemblVersion(selectedSpecies, "Ensembl " + ensemblVersion);
                        }
                        break block17;
                    }
                    waitingHandler.setRunCanceled();
                    throw new IllegalArgumentException("The mapping file could not be created.");
                }
                finally {
                    wr.close();
                }
            }
        }
    }

    public File getGeneMappingFolder() {
        return new File(GENE_MAPPING_FOLDER);
    }

    public String getCurrentSpecies() {
        return this.currentSpecies;
    }

    public void setCurrentSpecies(String currentSpecies) {
        this.currentSpecies = currentSpecies;
    }

    public String getCurrentSpeciesType() {
        return this.currentSpeciesType;
    }

    public void setCurrentSpeciesType(String currentSpeciesType) {
        this.currentSpeciesType = currentSpeciesType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultGeneMappingFiles(File aEnsemblVersionsFile, File aGoDomainsFile, File aSpeciesFile, File aDefaultSpeciesGoMappingsFile, File aDefaultSpeciesGeneMappingFile) {
        boolean fileCreated;
        boolean updateHumanEnsembl;
        File defaultSpeciesGeneMappingFile;
        File defaultSpeciesGoMappingsFile;
        File goDomainsFile;
        block33: {
            boolean folderCreated;
            if (!this.getGeneMappingFolder().exists() && !(folderCreated = this.getGeneMappingFolder().mkdir())) {
                throw new IllegalArgumentException("Could not create the gene mapping folder!");
            }
            File speciesFile = new File(this.getGeneMappingFolder(), "species");
            File ensemblVersionsFile = new File(this.getGeneMappingFolder(), "ensembl_versions");
            goDomainsFile = new File(this.getGeneMappingFolder(), "go_domains");
            defaultSpeciesGoMappingsFile = new File(this.getGeneMappingFolder(), aDefaultSpeciesGoMappingsFile.getName());
            defaultSpeciesGeneMappingFile = new File(this.getGeneMappingFolder(), aDefaultSpeciesGeneMappingFile.getName());
            try {
                boolean fileCreated2;
                if (!speciesFile.exists() && !(fileCreated2 = speciesFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the species file!");
                }
                Util.copyFile(aSpeciesFile, speciesFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the species file!");
            }
            updateHumanEnsembl = false;
            try {
                StringTokenizer tok;
                String line;
                BufferedReader br;
                if (!ensemblVersionsFile.exists()) {
                    updateHumanEnsembl = true;
                    fileCreated = ensemblVersionsFile.createNewFile();
                    if (!fileCreated) {
                        throw new IllegalArgumentException("Could not create the Ensembl versions file!");
                    }
                    Util.copyFile(aEnsemblVersionsFile, ensemblVersionsFile);
                    break block33;
                }
                Integer humanEnsemblVersionNew = null;
                FileReader r = new FileReader(aEnsemblVersionsFile);
                try {
                    br = new BufferedReader(r);
                    try {
                        line = br.readLine();
                        if (line != null) {
                            tok = new StringTokenizer(line);
                            tok.nextToken();
                            tok.nextToken();
                            humanEnsemblVersionNew = new Integer(tok.nextToken());
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                finally {
                    r.close();
                }
                if (humanEnsemblVersionNew == null) break block33;
                r = new FileReader(ensemblVersionsFile);
                try {
                    br = new BufferedReader(r);
                    try {
                        while ((line = br.readLine()) != null && !updateHumanEnsembl) {
                            tok = new StringTokenizer(line);
                            String tempSpecies = tok.nextToken();
                            tok.nextToken();
                            Integer humanEnsemblVersionOld = new Integer(tok.nextToken());
                            if (!tempSpecies.equalsIgnoreCase("hsapiens_gene_ensembl") || humanEnsemblVersionOld >= humanEnsemblVersionNew) continue;
                            updateHumanEnsembl = true;
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                finally {
                    r.close();
                }
                this.loadEnsemblSpeciesVersions(ensemblVersionsFile);
                if (updateHumanEnsembl) {
                    this.updateEnsemblVersion("hsapiens_gene_ensembl", "Ensembl " + humanEnsemblVersionNew);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create or update the Ensembl versions file!");
            }
        }
        try {
            if (!goDomainsFile.exists() && !(fileCreated = goDomainsFile.createNewFile())) {
                throw new IllegalArgumentException("Could not create the GO domains file!");
            }
            Util.copyFile(aGoDomainsFile, goDomainsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create the GO domains file!");
        }
        if (updateHumanEnsembl) {
            try {
                if (!defaultSpeciesGoMappingsFile.exists() && !(fileCreated = defaultSpeciesGoMappingsFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species GO mapping file!");
                }
                Util.copyFile(aDefaultSpeciesGoMappingsFile, defaultSpeciesGoMappingsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species GO mapping file!");
            }
            try {
                if (!defaultSpeciesGeneMappingFile.exists() && !(fileCreated = defaultSpeciesGeneMappingFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species gene mapping file!");
                }
                Util.copyFile(aDefaultSpeciesGeneMappingFile, defaultSpeciesGeneMappingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species gene mapping file!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSpeciesAndGoDomains() throws IOException, IllegalArgumentException {
        try {
            String line;
            BufferedReader br;
            if (!this.getGeneMappingFolder().exists()) {
                throw new IllegalArgumentException("Could not create the gene mapping folder!");
            }
            File speciesFile = new File(this.getGeneMappingFolder(), "species");
            File ensemblVersionsFile = new File(this.getGeneMappingFolder(), "ensembl_versions");
            File goDomainsFile = new File(this.getGeneMappingFolder(), "go_domains");
            if (!speciesFile.exists()) {
                throw new IllegalArgumentException("Could not create the species file!");
            }
            if (!ensemblVersionsFile.exists()) {
                throw new IllegalArgumentException("Could not create the Ensembl versions file!");
            }
            if (!goDomainsFile.exists()) {
                throw new IllegalArgumentException("Could not create the GO domains file!");
            }
            this.goDomainMap = new HashMap();
            this.allSpecies = new HashMap();
            this.allSpeciesMap = new HashMap();
            this.ensemblVersionsMap = new HashMap();
            if (!goDomainsFile.exists()) {
                throw new IllegalArgumentException("GO domains file \"" + goDomainsFile.getName() + "\" not found!\n" + "Continuing without GO domains.");
            }
            FileReader r = new FileReader(goDomainsFile);
            try {
                br = new BufferedReader(r);
                try {
                    while ((line = br.readLine()) != null) {
                        String[] elements = line.split("\\t");
                        this.goDomainMap.put(elements[0], elements[1]);
                    }
                }
                finally {
                    br.close();
                }
            }
            finally {
                r.close();
            }
            if (ensemblVersionsFile.exists()) {
                this.loadEnsemblSpeciesVersions(ensemblVersionsFile);
            }
            if (!speciesFile.exists()) {
                throw new IllegalArgumentException("Species file \"" + speciesFile.getName() + "\" not found!\n" + "GO Analysis Canceled.");
            }
            r = new FileReader(speciesFile);
            try {
                br = new BufferedReader(r);
                try {
                    line = br.readLine();
                    String currentSpeciesType = line.substring(1);
                    ArrayList<String> tempSpeciesList = new ArrayList<String>();
                    while ((line = br.readLine()) != null) {
                        if (line.trim().length() <= 0) continue;
                        if (line.startsWith(">")) {
                            this.allSpecies.put(currentSpeciesType, tempSpeciesList);
                            currentSpeciesType = line.substring(1);
                            tempSpeciesList = new ArrayList();
                            continue;
                        }
                        String[] elements = line.split("\\t");
                        String tempSpecies = elements[0].trim();
                        if (!this.allSpeciesMap.containsKey(currentSpeciesType)) {
                            this.allSpeciesMap.put(currentSpeciesType, new HashMap());
                        }
                        this.allSpeciesMap.get(currentSpeciesType).put(tempSpecies, elements[1].trim());
                        tempSpeciesList.add(tempSpecies);
                    }
                    if (!tempSpeciesList.isEmpty()) {
                        this.allSpecies.put(currentSpeciesType, tempSpeciesList);
                    }
                }
                finally {
                    br.close();
                }
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("An error occured when loading the species and GO domain file.\nGO Analysis Canceled.");
        }
    }

    public HashMap<String, String> getGoDomainMap() {
        return this.goDomainMap;
    }

    public HashMap<String, String> getSpeciesMap() {
        return this.speciesMap;
    }

    public HashMap<String, HashMap<String, String>> getAllSpeciesMap() {
        return this.allSpeciesMap;
    }

    public String getEnsemblDatabaseName(String speciesName) {
        return this.speciesMap.get(speciesName);
    }

    public String getEnsemblDatabaseName(String ensemblType, String speciesName) {
        return this.allSpeciesMap.get(ensemblType).get(speciesName);
    }

    public HashMap<String, String> getEnsemblVersionsMap() {
        return this.ensemblVersionsMap;
    }

    public String getEnsemblVersion(String ensemblDatabase) {
        return this.ensemblVersionsMap.get(ensemblDatabase);
    }

    public String getEnsemblSpeciesVersion(String speciesName) {
        String ensemblDB = this.getEnsemblDatabaseName(speciesName);
        if (ensemblDB != null) {
            return this.getEnsemblVersion(ensemblDB);
        }
        return null;
    }

    public String getEnsemblSpeciesVersion(String ensemblType, String speciesName) {
        String ensemblDB = this.getEnsemblDatabaseName(ensemblType, speciesName);
        if (ensemblDB != null) {
            return this.getEnsemblVersion(ensemblDB);
        }
        return null;
    }

    public ArrayList<String> getSpecies() {
        if (this.availableSpecies == null && this.species != null) {
            this.availableSpecies = new ArrayList();
            this.availableSpecies.addAll(this.species);
        }
        return this.availableSpecies;
    }

    public HashMap<String, ArrayList<String>> getAllSpecies() {
        if (this.species != null) {
            this.allSpecies = new HashMap();
            ArrayList<String> temp = new ArrayList<String>();
            temp.addAll(this.species);
            this.allSpecies.put("Vertebrates", temp);
        }
        if (this.availableSpecies != null) {
            this.allSpecies = new HashMap();
            this.allSpecies.put("Vertebrates", this.availableSpecies);
        }
        return this.allSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnsemblVersion(String selectedSpecies, String ensemblVersion) throws IOException {
        FileWriter w = new FileWriter(new File(this.getGeneMappingFolder(), "ensembl_versions"));
        try {
            BufferedWriter bw = new BufferedWriter(w);
            try {
                if (this.ensemblVersionsMap == null) {
                    this.ensemblVersionsMap = new HashMap();
                }
                this.ensemblVersionsMap.put(selectedSpecies, ensemblVersion);
                for (String key : this.ensemblVersionsMap.keySet()) {
                    bw.write(key + "\t" + this.ensemblVersionsMap.get(key) + System.getProperty("line.separator"));
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEnsemblSpeciesVersions(File ensemblVersionsFile) throws FileNotFoundException, IOException {
        FileReader r = new FileReader(ensemblVersionsFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                this.ensemblVersionsMap = new HashMap();
                String line = br.readLine();
                while (line != null) {
                    String[] elements = line.split("\\t");
                    this.ensemblVersionsMap.put(elements[0], elements[1]);
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
    }

    public boolean loadGeneMappings(String jarFilePath, WaitingHandler waitingHandler) {
        boolean success = true;
        try {
            this.createDefaultGeneMappingFiles(new File(jarFilePath, "resources/conf/gene_ontology/ensembl_versions"), new File(jarFilePath, "resources/conf/gene_ontology/go_domains"), new File(jarFilePath, "resources/conf/gene_ontology/species"), new File(jarFilePath, "resources/conf/gene_ontology/hsapiens_gene_ensembl_go_mappings"), new File(jarFilePath, "resources/conf/gene_ontology/hsapiens_gene_ensembl_gene_mappings"));
            this.loadSpeciesAndGoDomains();
        }
        catch (IOException e) {
            if (waitingHandler.isReport()) {
                waitingHandler.appendReport("An error occurred while attempting to create the gene preferences.", true, true);
            }
            e.printStackTrace();
            success = false;
        }
        if (this.getCurrentSpecies() != null && this.getCurrentSpeciesType() != null && this.getAllSpeciesMap() != null && new File(this.getGeneMappingFolder(), this.getAllSpeciesMap().get(this.getCurrentSpeciesType()).get(this.getCurrentSpecies()) + GENE_MAPPING_FILE_SUFFIX).exists()) {
            try {
                GeneFactory geneFactory = GeneFactory.getInstance();
                geneFactory.initialize(new File(this.getGeneMappingFolder(), this.getAllSpeciesMap().get(this.getCurrentSpeciesType()).get(this.getCurrentSpecies()) + GENE_MAPPING_FILE_SUFFIX), null);
            }
            catch (Exception e) {
                if (waitingHandler.isReport()) {
                    waitingHandler.appendReport("Unable to load the gene mapping file.", true, true);
                }
                e.printStackTrace();
                success = false;
            }
        }
        if (this.getCurrentSpecies() != null && this.getCurrentSpeciesType() != null && this.getAllSpeciesMap() != null && new File(this.getGeneMappingFolder(), this.getAllSpeciesMap().get(this.getCurrentSpeciesType()).get(this.getCurrentSpecies()) + GO_MAPPING_FILE_SUFFIX).exists()) {
            try {
                GOFactory goFactory = GOFactory.getInstance();
                goFactory.initialize(new File(this.getGeneMappingFolder(), this.getAllSpeciesMap().get(this.getCurrentSpeciesType()).get(this.getCurrentSpecies()) + GO_MAPPING_FILE_SUFFIX), null);
            }
            catch (Exception e) {
                if (waitingHandler.isReport()) {
                    waitingHandler.appendReport("Unable to load the gene ontology mapping file.", true, true);
                }
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }

    private URL getEnsemblUrl(String ensemblType) throws MalformedURLException {
        if (ensemblType.equalsIgnoreCase("fungi")) {
            return new URL("http://fungi.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("plants")) {
            return new URL("http://plants.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("protists")) {
            return new URL("http://protists.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("metazoa")) {
            return new URL("http://metazoa.ensembl.org/biomart/martservice/result");
        }
        return new URL("http://www.biomart.org/biomart/martservice/result");
    }
}

