/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;

public class IdFilter
implements Serializable {
    static final long serialVersionUID = 8416219001106063781L;
    private int minPepLength;
    private int maxPepLength;
    private double mascotMaxEvalue;
    private double omssaMaxEvalue;
    private double xtandemMaxEvalue;
    private double maxMassDeviation;
    private boolean isPpm;
    private boolean unknownPtm;

    public IdFilter() {
        this.minPepLength = 4;
        this.maxPepLength = 30;
        this.mascotMaxEvalue = -1.0;
        this.omssaMaxEvalue = -1.0;
        this.xtandemMaxEvalue = -1.0;
        this.maxMassDeviation = -1.0;
        this.isPpm = true;
        this.unknownPtm = true;
    }

    public IdFilter(int minPepLength, int maxPepLength, double mascotMaxEvalue, double omssaMaxEvalue, double xtandemMaxEvalue, double maxMzDeviation, boolean isPpm, boolean unknownPTM) {
        this.minPepLength = minPepLength;
        this.maxPepLength = maxPepLength;
        this.mascotMaxEvalue = mascotMaxEvalue;
        this.omssaMaxEvalue = omssaMaxEvalue;
        this.xtandemMaxEvalue = xtandemMaxEvalue;
        this.maxMassDeviation = maxMzDeviation;
        this.isPpm = isPpm;
        this.unknownPtm = unknownPTM;
    }

    public boolean validatePeptideAssumption(PeptideAssumption assumption) {
        int pepLength = assumption.getPeptide().getSequence().length();
        if (this.maxPepLength > 0 && pepLength > this.maxPepLength || this.minPepLength > 0 && pepLength < this.minPepLength) {
            return false;
        }
        int searchEngine = assumption.getAdvocate();
        double eValue = assumption.getScore();
        return !(searchEngine == 0 && this.mascotMaxEvalue > 0.0 && eValue > this.mascotMaxEvalue || searchEngine == 1 && this.omssaMaxEvalue > 0.0 && eValue > this.omssaMaxEvalue) && (searchEngine != 2 || !(this.xtandemMaxEvalue > 0.0) || !(eValue > this.xtandemMaxEvalue));
    }

    public boolean validateProteins(Peptide peptide) {
        if (peptide.getParentProteins().size() > 1) {
            boolean target = false;
            boolean decoy = false;
            for (String protein : peptide.getParentProteins()) {
                if (SequenceFactory.getInstance().isDecoyAccession(protein)) {
                    decoy = true;
                    continue;
                }
                target = true;
            }
            if (target && decoy) {
                return false;
            }
        }
        return true;
    }

    public boolean validateModifications(Peptide peptide) {
        if (this.unknownPtm) {
            ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
            for (ModificationMatch modMatch : modificationMatches) {
                if (!modMatch.getTheoreticPtm().equals(PTMFactory.unknownPTM.getName())) continue;
                return false;
            }
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap modMatches = new HashMap();
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            String modName;
            PTM ptm;
            if (!modMatch.isVariable() || (ptm = ptmFactory.getPTM(modName = modMatch.getTheoreticPtm())).getType() != 0) continue;
            if (!modMatches.containsKey(modName)) {
                modMatches.put(modName, new ArrayList());
            }
            ((ArrayList)modMatches.get(modName)).add(modMatch);
        }
        for (String modName : modMatches.keySet()) {
            try {
                ArrayList<Integer> possiblePositions = peptide.getPotentialModificationSites(ptmFactory.getPTM(modName));
                if (possiblePositions.size() >= ((ArrayList)modMatches.get(modName)).size()) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean validatePrecursor(PeptideAssumption assumption, String spectrumKey, SpectrumFactory spectrumFactory) throws IOException, MzMLUnmarshallerException {
        Precursor precursor = spectrumFactory.getPrecursor(spectrumKey);
        return !(this.maxMassDeviation > 0.0) || !(Math.abs(assumption.getDeltaMass(precursor.getMz(), this.isPpm)) > this.maxMassDeviation);
    }

    public boolean removeUnknownPTMs() {
        return this.unknownPtm;
    }

    public void setRemoveUnknownPTMs(boolean unknownPtm) {
        this.unknownPtm = unknownPtm;
    }

    public boolean isIsPpm() {
        return this.isPpm;
    }

    public void setIsPpm(boolean isPpm) {
        this.isPpm = isPpm;
    }

    public double getMascotMaxEvalue() {
        return this.mascotMaxEvalue;
    }

    public void setMascotMaxEvalue(double mascotMaxEvalue) {
        this.mascotMaxEvalue = mascotMaxEvalue;
    }

    public double getMaxMzDeviation() {
        return this.maxMassDeviation;
    }

    public void setMaxMzDeviation(double maxMzDeviation) {
        this.maxMassDeviation = maxMzDeviation;
    }

    public int getMaxPepLength() {
        return this.maxPepLength;
    }

    public void setMaxPepLength(int maxPepLength) {
        this.maxPepLength = maxPepLength;
    }

    public int getMinPepLength() {
        return this.minPepLength;
    }

    public void setMinPepLength(int minPepLength) {
        this.minPepLength = minPepLength;
    }

    public double getOmssaMaxEvalue() {
        return this.omssaMaxEvalue;
    }

    public void setOmssaMaxEvalue(double omssaMaxEvalue) {
        this.omssaMaxEvalue = omssaMaxEvalue;
    }

    public double getXtandemMaxEvalue() {
        return this.xtandemMaxEvalue;
    }

    public void setXtandemMaxEvalue(double xtandemMaxEvalue) {
        this.xtandemMaxEvalue = xtandemMaxEvalue;
    }

    public boolean equals(IdFilter anotherFilter) {
        return this.isPpm == anotherFilter.isPpm && this.unknownPtm == anotherFilter.removeUnknownPTMs() && this.minPepLength == anotherFilter.getMinPepLength() && this.maxPepLength == anotherFilter.getMaxPepLength() && this.mascotMaxEvalue == anotherFilter.getMascotMaxEvalue() && this.omssaMaxEvalue == anotherFilter.getOmssaMaxEvalue() && this.xtandemMaxEvalue == anotherFilter.getXtandemMaxEvalue() && this.maxMassDeviation == anotherFilter.getMaxMzDeviation();
    }
}

