/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.io.SerializationUtils;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class UtilitiesUserPreferences
implements Serializable {
    static final long serialVersionUID = -4343570286224891504L;
    public static final String USER_PREFERENCES_FILE = System.getProperty("user.home") + "/.compomics/userpreferences.cup";
    private Float spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
    private Float spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
    private Color spectrumAnnotatedPeakColor = Color.RED;
    private Color spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
    private Color sparklineColorValidated = new Color(110, 196, 97);
    private Color sparklineColorNonValidated = new Color(208, 19, 19);
    private Color sparklineColorNotFound = new Color(222, 222, 222);
    private Color sparklineColorPossible = new Color(100, 150, 255);
    private Color peptideSelected = new Color(0, 0, 255);
    private int memoryPreference = 4096;
    private String searchGuiPath = null;
    private String peptideShakerPath = null;
    private String reporterPath = null;
    private String relimsPath = null;
    private String localPrideFolder = "user.home";
    private File dbFolder = null;
    private ArrayList<File> favoriteDBs = null;

    public Color getSparklineColor() {
        return this.sparklineColorValidated;
    }

    public void setSparklineColor(Color sparklineColorValidated) {
        this.sparklineColorValidated = sparklineColorValidated;
    }

    public Color getSparklineColorNonValidated() {
        if (this.sparklineColorNonValidated == null) {
            this.sparklineColorNonValidated = new Color(255, 0, 0);
        }
        return this.sparklineColorNonValidated;
    }

    public Color getPeptideSelected() {
        if (this.peptideSelected == null) {
            this.peptideSelected = new Color(0, 0, 255);
        }
        return this.peptideSelected;
    }

    public Color getSparklineColorNotFound() {
        if (this.sparklineColorNotFound == null) {
            this.sparklineColorNotFound = new Color(222, 222, 222);
        }
        return this.sparklineColorNotFound;
    }

    public void setSparklineColorNonValidated(Color sparklineColorNonValidated) {
        this.sparklineColorNonValidated = sparklineColorNonValidated;
    }

    public Color getSparklineColorPossible() {
        if (this.sparklineColorPossible == null) {
            this.sparklineColorPossible = new Color(235, 235, 235);
        }
        return this.sparklineColorPossible;
    }

    public void setSparklineColorPossible(Color sparklineColorPossible) {
        this.sparklineColorPossible = sparklineColorPossible;
    }

    public int getMemoryPreference() {
        if (this.memoryPreference == 0) {
            this.memoryPreference = 4096;
        }
        return this.memoryPreference;
    }

    public void setMemoryPreference(int memoryPreference) {
        this.memoryPreference = memoryPreference;
    }

    public Color getSpectrumAnnotatedPeakColor() {
        if (this.spectrumAnnotatedPeakColor == null) {
            this.spectrumAnnotatedPeakColor = Color.RED;
        }
        return this.spectrumAnnotatedPeakColor;
    }

    public void setSpectrumAnnotatedPeakColor(Color spectrumAnnotatedPeakColor) {
        this.spectrumAnnotatedPeakColor = spectrumAnnotatedPeakColor;
    }

    public Color getSpectrumBackgroundPeakColor() {
        if (this.spectrumBackgroundPeakColor == null) {
            this.spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
        }
        return this.spectrumBackgroundPeakColor;
    }

    public void setSpectrumBackgroundPeakColor(Color spectrumBackgroundPeakColor) {
        this.spectrumBackgroundPeakColor = spectrumBackgroundPeakColor;
    }

    public Float getSpectrumAnnotatedPeakWidth() {
        if (this.spectrumAnnotatedPeakWidth == null) {
            this.spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumAnnotatedPeakWidth;
    }

    public void setSpectrumAnnotatedPeakWidth(float spectrumAnnotatedPeakWidth) {
        this.spectrumAnnotatedPeakWidth = Float.valueOf(spectrumAnnotatedPeakWidth);
    }

    public Float getSpectrumBackgroundPeakWidth() {
        if (this.spectrumBackgroundPeakWidth == null) {
            this.spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumBackgroundPeakWidth;
    }

    public void setSpectrumBackgroundPeakWidth(float spectrumBackgroundPeakWidth) {
        this.spectrumBackgroundPeakWidth = Float.valueOf(spectrumBackgroundPeakWidth);
    }

    public String getSearchGuiPath() {
        return this.searchGuiPath;
    }

    public void setSearchGuiPath(String searchGuiPath) {
        this.searchGuiPath = searchGuiPath;
    }

    public String getRelimsPath() {
        return this.relimsPath;
    }

    public void setRelimsPath(String relimsPath) {
        this.relimsPath = relimsPath;
    }

    public String getPeptideShakerPath() {
        return this.peptideShakerPath;
    }

    public void setPeptideShakerPath(String peptideShakerPath) {
        this.peptideShakerPath = peptideShakerPath;
    }

    public String getReporterPath() {
        return this.reporterPath;
    }

    public void setReporterPath(String reporterPath) {
        this.reporterPath = reporterPath;
    }

    public static void saveUserPreferences(UtilitiesUserPreferences userPreferences) {
        try {
            File file = new File(USER_PREFERENCES_FILE);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            SerializationUtils.writeObject(userPreferences, file);
        }
        catch (Exception e) {
            System.err.println("An error occurred while saving " + USER_PREFERENCES_FILE + " (see below).");
            e.printStackTrace();
        }
    }

    public static UtilitiesUserPreferences loadUserPreferences() {
        UtilitiesUserPreferences userPreferences;
        File file = new File(USER_PREFERENCES_FILE);
        if (!file.exists()) {
            userPreferences = new UtilitiesUserPreferences();
            UtilitiesUserPreferences.saveUserPreferences(userPreferences);
        } else {
            try {
                userPreferences = (UtilitiesUserPreferences)SerializationUtils.readObject(file);
            }
            catch (Exception e) {
                System.err.println("An error occurred while loading " + USER_PREFERENCES_FILE + " (see below). Preferences set back to default.");
                e.printStackTrace();
                userPreferences = new UtilitiesUserPreferences();
                UtilitiesUserPreferences.saveUserPreferences(userPreferences);
            }
        }
        return userPreferences;
    }

    public String getLocalPrideFolder() {
        return this.localPrideFolder;
    }

    public void setLocalPrideFolder(String localPrideFolder) {
        this.localPrideFolder = localPrideFolder;
    }

    public File getDbFolder() {
        return this.dbFolder;
    }

    public void setDbFolder(File dbFolder) {
        this.dbFolder = dbFolder;
    }

    public ArrayList<File> getFavoriteDBs() {
        if (this.favoriteDBs == null) {
            this.favoriteDBs = new ArrayList();
        } else {
            this.checkDbFiles();
        }
        return this.favoriteDBs;
    }

    public void checkDbFiles() {
        ArrayList<File> checkedFiles = new ArrayList<File>();
        for (File dbFile : this.favoriteDBs) {
            if (!dbFile.exists()) continue;
            checkedFiles.add(dbFile);
        }
        this.favoriteDBs = checkedFiles;
    }

    public void addFavoriteDB(File dbFile) {
        if (this.favoriteDBs == null) {
            this.favoriteDBs = new ArrayList();
        }
        this.favoriteDBs.add(0, dbFile);
    }
}

