/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences.gui;

import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.PTMScoringPreferences;
import com.compomics.util.preferences.ProcessingPreferences;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ProcessingPreferencesDialog
extends JDialog {
    private ProcessingPreferences processingPreferences;
    private PTMScoringPreferences ptmScoringPreferences;
    private JLabel aScoreLabel;
    private JComboBox ascoreCmb;
    private JPanel backgroundPanel;
    private JLabel estimateAScoreLabel;
    private JTextField flrTxt;
    private JPanel fractionsPanel;
    private JComboBox neutralLossesCmb;
    private JLabel neutralLossesLabel;
    private JButton okButton;
    private JLabel peptideFdrLabel;
    private JTextField peptideFdrTxt;
    private JLabel percentLabel;
    private JLabel percentLabel1;
    private JLabel percentLabel2;
    private JLabel percentLabel3;
    private JLabel percentLabel4;
    private JPanel processingParamsPanel;
    private JTextField proteinConfidenceMwTxt;
    private JLabel proteinFdrLabel;
    private JTextField proteinFdrTxt;
    private JLabel proteinMwLabel;
    private JLabel psmFdrLabel;
    private JTextField psmFdrTxt;
    private JPanel ptmScoringPanel;

    public ProcessingPreferencesDialog(Frame parent, boolean editable, ProcessingPreferences processingPreferences, PTMScoringPreferences ptmScoringPreferences) {
        super(parent, true);
        this.initComponents();
        this.proteinFdrTxt.setText(processingPreferences.getProteinFDR() + "");
        this.peptideFdrTxt.setText(processingPreferences.getPeptideFDR() + "");
        this.psmFdrTxt.setText(processingPreferences.getPsmFDR() + "");
        if (ptmScoringPreferences.aScoreCalculation()) {
            this.ascoreCmb.setSelectedIndex(0);
        } else {
            this.ascoreCmb.setSelectedIndex(1);
        }
        if (ptmScoringPreferences.isaScoreNeutralLosses()) {
            this.neutralLossesCmb.setSelectedIndex(0);
        } else {
            this.neutralLossesCmb.setSelectedIndex(1);
        }
        this.flrTxt.setText(ptmScoringPreferences.getFlrThreshold() + "");
        this.proteinConfidenceMwTxt.setText(processingPreferences.getProteinConfidenceMwPlots() + "");
        this.proteinFdrTxt.setEditable(editable);
        this.peptideFdrTxt.setEditable(editable);
        this.psmFdrTxt.setEditable(editable);
        this.proteinFdrTxt.setEnabled(editable);
        this.peptideFdrTxt.setEnabled(editable);
        this.psmFdrTxt.setEnabled(editable);
        this.ascoreCmb.setEnabled(editable);
        this.neutralLossesCmb.setEnabled(editable);
        this.flrTxt.setEnabled(editable);
        this.proteinConfidenceMwTxt.setEnabled(editable);
        this.ascoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.processingPreferences = processingPreferences;
        this.ptmScoringPreferences = ptmScoringPreferences;
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private boolean validateInput() {
        Double temp;
        try {
            temp = new Double(this.proteinFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
                this.proteinFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
            this.proteinFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.peptideFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
                this.peptideFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
            this.peptideFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.psmFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
                this.psmFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
            this.psmFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.flrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the false location rate.", "Input Error", 0);
                this.flrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the false location rate.", "Input Error", 0);
            this.flrTxt.requestFocus();
            return false;
        }
        try {
            temp = new Double(this.proteinConfidenceMwTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
                this.proteinConfidenceMwTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the Protein Confidence MW.", "Input Error", 0);
            this.proteinConfidenceMwTxt.requestFocus();
            return false;
        }
        if (this.ascoreCmb.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(this, "Disabling the A-score will impair PTM localization and thus distinction between peptides.", "Warning", 2);
        }
        if (this.neutralLossesCmb.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(this, "In our experience the A-score performs very poorely when accounting for neutral losses.", "Warning", 2);
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.processingParamsPanel = new JPanel();
        this.proteinFdrLabel = new JLabel();
        this.peptideFdrLabel = new JLabel();
        this.psmFdrLabel = new JLabel();
        this.psmFdrTxt = new JTextField();
        this.percentLabel = new JLabel();
        this.peptideFdrTxt = new JTextField();
        this.percentLabel2 = new JLabel();
        this.proteinFdrTxt = new JTextField();
        this.percentLabel3 = new JLabel();
        this.ptmScoringPanel = new JPanel();
        this.neutralLossesCmb = new JComboBox();
        this.flrTxt = new JTextField();
        this.aScoreLabel = new JLabel();
        this.ascoreCmb = new JComboBox();
        this.neutralLossesLabel = new JLabel();
        this.estimateAScoreLabel = new JLabel();
        this.percentLabel1 = new JLabel();
        this.fractionsPanel = new JPanel();
        this.proteinMwLabel = new JLabel();
        this.proteinConfidenceMwTxt = new JTextField();
        this.percentLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Processing");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcessingPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.processingParamsPanel.setBorder(BorderFactory.createTitledBorder("Processing Parameters"));
        this.processingParamsPanel.setOpaque(false);
        this.proteinFdrLabel.setText("Protein FDR");
        this.peptideFdrLabel.setText("Peptide FDR");
        this.psmFdrLabel.setText("PSM FDR");
        this.psmFdrTxt.setHorizontalAlignment(0);
        this.psmFdrTxt.setText("1");
        this.percentLabel.setText("%");
        this.peptideFdrTxt.setHorizontalAlignment(0);
        this.peptideFdrTxt.setText("1");
        this.percentLabel2.setText("%");
        this.proteinFdrTxt.setHorizontalAlignment(0);
        this.proteinFdrTxt.setText("1");
        this.percentLabel3.setText("%");
        GroupLayout processingParamsPanelLayout = new GroupLayout(this.processingParamsPanel);
        this.processingParamsPanel.setLayout(processingParamsPanelLayout);
        processingParamsPanelLayout.setHorizontalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinFdrLabel).addComponent(this.peptideFdrLabel).addComponent(this.psmFdrLabel)).addGap(32, 87, Short.MAX_VALUE).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.proteinFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel3)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.peptideFdrTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel2)).addGroup(GroupLayout.Alignment.TRAILING, processingParamsPanelLayout.createSequentialGroup().addComponent(this.psmFdrTxt, -2, 185, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel))).addContainerGap()));
        processingParamsPanelLayout.setVerticalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinFdrTxt, -2, -1, -2).addComponent(this.percentLabel3).addComponent(this.proteinFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideFdrTxt, -2, -1, -2).addComponent(this.percentLabel2).addComponent(this.peptideFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmFdrLabel).addComponent(this.psmFdrTxt, -2, -1, -2).addComponent(this.percentLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.ptmScoringPanel.setBorder(BorderFactory.createTitledBorder("PTM Scoring"));
        this.ptmScoringPanel.setOpaque(false);
        this.neutralLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.flrTxt.setHorizontalAlignment(0);
        this.flrTxt.setText("1");
        this.aScoreLabel.setText("False Localization Rate");
        this.ascoreCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.neutralLossesLabel.setText("Account Neutral Losses");
        this.estimateAScoreLabel.setText("Estimate A-score");
        this.percentLabel1.setText("%");
        GroupLayout ptmScoringPanelLayout = new GroupLayout(this.ptmScoringPanel);
        this.ptmScoringPanel.setLayout(ptmScoringPanelLayout);
        ptmScoringPanelLayout.setHorizontalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addComponent(this.estimateAScoreLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ascoreCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.neutralLossesCmb, GroupLayout.Alignment.TRAILING, 0, 185, Short.MAX_VALUE).addComponent(this.flrTxt, -1, 185, Short.MAX_VALUE))).addComponent(this.neutralLossesLabel).addComponent(this.aScoreLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel1).addContainerGap()));
        ptmScoringPanelLayout.setVerticalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estimateAScoreLabel).addComponent(this.ascoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel).addComponent(this.neutralLossesCmb, -2, -1, -2)).addGap(9, 9, 9).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aScoreLabel).addComponent(this.flrTxt, -2, -1, -2).addComponent(this.percentLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.fractionsPanel.setBorder(BorderFactory.createTitledBorder("Fractions"));
        this.fractionsPanel.setOpaque(false);
        this.proteinMwLabel.setText("Protein Confidence MW");
        this.proteinMwLabel.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.proteinConfidenceMwTxt.setHorizontalAlignment(0);
        this.proteinConfidenceMwTxt.setText("95");
        this.proteinConfidenceMwTxt.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.percentLabel4.setText("%");
        GroupLayout fractionsPanelLayout = new GroupLayout(this.fractionsPanel);
        this.fractionsPanel.setLayout(fractionsPanelLayout);
        fractionsPanelLayout.setHorizontalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMwLabel).addGap(30, 30, 30).addComponent(this.proteinConfidenceMwTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentLabel4).addContainerGap()));
        fractionsPanelLayout.setVerticalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinConfidenceMwTxt, -2, -1, -2).addComponent(this.percentLabel4).addComponent(this.proteinMwLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton)).addComponent(this.ptmScoringPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fractionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.processingParamsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingParamsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ptmScoringPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fractionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.processingPreferences.setProteinFDR(new Double(this.proteinFdrTxt.getText().trim()));
            this.processingPreferences.setPeptideFDR(new Double(this.peptideFdrTxt.getText().trim()));
            this.processingPreferences.setPsmFDR(new Double(this.psmFdrTxt.getText().trim()));
            this.ptmScoringPreferences.setaScoreCalculation(this.ascoreCmb.getSelectedIndex() == 0);
            this.ptmScoringPreferences.setaScoreNeutralLosses(this.neutralLossesCmb.getSelectedIndex() == 0);
            this.ptmScoringPreferences.setFlrThreshold(new Double(this.flrTxt.getText().trim()));
            this.processingPreferences.setProteinConfidenceMwPlots(new Double(this.proteinConfidenceMwTxt.getText().trim()));
            this.dispose();
        }
    }
}

