/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.xerces.impl.dv.util.Base64;

public class BinaryArrayImpl {
    public static final String BIG_ENDIAN_LABEL = "big";
    public static final String LITTLE_ENDIAN_LABEL = "little";
    public static final String FLOAT_PRECISION = "32";
    public static final String DOUBLE_PRECISION = "64";
    public static final int BYTES_TO_HOLD_FLOAT = 4;
    public static final int BYTES_TO_HOLD_DOUBLE = 8;
    protected String iBase64String = null;
    protected long iDataLength = -1L;
    protected String iDataEndian = null;
    protected String iDataPrecision = null;

    protected BinaryArrayImpl() {
    }

    public BinaryArrayImpl(String aBase64String, long aDataLength, String aDataEndian, String aDataPrecision) {
        this.iDataEndian = aDataEndian;
        this.constructorCommon(aBase64String, aDataLength, aDataPrecision);
    }

    public BinaryArrayImpl(double[] doubleArray, String aDataEndian) {
        this.iDataEndian = aDataEndian;
        if (doubleArray == null) {
            throw new IllegalArgumentException("The double[] 'doubleArray' that has been passed into the method BinaryArrayImpl is null.  This is not valid.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(doubleArray.length * 8);
        buffer.order(this.getByteOrder());
        for (double aDoubleArray : doubleArray) {
            buffer.putDouble(aDoubleArray);
        }
        String base64String = Base64.encode((byte[])buffer.array());
        this.constructorCommon(base64String, doubleArray.length, DOUBLE_PRECISION);
    }

    public BinaryArrayImpl(float[] floatArray, String aDataEndian) {
        this.iDataEndian = aDataEndian;
        if (floatArray == null) {
            throw new IllegalArgumentException("The float[] 'floatArray' that has been passed into the BinaryArrayImpl is null.  This is not valid.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(floatArray.length * 4);
        buffer.order(this.getByteOrder());
        for (float aFloatArray : floatArray) {
            buffer.putFloat(aFloatArray);
        }
        String base64String = Base64.encode((byte[])buffer.array());
        this.constructorCommon(base64String, floatArray.length, FLOAT_PRECISION);
    }

    private void constructorCommon(String aBase64String, long aDataLength, String aDataPrecision) {
        if (aBase64String == null) {
            throw new IllegalArgumentException("Attempting to instantiate a BinaryArrayImpl without specifying a valid value for aBase64String");
        }
        this.iBase64String = aBase64String.indexOf(10) > -1 ? aBase64String.trim().replaceAll("\\n", "") : aBase64String.trim();
        this.iDataLength = aDataLength;
        this.iDataPrecision = aDataPrecision;
    }

    public String getBase64String() {
        return this.iBase64String;
    }

    public byte[] getDecodedByteArray() {
        if (this.getBase64String() == null) {
            return null;
        }
        return Base64.decode((String)this.getBase64String());
    }

    private int getStep() {
        if (FLOAT_PRECISION.equals(this.getDataPrecision())) {
            return 4;
        }
        if (DOUBLE_PRECISION.equals(this.getDataPrecision())) {
            return 8;
        }
        throw new IllegalStateException("The value for data precision for this binary array must be either 32 or 64.  In this case it is: " + this.getDataPrecision());
    }

    private ByteOrder getByteOrder() {
        if (BIG_ENDIAN_LABEL.equals(this.getDataEndian())) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (LITTLE_ENDIAN_LABEL.equals(this.getDataEndian())) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalStateException("The value for data endian for this binary array must be either 'big' or 'little'.  In this case it is: " + this.getDataPrecision());
    }

    public double[] getDoubleArray() {
        int step = this.getStep();
        byte[] fullArray = this.getDecodedByteArray();
        if (fullArray == null || fullArray.length == 0) {
            return null;
        }
        if (fullArray.length % step != 0) {
            throw new IllegalStateException("Error caused by attempting to split a byte array of length " + fullArray.length + " into pieces of length " + step);
        }
        double[] doubleArray = new double[fullArray.length / step];
        ByteBuffer bb = ByteBuffer.wrap(fullArray);
        bb.order(this.getByteOrder());
        for (int indexOut = 0; indexOut < fullArray.length; indexOut += step) {
            doubleArray[indexOut / step] = step == 4 ? (double)bb.getFloat(indexOut) : bb.getDouble(indexOut);
        }
        return doubleArray;
    }

    public long getDataLength() {
        return this.iDataLength;
    }

    public String getDataEndian() {
        return this.iDataEndian;
    }

    public String getDataPrecision() {
        return this.iDataPrecision;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("    BinaryArrayImpl:").append(" DataLength=").append(this.iDataLength).append(", DataEndian=").append(this.iDataEndian).append(", DataPrecision=").append(this.iDataPrecision).append("\n, Base64 String='").append(this.iBase64String).append("'");
        buf.append("}\n");
        if (this.iBase64String != null) {
            byte[] decoded = this.getDecodedByteArray();
            buf.append("\n...DECODED: ");
            for (int i = 0; i < decoded.length; ++i) {
                buf.append(i == 0 ? "" : ", ").append(decoded[i]);
            }
            buf.append("}\n");
            double[] decodedDouble = this.getDoubleArray();
            buf.append("\n...TO DOUBLE ARRAY: ");
            for (int i = 0; i < decodedDouble.length; ++i) {
                buf.append(i == 0 ? "" : ", ").append(decodedDouble[i]);
            }
            buf.append("}\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryArrayImpl that = (BinaryArrayImpl)o;
        if (this.getDataLength() != that.getDataLength()) {
            return false;
        }
        if (!this.getDataEndian().equals(that.getDataEndian())) {
            return false;
        }
        if (!this.getDataPrecision().equals(that.getDataPrecision())) {
            return false;
        }
        return !(this.getBase64String() != null ? !this.getBase64String().equals(that.getBase64String()) : that.getBase64String() != null);
    }

    public int hashCode() {
        int result = this.getBase64String() != null ? this.getBase64String().hashCode() : 0;
        result = 29 * result + (int)(this.getDataLength() ^ this.getDataLength() >>> 32);
        result = 29 * result + this.getDataEndian().hashCode();
        result = 29 * result + this.getDataPrecision().hashCode();
        return result;
    }
}

