/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;

public class AminoAcidPattern
extends ExperimentObject
implements TagComponent {
    static final long serialVersionUID = -2823716418631089876L;
    private Integer target = 0;
    private int length = -1;
    private HashMap<Integer, ArrayList<AminoAcid>> aaTargeted = null;
    private HashMap<Integer, ArrayList<AminoAcid>> aaExcluded = null;
    private HashMap<Integer, ArrayList<ModificationMatch>> targetModifications = null;

    public AminoAcidPattern() {
    }

    public AminoAcidPattern(String sequence) {
        this.aaTargeted = new HashMap(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            ArrayList<AminoAcid> list = new ArrayList<AminoAcid>(1);
            list.add(aa);
            this.aaTargeted.put(i, list);
        }
        this.length = sequence.length();
    }

    public AminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherExcluded;
        this.target = aminoAcidPattern.getTarget();
        HashMap<Integer, ArrayList<AminoAcid>> otherTargets = aminoAcidPattern.getAaTargeted();
        if (otherTargets != null) {
            this.aaTargeted = new HashMap(otherTargets.size());
            for (int index : otherTargets.keySet()) {
                this.aaTargeted.put(index, (ArrayList)otherTargets.get(index).clone());
            }
        }
        if ((otherExcluded = aminoAcidPattern.getAaExcluded()) != null) {
            this.aaExcluded = new HashMap(otherExcluded.size());
            for (int index : otherExcluded.keySet()) {
                this.aaExcluded.put(index, (ArrayList)otherExcluded.get(index).clone());
            }
        }
        if ((modificationMatches = aminoAcidPattern.getModificationMatches()) != null) {
            this.targetModifications = new HashMap(modificationMatches.size());
            for (int index : modificationMatches.keySet()) {
                this.targetModifications.put(index, (ArrayList)modificationMatches.get(index).clone());
            }
        }
    }

    public HashMap<Integer, ArrayList<AminoAcid>> getAaTargeted() {
        return this.aaTargeted;
    }

    public HashMap<Integer, ArrayList<AminoAcid>> getAaExcluded() {
        return this.aaExcluded;
    }

    public AminoAcidPattern(ArrayList<String> targetTesidues) throws IllegalArgumentException {
        ArrayList<AminoAcid> aminoAcids = new ArrayList<AminoAcid>(targetTesidues.size());
        for (String letter : targetTesidues) {
            AminoAcid aa = AminoAcid.getAminoAcid(letter);
            if (aa != null) {
                aminoAcids.add(aa);
                continue;
            }
            throw new IllegalArgumentException("Amino acid not recognized " + letter + ".");
        }
        this.aaTargeted = new HashMap(1);
        this.aaTargeted.put(0, aminoAcids);
        this.length = 1;
    }

    public void swapRows(int fromRow, int toRow) throws IllegalArgumentException {
        if (this.aaTargeted.size() < fromRow || this.aaExcluded.size() < fromRow || fromRow < 0 || toRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + fromRow);
        }
        if (this.aaTargeted.size() < toRow || this.aaExcluded.size() < fromRow || toRow < 0 || fromRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + toRow);
        }
        ArrayList<AminoAcid> toRowDataTarget = this.aaTargeted.get(toRow);
        ArrayList<AminoAcid> toRowDataExcluded = this.aaExcluded.get(toRow);
        this.aaTargeted.put(toRow, this.aaTargeted.get(fromRow));
        this.aaExcluded.put(toRow, this.aaExcluded.get(fromRow));
        this.aaTargeted.put(fromRow, toRowDataTarget);
        this.aaExcluded.put(fromRow, toRowDataExcluded);
        if (this.target == fromRow) {
            this.target = toRow;
        } else if (this.target == toRow) {
            this.target = fromRow;
        }
    }

    public Integer getTarget() {
        return this.target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public ArrayList<AminoAcid> getAminoAcidsAtTarget() {
        return this.getTargetedAA(this.target);
    }

    public void setTargeted(int index, ArrayList<AminoAcid> targets) {
        if (this.aaTargeted == null) {
            this.aaTargeted = new HashMap(1);
        }
        this.aaTargeted.put(index, targets);
        this.length = -1;
    }

    public ArrayList<AminoAcid> getTargetedAA(int index) {
        ArrayList<AminoAcid> result;
        if (this.aaTargeted != null && (result = this.aaTargeted.get(index)) != null) {
            return result;
        }
        return new ArrayList<AminoAcid>();
    }

    public ArrayList<AminoAcid> getExcludedAA(int index) {
        ArrayList<AminoAcid> result;
        if (this.aaExcluded != null && (result = this.aaExcluded.get(index)) != null) {
            return result;
        }
        return new ArrayList<AminoAcid>();
    }

    public int getNTargetedAA(int index) {
        if (this.aaTargeted == null) {
            return 0;
        }
        ArrayList<AminoAcid> aas = this.getTargetedAA(index);
        return aas.size();
    }

    public int getNExcludedAA(int index) {
        if (this.aaExcluded == null) {
            return 0;
        }
        ArrayList<AminoAcid> aas = this.getExcludedAA(index);
        if (aas == null) {
            return 0;
        }
        return aas.size();
    }

    public void setExcluded(int index, ArrayList<AminoAcid> exclusions) {
        if (this.aaExcluded == null) {
            this.aaExcluded = new HashMap(1);
        }
        this.aaExcluded.put(index, exclusions);
        this.length = -1;
    }

    public void removeAA(int index) {
        ArrayList<Integer> indexes;
        if (this.aaTargeted != null) {
            indexes = new ArrayList<Integer>(this.aaTargeted.keySet());
            Collections.sort(indexes);
            for (int aa : indexes) {
                if (aa < index) continue;
                if (aa > index) {
                    this.aaTargeted.put(aa - 1, this.aaTargeted.get(aa));
                }
                this.aaTargeted.remove(aa);
            }
        }
        if (this.aaExcluded != null) {
            indexes = new ArrayList<Integer>(this.aaExcluded.keySet());
            Collections.sort(indexes);
            for (int aa : indexes) {
                if (aa < index) continue;
                if (aa > index) {
                    this.aaExcluded.put(aa - 1, this.aaExcluded.get(aa));
                }
                this.aaExcluded.remove(aa);
            }
        }
        if (this.targetModifications != null) {
            indexes = new ArrayList<Integer>(this.targetModifications.keySet());
            Collections.sort(indexes);
            int ptmIndex = index + 1;
            for (int aa : indexes) {
                if (aa < ptmIndex) continue;
                if (aa > ptmIndex) {
                    this.targetModifications.put(aa - 1, this.targetModifications.get(aa));
                }
                this.aaExcluded.remove(aa);
            }
        }
        this.length = -1;
    }

    public Pattern getAsStringPattern() {
        return this.getAsStringPattern(MatchingType.string, null);
    }

    public Pattern getAsStringPattern(MatchingType matchingType, Double massTolerance) {
        String regex = "";
        int tempLength = this.length();
        for (int i = 0; i < tempLength; ++i) {
            ArrayList<AminoAcid> exclude;
            ArrayList<String> toAdd = new ArrayList<String>();
            if (this.aaTargeted != null) {
                ArrayList<AminoAcid> tempTarget = this.aaTargeted.get(i);
                if (tempTarget == null || tempTarget.isEmpty()) {
                    toAdd.addAll(AminoAcid.getAminoAcidsList());
                } else {
                    for (AminoAcid aminoAcid : tempTarget) {
                        String value;
                        if (!toAdd.contains(aminoAcid.singleLetterCode)) {
                            toAdd.add(aminoAcid.singleLetterCode);
                        }
                        if (matchingType != MatchingType.aminoAcid && matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                        for (char tempAa : aminoAcid.getSubAminoAcids()) {
                            value = tempAa + "";
                            if (toAdd.contains(value)) continue;
                            toAdd.add(value);
                        }
                        for (char tempAa : aminoAcid.getCombinations()) {
                            value = tempAa + "";
                            if (toAdd.contains(value)) continue;
                            toAdd.add(value);
                        }
                        if (matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                        for (char tempAa : aminoAcid.getIndistinguishibleAminoAcids(massTolerance)) {
                            String value2 = tempAa + "";
                            if (toAdd.contains(value2)) continue;
                            toAdd.add(value2);
                        }
                    }
                }
            }
            Collections.sort(toAdd);
            ArrayList<String> restrictions = new ArrayList<String>();
            if (this.aaExcluded != null && (exclude = this.aaExcluded.get(i)) != null) {
                for (AminoAcid aa : exclude) {
                    if (restrictions.contains(aa.singleLetterCode)) continue;
                    restrictions.add(aa.singleLetterCode);
                }
            }
            regex = regex + "[";
            for (String string : toAdd) {
                if (restrictions.contains(string)) continue;
                regex = regex + string;
            }
            regex = regex + "]";
        }
        return Pattern.compile(regex, 2);
    }

    public String getPrositeFormat() {
        StringBuilder result = new StringBuilder();
        int cpt = 0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<AminoAcid> targetedAa = this.getTargetedAA(i);
            ArrayList<AminoAcid> excludedAa = this.getExcludedAA(i);
            if (!targetedAa.isEmpty() || !excludedAa.isEmpty()) {
                if (cpt > 0) {
                    result.append("(" + cpt + ")");
                    cpt = 0;
                }
                if (!targetedAa.isEmpty()) {
                    result.append("[");
                    for (AminoAcid aa : targetedAa) {
                        if (excludedAa.contains(aa)) continue;
                        result.append(aa.singleLetterCode);
                    }
                    result.append("]");
                } else if (!excludedAa.isEmpty()) {
                    result.append("{");
                    for (AminoAcid aa : excludedAa) {
                        result.append(aa.singleLetterCode);
                    }
                    result.append("}");
                }
            } else {
                ++cpt;
            }
            if (i != this.target) continue;
            result.append("!");
        }
        return result.toString();
    }

    public ArrayList<Integer> getIndexes(String input) {
        return this.getIndexes(input, MatchingType.string, (Double)Double.NaN);
    }

    public ArrayList<Integer> getIndexes(AminoAcidPattern input) {
        return this.getIndexes(input, MatchingType.string, (Double)Double.NaN);
    }

    public ArrayList<Integer> getIndexes(String input, MatchingType matchingType, Double massTolerance) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, matchingType, massTolerance, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public ArrayList<Integer> getIndexes(AminoAcidPattern input, MatchingType matchingType, Double massTolerance) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, matchingType, massTolerance, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public boolean matches(String aminoAcidSequence) {
        return this.matches(aminoAcidSequence, MatchingType.string, (Double)Double.NaN);
    }

    public int firstIndex(String aminoAcidSequence, MatchingType matchingType, Double massTolerance) {
        return this.firstIndex(aminoAcidSequence, matchingType, massTolerance, 0);
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, MatchingType matchingType, Double massTolerance) {
        return this.firstIndex(aminoAcidPattern, matchingType, massTolerance, 0);
    }

    public int firstIndex(String aminoAcidSequence, MatchingType matchingType, Double massTolerance, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidSequence.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                char aa = aminoAcidSequence.charAt(i + j);
                boolean reject = this.isExcluded(aa, j, matchingType, massTolerance);
                if (reject) {
                    match = false;
                } else {
                    boolean targeted = this.isTargeted(aa, j, matchingType, massTolerance);
                    if (!targeted) {
                        match = false;
                    }
                }
                if (!match) break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, MatchingType matchingType, Double massTolerance, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidPattern.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                boolean aaMatched = false;
                for (AminoAcid aminoAcid : aminoAcidPattern.getTargetedAA(i + j)) {
                    boolean targeted;
                    char aa = aminoAcid.singleLetterCode.charAt(0);
                    boolean reject = this.isExcluded(aa, j, matchingType, massTolerance);
                    if (reject || !(targeted = this.isTargeted(aa, j, matchingType, massTolerance))) continue;
                    aaMatched = true;
                    break;
                }
                if (aaMatched) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public boolean isTargeted(char aa, int index, MatchingType matchingType, Double massTolerance) {
        if (this.aaTargeted != null) {
            ArrayList<AminoAcid> aaList = this.aaTargeted.get(index);
            if (aaList != null && !aaList.isEmpty()) {
                for (AminoAcid targetedAA : aaList) {
                    if (aa == targetedAA.singleLetterCode.charAt(0)) {
                        return true;
                    }
                    if (matchingType != MatchingType.aminoAcid && matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                    for (char tempAA : targetedAA.getSubAminoAcids()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    for (char tempAA : targetedAA.getCombinations()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    if (matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                    for (char tempAA : targetedAA.getIndistinguishibleAminoAcids(massTolerance)) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isExcluded(char aa, int index, MatchingType matchingType, Double massTolerance) {
        ArrayList<AminoAcid> aaList;
        if (this.aaExcluded != null && (aaList = this.aaExcluded.get(index)) != null && !aaList.isEmpty()) {
            for (AminoAcid vetoAA : aaList) {
                if (aa == vetoAA.singleLetterCode.charAt(0)) {
                    return true;
                }
                if (matchingType != MatchingType.aminoAcid && matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                for (char tempAA : vetoAA.getSubAminoAcids()) {
                    if (aa != tempAA) continue;
                    return true;
                }
                for (char tempAA : vetoAA.getCombinations()) {
                    if (aa != tempAA) continue;
                    return true;
                }
                if (matchingType != MatchingType.indistiguishibleAminoAcids) continue;
                for (char tempAA : vetoAA.getIndistinguishibleAminoAcids(massTolerance)) {
                    if (aa != tempAA) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean matches(String aminoAcidSequence, MatchingType matchingType, Double massTolerance) {
        return this.firstIndex(aminoAcidSequence, matchingType, massTolerance) >= 0;
    }

    public boolean matches(AminoAcidPattern aminoAcidPattern, MatchingType matchingType, Double massTolerance) {
        return this.firstIndex(aminoAcidPattern, matchingType, massTolerance) >= 0;
    }

    public boolean isStarting(String aminoAcidSequence) {
        return this.isStarting(aminoAcidSequence, MatchingType.string, (Double)Double.NaN);
    }

    public boolean isStarting(AminoAcidPattern aminoAcidPattern) {
        return this.isStarting(aminoAcidPattern, MatchingType.string, (Double)Double.NaN);
    }

    public boolean isStarting(String aminoAcidSequence, MatchingType matchingType, Double massTolerance) {
        int patternLength = this.length();
        return this.matches(aminoAcidSequence.substring(0, patternLength), matchingType, massTolerance);
    }

    public boolean isStarting(AminoAcidPattern aminoAcidPattern, MatchingType matchingType, Double massTolerance) {
        int patternLength = this.length();
        return this.matches(aminoAcidPattern.getSubPattern(0, patternLength, false), matchingType, massTolerance);
    }

    public boolean isEnding(String aminoAcidSequence) {
        return this.isEnding(aminoAcidSequence, MatchingType.string, (Double)Double.NaN);
    }

    public boolean isEnding(AminoAcidPattern aminoAcidPattern) {
        return this.isEnding(aminoAcidPattern, MatchingType.string, (Double)Double.NaN);
    }

    public boolean isEnding(AminoAcidPattern aminoAcidPattern, MatchingType matchingType, Double massTolerance) {
        int patternLength = this.length();
        return this.matches(aminoAcidPattern.getSubPattern(aminoAcidPattern.length() - patternLength, false), matchingType, massTolerance);
    }

    public boolean isEnding(String aminoAcidSequence, MatchingType matchingType, Double massTolerance) {
        int patternLength = this.length();
        return this.matches(aminoAcidSequence.substring(aminoAcidSequence.length() - patternLength), matchingType, massTolerance);
    }

    public boolean isSameAs(AminoAcidPattern anotherPattern) {
        if (!anotherPattern.getAsStringPattern().pattern().equalsIgnoreCase(this.getAsStringPattern().pattern())) {
            return false;
        }
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherPattern.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (int j = 0; j < mods1.size(); ++j) {
                ModificationMatch modificationMatch2;
                ModificationMatch modificationMatch1 = mods1.get(j);
                if (modificationMatch1.equals(modificationMatch2 = mods2.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int length() {
        if (this.length == -1 || this.length == 0) {
            this.length = !(this.aaTargeted != null && !this.aaTargeted.isEmpty() || this.aaExcluded != null && !this.aaExcluded.isEmpty()) ? 0 : (this.aaTargeted == null || this.aaTargeted.isEmpty() ? Collections.max(this.aaExcluded.keySet()) + 1 : (this.aaExcluded == null || this.aaExcluded.isEmpty() ? Collections.max(this.aaTargeted.keySet()) + 1 : Math.max(Collections.max(this.aaTargeted.keySet()), Collections.max(this.aaExcluded.keySet())) + 1));
        }
        return this.length;
    }

    public AminoAcidPattern getStandardSearchPattern() {
        AminoAcidPattern result = new AminoAcidPattern();
        result.setTarget(this.target);
        result.setTargeted(this.target, this.getAminoAcidsAtTarget());
        return result;
    }

    public static AminoAcidPattern getTrypsinExample() {
        AminoAcidPattern example = new AminoAcidPattern();
        example.setTarget(0);
        ArrayList<AminoAcid> target = new ArrayList<AminoAcid>();
        target.add(AminoAcid.K);
        target.add(AminoAcid.R);
        example.setTargeted(0, target);
        ArrayList<AminoAcid> exclusion = new ArrayList<AminoAcid>();
        exclusion.add(AminoAcid.P);
        example.setExcluded(1, exclusion);
        return example;
    }

    public void merge(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherInclusionMap;
        HashMap<Integer, ArrayList<AminoAcid>> otherExclusionMap = otherPattern.getAaExcluded();
        if (otherExclusionMap != null) {
            for (int i : otherExclusionMap.keySet()) {
                ArrayList<AminoAcid> excludedAA;
                ArrayList<AminoAcid> otherAAs = otherPattern.getExcludedAA(i);
                if (otherAAs.isEmpty()) continue;
                if (this.aaExcluded == null) {
                    this.aaExcluded = new HashMap(otherExclusionMap.size());
                }
                if ((excludedAA = this.aaExcluded.get(i)) == null) {
                    this.aaExcluded.put(i, (ArrayList)otherAAs.clone());
                    continue;
                }
                for (AminoAcid aa : otherAAs) {
                    if (excludedAA.contains(aa)) continue;
                    excludedAA.add(aa);
                }
            }
        }
        if ((otherInclusionMap = otherPattern.getAaTargeted()) != null) {
            for (int i : otherInclusionMap.keySet()) {
                ArrayList<AminoAcid> targetedAA;
                ArrayList<AminoAcid> otherAAs = otherPattern.getExcludedAA(i);
                if (otherAAs.isEmpty()) continue;
                if (this.aaTargeted == null) {
                    this.aaTargeted = new HashMap(otherInclusionMap.size());
                }
                if ((targetedAA = this.aaTargeted.get(i)) == null) {
                    this.aaTargeted.put(i, (ArrayList)otherAAs.clone());
                    continue;
                }
                for (AminoAcid aa : otherAAs) {
                    if (targetedAA.contains(aa)) continue;
                    targetedAA.add(aa);
                }
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                this.addModificationMatches(i, otherPattern.getModificationMatches().get(i));
            }
        }
        this.length = -1;
    }

    public void append(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherTargetedMap;
        int patternLength = this.length();
        HashMap<Integer, ArrayList<AminoAcid>> otherExclusionMap = otherPattern.getAaExcluded();
        if (otherExclusionMap != null) {
            if (this.aaExcluded == null) {
                this.aaExcluded = new HashMap(otherExclusionMap.size());
            }
            for (int i : otherExclusionMap.keySet()) {
                int index = patternLength + i;
                this.aaExcluded.put(index, (ArrayList)otherExclusionMap.get(i).clone());
            }
        }
        if ((otherTargetedMap = otherPattern.getAaTargeted()) != null) {
            if (this.aaTargeted == null) {
                this.aaTargeted = new HashMap(otherTargetedMap.size());
            }
            for (int i : otherTargetedMap.keySet()) {
                int index = patternLength + i;
                this.aaTargeted.put(index, (ArrayList)otherTargetedMap.get(i).clone());
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                int newIndex = i + patternLength;
                for (ModificationMatch oldModificationMatch : modificationMatches.get(i)) {
                    ModificationMatch newModificationMatch = new ModificationMatch(oldModificationMatch.getTheoreticPtm(), oldModificationMatch.isVariable(), newIndex);
                    this.addModificationMatch(newIndex, newModificationMatch);
                }
            }
        }
        this.length = patternLength + otherPattern.length();
    }

    public static AminoAcidPattern merge(AminoAcidPattern pattern1, AminoAcidPattern pattern2) {
        AminoAcidPattern result = new AminoAcidPattern(pattern1);
        result.merge(pattern2);
        return result;
    }

    public String toString() {
        return this.getAsStringPattern().pattern();
    }

    @Override
    public String asSequence() {
        String result = "";
        for (int i = 0; i < this.length(); ++i) {
            if (this.getNTargetedAA(i) == 1 && this.getNExcludedAA(i) == 0) {
                result = result + this.getTargetedAA((int)i).get((int)0).singleLetterCode;
                continue;
            }
            result = result + "[";
            if (this.getNTargetedAA(i) == 0) {
                result = result + "X";
            } else {
                for (AminoAcid aa : this.getTargetedAA(i)) {
                    result = result + aa.singleLetterCode;
                }
            }
            if (this.getNExcludedAA(i) <= 0) continue;
            result = result + "/";
            for (AminoAcid aa : this.getExcludedAA(i)) {
                result = result + aa.singleLetterCode;
            }
        }
        return result;
    }

    public String asSequence(int index) {
        String result = "";
        if (this.getNTargetedAA(index) == 1 && this.getNExcludedAA(index) == 0) {
            result = result + this.getTargetedAA((int)index).get((int)0).singleLetterCode;
        } else {
            result = result + "[";
            if (this.getNTargetedAA(index) == 0) {
                result = result + "X";
            } else {
                for (AminoAcid aa : this.getTargetedAA(index)) {
                    result = result + aa.singleLetterCode;
                }
            }
            if (this.getNExcludedAA(index) > 0) {
                result = result + "/";
                for (AminoAcid aa : this.getExcludedAA(index)) {
                    result = result + aa.singleLetterCode;
                }
            }
        }
        return result;
    }

    public HashMap<Integer, ArrayList<ModificationMatch>> getModificationMatches() {
        return this.targetModifications;
    }

    public ArrayList<ModificationMatch> getModificationsAt(int localization) {
        ArrayList<ModificationMatch> tempResult;
        ArrayList<ModificationMatch> result = new ArrayList<ModificationMatch>();
        if (this.targetModifications != null && (tempResult = this.targetModifications.get(localization)) != null) {
            result = tempResult;
        }
        return result;
    }

    public void clearModificationMatches() {
        if (this.targetModifications != null) {
            this.targetModifications.clear();
        }
    }

    public void addModificationMatch(int localization, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatches = this.targetModifications.get(localization)) == null) {
            modificationMatches = new ArrayList();
            this.targetModifications.put(localization, modificationMatches);
        }
        modificationMatches.add(modificationMatch);
    }

    public void addModificationMatches(int localization, ArrayList<ModificationMatch> modificationMatches) {
        ArrayList<ModificationMatch> modificationMatchesAtIndex;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatchesAtIndex = this.targetModifications.get(localization)) == null) {
            modificationMatchesAtIndex = new ArrayList();
            this.targetModifications.put(localization, modificationMatchesAtIndex);
        }
        modificationMatches.addAll(modificationMatches);
    }

    public void changeModificationSite(ModificationMatch modificationMatch, int oldLocalization, int newLocalization) {
        int oldIndex = oldLocalization - 1;
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Wrong modification old target index " + oldLocalization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null || !this.targetModifications.containsKey(oldIndex) || !this.targetModifications.get(oldIndex).contains(modificationMatch)) {
            throw new IllegalArgumentException("Modification match " + modificationMatch + " not found at index " + oldLocalization + ".");
        }
        this.targetModifications.get(oldIndex).remove(modificationMatch);
        this.addModificationMatch(newLocalization, modificationMatch);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> mainModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        if (this.targetModifications != null) {
            for (int modSite : this.targetModifications.keySet()) {
                for (ModificationMatch modificationMatch : this.targetModifications.get(modSite)) {
                    String modName = modificationMatch.getTheoreticPtm();
                    if (modificationMatch.isVariable()) {
                        if (modificationMatch.isConfident()) {
                            if (!mainModificationSites.containsKey(modSite)) {
                                mainModificationSites.put(modSite, new ArrayList());
                            }
                            mainModificationSites.get(modSite).add(modName);
                            continue;
                        }
                        if (!secondaryModificationSites.containsKey(modSite)) {
                            secondaryModificationSites.put(modSite, new ArrayList());
                        }
                        secondaryModificationSites.get(modSite).add(modName);
                        continue;
                    }
                    if (excludeAllFixedPtms) continue;
                    if (!fixedModificationSites.containsKey(modSite)) {
                        fixedModificationSites.put(modSite, new ArrayList());
                    }
                    fixedModificationSites.get(modSite).add(modName);
                }
            }
        }
        return AminoAcidPattern.getTaggedModifiedSequence(modificationProfile, this, mainModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, AminoAcidPattern aminoAcidPattern, HashMap<Integer, ArrayList<String>> mainModificationSites, HashMap<Integer, ArrayList<String>> secondaryModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean useShortName) {
        if (mainModificationSites == null) {
            mainModificationSites = new HashMap();
        }
        if (secondaryModificationSites == null) {
            secondaryModificationSites = new HashMap();
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap();
        }
        String modifiedSequence = "";
        for (int aa = 1; aa <= aminoAcidPattern.length(); ++aa) {
            int patternIndex = aa - 1;
            if (aminoAcidPattern.getNTargetedAA(patternIndex) > 1 && aminoAcidPattern.getNExcludedAA(patternIndex) > 0) {
                modifiedSequence = modifiedSequence + "[";
            }
            if (aminoAcidPattern.getNTargetedAA(patternIndex) == 0) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                } else if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue("X", ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else {
                    modifiedSequence = modifiedSequence + "X";
                }
            }
            for (AminoAcid aminoAcid : aminoAcidPattern.getTargetedAA(patternIndex)) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.singleLetterCode, ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                modifiedSequence = modifiedSequence + aminoAcid.singleLetterCode;
            }
            if (aminoAcidPattern.getNExcludedAA(patternIndex) > 0) {
                modifiedSequence = modifiedSequence + "/";
                for (AminoAcid aminoAcid : aminoAcidPattern.getExcludedAA(patternIndex)) {
                    modifiedSequence = modifiedSequence + aminoAcid.singleLetterCode;
                }
            }
            if (aminoAcidPattern.getNTargetedAA(aa) <= 1 || aminoAcidPattern.getNExcludedAA(patternIndex) <= 0) continue;
            modifiedSequence = modifiedSequence + "]";
        }
        return modifiedSequence;
    }

    private static String getTaggedResidue(String residue, String ptmName, ModificationProfile modificationProfile, boolean mainPtm, boolean useHtmlColorCoding, boolean useShortName) {
        String taggedResidue = "";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        PTM ptm = ptmFactory.getPTM(ptmName);
        if (ptm.getType() == 0) {
            if (!useHtmlColorCoding) {
                taggedResidue = useShortName ? taggedResidue + residue + "<" + ptmFactory.getShortName(ptmName) + ">" : taggedResidue + residue + "<" + ptmName + ">";
            } else {
                Color ptmColor = modificationProfile.getColor(ptmName);
                taggedResidue = mainPtm ? taggedResidue + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(ptmColor) + "\">" + residue + "</span>" : taggedResidue + "<span style=\"color:#" + Util.color2Hex(ptmColor) + ";background:#" + Util.color2Hex(Color.WHITE) + "\">" + residue + "</span>";
            }
        } else {
            taggedResidue = taggedResidue + residue;
        }
        return taggedResidue;
    }

    public ArrayList<String> getAllPossibleSequences() {
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>();
        for (int i = 0; i < this.length(); ++i) {
            if (stringBuilders.isEmpty()) {
                if (this.aaTargeted != null) {
                    ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (AminoAcid aminoAcid : aminoAcids) {
                            stringBuilders.add(new StringBuilder(aminoAcid.singleLetterCode));
                        }
                        continue;
                    }
                    stringBuilders.add(new StringBuilder("X"));
                    continue;
                }
                stringBuilders.add(new StringBuilder("X"));
                continue;
            }
            ArrayList<StringBuilder> newBuilders = new ArrayList<StringBuilder>();
            for (StringBuilder stringBuilder : stringBuilders) {
                StringBuilder newBuilder = new StringBuilder(stringBuilder);
                if (this.aaTargeted != null) {
                    ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (AminoAcid aminoAcid : this.aaTargeted.get(i)) {
                            newBuilder.append(aminoAcid.singleLetterCode);
                            newBuilders.add(newBuilder);
                        }
                        continue;
                    }
                    newBuilder.append("X");
                    newBuilders.add(newBuilder);
                    continue;
                }
                newBuilder.append("X");
                newBuilders.add(newBuilder);
            }
            stringBuilders = newBuilders;
        }
        ArrayList<String> results = new ArrayList<String>(stringBuilders.size());
        for (StringBuilder stringBuilder : stringBuilders) {
            results.add(stringBuilder.toString());
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double getMass() {
        double mass = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<ModificationMatch> modificationAtIndex;
            if (this.aaTargeted == null) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". null as targeted amino acid map.");
            ArrayList<AminoAcid> aminoAcids = this.aaTargeted.get(i);
            if (aminoAcids.size() != 1) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". " + aminoAcids.size() + " amino acids at target position " + i + " as targeted amino acid.");
            mass += this.getTargetedAA((int)i).get((int)0).monoisotopicMass;
            if (this.targetModifications == null || (modificationAtIndex = this.targetModifications.get(i)) == null) continue;
            for (ModificationMatch modificationMatch : modificationAtIndex) {
                PTM ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm());
                mass += ptm.getMass();
            }
        }
        return mass;
    }

    public AminoAcidPattern getSubPattern(int startIndex, int endIndex, boolean updateTarget) {
        ArrayList aminoAcids;
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern();
        if (this.aaTargeted != null) {
            for (int i : this.aaTargeted.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                aminoAcids = (ArrayList)this.aaTargeted.get(i).clone();
                aminoAcidPattern.setTargeted(i - startIndex, aminoAcids);
            }
        }
        if (this.aaExcluded != null) {
            for (int i : this.aaExcluded.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                aminoAcids = (ArrayList)this.aaExcluded.get(i).clone();
                aminoAcidPattern.setTargeted(i - startIndex, aminoAcids);
            }
        }
        if (updateTarget) {
            aminoAcidPattern.setTarget(this.getTarget() - startIndex);
        } else {
            aminoAcidPattern.setTarget(this.getTarget());
        }
        if (this.targetModifications != null) {
            for (int i : this.targetModifications.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                int index = i - startIndex;
                ArrayList<ModificationMatch> modificationMatches = this.targetModifications.get(i);
                ArrayList<ModificationMatch> newMatches = new ArrayList<ModificationMatch>(modificationMatches.size());
                for (ModificationMatch modificationMatch : modificationMatches) {
                    newMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), index));
                }
                aminoAcidPattern.addModificationMatches(index, newMatches);
            }
        }
        return aminoAcidPattern;
    }

    public AminoAcidPattern getSubPattern(int startIndex, boolean updateTarget) {
        return this.getSubPattern(startIndex, this.length(), updateTarget);
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent) {
        if (!(anotherCompontent instanceof AminoAcidPattern)) {
            return false;
        }
        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)anotherCompontent;
        return this.isSameAs(aminoAcidPattern);
    }

    public static enum MatchingType {
        string,
        aminoAcid,
        indistiguishibleAminoAcids;

    }
}

