/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

public class ImmoniumIon
extends Ion {
    static final long serialVersionUID = -3403620196563864756L;
    public static final int ALANINE = 0;
    public static final int ARGININE = 1;
    public static final int ASPARAGINE = 2;
    public static final int ASPARTIC_ACID = 3;
    public static final int CYSTEINE = 4;
    public static final int GLUTAMIC_ACID = 5;
    public static final int GLUTAMINE = 6;
    public static final int GLYCINE = 7;
    public static final int HISTIDINE = 8;
    public static final int ISOLEUCINE = 9;
    public static final int LEUCINE = 10;
    public static final int LYSINE = 11;
    public static final int METHIONINE = 12;
    public static final int PHENYLALANINE = 13;
    public static final int PROLINE = 14;
    public static final int SELENOCYSTEINE = 15;
    public static final int SERINE = 16;
    public static final int THREONINE = 17;
    public static final int TRYPTOPHAN = 18;
    public static final int TYROSINE = 19;
    public static final int VALINE = 20;
    private int subType;

    public ImmoniumIon(char residue) {
        this.type = Ion.IonType.IMMONIUM_ION;
        this.subType = ImmoniumIon.getSubtype(residue);
        AminoAcid currentAA = AminoAcid.getAminoAcid(residue);
        this.theoreticMass = currentAA.monoisotopicMass - Atom.C.mass - Atom.O.mass;
    }

    public ImmoniumIon(int subType) {
        this.type = Ion.IonType.IMMONIUM_ION;
        this.subType = subType;
        char aa = ImmoniumIon.getResidue(subType);
        AminoAcid currentAA = AminoAcid.getAminoAcid(aa);
        this.theoreticMass = currentAA.monoisotopicMass - Atom.C.mass - Atom.O.mass;
    }

    public static char getResidue(int subtype) {
        switch (subtype) {
            case 0: {
                return 'A';
            }
            case 4: {
                return 'C';
            }
            case 3: {
                return 'D';
            }
            case 5: {
                return 'E';
            }
            case 13: {
                return 'F';
            }
            case 7: {
                return 'G';
            }
            case 8: {
                return 'H';
            }
            case 9: {
                return 'I';
            }
            case 11: {
                return 'K';
            }
            case 10: {
                return 'L';
            }
            case 12: {
                return 'M';
            }
            case 2: {
                return 'N';
            }
            case 14: {
                return 'P';
            }
            case 6: {
                return 'Q';
            }
            case 1: {
                return 'R';
            }
            case 16: {
                return 'S';
            }
            case 17: {
                return 'T';
            }
            case 20: {
                return 'V';
            }
            case 18: {
                return 'W';
            }
            case 19: {
                return 'Y';
            }
        }
        return 'X';
    }

    public static int getSubtype(char residue) {
        switch (residue) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 4;
            }
            case 'D': {
                return 3;
            }
            case 'E': {
                return 5;
            }
            case 'F': {
                return 13;
            }
            case 'G': {
                return 7;
            }
            case 'H': {
                return 8;
            }
            case 'I': {
                return 9;
            }
            case 'K': {
                return 11;
            }
            case 'L': {
                return 10;
            }
            case 'M': {
                return 12;
            }
            case 'N': {
                return 2;
            }
            case 'P': {
                return 14;
            }
            case 'Q': {
                return 6;
            }
            case 'R': {
                return 1;
            }
            case 'S': {
                return 16;
            }
            case 'T': {
                return 17;
            }
            case 'V': {
                return 20;
            }
            case 'W': {
                return 18;
            }
            case 'Y': {
                return 19;
            }
        }
        return -1;
    }

    @Override
    public String getName() {
        return "i" + ImmoniumIon.getResidue(this.subType);
    }

    @Override
    public CvTerm getPrideCvTerm() {
        switch (this.subType) {
            case 0: {
                return new CvTerm("PRIDE", "PRIDE:0000240", "immonium A", "0");
            }
            case 4: {
                return new CvTerm("PRIDE", "PRIDE:0000241", "immonium C", "0");
            }
            case 3: {
                return new CvTerm("PRIDE", "PRIDE:0000242", "immonium D", "0");
            }
            case 5: {
                return new CvTerm("PRIDE", "PRIDE:0000243", "immonium E", "0");
            }
            case 13: {
                return new CvTerm("PRIDE", "PRIDE:0000244", "immonium F", "0");
            }
            case 7: {
                return new CvTerm("PRIDE", "PRIDE:0000245", "immonium G", "0");
            }
            case 8: {
                return new CvTerm("PRIDE", "PRIDE:0000246", "immonium H", "0");
            }
            case 9: {
                return new CvTerm("PRIDE", "PRIDE:0000247", "immonium I", "0");
            }
            case 11: {
                return new CvTerm("PRIDE", "PRIDE:0000248", "immonium K", "0");
            }
            case 10: {
                return new CvTerm("PRIDE", "PRIDE:0000249", "immonium L", "0");
            }
            case 12: {
                return new CvTerm("PRIDE", "PRIDE:0000250", "immonium M", "0");
            }
            case 2: {
                return new CvTerm("PRIDE", "PRIDE:0000251", "immonium N", "0");
            }
            case 14: {
                return new CvTerm("PRIDE", "PRIDE:0000252", "immonium P", "0");
            }
            case 6: {
                return new CvTerm("PRIDE", "PRIDE:0000253", "immonium Q", "0");
            }
            case 1: {
                return new CvTerm("PRIDE", "PRIDE:0000254", "immonium R", "0");
            }
            case 16: {
                return new CvTerm("PRIDE", "PRIDE:0000255", "immonium S", "0");
            }
            case 17: {
                return new CvTerm("PRIDE", "PRIDE:0000256", "immonium T", "0");
            }
            case 20: {
                return new CvTerm("PRIDE", "PRIDE:0000257", "immonium V", "0");
            }
            case 18: {
                return new CvTerm("PRIDE", "PRIDE:0000258", "immonium W", "0");
            }
            case 19: {
                return new CvTerm("PRIDE", "PRIDE:0000259", "immonium Y", "0");
            }
        }
        return null;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        return "Immonium " + ImmoniumIon.getResidue(this.subType);
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>();
        possibleTypes.add(0);
        possibleTypes.add(4);
        possibleTypes.add(3);
        possibleTypes.add(5);
        possibleTypes.add(13);
        possibleTypes.add(7);
        possibleTypes.add(8);
        possibleTypes.add(9);
        possibleTypes.add(11);
        possibleTypes.add(10);
        possibleTypes.add(12);
        possibleTypes.add(2);
        possibleTypes.add(14);
        possibleTypes.add(6);
        possibleTypes.add(1);
        possibleTypes.add(16);
        possibleTypes.add(17);
        possibleTypes.add(20);
        possibleTypes.add(18);
        possibleTypes.add(19);
        return possibleTypes;
    }

    @Override
    public ArrayList<NeutralLoss> getNeutralLosses() {
        return new ArrayList<NeutralLoss>();
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.IMMONIUM_ION && anotherIon.getSubType() == this.subType;
    }
}

