/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.Util;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationDB;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public abstract class Identification
extends ExperimentObject {
    static final long serialVersionUID = -2551700699384242554L;
    public static final String EXTENTION = ".cuh";
    protected ArrayList<String> proteinIdentification = new ArrayList();
    protected ArrayList<String> peptideIdentification = new ArrayList();
    protected HashMap<String, ArrayList<String>> spectrumIdentificationMap = new HashMap();
    protected ArrayList<String> spectrumIdentification = new ArrayList();
    protected HashMap<String, ArrayList<String>> proteinMap = new HashMap();
    protected int methodUsed;
    protected String serializationDirectory;
    protected HashMap<String, HashMap<String, UrParameter>> urParameters = new HashMap();
    protected ArrayList<String> longKeys = new ArrayList();
    private Boolean isDB = true;
    private IdentificationDB identificationDB;
    protected String reference;
    private ArrayList<String> orderedSpectrumFileNames;

    public ArrayList<String> getOrderedSpectrumFileNames() {
        if (this.orderedSpectrumFileNames == null) {
            this.orderedSpectrumFileNames = this.getSpectrumFiles();
            Collections.sort(this.orderedSpectrumFileNames);
        }
        return this.orderedSpectrumFileNames;
    }

    public void setOrderedListOfSpectrumFileNames(ArrayList<String> orderedSpectrumFileNames) throws IllegalArgumentException {
        if (this.orderedSpectrumFileNames.size() != orderedSpectrumFileNames.size()) {
            throw new IllegalArgumentException("The length of the ordered file names as to be the same as the number of spectrum files. " + orderedSpectrumFileNames.size() + "!=" + this.orderedSpectrumFileNames.size());
        }
        this.orderedSpectrumFileNames = orderedSpectrumFileNames;
    }

    public ArrayList<String> getSpectrumFiles() {
        if (this.spectrumIdentificationMap == null) {
            this.updateSpectrumMapping();
        }
        return new ArrayList<String>(this.spectrumIdentificationMap.keySet());
    }

    public int getSpectrumIdentificationSize() {
        int result = 0;
        for (String spectrumFile : this.spectrumIdentificationMap.keySet()) {
            result += this.spectrumIdentificationMap.get(spectrumFile).size();
        }
        return result;
    }

    public void addMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        if (!this.isDB.booleanValue()) {
            if (!this.urParameters.containsKey(key)) {
                this.urParameters.put(key, new HashMap());
            }
            this.urParameters.get(key).put(ExperimentObject.getParameterKey(urParameter), urParameter);
        } else {
            this.identificationDB.addMatchParameter(key, urParameter);
        }
    }

    public UrParameter getMatchParameter(String matchKey, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.isDB.booleanValue()) {
            return this.urParameters.get(matchKey).get(ExperimentObject.getParameterKey(urParameter));
        }
        return this.identificationDB.getMatchPArameter(matchKey, urParameter, true);
    }

    public void loadSpectrumMatchParameters(String fileName, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatchParameters(fileName, urParameter, waitingHandler);
    }

    public void loadSpectrumMatchParameters(ArrayList<String> spectrumKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatchParameters(spectrumKeys, urParameter, waitingHandler);
    }

    public void loadPeptideMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatchParameters(urParameter, waitingHandler);
    }

    public void loadPeptideMatchParameters(ArrayList<String> peptideKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatchParameters(peptideKeys, urParameter, waitingHandler);
    }

    public void loadPeptideMatches(ArrayList<String> peptideKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatches(peptideKeys, waitingHandler);
    }

    public void loadProteinMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatchParameters(urParameter, waitingHandler);
    }

    public void loadProteinMatchParameters(ArrayList<String> proteinKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatchParameters(proteinKeys, urParameter, waitingHandler);
    }

    public void loadProteinMatches(WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatches(waitingHandler);
    }

    public void loadProteinMatches(ArrayList<String> proteinKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadProteinMatches(proteinKeys, waitingHandler);
    }

    public void loadPeptideMatches(WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadPeptideMatches(waitingHandler);
    }

    public void loadSpectrumMatches(String fileName, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatches(fileName, waitingHandler);
    }

    public void loadSpectrumMatches(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.identificationDB.loadSpectrumMatches(spectrumKeys, waitingHandler);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getSpectrumMatchParameter(key, urParameter, true);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getSpectrumMatchParameter(key, urParameter, useDB);
        }
        return this.getMatchParameter(key, urParameter);
    }

    public void addSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.addSpectrumMatchParameter(key, urParameter);
        } else {
            this.addMatchParameter(key, urParameter);
        }
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getPeptideMatchParameter(key, urParameter, true);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getPeptideMatchParameter(key, urParameter, useDB);
        }
        return this.getMatchParameter(key, urParameter);
    }

    public void addPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.addPeptideMatchParameter(key, urParameter);
        } else {
            this.addMatchParameter(key, urParameter);
        }
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatchParameter(key, urParameter, true);
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getProteinMatchParameter(key, urParameter, useDB);
        }
        return this.getMatchParameter(key, urParameter);
    }

    public void addProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.addProteinMatchParameter(key, urParameter);
        } else {
            this.addMatchParameter(key, urParameter);
        }
    }

    public void updateProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updateProteinParameter(key, urParameter);
        }
    }

    public void updatePeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updatePeptideParameter(key, urParameter);
        }
    }

    public void updateSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updateSpectrumParameter(key, urParameter);
        }
    }

    public void updateSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updateSpectrumMatch(spectrumMatch);
        }
    }

    public void updatePeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updatePeptideMatch(peptideMatch);
        }
    }

    public void updateProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException {
        if (this.isDB.booleanValue()) {
            this.identificationDB.updateProteinMatch(proteinMatch);
        }
    }

    public String getSerializationDirectory() {
        return this.serializationDirectory;
    }

    public void setDirectory(String serializationDirectory, boolean deleteOldDatabase) throws SQLException {
        this.serializationDirectory = serializationDirectory;
    }

    public void removeMatch(String matchKey) throws IllegalArgumentException, SQLException, IOException {
        if (this.proteinIdentification.contains(matchKey)) {
            for (String protein : ProteinMatch.getAccessions(matchKey)) {
                if (this.proteinMap.get(protein) == null) {
                    throw new IllegalArgumentException("Protein not found: " + protein + ".");
                }
                if (!this.proteinMap.get(protein).contains(matchKey)) continue;
                this.proteinMap.get(protein).remove(matchKey);
                if (!this.proteinMap.get(protein).isEmpty()) continue;
                this.proteinMap.remove(protein);
            }
        }
        this.proteinIdentification.remove(matchKey);
        this.peptideIdentification.remove(matchKey);
        this.spectrumIdentification.remove(matchKey);
        String fileName = Spectrum.getSpectrumFile(matchKey);
        ArrayList<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null) {
            spectrumKeys.remove(matchKey);
        }
        if (this.isDB.booleanValue()) {
            this.identificationDB.removeMatch(matchKey);
        } else {
            File matchFile = new File(this.serializationDirectory, this.getFileName(matchKey));
            matchFile.delete();
        }
    }

    public void removeSpectrumMatch(String matchKey) throws IllegalArgumentException, SQLException, IOException {
        this.spectrumIdentification.remove(matchKey);
        String fileName = Spectrum.getSpectrumFile(matchKey);
        ArrayList<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null) {
            spectrumKeys.remove(matchKey);
        }
        if (this.isDB.booleanValue()) {
            this.identificationDB.removeSpectrumMatch(matchKey);
        } else {
            File matchFile = new File(this.serializationDirectory, this.getFileName(matchKey));
            matchFile.delete();
        }
    }

    public void removePeptideMatch(String matchKey) throws IllegalArgumentException, SQLException, IOException {
        this.peptideIdentification.remove(matchKey);
        if (this.isDB.booleanValue()) {
            this.identificationDB.removePeptideMatch(matchKey);
        } else {
            File matchFile = new File(this.serializationDirectory, this.getFileName(matchKey));
            matchFile.delete();
        }
    }

    public void removeProteinMatch(String matchKey) throws IllegalArgumentException, SQLException, IOException {
        if (this.proteinIdentification.contains(matchKey)) {
            for (String protein : ProteinMatch.getAccessions(matchKey)) {
                if (this.proteinMap.get(protein) == null) {
                    throw new IllegalArgumentException("Protein not found: " + protein + ".");
                }
                if (!this.proteinMap.get(protein).contains(matchKey)) continue;
                this.proteinMap.get(protein).remove(matchKey);
                if (!this.proteinMap.get(protein).isEmpty()) continue;
                this.proteinMap.remove(protein);
            }
        }
        this.proteinIdentification.remove(matchKey);
        if (this.isDB.booleanValue()) {
            this.identificationDB.removeProteinMatch(matchKey);
        } else {
            File matchFile = new File(this.serializationDirectory, this.getFileName(matchKey));
            matchFile.delete();
        }
    }

    public boolean matchExists(String matchKey) {
        if (matchKey == null || matchKey.length() == 0) {
            return false;
        }
        String fileName = Spectrum.getSpectrumFile(matchKey);
        ArrayList<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null && spectrumKeys.contains(matchKey)) {
            return true;
        }
        return this.proteinIdentification.contains(matchKey) || this.peptideIdentification.contains(matchKey) || this.spectrumIdentification.contains(matchKey);
    }

    private Object getMatch(String matchKey) throws IllegalArgumentException {
        return this.getMatch(matchKey, 0);
    }

    private synchronized IdentificationMatch getMatch(String matchKey, int errorCounter) throws IllegalArgumentException {
        try {
            File newMatch = new File(this.serializationDirectory, this.getFileName(matchKey));
            FileInputStream fis = new FileInputStream(newMatch);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(bis);
            IdentificationMatch match = (IdentificationMatch)in.readObject();
            fis.close();
            bis.close();
            in.close();
            return match;
        }
        catch (Exception e) {
            if (errorCounter <= 100) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                return this.getMatch(matchKey, errorCounter + 1);
            }
            e.printStackTrace();
            throw new IllegalArgumentException("Error while loading " + matchKey);
        }
    }

    public SpectrumMatch getSpectrumMatch(String spectrumKey) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getSpectrumMatch(spectrumKey, true);
    }

    public SpectrumMatch getSpectrumMatch(String spectrumKey, boolean useDB) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getSpectrumMatch(spectrumKey, useDB);
        }
        return (SpectrumMatch)this.getMatch(spectrumKey);
    }

    public PeptideMatch getPeptideMatch(String peptideKey) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getPeptideMatch(peptideKey, true);
    }

    public PeptideMatch getPeptideMatch(String peptideKey, boolean useDB) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getPeptideMatch(peptideKey, useDB);
        }
        return (PeptideMatch)this.getMatch(peptideKey);
    }

    public ProteinMatch getProteinMatch(String proteinKey) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatch(proteinKey, true);
    }

    public ProteinMatch getProteinMatch(String proteinKey, boolean useDB) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.isDB.booleanValue()) {
            return this.identificationDB.getProteinMatch(proteinKey, useDB);
        }
        return (ProteinMatch)this.getMatch(proteinKey);
    }

    public boolean proteinDetailsInCache(String proteinKey) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch;
        PeptideMatch peptideMatch;
        ProteinMatch proteinMatch = this.getProteinMatch(proteinKey, false);
        return proteinMatch != null && (peptideMatch = this.getPeptideMatch(proteinMatch.getPeptideMatches().get(0), false)) != null && (spectrumMatch = this.getSpectrumMatch(peptideMatch.getSpectrumMatches().get(0), false)) != null;
    }

    public boolean peptideDetailsInCache(String peptideKey) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch;
        PeptideMatch peptideMatch = this.getPeptideMatch(peptideKey, false);
        return peptideMatch != null && (spectrumMatch = this.getSpectrumMatch(peptideMatch.getSpectrumMatches().get(0), false)) != null;
    }

    public ArrayList<String> getProteinIdentification() {
        return this.proteinIdentification;
    }

    public ArrayList<String> getPeptideIdentification() {
        return this.peptideIdentification;
    }

    public ArrayList<String> getSpectrumIdentification() {
        if (!this.spectrumIdentification.isEmpty()) {
            return this.spectrumIdentification;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String spectrumFile : this.spectrumIdentificationMap.keySet()) {
            result.addAll((Collection<String>)this.spectrumIdentificationMap.get(spectrumFile));
        }
        return result;
    }

    public ArrayList<String> getSpectrumIdentification(String spectrumFile) {
        return this.spectrumIdentificationMap.get(spectrumFile);
    }

    public HashMap<String, ArrayList<String>> getSpectrumIdentificationMap() {
        return this.spectrumIdentificationMap;
    }

    public void addSpectrumMatch(SpectrumMatch newMatch, boolean ascendingScore) throws FileNotFoundException, IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException {
        String spectrumKey = newMatch.getKey();
        String spectrumFile = Spectrum.getSpectrumFile(spectrumKey);
        boolean containsSpectrumKey = this.spectrumIdentificationMap.containsKey(spectrumFile);
        if (containsSpectrumKey && this.spectrumIdentificationMap.get(spectrumFile).contains(spectrumKey)) {
            SpectrumMatch oldMatch = this.getSpectrumMatch(spectrumKey, true);
            if (oldMatch == null) {
                throw new IllegalArgumentException("Spectrum match " + spectrumKey + " not found.");
            }
            for (int searchEngine : newMatch.getAdvocates()) {
                oldMatch.addHit(searchEngine, newMatch.getFirstHit(searchEngine), ascendingScore);
            }
            this.identificationDB.updateSpectrumMatch(oldMatch);
        } else {
            if (!containsSpectrumKey) {
                this.spectrumIdentificationMap.put(spectrumFile, new ArrayList());
            }
            this.spectrumIdentificationMap.get(spectrumFile).add(spectrumKey);
            try {
                this.identificationDB.addSpectrumMatch(newMatch);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Error while writing spectrum match " + spectrumKey + " in the database.");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException("Error while writing spectrum match " + spectrumKey + " in the database.");
            }
        }
    }

    public void buildPeptidesAndProteins(WaitingHandler waitingHandler, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(this.getSpectrumIdentificationSize());
            waitingHandler.setSecondaryProgressCounter(0);
        }
        for (String spectrumFile : this.spectrumIdentificationMap.keySet()) {
            for (String spectrumMatchKey : this.spectrumIdentificationMap.get(spectrumFile)) {
                this.buildPeptidesAndProteins(spectrumMatchKey, matchingType, massTolerance);
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                return;
            }
        }
    }

    public void buildPeptidesAndProteins(String spectrumMatchKey, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        PeptideMatch peptideMatch;
        String peptideKey;
        SpectrumMatch spectrumMatch = this.getSpectrumMatch(spectrumMatchKey);
        if (spectrumMatch == null) {
            throw new IllegalArgumentException("Spectrum match " + spectrumMatchKey + " not found.");
        }
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        if (peptide.getParentProteinsNoRemapping() == null) {
            peptide.getParentProteins(matchingType, massTolerance);
        }
        if (this.peptideIdentification.contains(peptideKey = peptide.getMatchingKey(matchingType, massTolerance))) {
            peptideMatch = this.getPeptideMatch(peptideKey);
            if (peptideMatch == null) {
                throw new IllegalArgumentException("Peptide match " + peptideKey + " not found.");
            }
            peptideMatch.addSpectrumMatch(spectrumMatchKey);
            this.identificationDB.updatePeptideMatch(peptideMatch);
        } else {
            peptideMatch = new PeptideMatch(peptide, spectrumMatchKey, peptideKey);
            this.peptideIdentification.add(peptideKey);
            try {
                this.identificationDB.addPeptideMatch(peptideMatch);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Error while writing peptide match " + peptideKey + " in the database.");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException("Error while writing peptide match " + peptideKey + " in the database.");
            }
        }
        String proteinKey = ProteinMatch.getProteinMatchKey(peptide);
        if (this.proteinIdentification.contains(proteinKey)) {
            ProteinMatch proteinMatch = this.getProteinMatch(proteinKey);
            if (proteinMatch == null) {
                throw new IllegalArgumentException("Protein match " + proteinKey + " not found.");
            }
            if (!proteinMatch.getPeptideMatches().contains(peptideKey)) {
                proteinMatch.addPeptideMatch(peptideKey);
                this.identificationDB.updateProteinMatch(proteinMatch);
            }
        } else {
            ProteinMatch proteinMatch = new ProteinMatch(peptideMatch.getTheoreticPeptide(), peptideKey);
            if (!proteinMatch.getKey().equals(proteinKey)) {
                throw new IllegalArgumentException("Protein inference issue: the protein key " + proteinKey + " does not match the peptide proteins " + proteinMatch.getKey() + "." + " Peptide: " + peptideKey + " found in spectrum " + spectrumMatchKey + " most likely a problem with " + Advocate.getAdvocate(spectrumMatch.getBestPeptideAssumption().getAdvocate()).getName() + ".");
            }
            this.proteinIdentification.add(proteinKey);
            for (String protein : peptide.getParentProteinsNoRemapping()) {
                if (!this.proteinMap.containsKey(protein)) {
                    this.proteinMap.put(protein, new ArrayList());
                }
                if (this.proteinMap.get(protein).contains(proteinKey)) continue;
                this.proteinMap.get(protein).add(proteinKey);
            }
            try {
                this.identificationDB.addProteinMatch(proteinMatch);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Error while writing protein match " + proteinKey + " in the database.");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SQLException("Error while writing protein match " + proteinKey + " in the database.");
            }
        }
    }

    public void addSpectrumMatch(Set<SpectrumMatch> spectrumMatches, boolean ascendingScore) throws FileNotFoundException, IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException {
        for (SpectrumMatch spectrumMatch : spectrumMatches) {
            this.addSpectrumMatch(spectrumMatch, ascendingScore);
        }
    }

    public int getMethodUsed() {
        return this.methodUsed;
    }

    public HashMap<String, ArrayList<String>> getProteinMap() {
        return this.proteinMap;
    }

    public String getFileName(String key) {
        for (String fc : Util.forbiddenCharacters) {
            String[] split = key.split(fc);
            key = "";
            for (String splitPart : split) {
                key = key + splitPart;
            }
        }
        if (key.length() < 100) {
            return key + EXTENTION;
        }
        int index = this.longKeys.indexOf(key);
        if (index == -1) {
            index = this.longKeys.size();
            this.longKeys.add(key);
        }
        return index + EXTENTION;
    }

    public Boolean isDB() {
        if (this.isDB == null) {
            this.isDB = false;
        }
        return this.isDB;
    }

    public void setIsDB(Boolean isDB) {
        this.isDB = isDB;
    }

    public void close() throws SQLException {
        if (this.isDB != null && this.isDB.booleanValue() && this.identificationDB != null) {
            this.identificationDB.close();
        }
    }

    public IdentificationMatch.MatchType getMatchType(String matchKey) {
        if (this.proteinIdentification.contains(matchKey)) {
            return IdentificationMatch.MatchType.Protein;
        }
        if (this.peptideIdentification.contains(matchKey)) {
            return IdentificationMatch.MatchType.Peptide;
        }
        if (this.spectrumIdentification.contains(matchKey)) {
            return IdentificationMatch.MatchType.Spectrum;
        }
        String fileName = Spectrum.getSpectrumFile(matchKey);
        ArrayList<String> spectrumKeys = this.spectrumIdentificationMap.get(fileName);
        if (spectrumKeys != null && spectrumKeys.contains(matchKey)) {
            return IdentificationMatch.MatchType.Spectrum;
        }
        return null;
    }

    public void establishConnection(String dbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.identificationDB = new IdentificationDB(dbFolder, this.reference, deleteOldDatabase, objectsCache);
    }

    public void convert(WaitingHandler waitingHandler, String newDirectory, String newName, ObjectsCache objectsCache, File directory) throws FileNotFoundException, IOException, ClassNotFoundException, SQLException, InterruptedException {
        this.setIsDB(true);
        this.reference = newName;
        this.establishConnection(newDirectory, true, objectsCache);
        File[] files = directory.listFiles();
        int nParameters = 0;
        for (HashMap<String, UrParameter> map : this.urParameters.values()) {
            nParameters += map.size();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(files.length + nParameters);
        }
        for (File file : files) {
            if (file.getName().endsWith(EXTENTION)) {
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(bis);
                IdentificationMatch match = (IdentificationMatch)in.readObject();
                fis.close();
                bis.close();
                in.close();
                file.delete();
                try {
                    this.identificationDB.addMatch(match);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IOException("Error while writing match " + match.getKey() + " in the database.");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException("Error while writing match " + match.getKey() + " in the database.");
                }
            }
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (waitingHandler.isRunCanceled()) break;
        }
        for (String matchKey : this.urParameters.keySet()) {
            IdentificationMatch.MatchType matchType = this.getMatchType(matchKey);
            for (UrParameter urParameter : this.urParameters.get(matchKey).values()) {
                if (matchType == IdentificationMatch.MatchType.Protein) {
                    matchKey = matchKey.replaceAll(" ", "_cus_");
                    this.addProteinMatchParameter(matchKey, urParameter);
                    continue;
                }
                if (matchType == IdentificationMatch.MatchType.Peptide) {
                    this.addPeptideMatchParameter(matchKey, urParameter);
                    continue;
                }
                if (matchType != IdentificationMatch.MatchType.Spectrum) continue;
                this.addSpectrumMatchParameter(matchKey, urParameter);
            }
            if (waitingHandler != null) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            break;
        }
        this.urParameters.clear();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        Util.deleteDir(directory);
        ArrayList<String> oldProteinKeys = new ArrayList<String>(this.proteinIdentification);
        this.proteinIdentification.clear();
        for (String proteinKey : oldProteinKeys) {
            this.proteinIdentification.add(proteinKey.replaceAll(" ", "_cus_"));
        }
        this.updateSpectrumMapping();
    }

    public void updateSpectrumMapping() {
        if (this.spectrumIdentificationMap == null) {
            this.spectrumIdentificationMap = new HashMap();
        }
        for (String psmKey : this.spectrumIdentification) {
            String spectrumFile = Spectrum.getSpectrumFile(psmKey);
            if (!this.spectrumIdentificationMap.containsKey(spectrumFile)) {
                this.spectrumIdentificationMap.put(spectrumFile, new ArrayList());
            }
            this.spectrumIdentificationMap.get(spectrumFile).add(psmKey);
        }
        this.spectrumIdentification.clear();
    }

    public static String getDefaultReference(String experimentReference, String sampleReference, int replicateNumber) {
        return Util.removeForbiddenCharacters(experimentReference + "_" + sampleReference + "_" + replicateNumber + "_id");
    }

    public ArrayList<String> getProteinMatches(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> proteinMatches = new ArrayList<String>();
        if (peptide.getParentProteinsNoRemapping() == null) {
            throw new IllegalArgumentException("Proteins are not mapped for peptide " + peptide.getKey() + ".");
        }
        for (String accession : peptide.getParentProteinsNoRemapping()) {
            ArrayList<String> keys = this.proteinMap.get(accession);
            if (keys == null) continue;
            for (String key : keys) {
                if (proteinMatches.contains(key)) continue;
                proteinMatches.add(key);
            }
        }
        return proteinMatches;
    }

    public boolean isUnique(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        return this.getProteinMatches(peptide).size() == 1;
    }
}

