/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.PepnovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.XtandemParameters;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.ModificationProfile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import no.uib.jsparklines.data.XYDataPoint;

public class SearchParameters
implements Serializable {
    static final long serialVersionUID = -2773993307168773763L;
    private MassAccuracyType precursorAccuracyType = MassAccuracyType.PPM;
    private MassAccuracyType fragmentAccuracyType = MassAccuracyType.DA;
    private Double precursorTolerance = 10.0;
    private Double precursorToleranceDalton = 0.5;
    private Double fragmentIonMZTolerance = 0.5;
    private ModificationProfile utilitiesModificationProfile = new ModificationProfile();
    private Enzyme enzyme;
    private Integer nMissedCleavages = 2;
    private File fastaFile;
    private File parametersFile;
    private HashMap<String, Double> fractionMolecularWeights = new HashMap();
    private HashMap<String, XYDataPoint> fractionMolecularWeightRanges = new HashMap();
    private Integer forwardIon = 1;
    private Integer rewindIon = 4;
    private Charge minChargeSearched = new Charge(1, 2);
    private Charge maxChargeSearched = new Charge(1, 4);
    private static String[] forwardIons = new String[]{"a", "b", "c"};
    private static String[] rewindIons = new String[]{"x", "y", "z"};
    private HashMap<Integer, IdentificationAlgorithmParameter> algorithmParameters;
    private PrecursorAccuracyType currentPrecursorAccuracyType = PrecursorAccuracyType.PPM;
    private Double maxEValue = 100.0;
    private Integer hitListLength = 25;
    private Integer hitListLengthDeNovo = 10;
    private Charge minimalChargeForMultipleChargedFragments = new Charge(1, 3);
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Boolean removePrecursor = false;
    private Boolean scalePrecursor = true;
    private Boolean estimateCharge = true;
    private Boolean correctPrecursorMass = true;
    private Boolean discardLowQualitySpectra = true;
    private String fragmentationModel = "CID_IT_TRYP";
    private Boolean generateQuery = false;
    private Map<String, String> pepNovoPtmMap;

    public ModificationProfile getModificationProfile() {
        return this.utilitiesModificationProfile;
    }

    public void setModificationProfile(ModificationProfile modificationProfile) {
        this.utilitiesModificationProfile = modificationProfile;
    }

    public Double getFragmentIonAccuracy() {
        return this.fragmentIonMZTolerance;
    }

    public void setFragmentIonAccuracy(Double fragmentIonMZTolerance) {
        this.fragmentIonMZTolerance = fragmentIonMZTolerance;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
    }

    public File getParametersFile() {
        return this.parametersFile;
    }

    public void setParametersFile(File parametersFile) {
        this.parametersFile = parametersFile;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public Integer getnMissedCleavages() {
        return this.nMissedCleavages;
    }

    public void setnMissedCleavages(Integer nMissedCleavages) {
        this.nMissedCleavages = nMissedCleavages;
    }

    public Integer getIonSearched1() {
        return this.forwardIon;
    }

    public void setIonSearched1(String ionSearched1) {
        if (ionSearched1.equals("a")) {
            this.forwardIon = 0;
        } else if (ionSearched1.equals("b")) {
            this.forwardIon = 1;
        } else if (ionSearched1.equals("c")) {
            this.forwardIon = 2;
        } else if (ionSearched1.equals("x")) {
            this.forwardIon = 3;
        } else if (ionSearched1.equals("y")) {
            this.forwardIon = 4;
        } else if (ionSearched1.equals("z")) {
            this.forwardIon = 5;
        }
    }

    public Integer getIonSearched2() {
        return this.rewindIon;
    }

    public void setIonSearched2(String ionSearched2) {
        if (ionSearched2.equals("a")) {
            this.rewindIon = 0;
        } else if (ionSearched2.equals("b")) {
            this.rewindIon = 1;
        } else if (ionSearched2.equals("c")) {
            this.rewindIon = 2;
        } else if (ionSearched2.equals("x")) {
            this.rewindIon = 3;
        } else if (ionSearched2.equals("y")) {
            this.rewindIon = 4;
        } else if (ionSearched2.equals("z")) {
            this.rewindIon = 5;
        }
    }

    public static String[] getIons() {
        int i$;
        String[] ions = new String[forwardIons.length + rewindIons.length];
        String[] arr$ = forwardIons;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            String forwardIon1;
            ions[ions.length] = forwardIon1 = arr$[i$];
        }
        arr$ = rewindIons;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            String rewindIon1;
            ions[ions.length] = rewindIon1 = arr$[i$];
        }
        return ions;
    }

    public static String[] getForwardIons() {
        return forwardIons;
    }

    public static String[] getRewindIons() {
        return rewindIons;
    }

    public Double getPrecursorAccuracy() {
        return this.precursorTolerance;
    }

    public void setPrecursorAccuracy(Double precursorTolerance) {
        this.precursorTolerance = precursorTolerance;
    }

    public Double getPrecursorAccuracyDalton() {
        if (this.precursorToleranceDalton == null) {
            this.precursorToleranceDalton = 0.5;
        }
        return this.precursorToleranceDalton;
    }

    public void setPrecursorAccuracyDalton(Double precursorToleranceDalton) {
        this.precursorToleranceDalton = precursorToleranceDalton;
    }

    public MassAccuracyType getPrecursorAccuracyType() {
        if (this.precursorAccuracyType == null) {
            this.precursorAccuracyType = this.currentPrecursorAccuracyType == PrecursorAccuracyType.PPM ? MassAccuracyType.PPM : MassAccuracyType.DA;
        }
        return this.precursorAccuracyType;
    }

    public void setPrecursorAccuracyType(MassAccuracyType precursorAccuracyType) {
        this.precursorAccuracyType = precursorAccuracyType;
    }

    public MassAccuracyType getFragmentAccuracyType() {
        if (this.fragmentAccuracyType == null) {
            this.fragmentAccuracyType = MassAccuracyType.DA;
        }
        return this.fragmentAccuracyType;
    }

    public void setFragmentAccuracyType(MassAccuracyType fragmentAccuracyType) {
        this.fragmentAccuracyType = fragmentAccuracyType;
    }

    public Boolean isPrecursorAccuracyTypePpm() {
        return this.getPrecursorAccuracyType() == MassAccuracyType.PPM;
    }

    public HashMap<String, Double> getFractionMolecularWeights() {
        return this.fractionMolecularWeights;
    }

    public void setFractionMolecularWeights(HashMap<String, Double> fractionMolecularWeights) {
        this.fractionMolecularWeights = fractionMolecularWeights;
    }

    public HashMap<String, XYDataPoint> getFractionMolecularWeightRanges() {
        return this.fractionMolecularWeightRanges;
    }

    public void setFractionMolecularWeightRanges(HashMap<String, XYDataPoint> fractionMolecularWeightRanges) {
        this.fractionMolecularWeightRanges = fractionMolecularWeightRanges;
    }

    public Charge getMaxChargeSearched() {
        return this.maxChargeSearched;
    }

    public void setMaxChargeSearched(Charge maxChargeSearched) {
        this.maxChargeSearched = maxChargeSearched;
    }

    public Charge getMinChargeSearched() {
        return this.minChargeSearched;
    }

    public void setMinChargeSearched(Charge minChargeSearched) {
        this.minChargeSearched = minChargeSearched;
    }

    public Double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(Double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public Integer getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(Integer hitListLength) {
        this.hitListLength = hitListLength;
    }

    public Integer getHitListLengthDeNovo() {
        return this.hitListLengthDeNovo;
    }

    public void setHitListLengthDeNovo(Integer hitListLengthDeNovo) {
        this.hitListLengthDeNovo = hitListLengthDeNovo;
    }

    public Charge getMinimalChargeForMultipleChargedFragments() {
        return this.minimalChargeForMultipleChargedFragments;
    }

    public void setMinimalChargeForMultipleChargedFragments(Charge minimalChargeForMultipleChargedFragments) {
        this.minimalChargeForMultipleChargedFragments = minimalChargeForMultipleChargedFragments;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(Boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public Boolean isRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Boolean isScalePrecursor() {
        return this.scalePrecursor;
    }

    public void setScalePrecursor(Boolean scalePrecursor) {
        this.scalePrecursor = scalePrecursor;
    }

    public HashMap<Integer, IdentificationAlgorithmParameter> getAlgorithmSpecificParameters() {
        return this.algorithmParameters;
    }

    public IdentificationAlgorithmParameter getIdentificationAlgorithmParameter(int algorithmID) {
        if (this.algorithmParameters == null) {
            return null;
        }
        return this.algorithmParameters.get(algorithmID);
    }

    public void setIdentificationAlgorithmParameter(int algorithmID, IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (this.algorithmParameters == null) {
            this.algorithmParameters = new HashMap();
        }
        this.algorithmParameters.put(algorithmID, identificationAlgorithmParameter);
    }

    public Set<Integer> getAlgorithms() {
        if (this.algorithmParameters == null) {
            return new HashSet<Integer>();
        }
        return this.algorithmParameters.keySet();
    }

    public static SearchParameters getIdentificationParameters(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        SearchParameters result = (SearchParameters)SerializationUtils.readObject(file);
        ModificationProfile modificationProfile = result.getModificationProfile();
        if (!modificationProfile.hasOMSSAIndexes()) {
            PTMFactory.getInstance().setSearchedOMSSAIndexes(modificationProfile);
        }
        if (result.getAlgorithmSpecificParameters() == null) {
            OmssaParameters omssaParameters = new OmssaParameters();
            omssaParameters.setEstimateCharge(result.isEstimateCharge());
            omssaParameters.setHitListLength(result.getHitListLength());
            omssaParameters.setMaxEValue(result.getMaxEValue());
            omssaParameters.setMaxPeptideLength(result.getMaxPeptideLength());
            omssaParameters.setMinPeptideLength(result.getMinPeptideLength());
            omssaParameters.setMinimalChargeForMultipleChargedFragments(result.getMinimalChargeForMultipleChargedFragments());
            omssaParameters.setRemovePrecursor(result.isRemovePrecursor());
            omssaParameters.setScalePrecursor(result.isScalePrecursor());
            result.setIdentificationAlgorithmParameter(omssaParameters.getAlgorithm().getIndex(), omssaParameters);
            XtandemParameters xtandemParameters = new XtandemParameters();
            xtandemParameters.setMaxEValue(result.getMaxEValue());
            result.setIdentificationAlgorithmParameter(xtandemParameters.getAlgorithm().getIndex(), xtandemParameters);
            PepnovoParameters pepnovoParameters = new PepnovoParameters();
            pepnovoParameters.setDiscardLowQualitySpectra(result.getDiscardLowQualitySpectra());
            pepnovoParameters.setEstimateCharge(result.isEstimateCharge());
            pepnovoParameters.setFragmentationModel(result.getFragmentationModel());
            pepnovoParameters.setGenerateQuery(result.generateQuery());
            pepnovoParameters.setHitListLength(result.getHitListLengthDeNovo());
            pepnovoParameters.setPepNovoPtmMap(result.getPepNovoPtmMap());
            result.setIdentificationAlgorithmParameter(pepnovoParameters.getAlgorithm().getIndex(), pepnovoParameters);
        }
        return result;
    }

    public static void saveIdentificationParameters(SearchParameters identificationParameters, File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        SerializationUtils.writeObject(identificationParameters, file);
    }

    public void saveIdentificationParametersAsTextFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(this.toString());
        bw.close();
        fw.close();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean html) {
        boolean first;
        ArrayList<String> fixedPtms;
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# General Identification Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("DATABASE_FILE=");
        if (this.fastaFile != null) {
            output.append(this.fastaFile.getAbsolutePath());
        }
        output.append(newLine);
        output.append("ENZYME=");
        if (this.enzyme != null) {
            output.append(this.enzyme.getName());
        }
        output.append(newLine);
        output.append("FIXED_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getFixedModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("VARIABLE_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getVariableModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("REFINEMENT_FIXED_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getRefinementFixedModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("REFINEMENT_VARIABLE_MODIFICATIONS=");
        if (this.utilitiesModificationProfile != null) {
            fixedPtms = this.utilitiesModificationProfile.getRefinementVariableModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("MAX_MISSED_CLEAVAGES=");
        output.append(this.nMissedCleavages);
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE=");
        output.append(this.precursorTolerance);
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE_UNIT=");
        if (this.getPrecursorAccuracyType() == MassAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(newLine);
        output.append("FRAGMENT_MASS_TOLERANCE=");
        output.append(this.fragmentIonMZTolerance);
        output.append(newLine);
        output.append("FRAGMENT_ION_TYPE_1=");
        if (this.forwardIon == 0) {
            output.append("a");
        } else if (this.forwardIon == 1) {
            output.append("b");
        } else if (this.forwardIon == 2) {
            output.append("c");
        } else if (this.forwardIon == 3) {
            output.append("x");
        } else if (this.forwardIon == 4) {
            output.append("y");
        } else if (this.forwardIon == 5) {
            output.append("z");
        }
        output.append(newLine);
        output.append("FRAGMENT_ION_TYPE_2=");
        if (this.rewindIon == 0) {
            output.append("a");
        } else if (this.rewindIon == 1) {
            output.append("b");
        } else if (this.rewindIon == 2) {
            output.append("c");
        } else if (this.rewindIon == 3) {
            output.append("x");
        } else if (this.rewindIon == 4) {
            output.append("y");
        } else if (this.rewindIon == 5) {
            output.append("z");
        }
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_LOWER_BOUND=");
        output.append(this.minChargeSearched);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_UPPER_BOUND=");
        output.append(this.maxChargeSearched);
        output.append(newLine);
        for (int index : this.algorithmParameters.keySet()) {
            output.append(newLine);
            output.append(newLine);
            output.append(this.algorithmParameters.get(index).toString(html));
        }
        return output.toString();
    }

    public boolean equals(SearchParameters otherSearchParameters) {
        if (otherSearchParameters == null) {
            return false;
        }
        if (this.getPrecursorAccuracyType() != otherSearchParameters.getPrecursorAccuracyType()) {
            return false;
        }
        if (this.getPrecursorAccuracy().doubleValue() != otherSearchParameters.getPrecursorAccuracy().doubleValue()) {
            return false;
        }
        if (this.getFragmentIonAccuracy().doubleValue() != otherSearchParameters.getFragmentIonAccuracy().doubleValue()) {
            return false;
        }
        if (this.getnMissedCleavages().intValue() != otherSearchParameters.getnMissedCleavages().intValue()) {
            return false;
        }
        if (this.getFastaFile() == null && otherSearchParameters.getFastaFile() != null || this.getFastaFile() != null && otherSearchParameters.getFastaFile() == null) {
            return false;
        }
        if (this.getFastaFile() != null && otherSearchParameters.getFastaFile() != null && !this.getFastaFile().getAbsolutePath().equalsIgnoreCase(otherSearchParameters.getFastaFile().getAbsolutePath())) {
            return false;
        }
        if (this.getIonSearched1().intValue() != otherSearchParameters.getIonSearched1().intValue()) {
            return false;
        }
        if (this.getIonSearched2().intValue() != otherSearchParameters.getIonSearched2().intValue()) {
            return false;
        }
        if (!this.getMinChargeSearched().equals(otherSearchParameters.getMinChargeSearched())) {
            return false;
        }
        if (!this.getMaxChargeSearched().equals(otherSearchParameters.getMaxChargeSearched())) {
            return false;
        }
        if (this.getEnzyme() != null && otherSearchParameters.getEnzyme() != null && !this.getEnzyme().equals(otherSearchParameters.getEnzyme())) {
            return false;
        }
        if (this.getEnzyme() != null && otherSearchParameters.getEnzyme() == null || this.getEnzyme() == null && otherSearchParameters.getEnzyme() != null) {
            return false;
        }
        if (this.getParametersFile() != null && otherSearchParameters.getParametersFile() != null && !this.getParametersFile().getAbsolutePath().equalsIgnoreCase(otherSearchParameters.getParametersFile().getAbsolutePath())) {
            return false;
        }
        if (this.getParametersFile() != null && otherSearchParameters.getParametersFile() == null || this.getParametersFile() == null && otherSearchParameters.getParametersFile() != null) {
            return false;
        }
        if (!this.getModificationProfile().equals(otherSearchParameters.getModificationProfile())) {
            return false;
        }
        if (this.getFractionMolecularWeightRanges() != null && otherSearchParameters.getFractionMolecularWeightRanges() != null && !this.getFractionMolecularWeightRanges().equals(otherSearchParameters.getFractionMolecularWeightRanges())) {
            return false;
        }
        if (this.getFractionMolecularWeightRanges() != null && otherSearchParameters.getFractionMolecularWeightRanges() == null || this.getFractionMolecularWeightRanges() == null && otherSearchParameters.getFractionMolecularWeightRanges() != null) {
            return false;
        }
        if (this.getAlgorithms().size() != otherSearchParameters.getAlgorithms().size()) {
            return false;
        }
        for (int se : this.getAlgorithms()) {
            IdentificationAlgorithmParameter otherParameter = otherSearchParameters.getIdentificationAlgorithmParameter(se);
            if (otherParameter == null) {
                return false;
            }
            IdentificationAlgorithmParameter thisParameter = this.getIdentificationAlgorithmParameter(se);
            if (otherParameter.equals(thisParameter)) continue;
            return false;
        }
        return true;
    }

    public Boolean isCorrectPrecursorMass() {
        if (this.correctPrecursorMass != null) {
            return this.correctPrecursorMass;
        }
        return true;
    }

    public void correctPrecursorMass(Boolean correctPrecursorMass) {
        this.correctPrecursorMass = correctPrecursorMass;
    }

    public Boolean getDiscardLowQualitySpectra() {
        if (this.discardLowQualitySpectra != null) {
            return this.discardLowQualitySpectra;
        }
        return true;
    }

    public void setDiscardLowQualitySpectra(Boolean discardLowQualitySpectra) {
        this.discardLowQualitySpectra = discardLowQualitySpectra;
    }

    public String getFragmentationModel() {
        return this.fragmentationModel;
    }

    public void setFragmentationModel(String fragmentationModel) {
        this.fragmentationModel = fragmentationModel;
    }

    public Boolean generateQuery() {
        return this.generateQuery;
    }

    public void setGenerateQuery(Boolean generateQuery) {
        this.generateQuery = generateQuery;
    }

    public Map<String, String> getPepNovoPtmMap() {
        return this.pepNovoPtmMap;
    }

    public void setPepNovoPtmMap(Map<String, String> pepNovoPtmMap) {
        this.pepNovoPtmMap = pepNovoPtmMap;
    }

    public static enum PrecursorAccuracyType {
        PPM,
        DA;

    }

    public static enum MassAccuracyType {
        PPM,
        DA;

    }
}

