/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.TagAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public abstract class SpectrumAnnotator {
    protected int precursorCharge;
    protected ArrayList<Ion> theoreticalFragmentIons;
    protected IonFactory fragmentFactory = IonFactory.getInstance();
    private String spectrumKey = "";
    protected double intensityLimit = 0.0;
    private ArrayList<Double> mz;
    private HashMap<Double, Peak> peakMap;
    protected HashMap<String, IonMatch> spectrumAnnotation = new HashMap();
    protected ArrayList<String> unmatchedIons = new ArrayList();
    protected double mzTolerance;
    protected boolean isPpm;
    protected static final boolean subtractIsotope = false;
    protected double massShift = 0.0;
    protected double massShiftNTerm = 0.0;
    protected double massShiftCTerm = 0.0;

    public static Vector<DefaultSpectrumAnnotation> getSpectrumAnnotation(ArrayList<IonMatch> ionMatches) {
        Vector<DefaultSpectrumAnnotation> currentAnnotations = new Vector<DefaultSpectrumAnnotation>();
        for (IonMatch ionMatch : ionMatches) {
            currentAnnotations.add(new DefaultSpectrumAnnotation(ionMatch.peak.mz, ionMatch.getAbsoluteError(false), SpectrumPanel.determineFragmentIonColor(ionMatch.ion, true), ionMatch.getPeakAnnotation()));
        }
        return currentAnnotations;
    }

    protected void matchInSpectrum(Ion theoreticIon, int inspectedCharge) {
        Charge charge = new Charge(1, inspectedCharge);
        IonMatch bestMatch = null;
        double fragmentMz = (theoreticIon.getTheoreticMass() + (double)inspectedCharge * ElementaryIon.proton.getTheoreticMass()) / (double)inspectedCharge;
        double deltaMz = this.isPpm ? this.mzTolerance / 1000000.0 * fragmentMz : this.mzTolerance;
        if (!this.mz.isEmpty() && fragmentMz >= this.mz.get(0) - deltaMz && fragmentMz <= this.mz.get(this.mz.size() - 1) + deltaMz) {
            Peak currentPeak;
            int indexMin = 0;
            int indexMax = this.mz.size() - 1;
            IonMatch tempMatch = new IonMatch(new Peak(this.mz.get(indexMax), 0.0), theoreticIon, charge);
            if (Math.abs(tempMatch.getError(this.isPpm, false)) <= this.mzTolerance) {
                currentPeak = this.peakMap.get(this.mz.get(indexMax));
                bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
            }
            if (Math.abs((tempMatch = new IonMatch(new Peak(this.mz.get(indexMin), 0.0), theoreticIon, charge)).getError(this.isPpm, false)) <= this.mzTolerance) {
                currentPeak = this.peakMap.get(this.mz.get(indexMin));
                if (bestMatch == null || bestMatch.peak.intensity < currentPeak.intensity) {
                    bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
                }
            }
            while (indexMax - indexMin > 1) {
                int index = (indexMax - indexMin) / 2 + indexMin;
                double currentMz = this.mz.get(index);
                tempMatch = new IonMatch(new Peak(currentMz, 0.0), theoreticIon, charge);
                if (Math.abs(tempMatch.getError(this.isPpm, false)) <= this.mzTolerance) {
                    Peak currentPeak2 = this.peakMap.get(this.mz.get(index));
                    if (bestMatch == null || bestMatch.peak.intensity < currentPeak2.intensity) {
                        bestMatch = new IonMatch(currentPeak2, theoreticIon, charge);
                    }
                }
                if (currentMz < fragmentMz) {
                    indexMin = index;
                    continue;
                }
                indexMax = index;
            }
        }
        if (bestMatch != null) {
            this.spectrumAnnotation.put(IonMatch.getPeakAnnotation(theoreticIon, charge), bestMatch);
        } else {
            this.unmatchedIons.add(IonMatch.getPeakAnnotation(theoreticIon, charge));
        }
    }

    protected void setSpectrum(MSnSpectrum spectrum, double intensityLimit) {
        if (!this.spectrumKey.equals(spectrum.getSpectrumKey()) || this.intensityLimit != intensityLimit) {
            this.spectrumKey = spectrum.getSpectrumKey();
            this.intensityLimit = intensityLimit;
            if (intensityLimit == 0.0) {
                this.peakMap = spectrum.getPeakMap();
                this.mz = new ArrayList<Double>(this.peakMap.keySet());
            } else {
                this.peakMap = new HashMap();
                this.mz = new ArrayList();
                for (Peak peak : spectrum.getPeakList()) {
                    if (!(peak.intensity > intensityLimit)) continue;
                    this.peakMap.put(peak.mz, peak);
                    this.mz.add(peak.mz);
                }
            }
            Collections.sort(this.mz);
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    protected void setMassTolerance(double mzTolerance, boolean isPpm) {
        if (mzTolerance != this.mzTolerance) {
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
            this.mzTolerance = mzTolerance;
            this.isPpm = isPpm;
        }
    }

    public boolean isAccounted(NeutralLossesMap neutralLosses, NeutralLoss neutralLoss, Ion ion) {
        if (neutralLosses == null || neutralLosses.isEmpty()) {
            return false;
        }
        for (NeutralLoss neutralLossRef : neutralLosses.getAccountedNeutralLosses()) {
            if (!neutralLoss.isSameAs(neutralLossRef)) continue;
            switch (ion.getType()) {
                case PEPTIDE_FRAGMENT_ION: {
                    PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getBStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getYStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
                case TAG_FRAGMENT_ION: {
                    TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getBStart(neutralLossRef) <= tagFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getYStart(neutralLossRef) <= tagFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
            }
            return true;
        }
        return false;
    }

    public boolean lossesValidated(NeutralLossesMap neutralLosses, Ion theoreticIon) {
        for (NeutralLoss neutralLoss : theoreticIon.getNeutralLosses()) {
            if (this.isAccounted(neutralLosses, neutralLoss, theoreticIon)) continue;
            return false;
        }
        return true;
    }

    public boolean chargeValidated(Ion theoreticIon, int charge, int precursorCharge) {
        switch (theoreticIon.getType()) {
            case IMMONIUM_ION: {
                return charge == 1;
            }
            case REPORTER_ION: {
                return charge == 1;
            }
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)theoreticIon;
                return charge <= peptideFragmentIon.getNumber() && (charge < precursorCharge || precursorCharge == 1);
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)theoreticIon;
                return charge <= tagFragmentIon.getNumber() && (charge < precursorCharge || precursorCharge == 1);
            }
            case PRECURSOR_ION: {
                return charge >= precursorCharge;
            }
        }
        throw new UnsupportedOperationException("Ion type " + theoreticIon.getTypeAsString() + " not implemented in the spectrum annotator.");
    }

    public abstract ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum var1, HashMap<Ion.IonType, ArrayList<Integer>> var2, NeutralLossesMap var3, ArrayList<Integer> var4);

    public String getCurrentlyLoadedSpectrumKey() {
        return this.spectrumKey;
    }

    public double getMassShift() {
        return this.massShift;
    }

    public double getMassShiftNTerm() {
        return this.massShiftNTerm;
    }

    public double getMassShiftCTerm() {
        return this.massShiftNTerm;
    }

    public void setMassShift(double aMassShift) {
        this.massShift = aMassShift;
        this.updateMassShifts();
    }

    public void setMassShifts(double aMassShift, double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShift = aMassShift;
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    public void setTerminalMassShifts(double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    private void updateMassShifts() {
        this.spectrumAnnotation.clear();
        this.unmatchedIons.clear();
        if (this.theoreticalFragmentIons != null) {
            for (Ion ion : this.theoreticalFragmentIons) {
                if (ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION) {
                    if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                        ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                    } else if (ion.getSubType() == 3 || ion.getSubType() == 4 || ion.getSubType() == 5) {
                        ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                    }
                }
                if (ion.getType() != Ion.IonType.TAG_FRAGMENT_ION) continue;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5) continue;
                ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
            }
        }
    }

    public static NeutralLossesMap getDefaultLosses(SpectrumIdentificationAssumption spectrumIdentificationAssumption, AminoAcidPattern.MatchingType matchingType, double mzTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
            PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
            return PeptideSpectrumAnnotator.getDefaultLosses(peptideAssumption.getPeptide(), matchingType, mzTolerance);
        }
        if (spectrumIdentificationAssumption instanceof TagAssumption) {
            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
            return TagSpectrumAnnotator.getDefaultLosses(tagAssumption.getTag(), matchingType, mzTolerance);
        }
        throw new IllegalArgumentException("Default neutral loss map not implemented for SpectrumIdentificationAssumption " + spectrumIdentificationAssumption.getClass() + ".");
    }

    protected ArrayList<IonMatch> matchPeak(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, NeutralLossesMap neutralLosses, Peak peak) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (iontypes.containsKey((Object)Ion.IonType.PRECURSOR_ION)) {
            charges.add(precursorCharge);
            charges.add(precursorCharge + 1);
        }
        for (Ion peptideIon : this.theoreticalFragmentIons) {
            if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType())) continue;
            for (int charge : charges) {
                IonMatch ionMatch;
                if (!this.chargeValidated(peptideIon, charge, precursorCharge) || !this.lossesValidated(neutralLosses, peptideIon) || !(Math.abs((ionMatch = new IonMatch(peak, peptideIon, new Charge(1, charge))).getError(this.isPpm, false)) <= this.mzTolerance)) continue;
                result.add(ionMatch);
            }
        }
        return result;
    }

    protected HashMap<Integer, ArrayList<Ion>> getExpectedIons(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge) {
        HashMap<Integer, ArrayList<Ion>> result = new HashMap<Integer, ArrayList<Ion>>();
        for (Ion peptideIon : this.theoreticalFragmentIons) {
            if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType()) || !this.lossesValidated(neutralLosses, peptideIon)) continue;
            for (int charge : charges) {
                if (!this.chargeValidated(peptideIon, charge, precursorCharge)) continue;
                if (!result.containsKey(charge)) {
                    result.put(charge, new ArrayList());
                }
                result.get(charge).add(peptideIon);
            }
        }
        return result;
    }

    public static ArrayList<IonMatch> matchReporterIon(Ion theoreticIon, Spectrum spectrum, double massTolerance) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        double targetMass = theoreticIon.getTheoreticMass();
        for (double mz : spectrum.getOrderedMzValues()) {
            if (Math.abs(mz - targetMass) <= massTolerance) {
                result.add(new IonMatch(spectrum.getPeakMap().get(mz), theoreticIon, new Charge(1, 1)));
            }
            if (mz > targetMass + massTolerance) break;
        }
        return result;
    }
}

