/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.massspectrometry.Charge;
import java.util.ArrayList;

public class OmssaParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -6704164074092668637L;
    private Double maxEValue = 100.0;
    private Integer hitListLength = 0;
    private Charge minimalChargeForMultipleChargedFragments = new Charge(1, 3);
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Boolean removePrecursor = false;
    private Boolean scalePrecursor = true;
    private Boolean estimateCharge = true;
    private String selectedOutput = "OMX";
    private static String[] omssaOutputTypes = new String[]{"OMX", "CSV"};
    private Boolean memoryMappedSequenceLibraries = true;
    private Integer numberOfItotopicPeaks = 0;
    private Double neutronThreshold = 1446.94;
    private Double lowIntensityCutOff = 0.0;
    private Double highIntensityCutOff = 0.2;
    private Double intensityCutOffIncrement = 5.0E-4;
    private Integer singleChargeWindow = 27;
    private Integer doubleChargeWindow = 14;
    private Integer nPeaksInSingleChargeWindow = 2;
    private Integer nPeaksInDoubleChargeWindow = 2;
    private Integer maxHitsPerSpectrumPerCharge = 30;
    private Integer nAnnotatedMostIntensePeaks = 6;
    private Integer minAnnotatedPeaks = 2;
    private Integer minPeaks = 4;
    private Boolean cleaveNtermMethionine = true;
    private Integer maxMzLadders = 128;
    private Integer maxFragmentCharge = 2;
    private Double fractionOfPeaksForChargeEstimation = 0.95;
    private Boolean determineChargePlusOneAlgorithmically = true;
    private Boolean searchPositiveIons = true;
    private Integer minPrecPerSpectrum = 1;
    private Boolean searchForwardFragmentFirst = false;
    private Boolean searchRewindFragments = true;
    private Integer maxFragmentPerSeries = 100;
    private Boolean useCorrelationCorrectionScore = true;
    private Double consecutiveIonProbability = 0.5;
    private Double iterativeSequenceEvalue = 0.0;
    private Double iterativeReplaceEvalue = 0.0;
    private Double iterativeSpectrumEvalue = 0.01;
    private ArrayList<Integer> noProlineRuleSeries = new ArrayList();

    public Double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(Double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public Integer getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(Integer hitListLength) {
        this.hitListLength = hitListLength;
    }

    public Charge getMinimalChargeForMultipleChargedFragments() {
        return this.minimalChargeForMultipleChargedFragments;
    }

    public void setMinimalChargeForMultipleChargedFragments(Charge minimalChargeForMultipleChargedFragments) {
        this.minimalChargeForMultipleChargedFragments = minimalChargeForMultipleChargedFragments;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(Boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public Boolean isRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Boolean isScalePrecursor() {
        return this.scalePrecursor;
    }

    public void setScalePrecursor(Boolean scalePrecursor) {
        this.scalePrecursor = scalePrecursor;
    }

    public String getSelectedOutput() {
        return this.selectedOutput;
    }

    public void setSelectedOutput(String selectedOutput) {
        this.selectedOutput = selectedOutput;
    }

    public static String[] getOmssaOutputTypes() {
        return omssaOutputTypes;
    }

    public Boolean isMemoryMappedSequenceLibraries() {
        return this.memoryMappedSequenceLibraries;
    }

    public void setMemoryMappedSequenceLibraries(Boolean memoryMappedSequenceLibraries) {
        this.memoryMappedSequenceLibraries = memoryMappedSequenceLibraries;
    }

    public Integer getNumberOfItotopicPeaks() {
        return this.numberOfItotopicPeaks;
    }

    public void setNumberOfItotopicPeaks(Integer numberOfItotopicPeaks) {
        this.numberOfItotopicPeaks = numberOfItotopicPeaks;
    }

    public Double getNeutronThreshold() {
        return this.neutronThreshold;
    }

    public void setNeutronThreshold(Double neutronThreshold) {
        this.neutronThreshold = neutronThreshold;
    }

    public Double getLowIntensityCutOff() {
        return this.lowIntensityCutOff;
    }

    public void setLowIntensityCutOff(Double lowIntensityCutOff) {
        this.lowIntensityCutOff = lowIntensityCutOff;
    }

    public Double getHighIntensityCutOff() {
        return this.highIntensityCutOff;
    }

    public void setHighIntensityCutOff(Double highIntensityCutOff) {
        this.highIntensityCutOff = highIntensityCutOff;
    }

    public Double getIntensityCutOffIncrement() {
        return this.intensityCutOffIncrement;
    }

    public void setIntensityCutOffIncrement(Double intensityCutOffIncrement) {
        this.intensityCutOffIncrement = intensityCutOffIncrement;
    }

    public Integer getSingleChargeWindow() {
        return this.singleChargeWindow;
    }

    public void setSingleChargeWindow(Integer singleChargeWindow) {
        this.singleChargeWindow = singleChargeWindow;
    }

    public Integer getDoubleChargeWindow() {
        return this.doubleChargeWindow;
    }

    public void setDoubleChargeWindow(Integer doubleChargeWindow) {
        this.doubleChargeWindow = doubleChargeWindow;
    }

    public Integer getnPeaksInSingleChargeWindow() {
        return this.nPeaksInSingleChargeWindow;
    }

    public void setnPeaksInSingleChargeWindow(Integer nPeaksInSingleChargeWindow) {
        this.nPeaksInSingleChargeWindow = nPeaksInSingleChargeWindow;
    }

    public Integer getnPeaksInDoubleChargeWindow() {
        return this.nPeaksInDoubleChargeWindow;
    }

    public void setnPeaksInDoubleChargeWindow(Integer nPeaksInDoubleChargeWindow) {
        this.nPeaksInDoubleChargeWindow = nPeaksInDoubleChargeWindow;
    }

    public Integer getMaxHitsPerSpectrumPerCharge() {
        return this.maxHitsPerSpectrumPerCharge;
    }

    public void setMaxHitsPerSpectrumPerCharge(Integer maxHitsPerSpectrumPerCharge) {
        this.maxHitsPerSpectrumPerCharge = maxHitsPerSpectrumPerCharge;
    }

    public Integer getnAnnotatedMostIntensePeaks() {
        return this.nAnnotatedMostIntensePeaks;
    }

    public void setnAnnotatedMostIntensePeaks(Integer nAnnotatedMostIntensePeaks) {
        this.nAnnotatedMostIntensePeaks = nAnnotatedMostIntensePeaks;
    }

    public Integer getMinAnnotatedPeaks() {
        return this.minAnnotatedPeaks;
    }

    public void setMinAnnotatedPeaks(Integer minAnnotatedPeaks) {
        this.minAnnotatedPeaks = minAnnotatedPeaks;
    }

    public Integer getMinPeaks() {
        return this.minPeaks;
    }

    public void setMinPeaks(Integer minPeaks) {
        this.minPeaks = minPeaks;
    }

    public Boolean isCleaveNterMethionine() {
        return this.cleaveNtermMethionine;
    }

    public void setCleaveNterMethionine(Boolean cleaveNterMethionine) {
        this.cleaveNtermMethionine = cleaveNterMethionine;
    }

    public Integer getMaxMzLadders() {
        return this.maxMzLadders;
    }

    public void setMaxMzLadders(Integer maxMzLadders) {
        this.maxMzLadders = maxMzLadders;
    }

    public Integer getMaxFragmentCharge() {
        return this.maxFragmentCharge;
    }

    public void setMaxFragmentCharge(Integer maxFragmentCharge) {
        this.maxFragmentCharge = maxFragmentCharge;
    }

    public Double getFractionOfPeaksForChargeEstimation() {
        return this.fractionOfPeaksForChargeEstimation;
    }

    public void setFractionOfPeaksForChargeEstimation(Double fractionOfPeaksForChargeEstimation) {
        this.fractionOfPeaksForChargeEstimation = fractionOfPeaksForChargeEstimation;
    }

    public Boolean isDetermineChargePlusOneAlgorithmically() {
        return this.determineChargePlusOneAlgorithmically;
    }

    public void setDetermineChargePlusOneAlgorithmically(Boolean determineChargePlusOneAlgorithmically) {
        this.determineChargePlusOneAlgorithmically = determineChargePlusOneAlgorithmically;
    }

    public Boolean isSearchPositiveIons() {
        return this.searchPositiveIons;
    }

    public void setSearchPositiveIons(Boolean searchPositiveIons) {
        this.searchPositiveIons = searchPositiveIons;
    }

    public Integer getMinPrecPerSpectrum() {
        return this.minPrecPerSpectrum;
    }

    public void setMinPrecPerSpectrum(Integer minPrecPerSpectrum) {
        this.minPrecPerSpectrum = minPrecPerSpectrum;
    }

    public Boolean isSearchForwardFragmentFirst() {
        return this.searchForwardFragmentFirst;
    }

    public void setSearchForwardFragmentFirst(Boolean searchForwardFragmentFirst) {
        this.searchForwardFragmentFirst = searchForwardFragmentFirst;
    }

    public Boolean isSearchRewindFragments() {
        return this.searchRewindFragments;
    }

    public void setSearchRewindFragments(Boolean searchRewindFragments) {
        this.searchRewindFragments = searchRewindFragments;
    }

    public Integer getMaxFragmentPerSeries() {
        return this.maxFragmentPerSeries;
    }

    public void setMaxFragmentPerSeries(Integer maxFragmentPerSeries) {
        this.maxFragmentPerSeries = maxFragmentPerSeries;
    }

    public Boolean isUseCorrelationCorrectionScore() {
        return this.useCorrelationCorrectionScore;
    }

    public void setUseCorrelationCorrectionScore(Boolean useCorrelationCorrectionScore) {
        this.useCorrelationCorrectionScore = useCorrelationCorrectionScore;
    }

    public Double getConsecutiveIonProbability() {
        return this.consecutiveIonProbability;
    }

    public void setConsecutiveIonProbability(Double consecutiveIonProbability) {
        this.consecutiveIonProbability = consecutiveIonProbability;
    }

    public Double getIterativeSequenceEvalue() {
        return this.iterativeSequenceEvalue;
    }

    public void setIterativeSequenceEvalue(Double iterativeSequenceEvalue) {
        this.iterativeSequenceEvalue = iterativeSequenceEvalue;
    }

    public Double getIterativeReplaceEvalue() {
        return this.iterativeReplaceEvalue;
    }

    public void setIterativeReplaceEvalue(Double iterativeReplaceEvalue) {
        this.iterativeReplaceEvalue = iterativeReplaceEvalue;
    }

    public Double getIterativeSpectrumEvalue() {
        return this.iterativeSpectrumEvalue;
    }

    public void setIterativeSpectrumEvalue(Double iterativeSpectrumEvalue) {
        this.iterativeSpectrumEvalue = iterativeSpectrumEvalue;
    }

    public ArrayList<Integer> getNoProlineRuleSeries() {
        return this.noProlineRuleSeries;
    }

    public void setNoProlineRuleSeries(ArrayList<Integer> noProlineRuleSeries) {
        this.noProlineRuleSeries = noProlineRuleSeries;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.OMSSA;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof OmssaParameters) {
            OmssaParameters omssaParameters = (OmssaParameters)identificationAlgorithmParameter;
            if (!this.getMaxEValue().equals(omssaParameters.getMaxEValue())) {
                return false;
            }
            if (!this.getHitListLength().equals(omssaParameters.getHitListLength())) {
                return false;
            }
            if (!this.getMaxPeptideLength().equals(omssaParameters.getMaxPeptideLength())) {
                return false;
            }
            if (!this.getMinPeptideLength().equals(omssaParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.getMinimalChargeForMultipleChargedFragments().equals(omssaParameters.getMinimalChargeForMultipleChargedFragments())) {
                return false;
            }
            if (!this.isEstimateCharge().equals(omssaParameters.isEstimateCharge())) {
                return false;
            }
            if (!this.isRemovePrecursor().equals(omssaParameters.isRemovePrecursor())) {
                return false;
            }
            if (!this.isScalePrecursor().equals(omssaParameters.isScalePrecursor())) {
                return false;
            }
            if (!this.getSelectedOutput().equals(omssaParameters.getSelectedOutput())) {
                return false;
            }
            if (!this.isMemoryMappedSequenceLibraries().equals(omssaParameters.isMemoryMappedSequenceLibraries())) {
                return false;
            }
            if (!this.getNumberOfItotopicPeaks().equals(omssaParameters.getNumberOfItotopicPeaks())) {
                return false;
            }
            if (!this.getNeutronThreshold().equals(omssaParameters.getNeutronThreshold())) {
                return false;
            }
            if (!this.getLowIntensityCutOff().equals(omssaParameters.getLowIntensityCutOff())) {
                return false;
            }
            if (!this.getHighIntensityCutOff().equals(omssaParameters.getHighIntensityCutOff())) {
                return false;
            }
            if (!this.getIntensityCutOffIncrement().equals(omssaParameters.getIntensityCutOffIncrement())) {
                return false;
            }
            if (!this.getSingleChargeWindow().equals(omssaParameters.getSingleChargeWindow())) {
                return false;
            }
            if (!this.getDoubleChargeWindow().equals(omssaParameters.getDoubleChargeWindow())) {
                return false;
            }
            if (!this.getnPeaksInSingleChargeWindow().equals(omssaParameters.getnPeaksInSingleChargeWindow())) {
                return false;
            }
            if (!this.getnPeaksInDoubleChargeWindow().equals(omssaParameters.getnPeaksInDoubleChargeWindow())) {
                return false;
            }
            if (!this.getMaxHitsPerSpectrumPerCharge().equals(omssaParameters.getMaxHitsPerSpectrumPerCharge())) {
                return false;
            }
            if (!this.getnAnnotatedMostIntensePeaks().equals(omssaParameters.getnAnnotatedMostIntensePeaks())) {
                return false;
            }
            if (!this.getMinAnnotatedPeaks().equals(omssaParameters.getMinAnnotatedPeaks())) {
                return false;
            }
            if (!this.getMinPeaks().equals(omssaParameters.getMinPeaks())) {
                return false;
            }
            if (!this.isCleaveNterMethionine().equals(omssaParameters.isCleaveNterMethionine())) {
                return false;
            }
            if (!this.getMaxMzLadders().equals(omssaParameters.getMaxMzLadders())) {
                return false;
            }
            if (!this.getMaxFragmentCharge().equals(omssaParameters.getMaxFragmentCharge())) {
                return false;
            }
            if (!this.getFractionOfPeaksForChargeEstimation().equals(omssaParameters.getFractionOfPeaksForChargeEstimation())) {
                return false;
            }
            if (!this.isDetermineChargePlusOneAlgorithmically().equals(omssaParameters.isDetermineChargePlusOneAlgorithmically())) {
                return false;
            }
            if (!this.isSearchPositiveIons().equals(omssaParameters.isSearchPositiveIons())) {
                return false;
            }
            if (!this.isSearchRewindFragments().equals(omssaParameters.isSearchRewindFragments())) {
                return false;
            }
            if (!this.getMaxFragmentPerSeries().equals(omssaParameters.getMaxFragmentPerSeries())) {
                return false;
            }
            if (!this.isUseCorrelationCorrectionScore().equals(omssaParameters.isUseCorrelationCorrectionScore())) {
                return false;
            }
            if (!this.getConsecutiveIonProbability().equals(omssaParameters.getConsecutiveIonProbability())) {
                return false;
            }
            if (!this.getIterativeSequenceEvalue().equals(omssaParameters.getIterativeSequenceEvalue())) {
                return false;
            }
            if (!this.getIterativeSpectrumEvalue().equals(omssaParameters.getIterativeSpectrumEvalue())) {
                return false;
            }
            return this.getIterativeReplaceEvalue().equals(omssaParameters.getIterativeReplaceEvalue());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("EVALUE_CUTOFF=");
        output.append(this.maxEValue);
        output.append(newLine);
        output.append("MAXIMUM_HITLIST_LENGTH=");
        output.append(this.hitListLength);
        output.append(newLine);
        output.append("PRECURSOR_ELIMINATION=");
        output.append(this.removePrecursor);
        output.append(newLine);
        output.append("PRECURSOR_SCALING=");
        output.append(this.scalePrecursor);
        output.append(newLine);
        output.append("MINIMAL_PEPTIDE_SIZE=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAXIMAL_PEPTIDE_SIZE=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS=");
        output.append(this.minimalChargeForMultipleChargedFragments);
        output.append(newLine);
        output.append("CHARGE_ESTIMATION=");
        output.append(this.estimateCharge);
        output.append(newLine);
        output.append("OUTPUT_TYPE=");
        output.append(this.selectedOutput);
        output.append(newLine);
        output.append("MEMORY_MAPPED_SEQUENCES=");
        output.append(this.memoryMappedSequenceLibraries);
        output.append(newLine);
        output.append("NUMBER_OF_ISOTOPES=");
        output.append(this.numberOfItotopicPeaks);
        output.append(newLine);
        output.append("MASS_TO_CONSIDER_EXACT_NEUTRON_MASS=");
        output.append(this.neutronThreshold);
        output.append(newLine);
        output.append("LOW_INTENSITY_CUTOFF=");
        output.append(this.lowIntensityCutOff);
        output.append(newLine);
        output.append("HIGH_INTENSITY_CUTOFF=");
        output.append(this.highIntensityCutOff);
        output.append(newLine);
        output.append("INTENSITY_INCREMENT=");
        output.append(this.intensityCutOffIncrement);
        output.append(newLine);
        output.append("SINGLE_CHARGE_WINDOW_WIDTH=");
        output.append(this.singleChargeWindow);
        output.append(newLine);
        output.append("DOUBLE_CHARGE_WINDOW_WIDTH=");
        output.append(this.doubleChargeWindow);
        output.append(newLine);
        output.append("SINGLE_CHARGE_WINDOW_NPEAKS=");
        output.append(this.nPeaksInSingleChargeWindow);
        output.append(newLine);
        output.append("DOUBLE_CHARGE_WINDOW_NPEAKS=");
        output.append(this.nPeaksInDoubleChargeWindow);
        output.append(newLine);
        output.append("MAX_HITS_PER_SPECTRUM_PER_CHARGE=");
        output.append(this.maxHitsPerSpectrumPerCharge);
        output.append(newLine);
        output.append("MIN_ANNOTATED_INTENSE_PEAKS=");
        output.append(this.nAnnotatedMostIntensePeaks);
        output.append(newLine);
        output.append("MIN_ANNOTATED_PEAKS=");
        output.append(this.minAnnotatedPeaks);
        output.append(newLine);
        output.append("MIN_PEAKS=");
        output.append(this.minPeaks);
        output.append(newLine);
        output.append("CLEAVE_TERMINAL_METHIONINE=");
        output.append(this.cleaveNtermMethionine);
        output.append(newLine);
        output.append("MAX_MZ_LADDERS=");
        output.append(this.maxMzLadders);
        output.append(newLine);
        output.append("MAX_FRAGMENT_CHARGE=");
        output.append(this.maxFragmentCharge);
        output.append(newLine);
        output.append("FRACTION_PEAKS_FOR_CHARGE_1_ESTIMATION=");
        output.append(this.fractionOfPeaksForChargeEstimation);
        output.append(newLine);
        output.append("AUTO_DETERMINE_CHARGE_ONE=");
        output.append(this.determineChargePlusOneAlgorithmically);
        output.append(newLine);
        output.append("SEARCH_POSITIVE_IONS=");
        output.append(this.searchPositiveIons);
        output.append(newLine);
        output.append("MIN_PERCURSORS_PER_SPECTRUM=");
        output.append(this.minPrecPerSpectrum);
        output.append(newLine);
        output.append("FORWARD_FRAGMENTS_FIRST=");
        output.append(this.searchForwardFragmentFirst);
        output.append(newLine);
        output.append("REWIND_FRAGMENTS=");
        output.append(this.searchRewindFragments);
        output.append(newLine);
        output.append("FRAGMENTS_PER_SERIES=");
        output.append(this.maxFragmentPerSeries);
        output.append(newLine);
        output.append("CORRELATION_CORRECTION_SCORE=");
        output.append(this.useCorrelationCorrectionScore);
        output.append(newLine);
        output.append("CONSECUTIVE_ION_PROBABILITY=");
        output.append(this.consecutiveIonProbability);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_SEQUENCE_EVALUE=");
        output.append(this.iterativeSequenceEvalue);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_SPECTRUM_EVALUE=");
        output.append(this.iterativeSpectrumEvalue);
        output.append(newLine);
        output.append("ITERATIVE_SEARCH_REPLACEMENT_EVALUE=");
        output.append(this.iterativeReplaceEvalue);
        output.append(newLine);
        return output.toString();
    }
}

