/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.ElementaryElement;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;

public class IonMatch
extends ExperimentObject {
    static final long serialVersionUID = 5753142782728884464L;
    public Peak peak;
    public Ion ion;
    public Charge charge;

    public IonMatch(Peak aPeak, Ion anIon, Charge aCharge) {
        this.peak = aPeak;
        this.ion = anIon;
        this.charge = aCharge;
    }

    public double getError() {
        return this.peak.mz - (this.ion.getTheoreticMass() + (double)this.charge.value * Atom.H.mass) / (double)this.charge.value;
    }

    public double getAbsoluteError(boolean subtractIsotope) {
        double theoreticMass = this.ion.getTheoreticMass();
        if (subtractIsotope) {
            theoreticMass -= (double)this.getIsotopeNumber() * ElementaryElement.neutron.getMass();
        }
        return this.peak.mz - (theoreticMass + (double)this.charge.value * ElementaryIon.proton.getTheoreticMass()) / (double)this.charge.value;
    }

    public double getAbsoluteError() {
        return this.getAbsoluteError(false);
    }

    public double getRelativeError(boolean subtractIsotope) {
        if (this.charge != null && this.charge.value != 0) {
            double theoreticMz = (this.ion.getTheoreticMass() + (double)this.charge.value * ElementaryIon.proton.getTheoreticMass()) / (double)this.charge.value;
            double measuredMz = this.peak.mz;
            if (subtractIsotope) {
                measuredMz -= (double)this.getIsotopeNumber() * ElementaryElement.neutron.getMass() / (double)this.charge.value;
            }
            return (measuredMz - theoreticMz) / theoreticMz * 1000000.0;
        }
        return Double.MAX_VALUE;
    }

    public double getRelativeError() {
        return this.getRelativeError(false);
    }

    public int getIsotopeNumber() {
        double experimentalMass = this.peak.mz * (double)this.charge.value - (double)this.charge.value * ElementaryIon.proton.getTheoreticMass();
        double result = (experimentalMass - this.ion.getTheoreticMass()) / ElementaryElement.neutron.getMass();
        return (int)Math.round(result);
    }

    public double getError(boolean isPpm, boolean subtractIsotope) {
        if (isPpm) {
            return this.getRelativeError(subtractIsotope);
        }
        return this.getAbsoluteError(subtractIsotope);
    }

    public String getPeakAnnotation() {
        return IonMatch.getPeakAnnotation(false, this.ion, this.charge);
    }

    public static String getPeakAnnotation(Ion ion, Charge charge) {
        return IonMatch.getPeakAnnotation(false, ion, charge);
    }

    public static String getPeakAnnotation(boolean html, Ion ion, Charge charge) {
        String result = "";
        switch (ion.getType()) {
            case PEPTIDE_FRAGMENT_ION: {
                if (html) {
                    result = result + "<html>";
                }
                result = result + ion.getSubTypeAsString();
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                result = html ? result + "<sub>" + fragmentIon.getNumber() + "</sub>" : result + fragmentIon.getNumber();
                result = result + charge.getChargeAsFormattedString();
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        result = Character.isDigit(neutralLoss.charAt(i)) ? result + "<sub>" + neutralLoss.charAt(i) + "</sub>" : result + neutralLoss.charAt(i);
                    }
                } else {
                    result = result + ion.getNeutralLossesAsString();
                }
                if (html) {
                    result = result + "</html>";
                }
                return result;
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                if (html) {
                    result = result + "<html>";
                }
                result = result + ion.getSubTypeAsString();
                if (tagFragmentIon.getSubNumber() > 0) {
                    result = html ? result + "<sub>" + tagFragmentIon.getSubNumber() + "</sub>" : result + tagFragmentIon.getSubNumber();
                } else if (tagFragmentIon.getMassGap() > 0.0 && tagFragmentIon.getSubNumber() == 0) {
                    result = html ? result + "<sub>(" + tagFragmentIon.getMassGap() + ")</sub>" : result + "(" + tagFragmentIon.getMassGap() + ")";
                }
                result = result + charge.getChargeAsFormattedString();
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        result = Character.isDigit(neutralLoss.charAt(i)) ? result + "<sub>" + neutralLoss.charAt(i) + "</sub>" : result + neutralLoss.charAt(i);
                    }
                } else {
                    result = result + ion.getNeutralLossesAsString();
                }
                if (html) {
                    result = result + "</html>";
                }
                return result;
            }
            case PRECURSOR_ION: {
                if (html) {
                    result = result + "<html>";
                }
                result = result + ion.getSubTypeAsString() + "-";
                result = result + charge.getChargeAsFormattedString();
                String neutralLoss = ion.getNeutralLossesAsString();
                if (html) {
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        result = Character.isDigit(neutralLoss.charAt(i)) ? result + "<sub>" + neutralLoss.charAt(i) + "</sub>" : result + neutralLoss.charAt(i);
                    }
                } else {
                    result = result + neutralLoss;
                }
                if (html) {
                    result = result + "</html>";
                }
                return result;
            }
        }
        if (html) {
            result = result + "<html>";
        }
        result = result + ion.getName();
        if (html) {
            result = result + "</html>";
        }
        return result;
    }

    public String getPeakAnnotation(boolean html) {
        return IonMatch.getPeakAnnotation(html, this.ion, this.charge);
    }

    public CvTerm getMZPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000188", "product ion m/z", this.peak.mz + "");
    }

    public CvTerm getIntensityPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000189", "product ion intensity", this.peak.intensity + "");
    }

    public CvTerm getIonMassErrorPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000190", "product ion mass error", this.getAbsoluteError(true) + "");
    }

    public CvTerm getChargePrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000204", "product ion charge", this.charge.value + "");
    }
}

