/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.Util;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.db.ObjectsDB;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.protein_inference.proteintree.Node;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ProteinTreeComponentsFactory {
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private static ProteinTreeComponentsFactory instance = null;
    public static final String defaultDbFolderPath = System.getProperty("user.home") + "/.compomics/proteins/";
    private boolean debug = false;
    private ObjectsDB objectsDB;
    private ObjectsCache objectsCache = new ObjectsCache();
    public static final String folderSeparator = "_cus_";
    public static final String dbName = "proteinTree";
    private static final String nodeTable = "nodes";
    private static final String lengthTable = "lengths";
    private static final String parametersTable = "parameters";
    private HashSet<String> tagsInTree = null;

    private ProteinTreeComponentsFactory() throws IOException {
        this.objectsCache.setAutomatedMemoryManagement(false);
        this.objectsCache.setCacheSize(1000);
        this.objectsCache.setBatchSize(100);
    }

    public static ProteinTreeComponentsFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new ProteinTreeComponentsFactory();
        }
        return instance;
    }

    public boolean initiate() throws SQLException, IOException {
        File dbFolder = this.getDbFolder();
        boolean exists = true;
        if (!dbFolder.exists()) {
            exists = false;
            if (!dbFolder.mkdir()) {
                throw new IOException("Impossible to create database folder " + dbFolder.getAbsolutePath() + ".");
            }
        }
        this.objectsDB = new ObjectsDB(dbFolder.getAbsolutePath(), dbName, false, this.objectsCache);
        if (!exists) {
            this.objectsDB.addTable(nodeTable);
            this.objectsDB.addTable(lengthTable);
            this.objectsDB.addTable(parametersTable);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws IOException {
        try {
            this.setCorrupted(true);
        }
        finally {
            try {
                this.close();
            }
            finally {
                File dbFolder = this.getDbFolder();
                return Util.deleteDir(dbFolder);
            }
        }
    }

    public void close() throws IOException, SQLException {
        if (this.objectsDB != null) {
            this.objectsDB.close();
            this.objectsCache = new ObjectsCache();
        }
    }

    public String getDbFolderName() {
        return this.sequenceFactory.getFileName() + folderSeparator + this.sequenceFactory.getCurrentFastaIndex().getLastModified();
    }

    public File getDbFolder() throws IOException {
        boolean success;
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        File folder = utilitiesUserPreferences.getProteinTreeFolder();
        if (!folder.exists() && !(success = folder.mkdirs())) {
            throw new IOException("Unable to create database folder " + folder + ".");
        }
        return new File(folder, this.getDbFolderName());
    }

    public void saveNode(String tag, Node node) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(nodeTable, tag, node, false);
    }

    public void saveNodes(HashMap<String, Object> nodes) throws SQLException, IOException {
        this.objectsDB.insertObjects(nodeTable, nodes, null, true);
    }

    public Node getNode(String tag) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        if (this.tagsInTree != null && !this.tagsInTree.contains(tag)) {
            return null;
        }
        Node result = (Node)this.objectsDB.retrieveObject(nodeTable, tag, true, false);
        if (this.tagsInTree != null && result == null) {
            throw new IllegalArgumentException(tag + " not found in database.");
        }
        return result;
    }

    public void loadNodes(ArrayList<String> tags) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.objectsDB.loadObjects(nodeTable, tags, null);
    }

    public void saveProteinLengths(HashMap<String, Object> lengths) throws SQLException, IOException {
        this.objectsDB.insertObjects(lengthTable, lengths, null, true);
    }

    public Integer getProteinLength(String accession) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        return (Integer)this.objectsDB.retrieveObject(lengthTable, accession, true);
    }

    public void saveInitialSize(int size) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "initialSize", size, false);
    }

    public Integer getInitialSize() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (Integer)this.objectsDB.retrieveObject(parametersTable, "initialSize", true);
    }

    public void loadProteinLengths() throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        this.objectsDB.loadObjects(lengthTable, null);
    }

    public void loadParameters() throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        this.objectsDB.loadObjects(parametersTable, null);
    }

    public void setImportComplete(boolean completed) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "importComplete", completed, false);
    }

    public boolean importComplete() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Boolean result = (Boolean)this.objectsDB.retrieveObject(parametersTable, "importComplete", true);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setCorrupted(boolean corrupted) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "corrupted", corrupted, false);
    }

    public boolean isCorrupted() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Boolean result = (Boolean)this.objectsDB.retrieveObject(parametersTable, "corrupted", true);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setVersion(String version) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(parametersTable, "version", version, false);
    }

    public String getVersion() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (String)this.objectsDB.retrieveObject(parametersTable, "version", true);
    }

    public void loadTags() throws SQLException {
        this.tagsInTree = this.objectsDB.tableContentAsSet(nodeTable);
    }
}

