/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.BasicMathFunctions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class AScore {
    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        return AScore.getAScore(peptide, ptms, spectrum, iontypes, null, charges, precursorCharge, mzTolerance, false, matchingType);
    }

    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        return AScore.getAScore(peptide, ptms, spectrum, iontypes, neutralLosses, charges, precursorCharge, mzTolerance, true, matchingType);
    }

    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, boolean accountNeutralLosses, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for A-score calculation.");
        }
        int nPTM = 0;
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (!modMatch.isVariable()) continue;
            for (PTM ptm : ptms) {
                if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                ++nPTM;
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for A-score calculation.");
        }
        PTM refPTM = ptms.get(0);
        double ptmMass = refPTM.getMass();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
                if (!(Math.abs(neutralLoss.mass - ptmMass) > mzTolerance)) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, 1, 1);
            }
        }
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (PTM ptm : ptms) {
            for (int potentialSite : peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        if (possibleSites.size() > nPTM) {
            int secondPosition;
            int bestPosition;
            Collections.sort(possibleSites);
            PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
            Peptide noModPeptide = Peptide.getNoModPeptide(peptide, ptms);
            HashMap<Integer, MSnSpectrum> spectrumMap = AScore.getReducedSpectra(spectrum, mzTolerance, 10);
            HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = AScore.getPositionToScoreMap(peptide, noModPeptide, possibleSites, spectrum, spectrumMap, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance, spectrumAnnotator, refPTM);
            HashMap<Double, ArrayList<Integer>> peptideScoreToPostitionMap = AScore.getPeptideScoreToPositionMap(positionToScoreMap);
            ArrayList<Double> scores = new ArrayList<Double>(peptideScoreToPostitionMap.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            ArrayList<Integer> positions = peptideScoreToPostitionMap.get(scores.get(0));
            if (positions.size() == 1) {
                bestPosition = positions.get(0);
                positions = peptideScoreToPostitionMap.get(scores.get(1));
                if (positions.size() > 1) {
                    Collections.shuffle(positions);
                }
                secondPosition = positions.get(0);
            } else {
                if (positions.size() > 2) {
                    Collections.shuffle(positions);
                }
                bestPosition = positions.get(0);
                secondPosition = positions.get(1);
            }
            double maxDiff = 0.0;
            int bestI = 0;
            for (int i = 1; i <= 10; ++i) {
                double diff = positionToScoreMap.get(bestPosition).get(i) - positionToScoreMap.get(secondPosition).get(i);
                if (!(diff >= maxDiff)) continue;
                bestI = i - 1;
                maxDiff = diff;
            }
            int N = 0;
            int posMin = Math.min(bestPosition, secondPosition);
            int posMax = Math.max(bestPosition, secondPosition);
            for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
                for (Ion ion : ions) {
                    int aa;
                    if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                    PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                    if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                        aa = fragmentIon.getNumber();
                        if (aa <= posMin || aa > posMax) continue;
                        ++N;
                        continue;
                    }
                    if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                    ++N;
                }
            }
            double p = ((double)bestI + 1.0) / 100.0;
            Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
            tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMin));
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(bestI), tempPeptide, 0.0, mzTolerance, false);
            int n = 0;
            for (IonMatch match : matches) {
                int aa;
                Ion ion = match.ion;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++n;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++n;
            }
            double p1 = 0.0;
            for (int k = n; k <= N; ++k) {
                p1 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
            }
            tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
            tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMax));
            matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(bestI), tempPeptide, 0.0, mzTolerance, false);
            n = 0;
            for (IonMatch match : matches) {
                int aa;
                Ion ion = match.ion;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++n;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++n;
            }
            double p2 = 0.0;
            for (int k = n; k <= N; ++k) {
                p2 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
            }
            if (p1 == p2) {
                result.put(posMin, 0.0);
                result.put(posMax, 0.0);
            } else if (p1 < p2) {
                ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
                modificationProfile.add(posMin);
                double score1 = -10.0 * Math.log10(p1);
                double score2 = -10.0 * Math.log10(p2);
                double score = score1 - score2;
                result.put(posMin, score);
            } else {
                ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
                modificationProfile.add(posMax);
                double score1 = -10.0 * Math.log10(p1);
                double score2 = -10.0 * Math.log10(p2);
                double score = score2 - score1;
                result.put(posMax, score);
            }
        } else if (possibleSites.size() == nPTM) {
            Iterator<PTM> i$ = possibleSites.iterator();
            while (i$.hasNext()) {
                int pos = (Integer)((Object)i$.next());
                result.put(pos, 100.0);
            }
        } else {
            throw new IllegalArgumentException("Found less potential modification sites than PTMs during A-score calculation. Peptide key: " + peptide.getKey());
        }
        return result;
    }

    public static HashMap<Double, ArrayList<Integer>> getPeptideScoreToPositionMap(HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap) {
        HashMap<Double, ArrayList<Integer>> result = new HashMap<Double, ArrayList<Integer>>();
        for (int pos : positionToScoreMap.keySet()) {
            Double peptideScore = 0.0;
            if (positionToScoreMap.get(pos).containsKey(1)) {
                peptideScore = peptideScore + 0.5 * positionToScoreMap.get(pos).get(1);
            }
            if (positionToScoreMap.get(pos).containsKey(2)) {
                peptideScore = peptideScore + 0.75 * positionToScoreMap.get(pos).get(2);
            }
            if (positionToScoreMap.get(pos).containsKey(3)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(3);
            }
            if (positionToScoreMap.get(pos).containsKey(4)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(4);
            }
            if (positionToScoreMap.get(pos).containsKey(5)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(5);
            }
            if (positionToScoreMap.get(pos).containsKey(6)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(6);
            }
            if (positionToScoreMap.get(pos).containsKey(7)) {
                peptideScore = peptideScore + 0.75 * positionToScoreMap.get(pos).get(7);
            }
            if (positionToScoreMap.get(pos).containsKey(8)) {
                peptideScore = peptideScore + 0.5 * positionToScoreMap.get(pos).get(8);
            }
            if (positionToScoreMap.get(pos).containsKey(9)) {
                peptideScore = peptideScore + 0.25 * positionToScoreMap.get(pos).get(9);
            }
            if (positionToScoreMap.get(pos).containsKey(10)) {
                peptideScore = peptideScore + 0.25 * positionToScoreMap.get(pos).get(10);
            }
            if (!result.containsKey(peptideScore)) {
                result.put(peptideScore, new ArrayList());
            }
            result.get(peptideScore).add(pos);
        }
        return result;
    }

    public static HashMap<Integer, HashMap<Integer, Double>> getPositionToScoreMap(Peptide peptide, Peptide noModPeptide, ArrayList<Integer> possibleSites, MSnSpectrum spectrum, HashMap<Integer, MSnSpectrum> spectrumMap, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap scoringLossesMap, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, PeptideSpectrumAnnotator spectrumAnnotator, PTM refPTM) {
        HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = new HashMap<Integer, HashMap<Integer, Double>>();
        int N = 0;
        for (ArrayList<Ion> fragmentIons : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
            N += fragmentIons.size();
        }
        for (int i = 0; i < spectrumMap.keySet().size(); ++i) {
            double p = ((double)i + 1.0) / 100.0;
            for (int pos : possibleSites) {
                Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
                tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, pos));
                ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(i), tempPeptide, 0.0, mzTolerance, false);
                int n = matches.size();
                double P = 0.0;
                for (int k = n; k <= N; ++k) {
                    P += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
                }
                if (P <= Double.MIN_NORMAL) {
                    P = Double.MIN_NORMAL;
                }
                double score = -10.0 * Math.log10(P);
                if (!positionToScoreMap.containsKey(pos)) {
                    positionToScoreMap.put(pos, new HashMap());
                }
                positionToScoreMap.get(pos).put(i + 1, score);
            }
        }
        return positionToScoreMap;
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance) {
        return AScore.getReducedSpectra(baseSpectrum, mzTolerance, -1);
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance, int depthMax) {
        int i;
        double currentmzMin;
        HashMap<Integer, MSnSpectrum> result = new HashMap<Integer, MSnSpectrum>();
        HashMap<Double, Peak> peakMap = baseSpectrum.getPeakMap();
        ArrayList<Double> mz = new ArrayList<Double>(peakMap.keySet());
        Collections.sort(mz);
        double mzMax = mz.get(mz.size() - 1);
        int cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            int cptTemp = 0;
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                ++cptTemp;
                ++cpt;
            }
            if (depthMax != -1 || cptTemp <= depthMax) continue;
            depthMax = cptTemp;
        }
        for (i = 0; i < depthMax; ++i) {
            result.put(i, new MSnSpectrum(2, baseSpectrum.getPrecursor(), baseSpectrum.getSpectrumTitle() + "_" + i, new HashMap<Double, Peak>(), "a score"));
        }
        cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            ArrayList<Double> intensities = new ArrayList<Double>();
            HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                Peak tempPeak = peakMap.get(mz.get(cpt));
                intensities.add(-tempPeak.intensity);
                tempMap.put(-tempPeak.intensity, tempPeak);
                ++cpt;
            }
            Collections.sort(intensities);
            for (i = 0; i < intensities.size(); ++i) {
                for (int j = i; j < depthMax; ++j) {
                    result.get(j).addPeak((Peak)tempMap.get(intensities.get(i)));
                }
            }
        }
        return result;
    }
}

