/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PhosphoRS {
    public static final int maxDepth = 8;

    public static HashMap<Integer, Double> getSequenceProbabilities(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, boolean accountNeutralLosses, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for PhosphoRS calculation.");
        }
        int nPTM = 0;
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (!modMatch.isVariable()) continue;
            for (PTM ptm : ptms) {
                if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                ++nPTM;
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for A-score calculation.");
        }
        PTM refPTM = ptms.get(0);
        double ptmMass = refPTM.getMass();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
                if (!(Math.abs(neutralLoss.mass - ptmMass) > mzTolerance)) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, 1, 1);
            }
        }
        HashMap<ArrayList<Integer>, Double> profileToScoreMap = new HashMap<ArrayList<Integer>, Double>();
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (PTM ptm : ptms) {
            for (int potentialSite : peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        if (possibleSites.size() > nPTM) {
            Collections.sort(possibleSites);
            ArrayList<ArrayList<Integer>> possibleProfiles = PhosphoRS.getPossibleModificationProfiles(possibleSites, nPTM);
            PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
            Peptide noModPeptide = Peptide.getNoModPeptide(peptide, ptms);
            double p = PhosphoRS.getp(spectrum, mzTolerance);
            HashMap<Double, ArrayList<ArrayList<Integer>>> siteDeterminingIonsMap = PhosphoRS.getSiteDeterminingIons(noModPeptide, possibleProfiles, refPTM.getName(), spectrumAnnotator, iontypes, scoringLossesMap, charges, precursorCharge);
            ArrayList<Double> siteDeterminingIons = new ArrayList<Double>(siteDeterminingIonsMap.keySet());
            Collections.sort(siteDeterminingIons);
            double minMz = spectrum.getMinMz();
            double maxMz = spectrum.getMaxMz();
            HashMap<Double, Peak> reducedSpectrum = new HashMap<Double, Peak>();
            while (minMz < maxMz) {
                int bestI;
                double tempMax = minMz + 100.0;
                MSnSpectrum tempSpectrum = new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_PhosphoRS_minMZ_" + minMz, spectrum.getSubSpectrum(minMz, tempMax), spectrum.getFileName());
                ArrayList<MSnSpectrum> spectra = PhosphoRS.getReducedSpectra(tempSpectrum);
                HashMap<ArrayList<Integer>, ArrayList<Double>> subMapGoofy = new HashMap<ArrayList<Integer>, ArrayList<Double>>();
                for (double ionMz : siteDeterminingIons) {
                    if (!(ionMz > minMz) || !(ionMz <= maxMz)) continue;
                    ArrayList<ArrayList<Integer>> profiles = siteDeterminingIonsMap.get(ionMz);
                    for (ArrayList<Integer> profile : profiles) {
                        ArrayList<Double> mzs = (ArrayList<Double>)subMapGoofy.get(profile);
                        if (mzs == null) {
                            mzs = new ArrayList<Double>();
                            subMapGoofy.put(profile, mzs);
                        }
                        mzs.add(ionMz);
                    }
                }
                if (!subMapGoofy.isEmpty()) {
                    ArrayList deltas = new ArrayList();
                    int nDeltas = 0;
                    for (int i = 0; i < spectra.size(); ++i) {
                        ArrayList<Double> scores = new ArrayList<Double>();
                        ArrayList<Double> currentDeltas = new ArrayList<Double>();
                        ArrayList<ArrayList> scored = new ArrayList<ArrayList>();
                        boolean noIons = false;
                        for (ArrayList<Integer> profile : possibleProfiles) {
                            if (!subMapGoofy.containsKey(profile)) {
                                if (noIons) continue;
                                noIons = true;
                                Peptide tempPeptide = Peptide.getNoModPeptide(peptide, ptms);
                                for (int pos : profile) {
                                    tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, pos));
                                }
                                double score = PhosphoRS.getPhosphoRsScore(tempPeptide, spectra.get(i), p, spectrumAnnotator, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance);
                                scores.add(score);
                                continue;
                            }
                            ArrayList tempSiteDeterminingIons = (ArrayList)subMapGoofy.get(profile);
                            boolean alreadyScored = false;
                            for (ArrayList scoredIons : scored) {
                                if (!Util.sameLists(tempSiteDeterminingIons, scoredIons)) continue;
                                alreadyScored = true;
                                break;
                            }
                            if (alreadyScored) continue;
                            Peptide tempPeptide = Peptide.getNoModPeptide(peptide, ptms);
                            for (int pos : profile) {
                                tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, pos));
                            }
                            double score = PhosphoRS.getPhosphoRsScore(tempPeptide, spectra.get(i), p, spectrumAnnotator, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance);
                            scores.add(score);
                            scored.add(tempSiteDeterminingIons);
                        }
                        Collections.sort(scores, Collections.reverseOrder());
                        for (int j = 0; j < scores.size() - 1; ++j) {
                            currentDeltas.add((Double)scores.get(j) - (Double)scores.get(j + 1));
                        }
                        if (currentDeltas.size() > nDeltas) {
                            nDeltas = currentDeltas.size();
                        }
                        deltas.add(currentDeltas);
                    }
                    bestI = 0;
                    double largestDelta = 0.0;
                    for (int j = 0; j < nDeltas; ++j) {
                        for (int i = 0; i < deltas.size(); ++i) {
                            ArrayList tempDeltas = (ArrayList)deltas.get(i);
                            if (j >= tempDeltas.size() || !((Double)tempDeltas.get(j) > largestDelta)) continue;
                            largestDelta = (Double)tempDeltas.get(j);
                            bestI = i;
                        }
                        if (largestDelta > 0.0) break;
                    }
                    if (largestDelta == 0.0) {
                        bestI = Math.min(8, spectra.size() - 1);
                    }
                    reducedSpectrum.putAll(spectra.get(bestI).getPeakMap());
                } else {
                    double bestScore = 0.0;
                    bestI = 0;
                    for (int i = 0; i < spectra.size(); ++i) {
                        double score = PhosphoRS.getPhosphoRsScore(peptide, spectra.get(i), p, spectrumAnnotator, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance);
                        if (!(score >= bestScore)) continue;
                        bestScore = score;
                        bestI = i;
                    }
                    reducedSpectrum.putAll(spectra.get(bestI).getPeakMap());
                }
                minMz = tempMax;
            }
            MSnSpectrum phosphoRsSpectrum = new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_phosphoRS", reducedSpectrum, spectrum.getFileName());
            HashMap<ArrayList<Integer>, Double> pInvMap = new HashMap<ArrayList<Integer>, Double>(possibleProfiles.size());
            double pInvTotal = 0.0;
            for (ArrayList<Integer> profile : possibleProfiles) {
                Peptide tempPeptide = Peptide.getNoModPeptide(peptide, ptms);
                for (int pos : profile) {
                    tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, pos));
                }
                double score = PhosphoRS.getPhosphoRsScore(tempPeptide, phosphoRsSpectrum, p, spectrumAnnotator, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance);
                double pInv = Math.pow(10.0, score / 10.0);
                pInvMap.put(profile, pInv);
                pInvTotal += pInv;
            }
            for (ArrayList<Integer> profile : possibleProfiles) {
                double phosphoRsProbability = (Double)pInvMap.get(profile) / pInvTotal * 100.0;
                profileToScoreMap.put(profile, phosphoRsProbability);
            }
        } else if (possibleSites.size() == nPTM) {
            profileToScoreMap.put(possibleSites, 100.0);
        } else {
            throw new IllegalArgumentException("Found less potential modification sites than PTMs during A-score calculation. Peptide key: " + peptide.getKey());
        }
        HashMap<Integer, Double> scores = new HashMap<Integer, Double>();
        for (ArrayList profile : profileToScoreMap.keySet()) {
            double score = (Double)profileToScoreMap.get(profile);
            for (Integer site : profile) {
                if (!scores.containsKey(site)) {
                    scores.put(site, score);
                    continue;
                }
                scores.put(site, scores.get(site) + score);
            }
        }
        return scores;
    }

    private static double getPhosphoRsScore(Peptide peptide, MSnSpectrum spectrum, double p, PeptideSpectrumAnnotator spectrumAnnotator, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap scoringLossesMap, ArrayList<Integer> charges, int precursorCharge, double mzTolerance) {
        int N = 0;
        for (ArrayList<Ion> fragmentIons : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
            N += fragmentIons.size();
        }
        ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrum, peptide, 0.0, mzTolerance, false);
        int n = matches.size();
        double P = 0.0;
        for (int k = n; k <= N; ++k) {
            P += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
        }
        if (P <= Double.MIN_NORMAL) {
            P = Double.MIN_NORMAL;
        }
        double score = -10.0 * Math.log10(P);
        return score;
    }

    private static double getp(Spectrum spectrum, double ms2Tolerance) {
        int N = spectrum.getPeakMap().size();
        double w = spectrum.getMaxMz() - spectrum.getMinMz();
        return ms2Tolerance * (double)N / w;
    }

    private static ArrayList<ArrayList<Integer>> getPossibleModificationProfiles(ArrayList<Integer> possibleSites, int nPtms) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (int pos : possibleSites) {
            ArrayList<Integer> profile = new ArrayList<Integer>(nPtms);
            profile.add(pos);
            result.add(profile);
        }
        for (int i = 2; i <= nPtms; ++i) {
            ArrayList<ArrayList<Integer>> tempresult = new ArrayList<ArrayList<Integer>>(result);
            result = new ArrayList();
            for (ArrayList<Integer> tempProfile : tempresult) {
                int lastPos = tempProfile.get(tempProfile.size() - 1);
                for (int pos : possibleSites) {
                    if (pos <= lastPos) continue;
                    ArrayList<Integer> profile = new ArrayList<Integer>(tempProfile);
                    profile.add(pos);
                    result.add(profile);
                }
            }
        }
        return result;
    }

    private static HashMap<Double, ArrayList<ArrayList<Integer>>> getSiteDeterminingIons(Peptide noModPeptide, ArrayList<ArrayList<Integer>> possibleProfiles, String referencePtmName, PeptideSpectrumAnnotator spectrumAnnotator, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap scoringLossesMap, ArrayList<Integer> charges, int precursorCharge) {
        HashMap<Double, ArrayList<ArrayList<Integer>>> siteDeterminingIons = new HashMap<Double, ArrayList<ArrayList<Integer>>>();
        HashMap commonIons = new HashMap();
        for (ArrayList<Integer> modificationProfile : possibleProfiles) {
            Peptide peptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
            for (int pos : modificationProfile) {
                peptide.addModificationMatch(new ModificationMatch(referencePtmName, true, pos));
            }
            ArrayList<Double> mzs = new ArrayList<Double>();
            for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
                for (Ion ion : ions) {
                    for (int charge : charges) {
                        double mz = ion.getTheoreticMz(charge);
                        if (mzs.contains(mz)) continue;
                        mzs.add(mz);
                    }
                }
            }
            Iterator<ArrayList<Ion>> i$ = mzs.iterator();
            while (i$.hasNext()) {
                ArrayList<ArrayList<Integer>> profiles;
                double mz = (Double)((Object)i$.next());
                if (commonIons.isEmpty()) {
                    profiles = new ArrayList<ArrayList<Integer>>();
                    commonIons.put(mz, profiles);
                    profiles.add(modificationProfile);
                    continue;
                }
                if (commonIons.containsKey(mz)) continue;
                profiles = siteDeterminingIons.get(mz);
                if (profiles == null) {
                    profiles = new ArrayList();
                    siteDeterminingIons.put(mz, profiles);
                }
                profiles.add(modificationProfile);
            }
            i$ = new HashSet(commonIons.keySet()).iterator();
            while (i$.hasNext()) {
                double mz = (Double)((Object)i$.next());
                if (!mzs.contains(mz)) {
                    siteDeterminingIons.put(mz, (ArrayList<ArrayList<Integer>>)commonIons.get(mz));
                    commonIons.remove(mz);
                    continue;
                }
                ((ArrayList)commonIons.get(mz)).add(modificationProfile);
            }
        }
        return siteDeterminingIons;
    }

    private static ArrayList<MSnSpectrum> getReducedSpectra(MSnSpectrum spectrum) {
        ArrayList<MSnSpectrum> reducedSpectra = new ArrayList<MSnSpectrum>();
        HashMap<Double, ArrayList<Peak>> intensityToPeakMap = new HashMap<Double, ArrayList<Peak>>(spectrum.getPeakMap().size());
        for (Peak peak : spectrum.getPeakList()) {
            double intensity = peak.intensity;
            ArrayList<Peak> peaks = (ArrayList<Peak>)intensityToPeakMap.get(intensity);
            if (peaks == null) {
                peaks = new ArrayList<Peak>();
                intensityToPeakMap.put(intensity, peaks);
            }
            peaks.add(peak);
        }
        ArrayList intensities = new ArrayList(intensityToPeakMap.keySet());
        Collections.sort(intensities, Collections.reverseOrder());
        for (int depth = 1; depth <= 8; ++depth) {
            HashMap<Double, Peak> mzToPeak = new HashMap<Double, Peak>();
            int nPeaks = 0;
            Iterator i$ = intensities.iterator();
            while (i$.hasNext()) {
                double intensity = (Double)i$.next();
                for (Peak peak : (ArrayList)intensityToPeakMap.get(intensity)) {
                    mzToPeak.put(peak.mz, peak);
                    if (++nPeaks != depth) continue;
                    break;
                }
                if (nPeaks != depth) continue;
                break;
            }
            reducedSpectra.add(new MSnSpectrum(spectrum.getLevel(), spectrum.getPrecursor(), spectrum.getSpectrumTitle() + "_" + depth, mzToPeak, spectrum.getFileName()));
        }
        return reducedSpectra;
    }
}

