/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.scoring;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.BasicMathFunctions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class PsmScores {
    public static double getAScorePeptideScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, boolean accountNeutralLosses) throws IOException, IllegalArgumentException, InterruptedException {
        HashMap<Integer, MSnSpectrum> spectrumMap = PsmScores.getReducedSpectra(spectrum, mzTolerance, 10);
        PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
        int N = 0;
        for (ArrayList<Ion> fragmentIons : spectrumAnnotator.getExpectedIons(iontypes, neutralLosses, charges, precursorCharge, peptide).values()) {
            N += fragmentIons.size();
        }
        HashMap<Integer, Double> depthMap = new HashMap<Integer, Double>();
        for (int i = 0; i < spectrumMap.keySet().size(); ++i) {
            double p = ((double)i + 1.0) / 100.0;
            ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, precursorCharge, spectrumMap.get(i), peptide, 0.0, mzTolerance, false);
            int n = matches.size();
            double P = 0.0;
            for (int k = n; k <= N; ++k) {
                P += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
            }
            if (P <= Double.MIN_NORMAL) {
                P = Double.MIN_NORMAL;
            }
            double score = -10.0 * Math.log10(P);
            depthMap.put(i + 1, score);
        }
        Double peptideScore = 0.0;
        if (depthMap.containsKey(1)) {
            peptideScore = peptideScore + 0.5 * (Double)depthMap.get(1);
        }
        if (depthMap.containsKey(2)) {
            peptideScore = peptideScore + 0.75 * (Double)depthMap.get(2);
        }
        if (depthMap.containsKey(3)) {
            peptideScore = peptideScore + 1.0 * (Double)depthMap.get(3);
        }
        if (depthMap.containsKey(4)) {
            peptideScore = peptideScore + 1.0 * (Double)depthMap.get(4);
        }
        if (depthMap.containsKey(5)) {
            peptideScore = peptideScore + 1.0 * (Double)depthMap.get(5);
        }
        if (depthMap.containsKey(6)) {
            peptideScore = peptideScore + 1.0 * (Double)depthMap.get(6);
        }
        if (depthMap.containsKey(7)) {
            peptideScore = peptideScore + 0.75 * (Double)depthMap.get(7);
        }
        if (depthMap.containsKey(8)) {
            peptideScore = peptideScore + 0.5 * (Double)depthMap.get(8);
        }
        if (depthMap.containsKey(9)) {
            peptideScore = peptideScore + 0.25 * (Double)depthMap.get(9);
        }
        if (depthMap.containsKey(10)) {
            peptideScore = peptideScore + 0.25 * (Double)depthMap.get(10);
        }
        return peptideScore;
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance) {
        return PsmScores.getReducedSpectra(baseSpectrum, mzTolerance, -1);
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance, int depthMax) {
        int i;
        double currentmzMin;
        HashMap<Integer, MSnSpectrum> result = new HashMap<Integer, MSnSpectrum>();
        HashMap<Double, Peak> peakMap = baseSpectrum.getPeakMap();
        ArrayList<Double> mz = new ArrayList<Double>(peakMap.keySet());
        Collections.sort(mz);
        double mzMax = mz.get(mz.size() - 1);
        int cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            int cptTemp = 0;
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                ++cptTemp;
                ++cpt;
            }
            if (depthMax != -1 || cptTemp <= depthMax) continue;
            depthMax = cptTemp;
        }
        for (i = 0; i < depthMax; ++i) {
            result.put(i, new MSnSpectrum(2, baseSpectrum.getPrecursor(), baseSpectrum.getSpectrumTitle() + "_" + i, new HashMap<Double, Peak>(), "a score"));
        }
        cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            ArrayList<Double> intensities = new ArrayList<Double>();
            HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                Peak tempPeak = peakMap.get(mz.get(cpt));
                intensities.add(-tempPeak.intensity);
                tempMap.put(-tempPeak.intensity, tempPeak);
                ++cpt;
            }
            Collections.sort(intensities);
            for (i = 0; i < intensities.size(); ++i) {
                for (int j = i; j < depthMax; ++j) {
                    result.get(j).addPeak((Peak)tempMap.get(intensities.get(i)));
                }
            }
        }
        return result;
    }
}

