/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.search_parameters_cli;

import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.search_parameters_cli.IdentificationParametersInputBean;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public abstract class AbstractIdentificationParametersCli
implements Callable {
    private IdentificationParametersInputBean input;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();

    public void initiate(String[] args) {
        try {
            try {
                this.ptmFactory.importModifications(this.getModificationsFile(), false);
            }
            catch (Exception e) {
                System.out.println("An error occurred while loading the modifications.");
                e.printStackTrace();
            }
            try {
                this.ptmFactory.importModifications(this.getUserModificationsFile(), true);
            }
            catch (Exception e) {
                System.out.println("An error occurred while loading the user modifications.");
                e.printStackTrace();
            }
            try {
                this.enzymeFactory.importEnzymes(this.getEnzymeFile());
            }
            catch (Exception e) {
                System.out.println("An error occurred while loading the enzymes.");
                e.printStackTrace();
            }
            Options lOptions = new Options();
            this.createOptionsCLI(lOptions);
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(lOptions, args);
            if (!IdentificationParametersInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("IdentificationParametersCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(AbstractIdentificationParametersCli.getHeader());
                lPrintWriter.print(this.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else if (!IdentificationParametersInputBean.isValidModifications(line)) {
                this.printModifications();
            } else {
                this.input = new IdentificationParametersInputBean(line);
                this.call();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object call() {
        try {
            if (this.input.isListMods().booleanValue()) {
                this.printModifications();
            } else {
                File outputFile = this.input.getDestinationFile();
                SearchParameters searchParameters = this.input.getSearchParameters();
                SearchParameters.saveIdentificationParameters(searchParameters, outputFile);
                System.out.println(System.getProperty("line.separator") + "Identification Parameters file created: " + outputFile.getAbsolutePath() + System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void printModifications() {
        PTM ptm;
        System.out.println("Available modifications:" + System.getProperty("line.separator"));
        System.out.println("    Default modifications:");
        for (String ptmName : this.ptmFactory.getDefaultModificationsOrdered()) {
            ptm = this.ptmFactory.getPTM(ptmName);
            System.out.println(this.getProteinLine(ptm));
        }
        System.out.println();
        System.out.println("    User modifications:");
        for (String ptmName : this.ptmFactory.getUserModificationsOrdered()) {
            ptm = this.ptmFactory.getPTM(ptmName);
            System.out.println(this.getProteinLine(ptm));
        }
        System.out.println();
    }

    private String getProteinLine(PTM ptm) {
        double ptmMass = ptm.getMass();
        String sign = "";
        if (ptmMass > 0.0) {
            sign = "+";
        }
        String target = "";
        switch (ptm.getType()) {
            case 0: {
                target = ptm.getPattern().toString();
                break;
            }
            case 3: {
                target = "Protein C-terminus";
                break;
            }
            case 4: {
                target = "Protein C-terminus ending with " + ptm.getPattern().toString();
                break;
            }
            case 7: {
                target = "Peptide C-terminus";
                break;
            }
            case 8: {
                target = "Peptide C-terminus ending with " + ptm.getPattern().toString();
                break;
            }
            case 1: {
                target = "Protein N-terminus";
                break;
            }
            case 2: {
                target = "Protein N-terminus starting with " + ptm.getPattern().toString();
                break;
            }
            case 5: {
                target = "Peptide N-terminus";
                break;
            }
            case 6: {
                target = "Peptide N-terminus starting with " + ptm.getPattern().toString();
            }
        }
        return ptm.getName() + " (" + sign + ptm.getMass() + " targeting " + target + " )";
    }

    protected abstract File getModificationsFile();

    protected abstract File getUserModificationsFile();

    protected abstract File getEnzymeFile();

    protected abstract void createOptionsCLI(Options var1);

    protected abstract String getOptionsAsString();

    public static String getHeader() {
        return System.getProperty("line.separator") + "IdentificationParametersCLI creates an identification parameters file." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Use the out option to specify the output file or the mods option to list the available modifications." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see http://searchgui.googlecode.com and http://code.google.com/p/searchgui/wiki/IdentificationParametersCLI." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }
}

