/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotators;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class PeptideSpectrumAnnotator
extends SpectrumAnnotator {
    private Peptide peptide;

    public void setPeptide(Peptide peptide, int precursorCharge) {
        if (this.peptide == null || !this.peptide.getKey().equals(peptide.getKey()) || !this.peptide.sameModificationsAs(peptide) || this.precursorCharge != precursorCharge) {
            this.peptide = peptide;
            this.precursorCharge = precursorCharge;
            this.theoreticalFragmentIons = this.fragmentFactory.getFragmentIons(peptide);
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                for (Ion ion : this.theoreticalFragmentIons) {
                    if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                    if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                        ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                        continue;
                    }
                    if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5) continue;
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    public ArrayList<IonMatch> matchPeak(Peptide peptide, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, NeutralLossesMap neutralLosses, Peak peak) {
        this.setPeptide(peptide, precursorCharge);
        return this.matchPeak(iontypes, charges, precursorCharge, neutralLosses, peak);
    }

    public ArrayList<IonMatch> getSpectrumAnnotation(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, MSnSpectrum spectrum, Peptide peptide, double intensityLimit, double mzTolerance, boolean isPpm) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (spectrum != null) {
            this.setSpectrum(spectrum, intensityLimit);
        }
        this.setPeptide(peptide, precursorCharge);
        this.setMassTolerance(mzTolerance, isPpm);
        ArrayList<Integer> precursorCharges = new ArrayList<Integer>();
        for (int i = 1; i <= precursorCharge; ++i) {
            precursorCharges.add(i);
        }
        if (this.theoreticalFragmentIons != null) {
            for (Ion peptideIon : this.theoreticalFragmentIons) {
                if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType()) || !this.lossesValidated(neutralLosses, peptideIon)) continue;
                ArrayList<Object> tempCharges = peptideIon.getType() == Ion.IonType.PRECURSOR_ION ? precursorCharges : charges;
                Iterator<Object> i$ = tempCharges.iterator();
                while (i$.hasNext()) {
                    int charge = (Integer)i$.next();
                    if (!this.chargeValidated(peptideIon, charge, precursorCharge)) continue;
                    String key = IonMatch.getPeakAnnotation(peptideIon, new Charge(1, charge));
                    if (!this.spectrumAnnotation.containsKey(key) && !this.unmatchedIons.contains(key)) {
                        this.matchInSpectrum(peptideIon, charge);
                    }
                    if (this.unmatchedIons.contains(key)) continue;
                    result.add((IonMatch)this.spectrumAnnotation.get(key));
                }
            }
        }
        return result;
    }

    public HashMap<Integer, ArrayList<IonMatch>> getCoveredAminoAcids(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, MSnSpectrum spectrum, Peptide peptide, double intensityLimit, double mzTolerance, boolean isPpm) {
        HashMap<Integer, ArrayList<IonMatch>> matchesMap = new HashMap<Integer, ArrayList<IonMatch>>();
        ArrayList<IonMatch> matches = this.getSpectrumAnnotation(iontypes, neutralLosses, charges, precursorCharge, spectrum, peptide, intensityLimit, mzTolerance, isPpm);
        for (IonMatch ionMatch : matches) {
            Ion ion = ionMatch.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            int number = ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2 ? ((PeptideFragmentIon)ion).getNumber() : peptide.getSequence().length() + 1 - ((PeptideFragmentIon)ion).getNumber();
            if (!matchesMap.containsKey(number)) {
                matchesMap.put(number, new ArrayList());
            }
            matchesMap.get(number).add(ionMatch);
        }
        return matchesMap;
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, Peptide peptide) {
        this.setPeptide(peptide, precursorCharge);
        return this.getExpectedIons(iontypes, neutralLosses, charges, precursorCharge);
    }

    @Override
    public ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges) {
        return this.getSpectrumAnnotation(iontypes, neutralLosses, charges, this.precursorCharge, spectrum, this.peptide, this.intensityLimit, this.mzTolerance, this.isPpm);
    }

    public static NeutralLossesMap getDefaultLosses(Peptide peptide, AminoAcidPattern.MatchingType matchingType, double mzTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        int firstIndex;
        PTMFactory pTMFactory = PTMFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        int aaMin = peptide.getSequence().length();
        int aaMax = 0;
        if (IonFactory.getInstance().getDefaultNeutralLosses().contains(NeutralLoss.H2O)) {
            firstIndex = peptide.getSequence().indexOf("D");
            if (firstIndex != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("D"), aaMax);
            }
            if ((firstIndex = peptide.getSequence().indexOf("E")) != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("E"), aaMax);
            }
            if ((firstIndex = peptide.getSequence().indexOf("S")) != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("S"), aaMax);
            }
            if ((firstIndex = peptide.getSequence().indexOf("T")) != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("T"), aaMax);
            }
            if (aaMin < peptide.getSequence().length()) {
                neutralLossesMap.addNeutralLoss(NeutralLoss.H2O, aaMin + 1, peptide.getSequence().length() - aaMax);
            }
        }
        aaMin = peptide.getSequence().length();
        aaMax = 0;
        if (IonFactory.getInstance().getDefaultNeutralLosses().contains(NeutralLoss.NH3)) {
            firstIndex = peptide.getSequence().indexOf("K");
            if (firstIndex != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("K"), aaMax);
            }
            if ((firstIndex = peptide.getSequence().indexOf("N")) != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("N"), aaMax);
            }
            if ((firstIndex = peptide.getSequence().indexOf("Q")) != -1) {
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("Q"), aaMax);
            }
            if (aaMin < peptide.getSequence().length()) {
                neutralLossesMap.addNeutralLoss(NeutralLoss.NH3, aaMin + 1, peptide.getSequence().length() - aaMax);
            }
        }
        int modMin = peptide.getSequence().length();
        int modMax = 0;
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            PTM ptm = pTMFactory.getPTM(modMatch.getTheoreticPtm());
            if (ptm == null) {
                throw new IllegalArgumentException("PTM " + modMatch.getTheoreticPtm() + " not loaded in PTM factory.");
            }
            for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                ArrayList<Integer> indexes = peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance);
                if (!indexes.isEmpty()) {
                    Collections.sort(indexes);
                    modMin = indexes.get(0);
                    modMax = indexes.get(indexes.size() - 1);
                }
                neutralLossesMap.addNeutralLoss(neutralLoss, modMin, peptide.getSequence().length() - modMax + 1);
            }
        }
        return neutralLossesMap;
    }

    public Peptide getCurrentlyLoadedPeptide() {
        return this.peptide;
    }
}

