/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotators;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.SpectrumAnnotator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TagSpectrumAnnotator
extends SpectrumAnnotator {
    private Tag tag;

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag newTag, int precursorCharge) {
        if (this.tag == null || !this.tag.isSameAs(newTag) || this.precursorCharge != precursorCharge) {
            this.tag = newTag;
            this.precursorCharge = precursorCharge;
            this.theoreticalFragmentIons = this.fragmentFactory.getFragmentIons(newTag);
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                for (Ion ion : this.theoreticalFragmentIons) {
                    if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                    if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                        ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                        continue;
                    }
                    if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5) continue;
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    public static NeutralLossesMap getDefaultLosses(Tag tag, AminoAcidPattern.MatchingType matchingType, double mzTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        int index;
        int i;
        AminoAcidPattern aminoAcidPattern;
        int tagLength;
        PTMFactory pTMFactory = PTMFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        int aaMin = tagLength = tag.getLengthInAminoAcid();
        int aaMax = 0;
        int offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                aminoAcidPattern = (AminoAcidPattern)component;
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    if (!aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.D) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.E) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.S) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.T)) continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            ++offset;
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.H2O, aaMin + 1, tagLength - aaMax);
        }
        aaMin = tagLength;
        aaMax = 0;
        offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                aminoAcidPattern = (AminoAcidPattern)component;
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    if (!aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.D) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.E) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.S) && !aminoAcidPattern.getAminoAcidsAtTarget().contains(AminoAcid.T)) continue;
                    index = i + offset;
                    aaMin = Math.min(index, aaMin);
                    aaMax = Math.max(index, aaMax);
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            ++offset;
        }
        if (aaMin < tagLength) {
            neutralLossesMap.addNeutralLoss(NeutralLoss.NH3, aaMin + 1, tagLength - aaMax);
        }
        int modMin = tagLength;
        int modMax = 0;
        offset = 0;
        for (TagComponent component : tag.getContent()) {
            if (component instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern2 = (AminoAcidPattern)component;
                for (int i2 = 1; i2 <= aminoAcidPattern2.length(); ++i2) {
                    for (ModificationMatch modificationMatch : aminoAcidPattern2.getModificationsAt(i2)) {
                        PTM ptm = pTMFactory.getPTM(modificationMatch.getTheoreticPtm());
                        if (ptm == null) {
                            throw new IllegalArgumentException("PTM " + modificationMatch.getTheoreticPtm() + " not loaded in PTM factory.");
                        }
                        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                            ArrayList<Integer> indexes = tag.getPotentialModificationSites(ptm, matchingType, mzTolerance);
                            if (!indexes.isEmpty()) {
                                Collections.sort(indexes);
                                modMin = indexes.get(0);
                                modMax = indexes.get(indexes.size() - 1);
                            }
                            neutralLossesMap.addNeutralLoss(neutralLoss, modMin, tag.getLengthInAminoAcid() - modMax + 1);
                        }
                    }
                }
                offset += aminoAcidPattern2.length();
                continue;
            }
            ++offset;
        }
        return neutralLossesMap;
    }

    public ArrayList<IonMatch> getSpectrumAnnotation(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, MSnSpectrum spectrum, Tag tag, double intensityLimit, double mzTolerance, boolean isPpm) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (spectrum != null) {
            this.setSpectrum(spectrum, intensityLimit);
        }
        this.setTag(tag, precursorCharge);
        this.setMassTolerance(mzTolerance, isPpm);
        ArrayList<Integer> precursorCharges = new ArrayList<Integer>();
        for (int i = 1; i <= precursorCharge; ++i) {
            precursorCharges.add(i);
        }
        if (this.theoreticalFragmentIons != null) {
            for (Ion fragmentIon : this.theoreticalFragmentIons) {
                if (!iontypes.containsKey((Object)fragmentIon.getType()) || !iontypes.get((Object)fragmentIon.getType()).contains(fragmentIon.getSubType()) || !this.lossesValidated(neutralLosses, fragmentIon)) continue;
                ArrayList<Object> tempCharges = fragmentIon.getType() == Ion.IonType.PRECURSOR_ION ? precursorCharges : charges;
                Iterator<Object> i$ = tempCharges.iterator();
                while (i$.hasNext()) {
                    int charge = (Integer)i$.next();
                    if (!this.chargeValidated(fragmentIon, charge, precursorCharge)) continue;
                    String key = IonMatch.getPeakAnnotation(fragmentIon, new Charge(1, charge));
                    if (!this.spectrumAnnotation.containsKey(key) && !this.unmatchedIons.contains(key)) {
                        this.matchInSpectrum(fragmentIon, charge);
                    }
                    if (this.unmatchedIons.contains(key)) continue;
                    result.add((IonMatch)this.spectrumAnnotation.get(key));
                }
            }
        }
        return result;
    }

    @Override
    public ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges) {
        return this.getSpectrumAnnotation(iontypes, neutralLosses, charges, this.precursorCharge, spectrum, this.tag, this.intensityLimit, this.mzTolerance, this.isPpm);
    }
}

