/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.tags;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Tag
extends ExperimentObject {
    private ArrayList<TagComponent> content = new ArrayList();

    public Tag() {
    }

    public Tag(double nTermGap, AminoAcidPattern sequenceTag, double cTermGap) {
        this.addMassGap(nTermGap);
        this.addAminoAcidSequence(sequenceTag);
        this.addMassGap(cTermGap);
    }

    public ArrayList<TagComponent> getContent() {
        return this.content;
    }

    public void addMassGap(double massGap) {
        if (massGap != 0.0) {
            this.content.add(new MassGap(massGap));
        }
    }

    public void addAminoAcidSequence(AminoAcidPattern aminoAcidSequence) {
        if (aminoAcidSequence.length() > 0) {
            TagComponent lastComponent;
            if (!this.content.isEmpty() && (lastComponent = this.content.get(this.content.size() - 1)) instanceof AminoAcidPattern) {
                AminoAcidPattern pattern = (AminoAcidPattern)lastComponent;
                pattern.append(aminoAcidSequence);
                return;
            }
            this.content.add(aminoAcidSequence);
        }
    }

    public String asSequence() {
        String result = "";
        for (TagComponent tagComponent : this.content) {
            result = result + tagComponent.asSequence();
        }
        return result;
    }

    public String getLongestAminoAcidSequence() {
        String result = "";
        AminoAcidPattern lastAminoAcidPattern = null;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof MassGap) {
                if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
                    result = lastAminoAcidPattern.asSequence();
                }
                lastAminoAcidPattern = null;
                continue;
            }
            if (!(tagComponent instanceof AminoAcidPattern)) continue;
            AminoAcidPattern currentPattern = (AminoAcidPattern)tagComponent;
            if (lastAminoAcidPattern == null) {
                lastAminoAcidPattern = currentPattern;
                continue;
            }
            lastAminoAcidPattern.append(currentPattern);
        }
        if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
            result = lastAminoAcidPattern.asSequence();
        }
        return result;
    }

    public double getMass() {
        double mass = 0.0;
        for (TagComponent tagComponent : this.content) {
            mass += tagComponent.getMass().doubleValue();
        }
        return mass;
    }

    public double getMass(boolean includeCTermGap, boolean includeNTermGap) {
        double mass = this.getMass();
        if (!includeCTermGap) {
            mass -= this.getCTerminalGap();
        }
        if (!includeNTermGap) {
            mass -= this.getNTerminalGap();
        }
        return mass;
    }

    public double getNTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(0);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public double getCTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(this.content.size() - 1);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedModifications, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, excludeAllFixedModifications, includeTerminalGaps);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, false, includeTerminalGaps);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, Tag tag, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedPtms, boolean includeTerminalGaps) {
        String modifiedSequence = "";
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + tag.getNTerminal(includeTerminalGaps);
        for (int i = 0; i < tag.getContent().size(); ++i) {
            TagComponent tagComponent = tag.getContent().get(i);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                modifiedSequence = modifiedSequence + aminoAcidPattern.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, useShortName, excludeAllFixedPtms);
                continue;
            }
            if (!includeTerminalGaps && (i <= 0 || i >= tag.getContent().size() - 1)) continue;
            modifiedSequence = modifiedSequence + tagComponent.asSequence();
        }
        modifiedSequence = modifiedSequence + tag.getCTerminal(includeTerminalGaps);
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public String getNTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent firstComponent = this.content.get(0);
        if (firstComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)firstComponent;
            String nTerm = "NH2";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                nTerm = ptmFactory.getShortName(modificationMatch.getTheoreticPtm());
            }
            nTerm = nTerm.replaceAll("-", " ");
            return nTerm + "-";
        }
        if (firstComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return firstComponent.asSequence();
            }
            return "...";
        }
        throw new IllegalArgumentException("Terminal tag not implemented for TagComponent " + firstComponent.getClass() + ".");
    }

    public String getCTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent lastComponent = this.content.get(this.content.size() - 1);
        if (lastComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)lastComponent;
            String cTerm = "COOH";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                cTerm = ptmFactory.getShortName(modificationMatch.getTheoreticPtm());
            }
            cTerm = cTerm.replaceAll("-", " ");
            return "-" + cTerm;
        }
        if (lastComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return lastComponent.asSequence();
            }
            return "...";
        }
        throw new IllegalArgumentException("Terminal tag not implemented for TagComponent " + lastComponent.getClass() + ".");
    }

    public int getLengthInAminoAcid() {
        int length = 0;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                length += aminoAcidPattern.length();
                continue;
            }
            ++length;
        }
        return length;
    }

    public ArrayList<Integer> getPotentialModificationSites(PTM ptm, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern ptmPattern = ptm.getPattern();
        int patternLength = ptmPattern.length();
        switch (ptm.getType()) {
            case 0: {
                int offset = 0;
                for (TagComponent tagComponent : this.content) {
                    if (tagComponent instanceof AminoAcidPattern) {
                        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                        for (int i : ptmPattern.getIndexes(aminoAcidPattern)) {
                            possibleSites.add(i + offset);
                        }
                        offset += aminoAcidPattern.length();
                        continue;
                    }
                    ++offset;
                }
            }
            case 3: 
            case 7: {
                possibleSites.add(patternLength);
            }
            case 1: 
            case 5: {
                possibleSites.add(1);
            }
            case 4: 
            case 8: {
                AminoAcidPattern aminoAcidPattern;
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(this.content.size() - 1);
                if (component instanceof AminoAcidPattern) {
                    aminoAcidPattern = (AminoAcidPattern)component;
                    if (ptmPattern.isEnding(aminoAcidPattern)) {
                        possibleSites.add(patternLength);
                    }
                } else {
                    possibleSites.add(patternLength);
                }
            }
            case 2: 
            case 6: {
                AminoAcidPattern aminoAcidPattern;
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(0);
                if (component instanceof AminoAcidPattern) {
                    aminoAcidPattern = (AminoAcidPattern)component;
                    if (!ptmPattern.isStarting(aminoAcidPattern)) break;
                    possibleSites.add(patternLength);
                    break;
                }
                possibleSites.add(patternLength);
            }
        }
        return possibleSites;
    }

    public boolean isSameAs(Tag anotherTag) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (!component1.isSameAs(component2 = anotherTag.getContent().get(i))) continue;
            return false;
        }
        return true;
    }

    public HashMap<Integer, ArrayList<Peptide>> getPeptideMatches(String sequence, int tagIndex, int componentIndex, AminoAcidPattern.MatchingType matchingType, Double massTolerance, ArrayList<String> fixedModifications, ArrayList<String> variableModifications) {
        AminoAcidPattern ptmPattern;
        HashMap<Integer, ArrayList<Peptide>> result = new HashMap<Integer, ArrayList<Peptide>>();
        double minMod = 0.0;
        for (String modificationName : variableModifications) {
            PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
            if (!(ptm.getMass() < minMod)) continue;
            minMod = ptm.getMass();
        }
        int sequenceLastIndex = sequence.length() - 1;
        HashMap<AminoAcidPattern, Integer> nTermPossiblePatternsIndexes = new HashMap<AminoAcidPattern, Integer>();
        nTermPossiblePatternsIndexes.put(new AminoAcidPattern(), tagIndex);
        for (int i = componentIndex - 1; i >= 0; --i) {
            TagComponent tagComponent = this.content.get(i);
            HashMap<AminoAcidPattern, Integer> newIndexes = new HashMap<AminoAcidPattern, Integer>();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidPattern nTermPattern : nTermPossiblePatternsIndexes.keySet()) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern);
                    int startIndex = aaIndex - (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (startIndex < 0 || !aminoAcidPattern.matches(subSequence = sequence.substring(startIndex, aaIndex), matchingType, massTolerance)) continue;
                    AminoAcidPattern newPattern = (AminoAcidPattern)tagComponent;
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found;
                            PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm.getType() == 5 || ptm.getType() == 1 && startIndex == 0) {
                                found = false;
                                for (ModificationMatch modificationMatch : newPattern.getModificationsAt(1)) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm.getType() != 6 && (ptm.getType() != 2 || startIndex != 0)) continue;
                            if (ptm.getPattern().firstIndex(subSequence, matchingType, massTolerance) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found = false;
                            for (ModificationMatch modificationMatch : newPattern.getModificationsAt(1)) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    newPattern.append(nTermPattern);
                    newIndexes.put(newPattern, startIndex);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidPattern nTermPattern : nTermPossiblePatternsIndexes.keySet()) {
                    int aaIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern);
                    HashMap<AminoAcidPattern, Double> possiblePatternsMasses = new HashMap<AminoAcidPattern, Double>();
                    ArrayList<AminoAcidPattern> validPatterns = new ArrayList<AminoAcidPattern>();
                    while (--aaIndex >= 0) {
                        PTM ptm;
                        AminoAcidPattern ptmPattern2;
                        PTM ptm2;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        for (String modificationName : fixedModifications) {
                            PTM ptm3 = PTMFactory.getInstance().getPTM(modificationName);
                            AminoAcidPattern ptmPattern3 = ptm3.getPattern();
                            if (ptm3.getType() != 0 || !ptmPattern3.isTargeted(aa, ptmPattern3.getTarget(), matchingType, massTolerance)) continue;
                            fixedMass += ptm3.getMass();
                        }
                        if (possiblePatternsMasses.isEmpty()) {
                            AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possiblePatternsMasses.put(newPattern, noModMass);
                            for (String modificationName : variableModifications) {
                                PTM ptm4 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern = ptm4.getPattern();
                                if (ptm4.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                                newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                newPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                double newMass = noModMass + ptm4.getMass();
                                possiblePatternsMasses.put(newPattern, newMass);
                            }
                        } else {
                            HashMap<AminoAcidPattern, Double> newPatternsMasses = new HashMap<AminoAcidPattern, Double>();
                            for (AminoAcidPattern aminoAcidPattern : possiblePatternsMasses.keySet()) {
                                AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + (Double)possiblePatternsMasses.get(aminoAcidPattern);
                                newPattern.append(aminoAcidPattern);
                                newPatternsMasses.put(newPattern, noModMass);
                                for (String modificationName : variableModifications) {
                                    ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern2 = ptm2.getPattern();
                                    if (ptm2.getType() != 0 || !ptmPattern2.isTargeted(aa, ptmPattern2.getTarget(), matchingType, massTolerance)) continue;
                                    newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                    newPattern.append(aminoAcidPattern);
                                    newPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    double newMass = noModMass + ptm2.getMass();
                                    newPatternsMasses.put(newPattern, newMass);
                                }
                            }
                            possiblePatternsMasses = newPatternsMasses;
                        }
                        double fixedNTermModifications = 0.0;
                        for (String modificationName : fixedModifications) {
                            ptm = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm.getType() != 5) continue;
                            fixedNTermModifications = ptm.getMass();
                            break;
                        }
                        if (aaIndex == 0) {
                            for (String modificationName : fixedModifications) {
                                ptm = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm.getType() != 1) continue;
                                fixedNTermModifications = ptm.getMass();
                                break;
                            }
                        }
                        ArrayList aminoAcidPatterns = new ArrayList(possiblePatternsMasses.keySet());
                        block14: for (AminoAcidPattern aminoAcidPattern : aminoAcidPatterns) {
                            AminoAcidPattern ptmPattern4;
                            PTM ptm5;
                            for (String modificationName : fixedModifications) {
                                ptm5 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern4 = ptm5.getPattern();
                                if (ptm5.getType() != 6 || !ptmPattern4.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern4.getTarget(), matchingType, massTolerance)) continue;
                                fixedNTermModifications = ptm5.getMass();
                                break;
                            }
                            if (aaIndex == 0) {
                                for (String modificationName : fixedModifications) {
                                    ptm5 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern4 = ptm5.getPattern();
                                    if (ptm5.getType() != 2 || !ptmPattern4.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern4.getTarget(), matchingType, massTolerance)) continue;
                                    fixedNTermModifications = ptm5.getMass();
                                    break;
                                }
                            }
                            if ((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + minMod > massGap + massTolerance) {
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            if (Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications - massGap) <= massTolerance) {
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            boolean found = false;
                            if (aaIndex == 0) {
                                for (String modificationName : variableModifications) {
                                    ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern2 = ptm2.getPattern();
                                    if (ptm2.getType() != 1 && (ptm2.getType() != 2 || !ptmPattern2.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern2.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + ptm2.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                    validPatterns.add(aminoAcidPattern);
                                    possiblePatternsMasses.remove(aminoAcidPattern);
                                    break;
                                }
                            }
                            if (found) continue;
                            for (String modificationName : variableModifications) {
                                ptm2 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern2 = ptm2.getPattern();
                                if (ptm2.getType() != 5 && (ptm2.getType() != 6 || !ptmPattern2.isTargeted(aminoAcidPattern.getTargetedAA((int)0).get((int)0).singleLetterCode.charAt(0), ptmPattern2.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedNTermModifications + ptm2.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidPattern.addModificationMatch(1, new ModificationMatch(modificationName, true, 1));
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue block14;
                            }
                        }
                        if (!possiblePatternsMasses.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidPattern aminoAcidPattern : validPatterns) {
                        aminoAcidPattern.append(nTermPattern);
                        int newIndex = (Integer)nTermPossiblePatternsIndexes.get(nTermPattern) - aminoAcidPattern.length();
                        newIndexes.put(aminoAcidPattern, newIndex);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence mating.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            nTermPossiblePatternsIndexes = newIndexes;
        }
        AminoAcidPattern tagPattern = (AminoAcidPattern)this.content.get(componentIndex);
        if (componentIndex == 0) {
            boolean goodTerminalPTms = true;
            for (String modificationName : fixedModifications) {
                boolean found;
                PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                if (ptm.getType() == 5 || ptm.getType() == 1 && tagIndex == 0) {
                    found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (ptm.getType() != 6 && (ptm.getType() != 2 || tagIndex != 0)) continue;
                if (ptm.getPattern().firstIndex(tagPattern, matchingType, massTolerance) != 0) {
                    goodTerminalPTms = false;
                    break;
                }
                found = false;
                for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(1)) {
                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                goodTerminalPTms = false;
                break;
            }
            if (!goodTerminalPTms) {
                return result;
            }
        }
        int endTagIndex = tagIndex + tagPattern.length() - 1;
        if (componentIndex == this.content.size() - 1) {
            boolean goodTerminalPTms = true;
            for (String modificationName : fixedModifications) {
                PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                if (ptm.getType() == 7 || ptm.getType() == 3 && endTagIndex == sequenceLastIndex) {
                    boolean found = false;
                    for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                        if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    goodTerminalPTms = false;
                    break;
                }
                if (ptm.getType() != 8 && (ptm.getType() != 4 || endTagIndex != sequenceLastIndex)) continue;
                if (ptm.getPattern().firstIndex(tagPattern, matchingType, massTolerance) != 0) {
                    goodTerminalPTms = false;
                    break;
                }
                boolean found = false;
                for (ModificationMatch modificationMatch : tagPattern.getModificationsAt(tagPattern.length())) {
                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                goodTerminalPTms = false;
                break;
            }
            if (!goodTerminalPTms) {
                return result;
            }
        }
        HashMap<AminoAcidPattern, Integer> cTermPossiblePatternsIndexes = new HashMap<AminoAcidPattern, Integer>();
        cTermPossiblePatternsIndexes.put(new AminoAcidPattern(), endTagIndex);
        for (int i = componentIndex + 1; i < this.content.size(); ++i) {
            TagComponent tagComponent = this.content.get(i);
            HashMap<AminoAcidPattern, Integer> newIndexes = new HashMap<AminoAcidPattern, Integer>();
            if (tagComponent instanceof AminoAcidPattern) {
                for (AminoAcidPattern cTermPattern : cTermPossiblePatternsIndexes.keySet()) {
                    String subSequence;
                    AminoAcidPattern aminoAcidPattern;
                    int aaIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern);
                    int endIndex = aaIndex + (aminoAcidPattern = (AminoAcidPattern)tagComponent).length();
                    if (endIndex > sequenceLastIndex || !aminoAcidPattern.matches(subSequence = sequence.substring(aaIndex, endIndex), matchingType, massTolerance)) continue;
                    AminoAcidPattern newPattern = (AminoAcidPattern)tagComponent;
                    boolean goodTerminalPTms = true;
                    if (i == 0) {
                        for (String modificationName : fixedModifications) {
                            boolean found;
                            PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm.getType() == 7 || ptm.getType() == 3 && endIndex == sequenceLastIndex) {
                                found = false;
                                for (ModificationMatch modificationMatch : newPattern.getModificationsAt(newPattern.length())) {
                                    if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                goodTerminalPTms = false;
                                break;
                            }
                            if (ptm.getType() != 8 && (ptm.getType() != 4 || endIndex != sequenceLastIndex)) continue;
                            if (ptm.getPattern().firstIndex(subSequence, matchingType, massTolerance) != 0) {
                                goodTerminalPTms = false;
                                break;
                            }
                            found = false;
                            for (ModificationMatch modificationMatch : newPattern.getModificationsAt(newPattern.length())) {
                                if (!modificationMatch.getTheoreticPtm().equals(modificationName)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            goodTerminalPTms = false;
                            break;
                        }
                    }
                    if (!goodTerminalPTms) continue;
                    cTermPattern.append(newPattern);
                    newIndexes.put(cTermPattern, endIndex);
                }
            } else if (tagComponent instanceof MassGap) {
                double massGap = tagComponent.getMass();
                for (AminoAcidPattern cTermPattern : cTermPossiblePatternsIndexes.keySet()) {
                    int aaIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern);
                    HashMap<AminoAcidPattern, Double> possiblePatternsMasses = new HashMap<AminoAcidPattern, Double>();
                    ArrayList<AminoAcidPattern> validPatterns = new ArrayList<AminoAcidPattern>();
                    while (++aaIndex <= sequenceLastIndex) {
                        AminoAcidPattern ptmPattern5;
                        char aa = sequence.charAt(aaIndex);
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        double fixedMass = 0.0;
                        for (String modificationName : fixedModifications) {
                            PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                            ptmPattern = ptm.getPattern();
                            if (ptm.getType() != 0 || !ptmPattern.isTargeted(aa, ptmPattern.getTarget(), matchingType, massTolerance)) continue;
                            fixedMass += ptm.getMass();
                        }
                        if (possiblePatternsMasses.isEmpty()) {
                            AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                            double noModMass = aminoAcid.monoisotopicMass + fixedMass;
                            possiblePatternsMasses.put(newPattern, noModMass);
                            for (String modificationName : variableModifications) {
                                PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                                AminoAcidPattern ptmPattern6 = ptm.getPattern();
                                if (ptm.getType() != 0 || !ptmPattern6.isTargeted(aa, ptmPattern6.getTarget(), matchingType, massTolerance)) continue;
                                newPattern = new AminoAcidPattern(aminoAcid.singleLetterCode);
                                int modIndex = newPattern.length();
                                newPattern.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                double newMass = noModMass + ptm.getMass();
                                possiblePatternsMasses.put(newPattern, newMass);
                            }
                        } else {
                            HashMap<AminoAcidPattern, Double> newPatternsMasses = new HashMap<AminoAcidPattern, Double>();
                            for (AminoAcidPattern aminoAcidPattern : possiblePatternsMasses.keySet()) {
                                AminoAcidPattern newPattern = new AminoAcidPattern(aminoAcidPattern);
                                double noModMass = aminoAcid.monoisotopicMass + fixedMass + (Double)possiblePatternsMasses.get(aminoAcidPattern);
                                newPattern.append(new AminoAcidPattern(aminoAcid.singleLetterCode));
                                newPatternsMasses.put(newPattern, noModMass);
                                for (String modificationName : variableModifications) {
                                    PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern5 = ptm.getPattern();
                                    if (ptm.getType() != 0 || !ptmPattern5.isTargeted(aa, ptmPattern5.getTarget(), matchingType, massTolerance)) continue;
                                    newPattern = new AminoAcidPattern(aminoAcidPattern);
                                    newPattern.append(new AminoAcidPattern(aminoAcid.singleLetterCode));
                                    int modIndex = newPattern.length();
                                    newPattern.addModificationMatch(modIndex, new ModificationMatch(modificationName, true, modIndex));
                                    double newMass = noModMass + ptm.getMass();
                                    newPatternsMasses.put(newPattern, newMass);
                                }
                            }
                            possiblePatternsMasses = newPatternsMasses;
                        }
                        double fixedCTermModifications = 0.0;
                        for (String modificationName : fixedModifications) {
                            PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                            if (ptm.getType() != 7) continue;
                            fixedCTermModifications = ptm.getMass();
                            break;
                        }
                        if (aaIndex == sequenceLastIndex) {
                            for (String modificationName : fixedModifications) {
                                PTM ptm = PTMFactory.getInstance().getPTM(modificationName);
                                if (ptm.getType() != 3) continue;
                                fixedCTermModifications = ptm.getMass();
                                break;
                            }
                        }
                        ArrayList aminoAcidPatterns = new ArrayList(possiblePatternsMasses.keySet());
                        block39: for (AminoAcidPattern aminoAcidPattern : aminoAcidPatterns) {
                            AminoAcidPattern ptmPattern7;
                            PTM ptm;
                            PTM ptm6;
                            int lastAminoAcidIndex = aminoAcidPattern.length() - 1;
                            for (String modificationName : fixedModifications) {
                                ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern5 = ptm6.getPattern();
                                if (ptm6.getType() != 8 || !ptmPattern5.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern5.getTarget(), matchingType, massTolerance)) continue;
                                fixedCTermModifications = ptm6.getMass();
                                break;
                            }
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : fixedModifications) {
                                    ptm6 = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern5 = ptm6.getPattern();
                                    if (ptm6.getType() != 4 || !ptmPattern5.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern5.getTarget(), matchingType, massTolerance)) continue;
                                    fixedCTermModifications = ptm6.getMass();
                                    break;
                                }
                            }
                            if ((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + minMod > massGap + massTolerance) {
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            if (Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications - massGap) <= massTolerance) {
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue;
                            }
                            boolean found = false;
                            if (aaIndex == lastAminoAcidIndex) {
                                for (String modificationName : variableModifications) {
                                    ptm = PTMFactory.getInstance().getPTM(modificationName);
                                    ptmPattern7 = ptm.getPattern();
                                    if (ptm.getType() != 3 && (ptm.getType() != 4 || !ptmPattern7.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern7.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + ptm.getMass() - massGap) <= massTolerance)) continue;
                                    aminoAcidPattern.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, lastAminoAcidIndex));
                                    validPatterns.add(aminoAcidPattern);
                                    possiblePatternsMasses.remove(aminoAcidPattern);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            for (String modificationName : variableModifications) {
                                ptm = PTMFactory.getInstance().getPTM(modificationName);
                                ptmPattern7 = ptm.getPattern();
                                if (ptm.getType() != 7 && (ptm.getType() != 8 || !ptmPattern7.isTargeted(aminoAcidPattern.getTargetedAA((int)lastAminoAcidIndex).get((int)0).singleLetterCode.charAt(0), ptmPattern7.getTarget(), matchingType, massTolerance)) || !(Math.abs((Double)possiblePatternsMasses.get(aminoAcidPattern) + fixedCTermModifications + ptm.getMass() - massGap) <= massTolerance)) continue;
                                aminoAcidPattern.addModificationMatch(lastAminoAcidIndex, new ModificationMatch(modificationName, true, lastAminoAcidIndex));
                                validPatterns.add(aminoAcidPattern);
                                possiblePatternsMasses.remove(aminoAcidPattern);
                                continue block39;
                            }
                        }
                        if (!possiblePatternsMasses.isEmpty()) continue;
                        break;
                    }
                    for (AminoAcidPattern aminoAcidPattern : validPatterns) {
                        AminoAcidPattern newPattern = new AminoAcidPattern(cTermPattern);
                        newPattern.append(aminoAcidPattern);
                        int newIndex = (Integer)cTermPossiblePatternsIndexes.get(cTermPattern) + aminoAcidPattern.length();
                        newIndexes.put(newPattern, newIndex);
                    }
                }
            } else {
                throw new IllegalArgumentException("Tag component " + tagComponent.getClass() + " not implemented for sequence mating.");
            }
            if (newIndexes.isEmpty()) {
                return result;
            }
            cTermPossiblePatternsIndexes = newIndexes;
        }
        String seedSequence = sequence.substring(tagIndex, tagIndex + tagPattern.length());
        for (AminoAcidPattern nTerm : nTermPossiblePatternsIndexes.keySet()) {
            int nTermIndex = (Integer)nTermPossiblePatternsIndexes.get(nTerm);
            StringBuilder nTermSequence = new StringBuilder(nTerm.length() + seedSequence.length());
            for (int i = 0; i < nTerm.length(); ++i) {
                nTermSequence.append(nTerm.getTargetedAA((int)i).get((int)0).singleLetterCode);
            }
            nTermSequence.append(seedSequence);
            for (AminoAcidPattern cTerm : cTermPossiblePatternsIndexes.keySet()) {
                StringBuilder peptideSequence = new StringBuilder(nTerm.length() + seedSequence.length() + cTerm.length());
                peptideSequence.append((CharSequence)nTermSequence);
                ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
                HashMap<Integer, ArrayList<ModificationMatch>> nTermModifications = nTerm.getModificationMatches();
                if (nTermModifications != null) {
                    for (int i : nTermModifications.keySet()) {
                        for (ModificationMatch modificationMatch : nTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), i));
                        }
                    }
                }
                peptideSequence.append(seedSequence);
                HashMap<Integer, ArrayList<ModificationMatch>> sequenceModifications = tagPattern.getModificationMatches();
                if (sequenceModifications != null) {
                    for (int i : sequenceModifications.keySet()) {
                        for (ModificationMatch modificationMatch : sequenceModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTerm.length() + i));
                        }
                    }
                }
                for (int i = 0; i < cTerm.length(); ++i) {
                    peptideSequence.append(cTerm.getTargetedAA((int)i).get((int)0).singleLetterCode);
                }
                HashMap<Integer, ArrayList<ModificationMatch>> cTermModifications = cTerm.getModificationMatches();
                if (cTermModifications != null) {
                    for (int i : cTermModifications.keySet()) {
                        for (ModificationMatch modificationMatch : cTermModifications.get(i)) {
                            modificationMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), nTerm.length() + tagPattern.length() + i));
                        }
                    }
                }
                Peptide peptide = new Peptide(peptideSequence.toString(), modificationMatches);
                ArrayList<Peptide> peptides = result.get(nTermIndex);
                if (peptides == null) {
                    peptides = new ArrayList();
                    result.put(nTermIndex, peptides);
                }
                peptides.add(peptide);
            }
        }
        return result;
    }
}

