/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MSnSpectrum
extends Spectrum {
    static final long serialVersionUID = -7144961253807359274L;
    private Precursor precursor;

    public MSnSpectrum() {
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, String fileName) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.fileName = fileName;
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, HashMap<Double, Peak> peakMap, String fileName) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.peakList = peakMap;
        this.fileName = fileName;
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, HashMap<Double, Peak> peakMap, String fileName, double scanStartTime) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.peakList = peakMap;
        this.fileName = fileName;
        this.scanStartTime = scanStartTime;
    }

    public Precursor getPrecursor() {
        return this.precursor;
    }

    public void setPrecursor(Precursor precursor) {
        this.precursor = precursor;
    }

    public String asMgf() {
        return this.asMgf(new HashMap<String, String>());
    }

    public String asMgf(HashMap<String, String> additionalTags) {
        StringBuilder results = new StringBuilder();
        results.append("BEGIN IONS").append(System.getProperty("line.separator"));
        if (additionalTags != null) {
            ArrayList<String> additionalTagsKeys = new ArrayList<String>(additionalTags.keySet());
            Collections.sort(additionalTagsKeys);
            for (String string : additionalTagsKeys) {
                if (additionalTags.get(string) == null) continue;
                results.append(string).append("=").append(additionalTags.get(string)).append(System.getProperty("line.separator"));
            }
        }
        results.append("TITLE=").append(this.spectrumTitle).append(System.getProperty("line.separator"));
        results.append("PEPMASS=").append(this.precursor.getMz()).append("\t").append(this.precursor.getIntensity()).append(System.getProperty("line.separator"));
        if (this.precursor.hasRTWindow()) {
            results.append("RTINSECONDS=").append(this.precursor.getRtWindow()[0]).append("-").append(this.precursor.getRtWindow()[1]).append(System.getProperty("line.separator"));
        } else if (this.precursor.getRt() != -1.0) {
            results.append("RTINSECONDS=").append(this.precursor.getRt()).append(System.getProperty("line.separator"));
        }
        if (!this.precursor.getPossibleCharges().isEmpty()) {
            results.append("CHARGE=");
            boolean first = true;
            for (Charge charge : this.precursor.getPossibleCharges()) {
                if (first) {
                    first = false;
                } else {
                    results.append(" and ");
                }
                results.append(charge.toString());
            }
            results.append(System.getProperty("line.separator"));
        }
        if (this.scanNumber != null && !this.scanNumber.equals("")) {
            results.append("SCANS=").append(this.scanNumber).append(System.getProperty("line.separator"));
        }
        TreeMap<Double, Double> sortedPeakList = new TreeMap<Double, Double>();
        for (Peak peak : this.peakList.values()) {
            sortedPeakList.put(peak.mz, peak.intensity);
        }
        for (Map.Entry entry : sortedPeakList.entrySet()) {
            results.append(entry.getKey()).append(" ").append(entry.getValue()).append(System.getProperty("line.separator"));
        }
        results.append("END IONS").append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
        return results.toString();
    }

    public void writeMgf(BufferedWriter writer1) throws IOException {
        this.writeMgf(writer1, null);
    }

    public void writeMgf(BufferedWriter mgfWriter, HashMap<String, String> additionalTags) throws IOException {
        String spectrumAsMgf = this.asMgf(additionalTags);
        mgfWriter.write(spectrumAsMgf);
    }
}

