/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Sample;
import com.compomics.util.experiment.quantification.Quantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ReporterIonQuantification
extends Quantification {
    private HashMap<Integer, Sample> sampleAssignement = new HashMap();
    private ArrayList<Integer> controlSamples;
    private HashMap<Integer, Double> normalisationFactors = new HashMap();
    private ReporterMethod reporterMethod;

    public ReporterIonQuantification(Quantification.QuantificationMethod methodUsed) {
        this.methodUsed = methodUsed;
    }

    public void assignSample(int reporterIndex, Sample sample) {
        this.sampleAssignement.put(reporterIndex, sample);
    }

    public Sample getSample(int reporterIndex) {
        return this.sampleAssignement.get(reporterIndex);
    }

    public Integer getReporterIndex(Sample aSample) {
        for (int index : this.sampleAssignement.keySet()) {
            if (!this.sampleAssignement.get(index).isSameAs(aSample)) continue;
            return index;
        }
        return null;
    }

    public ReporterMethod getReporterMethod() {
        return this.reporterMethod;
    }

    public void setMethod(ReporterMethod reporterMethod) {
        this.reporterMethod = reporterMethod;
    }

    public static String getDefaultReference(String experimentReference, String sampleReference, int replicateNumber) {
        return Util.removeForbiddenCharacters(experimentReference + "_" + sampleReference + "_" + replicateNumber + "_reporterQuant");
    }

    public ArrayList<Integer> getControlSamples() {
        return this.controlSamples;
    }

    public void setControlSamples(ArrayList<Integer> controlSamples) {
        this.controlSamples = controlSamples;
    }

    public boolean hasNormalisationFactors() {
        return !this.normalisationFactors.isEmpty();
    }

    public void resetNormalisationFactors() {
        this.normalisationFactors.clear();
    }

    public void addNormalisationFactor(int sampleIndex, double normalisationFactor) {
        this.normalisationFactors.put(sampleIndex, normalisationFactor);
    }

    public double getNormalisationFactor(int sampleIndex) {
        Double normalisationFactor = this.normalisationFactors.get(sampleIndex);
        if (normalisationFactor == null) {
            return 1.0;
        }
        return normalisationFactor;
    }

    public Set<Integer> getSampleIndexes() {
        return this.sampleAssignement.keySet();
    }
}

