/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.quantification.reporterion.CorrectionFactor;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ReporterMethodFactory
extends ExperimentObject {
    private static ArrayList<ReporterMethod> methods;
    private static ReporterMethodFactory instance;

    private ReporterMethodFactory() {
    }

    public static ReporterMethodFactory getInstance() {
        if (instance == null) {
            instance = new ReporterMethodFactory();
        }
        return instance;
    }

    public ArrayList<ReporterMethod> getMethods() {
        return methods;
    }

    public String[] getMethodsNames() {
        String[] names = new String[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            names[i] = methods.get(i).getName();
        }
        return names;
    }

    public void saveFile(File aFile) {
    }

    public void importMethods(File aFile) throws IOException, XmlPullParserException {
        methods = new ArrayList();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("reporterMethod")) {
                methods.add(this.parseMethod(parser));
            }
            type = parser.next();
        }
        br.close();
    }

    private ReporterMethod parseMethod(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("name")) {
            type = parser.next();
        }
        type = parser.next();
        String name = parser.getText().trim();
        while (type != 2 || !parser.getName().equals("reporterIonList")) {
            type = parser.next();
        }
        ArrayList<ReporterIon> reporterIons = new ArrayList<ReporterIon>();
        while (type != 3 || !parser.getName().equals("reporterIonList")) {
            reporterIons.add(this.parseIon(parser));
            type = parser.next();
            while (type != 2 && type != 3) {
                type = parser.next();
            }
        }
        while (type != 2 || !parser.getName().equals("correctionFactorList")) {
            type = parser.next();
        }
        ArrayList<CorrectionFactor> correctionFactors = new ArrayList<CorrectionFactor>();
        while (type != 3 || !parser.getName().equals("correctionFactorList")) {
            correctionFactors.add(this.parseCorrectionFactor(parser));
            type = parser.next();
            while (type != 2 && type != 3) {
                type = parser.next();
            }
        }
        return new ReporterMethod(name, reporterIons, correctionFactors);
    }

    private ReporterIon parseIon(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("name")) {
            type = parser.next();
        }
        type = parser.next();
        String name = parser.getText().trim();
        while (type != 2 || !parser.getName().equals("mass")) {
            type = parser.next();
        }
        type = parser.next();
        Double mass = new Double(parser.getText().trim());
        while (type != 3 || !parser.getName().equals("reporterIon")) {
            type = parser.next();
        }
        return new ReporterIon(name, mass);
    }

    private CorrectionFactor parseCorrectionFactor(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("ionId")) {
            type = parser.next();
        }
        type = parser.next();
        Integer id = new Integer(parser.getText().trim());
        while (type != 2 || !parser.getName().equals("minus2")) {
            type = parser.next();
        }
        type = parser.next();
        Double minus2 = new Double(parser.getText().trim());
        while (type != 2 || !parser.getName().equals("minus1")) {
            type = parser.next();
        }
        type = parser.next();
        Double minus1 = new Double(parser.getText().trim());
        while (type != 2 || !parser.getName().equals("plus1")) {
            type = parser.next();
        }
        type = parser.next();
        Double plus1 = new Double(parser.getText().trim());
        while (type != 2 || !parser.getName().equals("plus2")) {
            type = parser.next();
        }
        type = parser.next();
        Double plus2 = new Double(parser.getText().trim());
        while (type != 3 || !parser.getName().equals("correctionFactor")) {
            type = parser.next();
        }
        return new CorrectionFactor(id, minus2, minus1, plus1, plus2);
    }

    static {
        instance = null;
    }
}

