/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.gene_mapping;

import com.compomics.util.experiment.annotation.gene.GeneFactory;
import com.compomics.util.experiment.annotation.go.GOFactory;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.GenePreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SpeciesDialog
extends JDialog {
    private GOFactory goFactory = GOFactory.getInstance();
    private GeneFactory geneFactory = GeneFactory.getInstance();
    private ProgressDialogX progressDialog;
    private JFrame frameParent = null;
    private JDialog dialogParent = null;
    public static final String SELECT_SPECIES_TAG = "-- Select Species --";
    public static final String NO_SPECIES_TAG = "-- (no selection) --";
    private Image waitingImage = null;
    private Image normalImage = null;
    private GenePreferences genePreferences;
    private JPanel backgroundPanel;
    private JComboBox ensemblCategoryJComboBox;
    private JLabel ensemblVersionLabel;
    private JPanel jPanel1;
    private JButton okButton;
    private JComboBox speciesJComboBox;
    private JLabel unknownSpeciesLabel;
    private JButton updateMappingsButton;

    public SpeciesDialog(JFrame parentFrame, GenePreferences genePreferences, boolean modal, Image waitingImage, Image normalImage) {
        super((Frame)parentFrame, modal);
        this.frameParent = parentFrame;
        this.genePreferences = genePreferences;
        this.initComponents();
        this.waitingImage = waitingImage;
        this.normalImage = normalImage;
        this.setUpGUI();
        this.setLocationRelativeTo(this.frameParent);
        this.setVisible(true);
    }

    public SpeciesDialog(JDialog parentDialog, JFrame mainFrame, GenePreferences genePreferences, boolean modal, Image waitingImage, Image normalImage) {
        super((Dialog)parentDialog, modal);
        this.dialogParent = parentDialog;
        this.frameParent = mainFrame;
        this.genePreferences = genePreferences;
        this.initComponents();
        this.waitingImage = waitingImage;
        this.normalImage = normalImage;
        this.setUpGUI();
        this.speciesJComboBox.requestFocus();
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.ensemblCategoryJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.speciesJComboBox.setRenderer(new AlignedListCellRenderer(0));
        if (this.genePreferences.getCurrentSpeciesType() != null) {
            this.ensemblCategoryJComboBox.setSelectedItem(this.genePreferences.getCurrentSpeciesType());
        }
        this.updateSpeciesList();
        String selectedSpecies = this.genePreferences.getCurrentSpecies();
        if (selectedSpecies != null) {
            for (int i = 0; i < this.speciesJComboBox.getItemCount(); ++i) {
                String content = (String)this.speciesJComboBox.getItemAt(i);
                if (!content.contains(selectedSpecies)) continue;
                this.speciesJComboBox.setSelectedIndex(i);
                boolean dbVersion = content.contains("N/A");
                if (dbVersion) {
                    this.updateMappingsButton.setText("Download");
                } else {
                    this.updateMappingsButton.setText("Update");
                }
                this.updateMappingsButton.setEnabled(true);
                break;
            }
        }
    }

    private void updateSpeciesList() {
        HashMap<String, ArrayList<String>> availableSpecies = this.genePreferences.getAllSpecies();
        String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
        this.speciesJComboBox.setEnabled(this.ensemblCategoryJComboBox.getSelectedIndex() > 0);
        if (this.ensemblCategoryJComboBox.getSelectedIndex() > 0) {
            ArrayList<String> currentSpeciesList = availableSpecies.get(currentEnsemblSpeciesType);
            ArrayList<String> speciesList = new ArrayList<String>();
            if (currentSpeciesList != null && !currentSpeciesList.isEmpty()) {
                speciesList.add(SELECT_SPECIES_TAG);
                for (int i = 0; i < currentSpeciesList.size(); ++i) {
                    String currentSpecies = currentSpeciesList.get(i);
                    String tempEnsemblVersion = this.genePreferences.getEnsemblSpeciesVersion(currentEnsemblSpeciesType, currentSpecies);
                    if (tempEnsemblVersion == null) {
                        tempEnsemblVersion = "N/A";
                    }
                    speciesList.add(currentSpecies + " [" + tempEnsemblVersion + "]");
                }
                speciesList.add(NO_SPECIES_TAG);
                String[] tempTable = new String[speciesList.size()];
                this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(speciesList.toArray(tempTable)));
            } else {
                String[] content = new String[]{NO_SPECIES_TAG};
                this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(content));
            }
        } else {
            String[] content = new String[]{SELECT_SPECIES_TAG};
            this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(content));
        }
        this.updateMappingsButton.setEnabled(this.ensemblCategoryJComboBox.getSelectedIndex() > 0 && this.speciesJComboBox.getSelectedIndex() > 0 && this.speciesJComboBox.getSelectedIndex() < this.speciesJComboBox.getItemCount() - 1);
    }

    private String getSelectedSpecies() {
        String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
        int selectedIndex = this.speciesJComboBox.getSelectedIndex();
        if (selectedIndex > 0 && selectedIndex < this.speciesJComboBox.getItemCount() - 1) {
            return this.genePreferences.getAllSpecies().get(currentEnsemblSpeciesType).get(selectedIndex - 1);
        }
        return null;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.speciesJComboBox = new JComboBox();
        this.updateMappingsButton = new JButton();
        this.ensemblCategoryJComboBox = new JComboBox();
        this.okButton = new JButton();
        this.unknownSpeciesLabel = new JLabel();
        this.ensemblVersionLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Species");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Select Species"));
        this.jPanel1.setOpaque(false);
        this.speciesJComboBox.setMaximumRowCount(20);
        this.speciesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.speciesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.speciesJComboBoxActionPerformed(evt);
            }
        });
        this.updateMappingsButton.setText("Update");
        this.updateMappingsButton.setToolTipText("Update the GO Mappings");
        this.updateMappingsButton.setEnabled(false);
        this.updateMappingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.updateMappingsButtonActionPerformed(evt);
            }
        });
        this.ensemblCategoryJComboBox.setMaximumRowCount(20);
        this.ensemblCategoryJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Select Species Type ---", "Fungi", "Plants", "Protists", "Metazoa", "Vertebrates"}));
        this.ensemblCategoryJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.ensemblCategoryJComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ensemblCategoryJComboBox, 0, 416, Short.MAX_VALUE).addComponent(this.speciesJComboBox, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.updateMappingsButton, -2, 86, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ensemblCategoryJComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesJComboBox, -2, -1, -2).addComponent(this.updateMappingsButton, -2, 23, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.speciesJComboBox, this.updateMappingsButton);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpeciesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.unknownSpeciesLabel.setFont(this.unknownSpeciesLabel.getFont().deriveFont(this.unknownSpeciesLabel.getFont().getStyle() | 2));
        this.unknownSpeciesLabel.setText("<html><a href>Species not in list?</a></html>");
        this.unknownSpeciesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.unknownSpeciesLabelMouseExited(evt);
            }
        });
        this.ensemblVersionLabel.setFont(this.ensemblVersionLabel.getFont().deriveFont(this.ensemblVersionLabel.getFont().getStyle() | 2));
        this.ensemblVersionLabel.setText("<html><a href>Ensembl version?</a></html>");
        this.ensemblVersionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpeciesDialog.this.ensemblVersionLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.unknownSpeciesLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.ensemblVersionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.unknownSpeciesLabel, -2, -1, -2).addComponent(this.ensemblVersionLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void speciesJComboBoxActionPerformed(ActionEvent evt) {
        String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
        String selectedSpecies = this.getSelectedSpecies();
        if (selectedSpecies != null) {
            this.updateMappingsButton.setEnabled(true);
            if (this.genePreferences.getEnsemblSpeciesVersion(currentEnsemblSpeciesType, selectedSpecies) == null) {
                this.updateMappingsButton.setText("Download");
            } else {
                this.updateMappingsButton.setText("Update");
            }
        } else {
            this.updateMappingsButton.setText("Download");
            this.updateMappingsButton.setEnabled(false);
        }
    }

    private void unknownSpeciesLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SpeciesDialog.html"), "#Species", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Species - Help");
        this.setCursor(new Cursor(0));
    }

    private void unknownSpeciesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unknownSpeciesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void ensemblVersionLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SpeciesDialog.html"), "#Ensembl_Version", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Species - Help");
        this.setCursor(new Cursor(0));
    }

    private void ensemblVersionLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void ensemblVersionLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
        String selectedSpecies = this.getSelectedSpecies();
        if (selectedSpecies != null) {
            if (this.genePreferences.getEnsemblSpeciesVersion(currentEnsemblSpeciesType, selectedSpecies) == null) {
                int option = JOptionPane.showConfirmDialog(this, "The gene and GO annotations are not downloaded for the selected species.\nDownload now?", "Gene Annotation Missing", 1);
                if (option != 2) {
                    if (option == 0) {
                        this.downloadMappings();
                    } else {
                        this.genePreferences.setCurrentSpecies(selectedSpecies);
                        this.genePreferences.setCurrentSpeciesType(currentEnsemblSpeciesType);
                        this.dispose();
                    }
                }
            } else {
                this.genePreferences.setCurrentSpecies(selectedSpecies);
                this.genePreferences.setCurrentSpeciesType(currentEnsemblSpeciesType);
                this.dispose();
            }
        } else {
            this.genePreferences.setCurrentSpecies(null);
            this.genePreferences.setCurrentSpeciesType(null);
            this.dispose();
        }
    }

    private void updateMappingsButtonActionPerformed(ActionEvent evt) {
        if (this.geneFactory.getCurrentEnsemblVersion(this.getEnsemblType()) != null) {
            if (this.updateMappingsButton.getText().equalsIgnoreCase("Download")) {
                this.clearOldMappings();
                this.downloadMappings();
            } else {
                String selectedSpecies;
                Integer latestEnsemblVersion = this.geneFactory.getCurrentEnsemblVersion(this.getEnsemblType());
                String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
                String selectedDb = this.genePreferences.getEnsemblDatabaseName(currentEnsemblSpeciesType, selectedSpecies = this.getSelectedSpecies());
                String currentEnsemblVersionAsString = this.genePreferences.getEnsemblVersion(selectedDb);
                if (currentEnsemblVersionAsString != null) {
                    Integer currentEnsemblVersion;
                    currentEnsemblVersionAsString = currentEnsemblVersionAsString.substring(currentEnsemblVersionAsString.indexOf(" ") + 1);
                    try {
                        currentEnsemblVersion = new Integer(currentEnsemblVersionAsString);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        currentEnsemblVersion = latestEnsemblVersion;
                    }
                    if (currentEnsemblVersion < latestEnsemblVersion) {
                        this.clearOldMappings();
                        this.downloadMappings();
                    } else {
                        JOptionPane.showMessageDialog(this, "Ensembl mappings are already up to date.", "Ensembl Mappings", 1);
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Ensembl mapping not available. Try again later.", "Ensembl Error", 1);
        }
    }

    private void ensemblCategoryJComboBoxActionPerformed(ActionEvent evt) {
        this.updateSpeciesList();
    }

    private void clearOldResults() {
        this.goFactory.clearFactory();
        this.geneFactory.clearFactory();
        try {
            this.goFactory.closeFiles();
            this.geneFactory.closeFiles();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occured when clearing the mappings.", "File Error", 0);
        }
    }

    private boolean clearOldMappings() {
        String currentEnsemblSpeciesType = (String)this.ensemblCategoryJComboBox.getSelectedItem();
        String selectedSpecies = this.getSelectedSpecies();
        String selectedDb = this.genePreferences.getEnsemblDatabaseName(currentEnsemblSpeciesType, selectedSpecies);
        this.goFactory.clearFactory();
        this.geneFactory.clearFactory();
        try {
            this.goFactory.closeFiles();
            this.geneFactory.closeFiles();
            File tempSpeciesGoFile = new File(this.genePreferences.getGeneMappingFolder(), selectedDb + "_go_mappings");
            File tempSpecieGenesFile = new File(this.genePreferences.getGeneMappingFolder(), selectedDb + "_gene_mappings");
            boolean goFileDeleted = true;
            boolean geneFileDeleted = true;
            if (tempSpeciesGoFile.exists() && !(goFileDeleted = tempSpeciesGoFile.delete())) {
                JOptionPane.showMessageDialog(this, "Failed to delete '" + tempSpeciesGoFile.getAbsolutePath() + "'.\n" + "Please delete the file manually, reselect the species in the list and click the Download button instead.", "Delete Failed", 1);
            }
            if (tempSpecieGenesFile.exists() && !(geneFileDeleted = tempSpecieGenesFile.delete())) {
                JOptionPane.showMessageDialog(this, "Failed to delete '" + tempSpecieGenesFile.getAbsolutePath() + "'.\n" + "Please delete the file manually, reselect the species in the list and click the Download button instead.", "Delete Failed", 1);
            }
            return goFileDeleted && geneFileDeleted;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occured when trying to update the mappings.", "File Error", 1);
            return false;
        }
    }

    private void downloadMappings() {
        this.progressDialog = this.dialogParent == null ? new ProgressDialogX((Frame)this.frameParent, this.normalImage, this.waitingImage, true) : new ProgressDialogX(this.dialogParent, this.frameParent, this.normalImage, this.waitingImage, true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Sending Request. Please Wait...");
        final SpeciesDialog finalRef = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SpeciesDialog.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog").start();
        new Thread("GoThread"){

            @Override
            public void run() {
                try {
                    boolean goMappingsDownloaded;
                    SpeciesDialog.this.clearOldResults();
                    String currentEnsemblSpeciesType = (String)SpeciesDialog.this.ensemblCategoryJComboBox.getSelectedItem();
                    String selectedSpecies = SpeciesDialog.this.getSelectedSpecies();
                    String selectedDb = SpeciesDialog.this.genePreferences.getEnsemblDatabaseName(currentEnsemblSpeciesType, selectedSpecies);
                    if (!SpeciesDialog.this.progressDialog.isRunCanceled() && !(goMappingsDownloaded = SpeciesDialog.this.genePreferences.downloadGoMappings(SpeciesDialog.this.getEnsemblType(), SpeciesDialog.this.getEnsemblDbName(), selectedDb, SpeciesDialog.this.progressDialog))) {
                        JOptionPane.showMessageDialog(finalRef, "Gene ontology mappings not available.\nDownloading gene mappings only.", "Gene Ontology Mappings", 1);
                    }
                    if (!SpeciesDialog.this.progressDialog.isRunCanceled()) {
                        SpeciesDialog.this.genePreferences.downloadGeneMappings(SpeciesDialog.this.getEnsemblType(), SpeciesDialog.this.getEnsemblDbName(), selectedDb, SpeciesDialog.this.geneFactory.getCurrentEnsemblVersion(SpeciesDialog.this.getEnsemblType()).toString(), SpeciesDialog.this.progressDialog);
                    }
                    boolean canceled = SpeciesDialog.this.progressDialog.isRunCanceled();
                    SpeciesDialog.this.progressDialog.setRunFinished();
                    if (!canceled) {
                        int selectedIndex = SpeciesDialog.this.speciesJComboBox.getSelectedIndex();
                        SpeciesDialog.this.genePreferences.loadSpeciesAndGoDomains();
                        SpeciesDialog.this.updateSpeciesList();
                        JOptionPane.showMessageDialog(finalRef, "Gene mappings downloaded.", "Gene Mappings", 1);
                        SpeciesDialog.this.speciesJComboBox.setSelectedIndex(selectedIndex);
                        SpeciesDialog.this.speciesJComboBoxActionPerformed(null);
                    }
                }
                catch (Exception e) {
                    SpeciesDialog.this.progressDialog.setRunFinished();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(finalRef, "An error occured when downloading the mappings.", "Download Error", 0);
                }
            }
        }.start();
    }

    private String getEnsemblType() {
        int selectedIndex = this.ensemblCategoryJComboBox.getSelectedIndex();
        switch (selectedIndex) {
            case 1: {
                return "fungi";
            }
            case 2: {
                return "plants";
            }
            case 3: {
                return "protists";
            }
            case 4: {
                return "metazoa";
            }
            case 5: {
                return "ensembl";
            }
        }
        return "unknown";
    }

    private String getEnsemblDbName() {
        int selectedIndex = this.ensemblCategoryJComboBox.getSelectedIndex();
        switch (selectedIndex) {
            case 1: {
                return "fungi_mart_" + this.geneFactory.getCurrentEnsemblVersion("fungi");
            }
            case 2: {
                return "plants_mart_" + this.geneFactory.getCurrentEnsemblVersion("plants");
            }
            case 3: {
                return "protists_mart_" + this.geneFactory.getCurrentEnsemblVersion("protists");
            }
            case 4: {
                return "metazoa_mart_" + this.geneFactory.getCurrentEnsemblVersion("metazoa");
            }
            case 5: {
                return "default";
            }
        }
        return "unknown";
    }
}

