/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.renderers;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FragmentIonTableCellRenderer
implements TableCellRenderer {
    private Color backgroundColor;
    private Color foregroundColor;
    private ArrayList<Integer> indices;
    private DecimalFormat numberFormat;

    public FragmentIonTableCellRenderer(ArrayList<Integer> indices, Color background, Color foreground) {
        this.indices = indices;
        this.backgroundColor = background;
        this.foregroundColor = foreground;
        this.numberFormat = new DecimalFormat("0.00");
        this.numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = label.getBackground();
        label.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        label.setHorizontalAlignment(4);
        if (this.indices.contains(row) && !isSelected) {
            label.setBackground(this.backgroundColor);
            label.setForeground(this.foregroundColor);
        }
        if (value instanceof Double) {
            label.setText(this.numberFormat.format(value));
        }
        return label;
    }
}

