/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings.algorithm_settings;

import com.compomics.util.experiment.identification.identification_parameters.OmssaParameters;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class OmssaSettingsDialog
extends JDialog {
    private OmssaParameters omssaParameters;
    private boolean cancelled = false;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JComboBox cTermIonsCmb;
    private JLabel cTermIonsLbl;
    private JComboBox chargeEstimationCombo;
    private JLabel chargeReductionLabel;
    private JComboBox cleaveNterminalMethionineCmb;
    private JLabel cleaveNterminalMethionineLbl;
    private JButton closeButton;
    private JLabel consecutiveIonProbabilityLbl;
    private JTextField consecutiveIonProbabilityTxt;
    private JComboBox correlationCorrectionScoreCmb;
    private JLabel correlationCorrectionScoreLbl;
    private JPanel databaseProcessingPanel;
    private JLabel doublyChargedNPeaksLbl;
    private JTextField doublyChargedNpeaksTxt;
    private JLabel doublyChargedWindowWidthLbl;
    private JTextField doublyChargedWindowWidthTxt;
    private JLabel eValueLbl;
    private JComboBox eliminatePrecursorCombo;
    private JComboBox forwardIonsFirstCmb;
    private JLabel forwardIonsFirstLbl;
    private JLabel fractionChargeLbl;
    private JTextField fractionChargeTxt;
    private JLabel highIntensityLbl;
    private JTextField highIntensityTxt;
    private JLabel hitListLbl;
    private JTextField hitlistTxt;
    private JLabel intensityIncrementLbl;
    private JTextField intensityIncrementTxt;
    private JLabel iterativeReplaceEvalueLbl;
    private JTextField iterativeReplaceEvalueTxt;
    private JPanel iterativeSearchSettingsPanel;
    private JLabel iterativeSequenceEvalueLbl;
    private JTextField iterativeSequenceEvalueTxt;
    private JLabel iterativeSpectraEvalueLbl;
    private JTextField iterativeSpectraEvalueTxt;
    private JSeparator jSeparator1;
    private JLabel lowIntensityLbl;
    private JTextField lowIntensityTxt;
    private JTextField maxEvalueTxt;
    private JLabel maxFragmentChargeLbl;
    private JTextField maxFragmentChargeTxt;
    private JLabel maxFragmentsPerSeriesLbl;
    private JTextField maxFragmentsPerSeriesTxt;
    private JLabel maxLaddersLbl;
    private JTextField maxLaddersTxt;
    private JTextField maxPepLengthTxt;
    private JLabel minAnnotatedMostIntensePeaksLbl;
    private JTextField minAnnotatedMostIntensePeaksTxt;
    private JLabel minAnnotatedPeaksLbl;
    private JTextField minAnnotatedPeaksTxt;
    private JTextField minPepLengthTxt;
    private JTextField minPrecChargeMultipleChargedFragmentsTxt;
    private JLabel minPrecPerSpectrumLbl;
    private JTextField minPrecPerSpectrumTxt;
    private JLabel minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel;
    private JLabel nHitsPerSpectrumPerChargeLbl;
    private JTextField nHitsPerSpectrumPerChargeTxt;
    private JLabel nIsotopesLbl;
    private JTextField nIsotopesTxt;
    private JLabel nPeaksLbl;
    private JTextField nPeaksTxt;
    private JLabel neutronLbl;
    private JTextField neutronTxt;
    private JButton okButton;
    private JComboBox omssaOutputFormatComboBox;
    private JLabel omssaOutputFormatLabel;
    private JButton openDialogHelpJButton;
    private JPanel outputParametersPanel;
    private JLabel peptideLengthDividerLabel1;
    private JLabel peptideLengthJLabel;
    private JLabel plusOneChargeAutomaticLbl;
    private JComboBox plusOneChargeCmb;
    private JLabel precursorChargeEstimationLabel;
    private JLabel precursorMassScalingLabel;
    private JComboBox precursorScalingCombo;
    private JComboBox searchPositiveIonsCmb;
    private JLabel searchPositiveIonsLbl;
    private JPanel semiEnzymaticParametersPanel;
    private JComboBox sequenceMappingCmb;
    private JLabel sequenceMappingLbl;
    private JLabel singlyChargedNPeaksLbl;
    private JTextField singlyChargedNpeaksTxt;
    private JLabel singlyChargedWindowWidthLbl;
    private JTextField singlyChargedWindowWidthTxt;
    private JPanel spectrumProcessingPanel;
    private JTabbedPane tabbedPane;

    public OmssaSettingsDialog(Frame parent, OmssaParameters omssaParameters) {
        super(parent, true);
        this.omssaParameters = omssaParameters;
        this.initComponents();
        this.setUpGui();
        this.fillGUI();
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.eliminatePrecursorCombo.setRenderer(new AlignedListCellRenderer(0));
        this.chargeEstimationCombo.setRenderer(new AlignedListCellRenderer(0));
        this.plusOneChargeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.precursorScalingCombo.setRenderer(new AlignedListCellRenderer(0));
        this.sequenceMappingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.cleaveNterminalMethionineCmb.setRenderer(new AlignedListCellRenderer(0));
        this.searchPositiveIonsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.forwardIonsFirstCmb.setRenderer(new AlignedListCellRenderer(0));
        this.cTermIonsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.correlationCorrectionScoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.omssaOutputFormatComboBox.setRenderer(new AlignedListCellRenderer(0));
    }

    private void fillGUI() {
        if (this.omssaParameters.getLowIntensityCutOff() != null) {
            this.lowIntensityTxt.setText(this.omssaParameters.getLowIntensityCutOff() + "");
        }
        if (this.omssaParameters.getHighIntensityCutOff() != null) {
            this.highIntensityTxt.setText(this.omssaParameters.getHighIntensityCutOff() + "");
        }
        if (this.omssaParameters.getIntensityCutOffIncrement() != null) {
            this.intensityIncrementTxt.setText(this.omssaParameters.getIntensityCutOffIncrement() + "");
        }
        if (this.omssaParameters.getMinPeaks() != null) {
            this.nPeaksTxt.setText(this.omssaParameters.getMinPeaks() + "");
        }
        if (this.omssaParameters.isRemovePrecursor() != null) {
            if (this.omssaParameters.isRemovePrecursor().booleanValue()) {
                this.eliminatePrecursorCombo.setSelectedIndex(0);
            } else {
                this.eliminatePrecursorCombo.setSelectedIndex(1);
            }
        }
        if (this.omssaParameters.isEstimateCharge() != null) {
            if (this.omssaParameters.isEstimateCharge().booleanValue()) {
                this.chargeEstimationCombo.setSelectedIndex(0);
            } else {
                this.chargeEstimationCombo.setSelectedIndex(1);
            }
        }
        if (this.omssaParameters.isDetermineChargePlusOneAlgorithmically() != null) {
            if (this.omssaParameters.isDetermineChargePlusOneAlgorithmically().booleanValue()) {
                this.plusOneChargeCmb.setSelectedIndex(0);
            } else {
                this.plusOneChargeCmb.setSelectedIndex(1);
            }
        }
        if (this.omssaParameters.getFractionOfPeaksForChargeEstimation() != null) {
            this.fractionChargeTxt.setText(this.omssaParameters.getFractionOfPeaksForChargeEstimation() + "");
        }
        if (this.omssaParameters.getMinPrecPerSpectrum() != null) {
            this.minPrecPerSpectrumTxt.setText(this.omssaParameters.getMinPrecPerSpectrum() + "");
        }
        if (this.omssaParameters.isScalePrecursor() != null) {
            if (this.omssaParameters.isScalePrecursor().booleanValue()) {
                this.precursorScalingCombo.setSelectedIndex(0);
            } else {
                this.precursorScalingCombo.setSelectedIndex(1);
            }
        } else {
            this.precursorScalingCombo.setSelectedIndex(1);
        }
        if (this.omssaParameters.isMemoryMappedSequenceLibraries() != null) {
            if (this.omssaParameters.isMemoryMappedSequenceLibraries().booleanValue()) {
                this.sequenceMappingCmb.setSelectedIndex(0);
            } else {
                this.sequenceMappingCmb.setSelectedIndex(1);
            }
        } else {
            this.sequenceMappingCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.isCleaveNterMethionine() != null) {
            if (this.omssaParameters.isCleaveNterMethionine().booleanValue()) {
                this.cleaveNterminalMethionineCmb.setSelectedIndex(0);
            } else {
                this.cleaveNterminalMethionineCmb.setSelectedIndex(1);
            }
        } else {
            this.cleaveNterminalMethionineCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(this.omssaParameters.getMinPeptideLength() + "");
        }
        if (this.omssaParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(this.omssaParameters.getMaxPeptideLength() + "");
        }
        if (this.omssaParameters.getMaxEValue() != null) {
            this.maxEvalueTxt.setText(this.omssaParameters.getMaxEValue() + "");
        }
        if (this.omssaParameters.getHitListLength() != null) {
            this.hitlistTxt.setText(this.omssaParameters.getHitListLength() + "");
        }
        this.omssaOutputFormatComboBox.setSelectedItem(this.omssaParameters.getSelectedOutput());
        if (this.omssaParameters.getMinimalChargeForMultipleChargedFragments() != null) {
            this.minPrecChargeMultipleChargedFragmentsTxt.setText(this.omssaParameters.getMinimalChargeForMultipleChargedFragments().value + "");
        }
        if (this.omssaParameters.getNumberOfItotopicPeaks() != null) {
            this.nIsotopesTxt.setText(this.omssaParameters.getNumberOfItotopicPeaks() + "");
        }
        if (this.omssaParameters.getNeutronThreshold() != null) {
            this.neutronTxt.setText(this.omssaParameters.getNeutronThreshold() + "");
        }
        if (this.omssaParameters.getSingleChargeWindow() != null) {
            this.singlyChargedWindowWidthTxt.setText(this.omssaParameters.getSingleChargeWindow() + "");
        }
        if (this.omssaParameters.getDoubleChargeWindow() != null) {
            this.doublyChargedWindowWidthTxt.setText(this.omssaParameters.getDoubleChargeWindow() + "");
        }
        if (this.omssaParameters.getnPeaksInSingleChargeWindow() != null) {
            this.singlyChargedNpeaksTxt.setText(this.omssaParameters.getnPeaksInSingleChargeWindow() + "");
        }
        if (this.omssaParameters.getnPeaksInDoubleChargeWindow() != null) {
            this.doublyChargedNpeaksTxt.setText(this.omssaParameters.getnPeaksInDoubleChargeWindow() + "");
        }
        if (this.omssaParameters.getnAnnotatedMostIntensePeaks() != null) {
            this.minAnnotatedMostIntensePeaksTxt.setText(this.omssaParameters.getnAnnotatedMostIntensePeaks() + "");
        }
        if (this.omssaParameters.getnAnnotatedMostIntensePeaks() != null) {
            this.minAnnotatedPeaksTxt.setText(this.omssaParameters.getMinAnnotatedPeaks() + "");
        }
        if (this.omssaParameters.getMaxMzLadders() != null) {
            this.maxLaddersTxt.setText(this.omssaParameters.getMaxMzLadders() + "");
        }
        if (this.omssaParameters.getMaxFragmentCharge() != null) {
            this.maxFragmentChargeTxt.setText(this.omssaParameters.getMaxFragmentCharge() + "");
        }
        if (this.omssaParameters.isSearchPositiveIons() != null) {
            if (this.omssaParameters.isSearchPositiveIons().booleanValue()) {
                this.searchPositiveIonsCmb.setSelectedIndex(0);
            } else {
                this.searchPositiveIonsCmb.setSelectedIndex(1);
            }
        } else {
            this.searchPositiveIonsCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.isSearchForwardFragmentFirst() != null) {
            if (this.omssaParameters.isSearchForwardFragmentFirst().booleanValue()) {
                this.forwardIonsFirstCmb.setSelectedIndex(0);
            } else {
                this.forwardIonsFirstCmb.setSelectedIndex(1);
            }
        } else {
            this.forwardIonsFirstCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.isSearchRewindFragments() != null) {
            if (this.omssaParameters.isSearchRewindFragments().booleanValue()) {
                this.cTermIonsCmb.setSelectedIndex(0);
            } else {
                this.cTermIonsCmb.setSelectedIndex(1);
            }
        } else {
            this.cTermIonsCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.getMaxFragmentPerSeries() != null) {
            this.maxFragmentsPerSeriesTxt.setText(this.omssaParameters.getMaxFragmentPerSeries() + "");
        }
        if (this.omssaParameters.isUseCorrelationCorrectionScore() != null) {
            if (this.omssaParameters.isUseCorrelationCorrectionScore().booleanValue()) {
                this.correlationCorrectionScoreCmb.setSelectedIndex(0);
            } else {
                this.correlationCorrectionScoreCmb.setSelectedIndex(1);
            }
        } else {
            this.correlationCorrectionScoreCmb.setSelectedIndex(1);
        }
        if (this.omssaParameters.getConsecutiveIonProbability() != null) {
            this.consecutiveIonProbabilityTxt.setText(this.omssaParameters.getConsecutiveIonProbability() + "");
        }
        if (this.omssaParameters.getIterativeSequenceEvalue() != null) {
            this.iterativeSequenceEvalueTxt.setText(this.omssaParameters.getIterativeSequenceEvalue() + "");
        }
        if (this.omssaParameters.getIterativeSpectrumEvalue() != null) {
            this.iterativeSpectraEvalueTxt.setText(this.omssaParameters.getIterativeSpectrumEvalue() + "");
        }
        if (this.omssaParameters.getIterativeReplaceEvalue() != null) {
            this.iterativeReplaceEvalueTxt.setText(this.omssaParameters.getIterativeReplaceEvalue() + "");
        }
        if (this.omssaParameters.getMaxHitsPerSpectrumPerCharge() != null) {
            this.nHitsPerSpectrumPerChargeTxt.setText(this.omssaParameters.getMaxHitsPerSpectrumPerCharge() + "");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public OmssaParameters getInput() {
        OmssaParameters tempOmssaParameters = new OmssaParameters();
        String input = this.lowIntensityTxt.getText().trim();
        tempOmssaParameters.setLowIntensityCutOff(new Double(input));
        input = this.highIntensityTxt.getText().trim();
        tempOmssaParameters.setHighIntensityCutOff(new Double(input));
        input = this.intensityIncrementTxt.getText().trim();
        tempOmssaParameters.setIntensityCutOffIncrement(new Double(input));
        input = this.nPeaksTxt.getText().trim();
        tempOmssaParameters.setIntensityCutOffIncrement(new Double(input));
        tempOmssaParameters.setRemovePrecursor(this.eliminatePrecursorCombo.getSelectedIndex() == 0);
        tempOmssaParameters.setEstimateCharge(this.chargeEstimationCombo.getSelectedIndex() == 0);
        tempOmssaParameters.setDetermineChargePlusOneAlgorithmically(this.plusOneChargeCmb.getSelectedIndex() == 0);
        input = this.fractionChargeTxt.getText().trim();
        tempOmssaParameters.setFractionOfPeaksForChargeEstimation(new Double(input));
        input = this.minPrecPerSpectrumTxt.getText().trim();
        tempOmssaParameters.setMinPrecPerSpectrum(new Integer(input));
        tempOmssaParameters.setScalePrecursor(this.precursorScalingCombo.getSelectedIndex() == 0);
        tempOmssaParameters.setMemoryMappedSequenceLibraries(this.sequenceMappingCmb.getSelectedIndex() == 0);
        tempOmssaParameters.setCleaveNterMethionine(this.cleaveNterminalMethionineCmb.getSelectedIndex() == 0);
        input = this.minPepLengthTxt.getText().trim();
        if (!input.equals("")) {
            tempOmssaParameters.setMinPeptideLength(new Integer(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            tempOmssaParameters.setMaxPeptideLength(new Integer(input));
        }
        input = this.maxEvalueTxt.getText().trim();
        tempOmssaParameters.setMaxEValue(new Double(input));
        input = this.hitlistTxt.getText().trim();
        tempOmssaParameters.setHitListLength(new Integer(input));
        tempOmssaParameters.setSelectedOutput(this.omssaOutputFormatComboBox.getSelectedItem().toString());
        input = this.minPrecChargeMultipleChargedFragmentsTxt.getText().trim();
        int charge = new Integer(input);
        tempOmssaParameters.setMinimalChargeForMultipleChargedFragments(new Charge(1, charge));
        input = this.nIsotopesTxt.getText().trim();
        tempOmssaParameters.setNumberOfItotopicPeaks(new Integer(input));
        input = this.neutronTxt.getText().trim();
        tempOmssaParameters.setNeutronThreshold(new Double(input));
        input = this.singlyChargedWindowWidthTxt.getText().trim();
        tempOmssaParameters.setSingleChargeWindow(new Integer(input));
        input = this.doublyChargedWindowWidthTxt.getText().trim();
        tempOmssaParameters.setDoubleChargeWindow(new Integer(input));
        input = this.singlyChargedNpeaksTxt.getText().trim();
        tempOmssaParameters.setnPeaksInSingleChargeWindow(new Integer(input));
        input = this.doublyChargedNpeaksTxt.getText().trim();
        tempOmssaParameters.setnPeaksInDoubleChargeWindow(new Integer(input));
        input = this.minAnnotatedMostIntensePeaksTxt.getText().trim();
        tempOmssaParameters.setnAnnotatedMostIntensePeaks(new Integer(input));
        input = this.minAnnotatedPeaksTxt.getText().trim();
        tempOmssaParameters.setMinAnnotatedPeaks(new Integer(input));
        input = this.nHitsPerSpectrumPerChargeTxt.getText().trim();
        tempOmssaParameters.setMaxHitsPerSpectrumPerCharge(new Integer(input));
        input = this.maxLaddersTxt.getText().trim();
        tempOmssaParameters.setMaxMzLadders(new Integer(input));
        input = this.maxFragmentChargeTxt.getText().trim();
        tempOmssaParameters.setMaxFragmentCharge(new Integer(input));
        tempOmssaParameters.setSearchPositiveIons(this.searchPositiveIonsCmb.getSelectedIndex() == 0);
        tempOmssaParameters.setSearchForwardFragmentFirst(this.forwardIonsFirstCmb.getSelectedIndex() == 0);
        tempOmssaParameters.setSearchRewindFragments(this.cTermIonsCmb.getSelectedIndex() == 0);
        input = this.maxFragmentsPerSeriesTxt.getText().trim();
        tempOmssaParameters.setMaxFragmentPerSeries(new Integer(input));
        tempOmssaParameters.setUseCorrelationCorrectionScore(this.correlationCorrectionScoreCmb.getSelectedIndex() == 0);
        input = this.consecutiveIonProbabilityTxt.getText().trim();
        tempOmssaParameters.setConsecutiveIonProbability(new Double(input));
        input = this.iterativeSequenceEvalueTxt.getText().trim();
        tempOmssaParameters.setIterativeSequenceEvalue(new Double(input));
        input = this.iterativeSpectraEvalueTxt.getText().trim();
        tempOmssaParameters.setIterativeSpectrumEvalue(new Double(input));
        input = this.iterativeReplaceEvalueTxt.getText().trim();
        tempOmssaParameters.setIterativeReplaceEvalue(new Double(input));
        return tempOmssaParameters;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.openDialogHelpJButton = new JButton();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.spectrumProcessingPanel = new JPanel();
        this.lowIntensityLbl = new JLabel();
        this.highIntensityLbl = new JLabel();
        this.intensityIncrementLbl = new JLabel();
        this.lowIntensityTxt = new JTextField();
        this.nPeaksLbl = new JLabel();
        this.highIntensityTxt = new JTextField();
        this.intensityIncrementTxt = new JTextField();
        this.nPeaksTxt = new JTextField();
        this.chargeReductionLabel = new JLabel();
        this.eliminatePrecursorCombo = new JComboBox();
        this.chargeEstimationCombo = new JComboBox();
        this.precursorChargeEstimationLabel = new JLabel();
        this.plusOneChargeCmb = new JComboBox();
        this.plusOneChargeAutomaticLbl = new JLabel();
        this.fractionChargeLbl = new JLabel();
        this.fractionChargeTxt = new JTextField();
        this.minPrecPerSpectrumLbl = new JLabel();
        this.minPrecPerSpectrumTxt = new JTextField();
        this.precursorMassScalingLabel = new JLabel();
        this.precursorScalingCombo = new JComboBox();
        this.databaseProcessingPanel = new JPanel();
        this.sequenceMappingLbl = new JLabel();
        this.sequenceMappingCmb = new JComboBox();
        this.cleaveNterminalMethionineCmb = new JComboBox();
        this.cleaveNterminalMethionineLbl = new JLabel();
        this.semiEnzymaticParametersPanel = new JPanel();
        this.maxPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel1 = new JLabel();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthJLabel = new JLabel();
        this.iterativeSearchSettingsPanel = new JPanel();
        this.iterativeSequenceEvalueLbl = new JLabel();
        this.iterativeSequenceEvalueTxt = new JTextField();
        this.iterativeSpectraEvalueLbl = new JLabel();
        this.iterativeSpectraEvalueTxt = new JTextField();
        this.iterativeReplaceEvalueLbl = new JLabel();
        this.iterativeReplaceEvalueTxt = new JTextField();
        this.advancedSearchSettingsPanel = new JPanel();
        this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel = new JLabel();
        this.minPrecChargeMultipleChargedFragmentsTxt = new JTextField();
        this.nIsotopesLbl = new JLabel();
        this.nIsotopesTxt = new JTextField();
        this.neutronLbl = new JLabel();
        this.neutronTxt = new JTextField();
        this.singlyChargedWindowWidthLbl = new JLabel();
        this.singlyChargedWindowWidthTxt = new JTextField();
        this.doublyChargedWindowWidthLbl = new JLabel();
        this.doublyChargedWindowWidthTxt = new JTextField();
        this.singlyChargedNpeaksTxt = new JTextField();
        this.singlyChargedNPeaksLbl = new JLabel();
        this.doublyChargedNPeaksLbl = new JLabel();
        this.doublyChargedNpeaksTxt = new JTextField();
        this.minAnnotatedMostIntensePeaksLbl = new JLabel();
        this.minAnnotatedMostIntensePeaksTxt = new JTextField();
        this.minAnnotatedPeaksLbl = new JLabel();
        this.minAnnotatedPeaksTxt = new JTextField();
        this.maxLaddersLbl = new JLabel();
        this.maxLaddersTxt = new JTextField();
        this.maxFragmentChargeTxt = new JTextField();
        this.maxFragmentChargeLbl = new JLabel();
        this.searchPositiveIonsLbl = new JLabel();
        this.searchPositiveIonsCmb = new JComboBox();
        this.forwardIonsFirstLbl = new JLabel();
        this.forwardIonsFirstCmb = new JComboBox();
        this.cTermIonsLbl = new JLabel();
        this.cTermIonsCmb = new JComboBox();
        this.maxFragmentsPerSeriesLbl = new JLabel();
        this.maxFragmentsPerSeriesTxt = new JTextField();
        this.correlationCorrectionScoreCmb = new JComboBox();
        this.correlationCorrectionScoreLbl = new JLabel();
        this.consecutiveIonProbabilityTxt = new JTextField();
        this.consecutiveIonProbabilityLbl = new JLabel();
        this.nHitsPerSpectrumPerChargeLbl = new JLabel();
        this.nHitsPerSpectrumPerChargeTxt = new JTextField();
        this.outputParametersPanel = new JPanel();
        this.omssaOutputFormatComboBox = new JComboBox();
        this.omssaOutputFormatLabel = new JLabel();
        this.eValueLbl = new JLabel();
        this.hitListLbl = new JLabel();
        this.maxEvalueTxt = new JTextField();
        this.hitlistTxt = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced OMSSA Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OmssaSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OmssaSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Note: The advanced settings are for expert use only. See the help for details.");
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setOpaque(true);
        this.spectrumProcessingPanel.setBackground(new Color(230, 230, 230));
        this.spectrumProcessingPanel.setPreferredSize(new Dimension(518, 143));
        this.lowIntensityLbl.setText("Low Intensity Cutoff (percent of most intense peak)");
        this.highIntensityLbl.setText("High Intensity Cutoff (percent of most intense peak)");
        this.intensityIncrementLbl.setText("Intensity Cutoff Increment");
        this.lowIntensityTxt.setHorizontalAlignment(0);
        this.lowIntensityTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.lowIntensityTxtKeyReleased(evt);
            }
        });
        this.nPeaksLbl.setText("Minimal Number of Peaks");
        this.highIntensityTxt.setHorizontalAlignment(0);
        this.highIntensityTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.highIntensityTxtKeyReleased(evt);
            }
        });
        this.intensityIncrementTxt.setHorizontalAlignment(0);
        this.intensityIncrementTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.intensityIncrementTxtKeyReleased(evt);
            }
        });
        this.nPeaksTxt.setHorizontalAlignment(0);
        this.nPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.nPeaksTxtKeyReleased(evt);
            }
        });
        this.chargeReductionLabel.setText("Eliminate Charge Reduced Precursors in Spectra");
        this.eliminatePrecursorCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.chargeEstimationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.precursorChargeEstimationLabel.setText("Precursor Charge Estimation");
        this.plusOneChargeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.plusOneChargeAutomaticLbl.setText("Plus One Charge Estimated Algorithmically");
        this.fractionChargeLbl.setText("Fraction of Precursor m/z for Charge One Estimation");
        this.fractionChargeTxt.setHorizontalAlignment(0);
        this.fractionChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.fractionChargeTxtKeyReleased(evt);
            }
        });
        this.minPrecPerSpectrumLbl.setText("Minimal Number of Precursors per Spectrum");
        this.minPrecPerSpectrumTxt.setHorizontalAlignment(0);
        this.minPrecPerSpectrumTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.minPrecPerSpectrumTxtKeyReleased(evt);
            }
        });
        this.precursorMassScalingLabel.setText("Precursor Mass Scaling");
        this.precursorScalingCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout spectrumProcessingPanelLayout = new GroupLayout(this.spectrumProcessingPanel);
        this.spectrumProcessingPanel.setLayout(spectrumProcessingPanelLayout);
        spectrumProcessingPanelLayout.setHorizontalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intensityIncrementLbl, -2, 370, -2).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.nPeaksLbl, GroupLayout.Alignment.LEADING, -1, 370, Short.MAX_VALUE).addComponent(this.chargeReductionLabel, GroupLayout.Alignment.LEADING, -1, 370, Short.MAX_VALUE)).addComponent(this.highIntensityLbl, -2, 370, -2).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.minPrecPerSpectrumLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fractionChargeLbl, -1, -1, Short.MAX_VALUE).addComponent(this.plusOneChargeAutomaticLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.precursorChargeEstimationLabel, GroupLayout.Alignment.LEADING, -1, 370, Short.MAX_VALUE)).addComponent(this.lowIntensityLbl, -2, 370, -2).addComponent(this.precursorMassScalingLabel, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lowIntensityTxt).addComponent(this.highIntensityTxt, GroupLayout.Alignment.TRAILING, -1, 179, Short.MAX_VALUE).addComponent(this.nPeaksTxt, GroupLayout.Alignment.TRAILING, -1, 179, Short.MAX_VALUE).addComponent(this.eliminatePrecursorCombo, GroupLayout.Alignment.TRAILING, 0, 179, Short.MAX_VALUE).addComponent(this.chargeEstimationCombo, GroupLayout.Alignment.TRAILING, 0, 179, Short.MAX_VALUE).addComponent(this.plusOneChargeCmb, GroupLayout.Alignment.TRAILING, 0, 179, Short.MAX_VALUE).addComponent(this.fractionChargeTxt, GroupLayout.Alignment.TRAILING, -1, 179, Short.MAX_VALUE).addComponent(this.minPrecPerSpectrumTxt, GroupLayout.Alignment.TRAILING, -1, 179, Short.MAX_VALUE).addComponent(this.intensityIncrementTxt, GroupLayout.Alignment.TRAILING, -1, 179, Short.MAX_VALUE).addComponent(this.precursorScalingCombo, GroupLayout.Alignment.TRAILING, 0, 179, Short.MAX_VALUE)).addGap(25, 25, 25)));
        spectrumProcessingPanelLayout.setVerticalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lowIntensityLbl).addComponent(this.lowIntensityTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highIntensityLbl).addComponent(this.highIntensityTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intensityIncrementLbl).addComponent(this.intensityIncrementTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nPeaksLbl).addComponent(this.nPeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chargeReductionLabel).addComponent(this.eliminatePrecursorCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precursorChargeEstimationLabel).addComponent(this.chargeEstimationCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.plusOneChargeAutomaticLbl).addComponent(this.plusOneChargeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fractionChargeLbl).addComponent(this.fractionChargeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.minPrecPerSpectrumLbl).addComponent(this.minPrecPerSpectrumTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precursorScalingCombo, -2, -1, -2).addComponent(this.precursorMassScalingLabel)).addContainerGap(318, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Spectrum", this.spectrumProcessingPanel);
        this.databaseProcessingPanel.setBackground(new Color(230, 230, 230));
        this.sequenceMappingLbl.setText("Sequences Mapping in Memory");
        this.sequenceMappingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.cleaveNterminalMethionineCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.cleaveNterminalMethionineLbl.setText("Cleave N-terminal Methionine");
        GroupLayout databaseProcessingPanelLayout = new GroupLayout(this.databaseProcessingPanel);
        this.databaseProcessingPanel.setLayout(databaseProcessingPanelLayout);
        databaseProcessingPanelLayout.setHorizontalGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceMappingLbl, -2, 370, -2).addComponent(this.cleaveNterminalMethionineLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cleaveNterminalMethionineCmb, 0, 180, Short.MAX_VALUE).addComponent(this.sequenceMappingCmb, 0, 180, Short.MAX_VALUE)).addGap(25, 25, 25)));
        databaseProcessingPanelLayout.setVerticalGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, databaseProcessingPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sequenceMappingLbl).addComponent(this.sequenceMappingCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databaseProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cleaveNterminalMethionineLbl).addComponent(this.cleaveNterminalMethionineCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Database", this.databaseProcessingPanel);
        this.semiEnzymaticParametersPanel.setBackground(new Color(230, 230, 230));
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel1.setText("-");
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthJLabel.setText("Peptide Length (min - max)");
        GroupLayout semiEnzymaticParametersPanelLayout = new GroupLayout(this.semiEnzymaticParametersPanel);
        this.semiEnzymaticParametersPanel.setLayout(semiEnzymaticParametersPanelLayout);
        semiEnzymaticParametersPanelLayout.setHorizontalGroup(semiEnzymaticParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, semiEnzymaticParametersPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.peptideLengthJLabel, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPepLengthTxt, -1, 84, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel1, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPepLengthTxt, -1, 84, Short.MAX_VALUE).addGap(25, 25, 25)));
        semiEnzymaticParametersPanelLayout.setVerticalGroup(semiEnzymaticParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(semiEnzymaticParametersPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(semiEnzymaticParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideLengthJLabel).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Semi-Enzymatic", this.semiEnzymaticParametersPanel);
        this.iterativeSearchSettingsPanel.setBackground(new Color(230, 230, 230));
        this.iterativeSequenceEvalueLbl.setText("E-value Cutoff for Sequences (0 means all)");
        this.iterativeSequenceEvalueTxt.setHorizontalAlignment(0);
        this.iterativeSequenceEvalueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.iterativeSequenceEvalueTxtKeyReleased(evt);
            }
        });
        this.iterativeSpectraEvalueLbl.setText("E-value Cutoff for Spectra (0 means all)");
        this.iterativeSpectraEvalueTxt.setHorizontalAlignment(0);
        this.iterativeSpectraEvalueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.iterativeSpectraEvalueTxtKeyReleased(evt);
            }
        });
        this.iterativeReplaceEvalueLbl.setText("E-value Cutoff to Replace a Hit (0 means keep best)");
        this.iterativeReplaceEvalueTxt.setHorizontalAlignment(0);
        this.iterativeReplaceEvalueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.iterativeReplaceEvalueTxtKeyReleased(evt);
            }
        });
        GroupLayout iterativeSearchSettingsPanelLayout = new GroupLayout(this.iterativeSearchSettingsPanel);
        this.iterativeSearchSettingsPanel.setLayout(iterativeSearchSettingsPanelLayout);
        iterativeSearchSettingsPanelLayout.setHorizontalGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iterativeSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterativeSequenceEvalueLbl, -2, 370, -2).addComponent(this.iterativeSpectraEvalueLbl, -2, 374, -2).addComponent(this.iterativeReplaceEvalueLbl, -2, 374, -2)).addGap(0, 0, 0).addGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterativeReplaceEvalueTxt, -1, 180, Short.MAX_VALUE).addComponent(this.iterativeSequenceEvalueTxt, GroupLayout.Alignment.TRAILING).addComponent(this.iterativeSpectraEvalueTxt, GroupLayout.Alignment.TRAILING)).addGap(25, 25, 25)));
        iterativeSearchSettingsPanelLayout.setVerticalGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iterativeSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterativeSequenceEvalueLbl).addComponent(this.iterativeSequenceEvalueTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterativeSpectraEvalueLbl).addComponent(this.iterativeSpectraEvalueTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(iterativeSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterativeReplaceEvalueLbl).addComponent(this.iterativeReplaceEvalueTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Iterative Search", this.iterativeSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setPreferredSize(new Dimension(518, 143));
        this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setText("Minimum Precursor Charge for Multiply Charged Fragments");
        this.minPrecChargeMultipleChargedFragmentsTxt.setHorizontalAlignment(0);
        this.minPrecChargeMultipleChargedFragmentsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.minPrecChargeMultipleChargedFragmentsTxtKeyReleased(evt);
            }
        });
        this.nIsotopesLbl.setText("Number of Isotopes");
        this.nIsotopesTxt.setHorizontalAlignment(0);
        this.nIsotopesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.nIsotopesTxtKeyReleased(evt);
            }
        });
        this.neutronLbl.setText("Mass Threshold to Consider Exact Neutron Mass");
        this.neutronTxt.setHorizontalAlignment(0);
        this.neutronTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.neutronTxtKeyReleased(evt);
            }
        });
        this.singlyChargedWindowWidthLbl.setText("Singly Charged Window Width (Da)");
        this.singlyChargedWindowWidthTxt.setHorizontalAlignment(0);
        this.singlyChargedWindowWidthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.singlyChargedWindowWidthTxtKeyReleased(evt);
            }
        });
        this.doublyChargedWindowWidthLbl.setText("Doubly Charged Window Width (Da)");
        this.doublyChargedWindowWidthTxt.setHorizontalAlignment(0);
        this.doublyChargedWindowWidthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.doublyChargedWindowWidthTxtKeyReleased(evt);
            }
        });
        this.singlyChargedNpeaksTxt.setHorizontalAlignment(0);
        this.singlyChargedNpeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.singlyChargedNpeaksTxtKeyReleased(evt);
            }
        });
        this.singlyChargedNPeaksLbl.setText("Number of Peaks in Singly Charged Windows");
        this.doublyChargedNPeaksLbl.setText("Number of Peaks in Doubly Charged Windows");
        this.doublyChargedNpeaksTxt.setHorizontalAlignment(0);
        this.doublyChargedNpeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.doublyChargedNpeaksTxtKeyReleased(evt);
            }
        });
        this.minAnnotatedMostIntensePeaksLbl.setText("Minimum Annotated Peaks Among the Most Intense Ones");
        this.minAnnotatedMostIntensePeaksTxt.setHorizontalAlignment(0);
        this.minAnnotatedMostIntensePeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.minAnnotatedMostIntensePeaksTxtKeyReleased(evt);
            }
        });
        this.minAnnotatedPeaksLbl.setText("Minimum Number of Annotated Peaks");
        this.minAnnotatedPeaksTxt.setHorizontalAlignment(0);
        this.minAnnotatedPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.minAnnotatedPeaksTxtKeyReleased(evt);
            }
        });
        this.maxLaddersLbl.setText("Maximum m/z Ladders");
        this.maxLaddersTxt.setHorizontalAlignment(0);
        this.maxLaddersTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.maxLaddersTxtKeyReleased(evt);
            }
        });
        this.maxFragmentChargeTxt.setHorizontalAlignment(0);
        this.maxFragmentChargeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.maxFragmentChargeTxtActionPerformed(evt);
            }
        });
        this.maxFragmentChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.maxFragmentChargeTxtKeyReleased(evt);
            }
        });
        this.maxFragmentChargeLbl.setText("Maximum Fragment Charge");
        this.searchPositiveIonsLbl.setText("Search Positive Ions");
        this.searchPositiveIonsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.forwardIonsFirstLbl.setText("Search Forward Ions First");
        this.forwardIonsFirstCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.cTermIonsLbl.setText("Search Rewind (C-terminal) Ions");
        this.cTermIonsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxFragmentsPerSeriesLbl.setText("Maximum Fragments per Series");
        this.maxFragmentsPerSeriesTxt.setHorizontalAlignment(0);
        this.maxFragmentsPerSeriesTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.maxFragmentsPerSeriesTxtActionPerformed(evt);
            }
        });
        this.maxFragmentsPerSeriesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.maxFragmentsPerSeriesTxtKeyReleased(evt);
            }
        });
        this.correlationCorrectionScoreCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.correlationCorrectionScoreLbl.setText("Use Correlation Correction Score");
        this.consecutiveIonProbabilityTxt.setHorizontalAlignment(0);
        this.consecutiveIonProbabilityTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.consecutiveIonProbabilityTxtActionPerformed(evt);
            }
        });
        this.consecutiveIonProbabilityTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.consecutiveIonProbabilityTxtKeyReleased(evt);
            }
        });
        this.consecutiveIonProbabilityLbl.setText("Consecutive Ion Probability");
        this.nHitsPerSpectrumPerChargeLbl.setText("Number of Hits per Spectrum per Charge");
        this.nHitsPerSpectrumPerChargeTxt.setHorizontalAlignment(0);
        this.nHitsPerSpectrumPerChargeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.nHitsPerSpectrumPerChargeTxtActionPerformed(evt);
            }
        });
        this.nHitsPerSpectrumPerChargeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.nHitsPerSpectrumPerChargeTxtKeyReleased(evt);
            }
        });
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPrecChargeMultipleChargedFragmentsTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.nIsotopesLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nIsotopesTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.neutronLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neutronTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.singlyChargedWindowWidthLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singlyChargedWindowWidthTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.doublyChargedWindowWidthLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doublyChargedWindowWidthTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.singlyChargedNPeaksLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singlyChargedNpeaksTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.doublyChargedNPeaksLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doublyChargedNpeaksTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.minAnnotatedMostIntensePeaksLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minAnnotatedMostIntensePeaksTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.minAnnotatedPeaksLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minAnnotatedPeaksTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxLaddersLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxLaddersTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxFragmentChargeLbl, -2, 370, -2).addComponent(this.searchPositiveIonsLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchPositiveIonsCmb, 0, 180, Short.MAX_VALUE).addComponent(this.maxFragmentChargeTxt, -1, 180, Short.MAX_VALUE))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.forwardIonsFirstLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.forwardIonsFirstCmb, 0, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.cTermIonsLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cTermIonsCmb, 0, 180, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxFragmentsPerSeriesLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxFragmentsPerSeriesTxt, -1, 180, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.correlationCorrectionScoreLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.correlationCorrectionScoreCmb, 0, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.consecutiveIonProbabilityLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consecutiveIonProbabilityTxt, -1, 180, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.nHitsPerSpectrumPerChargeLbl, -2, 370, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nHitsPerSpectrumPerChargeTxt, -1, 180, Short.MAX_VALUE))).addGap(25, 25, 25)));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel).addComponent(this.minPrecChargeMultipleChargedFragmentsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nIsotopesLbl).addComponent(this.nIsotopesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutronLbl).addComponent(this.neutronTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singlyChargedWindowWidthLbl).addComponent(this.singlyChargedWindowWidthTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doublyChargedWindowWidthLbl).addComponent(this.doublyChargedWindowWidthTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singlyChargedNPeaksLbl).addComponent(this.singlyChargedNpeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.doublyChargedNPeaksLbl).addComponent(this.doublyChargedNpeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minAnnotatedMostIntensePeaksLbl).addComponent(this.minAnnotatedMostIntensePeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minAnnotatedPeaksLbl).addComponent(this.minAnnotatedPeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLaddersLbl).addComponent(this.maxLaddersTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxFragmentChargeLbl).addComponent(this.maxFragmentChargeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchPositiveIonsLbl).addComponent(this.searchPositiveIonsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.forwardIonsFirstLbl).addComponent(this.forwardIonsFirstCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cTermIonsLbl).addComponent(this.cTermIonsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxFragmentsPerSeriesLbl).addComponent(this.maxFragmentsPerSeriesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.correlationCorrectionScoreLbl).addComponent(this.correlationCorrectionScoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.consecutiveIonProbabilityLbl).addComponent(this.consecutiveIonProbabilityTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nHitsPerSpectrumPerChargeLbl).addComponent(this.nHitsPerSpectrumPerChargeTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Advanced Search", this.advancedSearchSettingsPanel);
        this.outputParametersPanel.setBackground(new Color(230, 230, 230));
        this.omssaOutputFormatComboBox.setModel(new DefaultComboBoxModel<String>(OmssaParameters.getOmssaOutputTypes()));
        this.omssaOutputFormatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaSettingsDialog.this.omssaOutputFormatComboBoxActionPerformed(evt);
            }
        });
        this.omssaOutputFormatLabel.setText("OMSSA Output Format");
        this.eValueLbl.setText("E-value Cutoff");
        this.hitListLbl.setText("Maximum HitList Length (0 means all)");
        this.maxEvalueTxt.setHorizontalAlignment(0);
        this.maxEvalueTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.maxEvalueTxtKeyReleased(evt);
            }
        });
        this.hitlistTxt.setHorizontalAlignment(0);
        this.hitlistTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaSettingsDialog.this.hitlistTxtKeyReleased(evt);
            }
        });
        GroupLayout outputParametersPanelLayout = new GroupLayout(this.outputParametersPanel);
        this.outputParametersPanel.setLayout(outputParametersPanelLayout);
        outputParametersPanelLayout.setHorizontalGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputParametersPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.omssaOutputFormatLabel, -2, 370, -2).addComponent(this.hitListLbl, -2, 370, -2).addComponent(this.eValueLbl, -2, 370, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hitlistTxt, -1, 180, Short.MAX_VALUE).addComponent(this.maxEvalueTxt, -1, 180, Short.MAX_VALUE).addComponent(this.omssaOutputFormatComboBox, 0, 180, Short.MAX_VALUE)).addGap(25, 25, 25)));
        outputParametersPanelLayout.setVerticalGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputParametersPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eValueLbl).addComponent(this.maxEvalueTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hitListLbl).addComponent(this.hitlistTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(outputParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.omssaOutputFormatComboBox, -2, -1, -2).addComponent(this.omssaOutputFormatLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Output", this.outputParametersPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane).addComponent(this.jSeparator1).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 625, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void minPrecChargeMultipleChargedFragmentsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/OmssaSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "SearchGUI - Help", 500, 50);
        this.setCursor(new Cursor(0));
    }

    private void omssaOutputFormatComboBoxActionPerformed(ActionEvent evt) {
        if (((String)this.omssaOutputFormatComboBox.getSelectedItem()).equalsIgnoreCase("CSV") && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(OmssaSettingsDialog.this, JOptionEditorPane.getJOptionEditorPane("Note that the OMSSA CSV format is not compatible with <a href=\"http://www.peptide-shaker.googlecode.com\">PeptideShaker</a>."), "Format Warning", 2);
                }
            });
        }
        this.validateInput(false);
    }

    private void maxEvalueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void hitlistTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void iterativeSequenceEvalueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void iterativeSpectraEvalueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void iterativeReplaceEvalueTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nIsotopesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void neutronTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void singlyChargedWindowWidthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void doublyChargedWindowWidthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void singlyChargedNpeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void doublyChargedNpeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minAnnotatedMostIntensePeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minAnnotatedPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxLaddersTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentChargeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentChargeTxtActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentsPerSeriesTxtActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void maxFragmentsPerSeriesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void consecutiveIonProbabilityTxtActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void consecutiveIonProbabilityTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPrecPerSpectrumTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void fractionChargeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void intensityIncrementTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void highIntensityTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void lowIntensityTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nHitsPerSpectrumPerChargeTxtActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void nHitsPerSpectrumPerChargeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        this.lowIntensityLbl.setForeground(Color.BLACK);
        this.highIntensityLbl.setForeground(Color.BLACK);
        this.intensityIncrementLbl.setForeground(Color.BLACK);
        this.nPeaksLbl.setForeground(Color.BLACK);
        this.fractionChargeLbl.setForeground(Color.BLACK);
        this.minPrecPerSpectrumLbl.setForeground(Color.BLACK);
        this.peptideLengthJLabel.setForeground(Color.BLACK);
        this.maxPepLengthTxt.setForeground(Color.BLACK);
        this.eValueLbl.setForeground(Color.BLACK);
        this.hitListLbl.setForeground(Color.BLACK);
        this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setForeground(Color.BLACK);
        this.nIsotopesLbl.setForeground(Color.BLACK);
        this.neutronLbl.setForeground(Color.BLACK);
        this.singlyChargedWindowWidthLbl.setForeground(Color.BLACK);
        this.doublyChargedWindowWidthLbl.setForeground(Color.BLACK);
        this.singlyChargedNPeaksLbl.setForeground(Color.BLACK);
        this.doublyChargedNPeaksLbl.setForeground(Color.BLACK);
        this.minAnnotatedMostIntensePeaksLbl.setForeground(Color.BLACK);
        this.minAnnotatedPeaksLbl.setForeground(Color.BLACK);
        this.maxLaddersLbl.setForeground(Color.BLACK);
        this.maxFragmentChargeLbl.setForeground(Color.BLACK);
        this.maxFragmentsPerSeriesLbl.setForeground(Color.BLACK);
        this.consecutiveIonProbabilityLbl.setForeground(Color.BLACK);
        this.iterativeSequenceEvalueLbl.setForeground(Color.BLACK);
        this.iterativeSpectraEvalueLbl.setForeground(Color.BLACK);
        this.iterativeReplaceEvalueLbl.setForeground(Color.BLACK);
        this.nHitsPerSpectrumPerChargeLbl.setForeground(Color.BLACK);
        this.lowIntensityLbl.setToolTipText(null);
        this.highIntensityLbl.setToolTipText(null);
        this.intensityIncrementLbl.setToolTipText(null);
        this.nPeaksLbl.setToolTipText(null);
        this.fractionChargeLbl.setToolTipText(null);
        this.minPrecPerSpectrumLbl.setToolTipText(null);
        this.peptideLengthJLabel.setToolTipText(null);
        this.maxPepLengthTxt.setToolTipText(null);
        this.eValueLbl.setToolTipText(null);
        this.hitListLbl.setToolTipText(null);
        this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setToolTipText(null);
        this.nIsotopesLbl.setToolTipText(null);
        this.neutronLbl.setToolTipText(null);
        this.singlyChargedWindowWidthLbl.setToolTipText(null);
        this.doublyChargedWindowWidthLbl.setToolTipText(null);
        this.singlyChargedNPeaksLbl.setToolTipText(null);
        this.doublyChargedNPeaksLbl.setToolTipText(null);
        this.minAnnotatedMostIntensePeaksLbl.setToolTipText(null);
        this.minAnnotatedPeaksLbl.setToolTipText(null);
        this.maxLaddersLbl.setToolTipText(null);
        this.maxFragmentChargeLbl.setToolTipText(null);
        this.maxFragmentsPerSeriesLbl.setToolTipText(null);
        this.consecutiveIonProbabilityLbl.setToolTipText(null);
        this.iterativeSequenceEvalueLbl.setToolTipText(null);
        this.iterativeSpectraEvalueLbl.setToolTipText(null);
        this.iterativeReplaceEvalueLbl.setToolTipText(null);
        this.nHitsPerSpectrumPerChargeLbl.setToolTipText(null);
        if (this.lowIntensityTxt.getText() == null || this.lowIntensityTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a low intensity cutoff.", "Low Intensity Cutoff Error", 2);
            }
            valid = false;
            this.lowIntensityLbl.setForeground(Color.RED);
            this.lowIntensityLbl.setToolTipText("Please select a low intensity cutoff limit");
        }
        double doubleInput = -1.0;
        try {
            doubleInput = new Double(this.lowIntensityTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the low intensity cutoff.", "Low Intensity Cutoff Error", 2);
            }
            valid = false;
            this.lowIntensityLbl.setForeground(Color.RED);
            this.lowIntensityLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the low intensity cutoff.", "Low Intensity Cutoff Error", 2);
            }
            valid = false;
            this.sequenceMappingLbl.setForeground(Color.RED);
            this.sequenceMappingLbl.setToolTipText("Please select a positive number");
        }
        if (this.highIntensityTxt.getText() == null || this.highIntensityTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a high intensity cutoff.", "High Intensity Cutoff Error", 2);
            }
            valid = false;
            this.highIntensityLbl.setForeground(Color.RED);
            this.highIntensityLbl.setToolTipText("Please select a high intensity cutoff limit");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.highIntensityTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the high intensity cutoff.", "High Intensity Cutoff Error", 2);
            }
            valid = false;
            this.highIntensityLbl.setForeground(Color.RED);
            this.highIntensityLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the high intensity cutoff.", "High Intensity Cutoff Error", 2);
            }
            valid = false;
            this.highIntensityLbl.setForeground(Color.RED);
            this.highIntensityLbl.setToolTipText("Please select a positive number");
        }
        if (this.intensityIncrementTxt.getText() == null || this.intensityIncrementTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify an intensity cutoff increment.", "Intensity Cutoff Increment Error", 2);
            }
            valid = false;
            this.intensityIncrementLbl.setForeground(Color.RED);
            this.intensityIncrementLbl.setToolTipText("Please select a high intensity cutoff limit");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.intensityIncrementTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the intensity cutoff increment.", "Intensity Cutoff Increment Error", 2);
            }
            valid = false;
            this.intensityIncrementLbl.setForeground(Color.RED);
            this.intensityIncrementLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the intensity cutoff increment.", "Intensity Cutoff Increment Error", 2);
            }
            valid = false;
            this.intensityIncrementLbl.setForeground(Color.RED);
            this.intensityIncrementLbl.setToolTipText("Please select a positive number");
        }
        if (this.nPeaksTxt.getText() == null || this.nPeaksTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number of peaks per spectrum.", "Number of Peaks Error", 2);
            }
            valid = false;
            this.nPeaksLbl.setForeground(Color.RED);
            this.nPeaksLbl.setToolTipText("Please select a high intensity cutoff limit");
        }
        int intInput = -1;
        try {
            intInput = new Integer(this.nPeaksTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks per spectrum.", "Number of Peaks Error", 2);
            }
            valid = false;
            this.nPeaksLbl.setForeground(Color.RED);
            this.nPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks per spectrum.", "Number of Peaks Error", 2);
            }
            valid = false;
            this.nPeaksLbl.setForeground(Color.RED);
            this.nPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (this.fractionChargeTxt.getText() == null || this.fractionChargeTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify the fraction of peaks for charge estimation.", "Fraction of Peaks Error", 2);
            }
            valid = false;
            this.fractionChargeLbl.setForeground(Color.RED);
            this.fractionChargeLbl.setToolTipText("Please select a high intensity cutoff limit");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.fractionChargeTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the fraction of peaks for charge estimation.", "Fraction of Peaks Error", 2);
            }
            valid = false;
            this.fractionChargeLbl.setForeground(Color.RED);
            this.fractionChargeLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the fraction of peaks for charge estimation.", "Fraction of Peaks Error", 2);
            }
            valid = false;
            this.fractionChargeLbl.setForeground(Color.RED);
            this.fractionChargeLbl.setToolTipText("Please select a positive number");
        }
        if (this.minPrecPerSpectrumTxt.getText() == null || this.minPrecPerSpectrumTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the number of precursor per spectrum.", "Number of Precursor Error", 2);
            }
            valid = false;
            this.minPrecPerSpectrumLbl.setForeground(Color.RED);
            this.minPrecPerSpectrumLbl.setToolTipText("Please select a high intensity cutoff limit");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.minPrecPerSpectrumTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of precursor per spectrum.", "Number of Precursor Error", 2);
            }
            valid = false;
            this.minPrecPerSpectrumLbl.setForeground(Color.RED);
            this.minPrecPerSpectrumLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of precursor per spectrum.", "Number of Precursor Error", 2);
            }
            valid = false;
            this.minPrecPerSpectrumLbl.setForeground(Color.RED);
            this.minPrecPerSpectrumLbl.setToolTipText("Please select a positive number");
        }
        if (this.minPepLengthTxt.getText() != null && !this.minPepLengthTxt.getText().trim().equals("") || this.maxPepLengthTxt.getText() != null && !this.maxPepLengthTxt.getText().trim().equals("")) {
            int length = 0;
            try {
                length = Integer.parseInt(this.minPepLengthTxt.getText().trim());
            }
            catch (NumberFormatException nfe) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "You need to specify positive numbers for the peptide lengths.", "Peptide Length Error", 2);
                }
                valid = false;
                this.peptideLengthJLabel.setForeground(Color.RED);
                this.peptideLengthJLabel.setToolTipText("Please select positive integers");
            }
            if (length < 0) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "You need to specify positive integers for the peptide lengths.", "Incorrect peptide lengths found!", 2);
                }
                valid = false;
                this.peptideLengthJLabel.setForeground(Color.RED);
                this.peptideLengthJLabel.setToolTipText("Please select positive integers");
            }
            length = 0;
            try {
                length = Integer.parseInt(this.maxPepLengthTxt.getText().trim());
            }
            catch (NumberFormatException nfe) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "You need to specify positive numbers for the peptide lengths.", "Peptide Length Error", 2);
                }
                valid = false;
                this.peptideLengthJLabel.setForeground(Color.RED);
                this.peptideLengthJLabel.setToolTipText("Please select positive integers for the peptide length");
            }
            if (length <= 0) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "You need to specify positive integers for the peptide lengths.", "Incorrect peptide lengths found.", 2);
                }
                valid = false;
                this.peptideLengthJLabel.setForeground(Color.RED);
                this.peptideLengthJLabel.setToolTipText("Please select positive integers");
            }
        }
        if (this.maxEvalueTxt.getText() == null || this.maxEvalueTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the maximal e-value.", "Maximum E-Value Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a maximal e-value");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.maxEvalueTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal e-value.", "Maximum E-Value Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal e-value.", "Maximum E-Value Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a positive number");
        }
        if (this.hitlistTxt.getText() == null || this.hitlistTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the hitlist length.", "Hitlist Length Error", 2);
            }
            valid = false;
            this.hitListLbl.setForeground(Color.RED);
            this.hitListLbl.setToolTipText("Please select a hitlist length");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.hitlistTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the hitlist length.", "Hitlist Length Error", 2);
            }
            valid = false;
            this.hitListLbl.setForeground(Color.RED);
            this.hitListLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the hitlist length.", "Hitlist Length Error", 2);
            }
            valid = false;
            this.hitListLbl.setForeground(Color.RED);
            this.hitListLbl.setToolTipText("Please select a positive number");
        }
        if (this.nHitsPerSpectrumPerChargeTxt.getText() == null || this.nHitsPerSpectrumPerChargeTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the number of hits per spectrum and per charge.", "Hits per Spectrum and per Charge Error", 2);
            }
            valid = false;
            this.nHitsPerSpectrumPerChargeLbl.setForeground(Color.RED);
            this.nHitsPerSpectrumPerChargeLbl.setToolTipText("Please select a hitlist length");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.nHitsPerSpectrumPerChargeTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of hits per spectrum and per charge.", "Hits per Spectrum and per Charge Error", 2);
            }
            valid = false;
            this.nHitsPerSpectrumPerChargeLbl.setForeground(Color.RED);
            this.nHitsPerSpectrumPerChargeLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of hits per spectrum and per charge.", "Hits per Spectrum and per Charge Error", 2);
            }
            valid = false;
            this.nHitsPerSpectrumPerChargeLbl.setForeground(Color.RED);
            this.nHitsPerSpectrumPerChargeLbl.setToolTipText("Please select a positive number");
        }
        if (this.minPrecChargeMultipleChargedFragmentsTxt.getText() == null || this.minPrecChargeMultipleChargedFragmentsTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the minimal charge to consider multiply charged fragments.", "Minimal Charge for Multiple Fragments Error", 2);
            }
            valid = false;
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setForeground(Color.RED);
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setToolTipText("Please select a minimal charge to consider multiply charged fragments");
        }
        intInput = -1;
        try {
            String debug = this.minPrecChargeMultipleChargedFragmentsTxt.getText().trim();
            intInput = new Integer(debug);
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal charge to consider multiply charged fragments.", "Minimal Charge for Multiple Fragments Error", 2);
            }
            valid = false;
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setForeground(Color.RED);
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal charge to consider multiply charged fragments.", "Minimal Charge for Multiple Fragments Error", 2);
            }
            valid = false;
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setForeground(Color.RED);
            this.minPrecursorChargeConsideredMultiplyChargedFragmentsJLabel.setToolTipText("Please select a positive number");
        }
        if (this.nIsotopesTxt.getText() == null || this.nIsotopesTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the number of isotopes to consider.", "Minimal Charge for Multiple Fragments Error", 2);
            }
            valid = false;
            this.nIsotopesLbl.setForeground(Color.RED);
            this.nIsotopesLbl.setToolTipText("Please select a number of isotopes to consider");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.minPrecChargeMultipleChargedFragmentsTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of isotopes to consider.", "Number of Isotopes Error", 2);
            }
            valid = false;
            this.nIsotopesLbl.setForeground(Color.RED);
            this.nIsotopesLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of isotopes to consider.", "Number of Isotopes Error", 2);
            }
            valid = false;
            this.nIsotopesLbl.setForeground(Color.RED);
            this.nIsotopesLbl.setToolTipText("Please select a positive number");
        }
        if (this.maxEvalueTxt.getText() == null || this.maxEvalueTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the mass after which the exact mass of a neutron is used.", "Mass for Proton Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a mass after which the exact mass of a neutron is used");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.maxEvalueTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the mass after which the exact mass of a neutron is used.", "Mass for Proton Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the mass after which the exact mass of a neutron is used.", "Mass for Proton Error", 2);
            }
            valid = false;
            this.eValueLbl.setForeground(Color.RED);
            this.eValueLbl.setToolTipText("Please select a positive number");
        }
        if (this.singlyChargedWindowWidthTxt.getText() == null || this.singlyChargedWindowWidthTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a size for single charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.singlyChargedWindowWidthLbl.setForeground(Color.RED);
            this.singlyChargedWindowWidthLbl.setToolTipText("Please select a size for single charge windows");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.singlyChargedWindowWidthTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the size for single charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.singlyChargedWindowWidthLbl.setForeground(Color.RED);
            this.singlyChargedWindowWidthLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the size for single charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.singlyChargedWindowWidthLbl.setForeground(Color.RED);
            this.singlyChargedWindowWidthLbl.setToolTipText("Please select a positive number");
        }
        if (this.doublyChargedWindowWidthTxt.getText() == null || this.doublyChargedWindowWidthTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a size for double charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.doublyChargedWindowWidthLbl.setForeground(Color.RED);
            this.doublyChargedWindowWidthLbl.setToolTipText("Please select a size for double charge windows");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.doublyChargedWindowWidthTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the size for double charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.doublyChargedWindowWidthLbl.setForeground(Color.RED);
            this.doublyChargedWindowWidthLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the size for double charge windows.", "Window Size Error", 2);
            }
            valid = false;
            this.doublyChargedWindowWidthLbl.setForeground(Color.RED);
            this.doublyChargedWindowWidthLbl.setToolTipText("Please select a positive number");
        }
        if (this.singlyChargedNpeaksTxt.getText() == null || this.singlyChargedNpeaksTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number of peaks for single charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.singlyChargedNPeaksLbl.setForeground(Color.RED);
            this.singlyChargedNPeaksLbl.setToolTipText("Please select a number of peaks for single charge windows");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.singlyChargedNpeaksTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks for single charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.singlyChargedNPeaksLbl.setForeground(Color.RED);
            this.singlyChargedNPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks size for single charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.singlyChargedNPeaksLbl.setForeground(Color.RED);
            this.singlyChargedNPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (this.doublyChargedNpeaksTxt.getText() == null || this.doublyChargedNpeaksTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number of peaks for double charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.doublyChargedNPeaksLbl.setForeground(Color.RED);
            this.doublyChargedNPeaksLbl.setToolTipText("Please select a number of peaks for double charge windows");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.doublyChargedNpeaksTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks for double charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.doublyChargedNPeaksLbl.setForeground(Color.RED);
            this.doublyChargedNPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the number of peaks size for double charge windows.", "Window Number of Peaks Error", 2);
            }
            valid = false;
            this.doublyChargedNPeaksLbl.setForeground(Color.RED);
            this.doublyChargedNPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (this.minAnnotatedMostIntensePeaksTxt.getText() == null || this.minAnnotatedMostIntensePeaksTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the minimal number of annotated peaks among the most intense ones.", "Number of Annotated Intense Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedMostIntensePeaksLbl.setForeground(Color.RED);
            this.minAnnotatedMostIntensePeaksLbl.setToolTipText("Please select a number of peaks for the minimal number of annotated peaks among the most intense ones");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.minAnnotatedMostIntensePeaksTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal number of annotated peaks among the most intense ones.", "Number of Annotated Intense Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedMostIntensePeaksLbl.setForeground(Color.RED);
            this.minAnnotatedMostIntensePeaksLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal number of annotated peaks among the most intense ones.", "Number of Annotated Intense Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedMostIntensePeaksLbl.setForeground(Color.RED);
            this.minAnnotatedMostIntensePeaksLbl.setToolTipText("Please select a positive number");
        }
        if (this.minAnnotatedPeaksTxt.getText() == null || this.minAnnotatedPeaksTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the minimal number of annotated peaks.", "Number of Annotated Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedPeaksLbl.setForeground(Color.RED);
            this.minAnnotatedPeaksLbl.setToolTipText("Please select a number of peaks for the minimal number of annotated peaks");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.minAnnotatedPeaksTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal number of annotated peaks.", "Number of Annotated Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedPeaksLbl.setForeground(Color.RED);
            this.minAnnotatedPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the minimal number of annotated peaks.", "Number of Annotated Peaks Error", 2);
            }
            valid = false;
            this.minAnnotatedPeaksLbl.setForeground(Color.RED);
            this.minAnnotatedPeaksLbl.setToolTipText("Please select a positive number");
        }
        if (this.maxLaddersTxt.getText() == null || this.maxLaddersTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the maximal m/z ladder size.", "Ladder Size Error", 2);
            }
            valid = false;
            this.maxLaddersLbl.setForeground(Color.RED);
            this.maxLaddersLbl.setToolTipText("Please select a number of peaks for the maximal m/z ladder size");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.maxLaddersTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal m/z ladder size.", "Ladder Size Error", 2);
            }
            valid = false;
            this.maxLaddersLbl.setForeground(Color.RED);
            this.maxLaddersLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal m/z ladder size.", "Ladder Size Error", 2);
            }
            valid = false;
            this.maxLaddersLbl.setForeground(Color.RED);
            this.maxLaddersLbl.setToolTipText("Please select a positive number");
        }
        if (this.maxFragmentChargeTxt.getText() == null || this.maxFragmentChargeTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the maximal fragment charge.", "Fragment Charge Error", 2);
            }
            valid = false;
            this.maxFragmentChargeLbl.setForeground(Color.RED);
            this.maxFragmentChargeLbl.setToolTipText("Please select a number of peaks for the maximal fragment charge");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.maxFragmentChargeTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal fragment charge.", "Fragment Charge Error", 2);
            }
            valid = false;
            this.maxFragmentChargeLbl.setForeground(Color.RED);
            this.maxFragmentChargeLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal fragment charge.", "Fragment Charge Error", 2);
            }
            valid = false;
            this.maxFragmentChargeLbl.setForeground(Color.RED);
            this.maxFragmentChargeLbl.setToolTipText("Please select a positive number");
        }
        if (this.maxFragmentsPerSeriesTxt.getText() == null || this.maxFragmentsPerSeriesTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a number for the maximal number of fragments per series.", "Fragments per Series Error", 2);
            }
            valid = false;
            this.maxFragmentsPerSeriesLbl.setForeground(Color.RED);
            this.maxFragmentsPerSeriesLbl.setToolTipText("Please select a number of peaks for the maximal number of fragments per series");
        }
        intInput = -1;
        try {
            intInput = new Integer(this.maxFragmentsPerSeriesTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal number of fragments per series.", "Fragments per Series Error", 2);
            }
            valid = false;
            this.maxFragmentsPerSeriesLbl.setForeground(Color.RED);
            this.maxFragmentsPerSeriesLbl.setToolTipText("Please select a positive number");
        }
        if (intInput < 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the maximal number of fragments per series.", "Fragments per Series Error", 2);
            }
            valid = false;
            this.maxFragmentsPerSeriesLbl.setForeground(Color.RED);
            this.maxFragmentsPerSeriesLbl.setToolTipText("Please select a positive number");
        }
        if (this.consecutiveIonProbabilityTxt.getText() == null || this.consecutiveIonProbabilityTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the consecutive ion probability.", "Consecutive Ion Probability Error", 2);
            }
            valid = false;
            this.consecutiveIonProbabilityLbl.setForeground(Color.RED);
            this.consecutiveIonProbabilityLbl.setToolTipText("Please select a mass after which the consecutive ion probability");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.consecutiveIonProbabilityTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the consecutive ion probability.", "Consecutive Ion Probability Error", 2);
            }
            valid = false;
            this.consecutiveIonProbabilityLbl.setForeground(Color.RED);
            this.consecutiveIonProbabilityLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the consecutive ion probability.", "Consecutive Ion Probability Error", 2);
            }
            valid = false;
            this.consecutiveIonProbabilityLbl.setForeground(Color.RED);
            this.consecutiveIonProbabilityLbl.setToolTipText("Please select a positive number");
        }
        if (this.iterativeSequenceEvalueTxt.getText() == null || this.iterativeSequenceEvalueTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the e-value cutoff to include sequences in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSequenceEvalueLbl.setForeground(Color.RED);
            this.iterativeSequenceEvalueLbl.setToolTipText("Please select a mass after which the e-value cutoff to include sequences in the iterative search");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.iterativeSequenceEvalueTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to include sequences in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSequenceEvalueLbl.setForeground(Color.RED);
            this.iterativeSequenceEvalueLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to include sequences in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSequenceEvalueLbl.setForeground(Color.RED);
            this.iterativeSequenceEvalueLbl.setToolTipText("Please select a positive number");
        }
        if (this.iterativeSpectraEvalueTxt.getText() == null || this.iterativeSpectraEvalueTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the e-value cutoff to include spectra in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSpectraEvalueLbl.setForeground(Color.RED);
            this.iterativeSpectraEvalueLbl.setToolTipText("Please select a mass after which the e-value cutoff to include spectra in the iterative search");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.iterativeSpectraEvalueTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to include spectra in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSpectraEvalueLbl.setForeground(Color.RED);
            this.iterativeSpectraEvalueLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to include spectra in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeSpectraEvalueLbl.setForeground(Color.RED);
            this.iterativeSpectraEvalueLbl.setToolTipText("Please select a positive number");
        }
        if (this.iterativeReplaceEvalueTxt.getText() == null || this.iterativeReplaceEvalueTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a value for the e-value cutoff to replace hits in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeReplaceEvalueLbl.setForeground(Color.RED);
            this.iterativeReplaceEvalueLbl.setToolTipText("Please select a mass after which the e-value cutoff to replace hits in the iterative search");
        }
        doubleInput = -1.0;
        try {
            doubleInput = new Double(this.iterativeReplaceEvalueTxt.getText().trim());
        }
        catch (NumberFormatException nfe) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to replace hits in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeReplaceEvalueLbl.setForeground(Color.RED);
            this.iterativeReplaceEvalueLbl.setToolTipText("Please select a positive number");
        }
        if (doubleInput < 0.0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a positive number for the e-value cutoff to replace hits in the iterative search.", "Iterative Search E-value Error", 2);
            }
            valid = false;
            this.iterativeReplaceEvalueLbl.setForeground(Color.RED);
            this.iterativeReplaceEvalueLbl.setToolTipText("Please select a positive number");
        }
        return valid;
    }
}

