/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.gui.spectrum.GraphicsPanel;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.BorderFactory;

public class ChromatogramPanel
extends GraphicsPanel {
    private Color iChromatogramColor = Color.GRAY;
    private Color iChromatogramPointColor = Color.BLACK;

    public ChromatogramPanel(double[] aXAxisData, double[] aYAxisData) {
        this(aXAxisData, aYAxisData, null, null, null);
    }

    public ChromatogramPanel(double[] aXAxisData, double[] aYAxisData, String aXAxisLabel, String aYAxisLabel) {
        this(aXAxisData, aYAxisData, aXAxisLabel, aYAxisLabel, null);
    }

    public ChromatogramPanel(double[] aXAxisData, double[] aYAxisData, String aXAxisLabel, String aYAxisLabel, Integer aPointSize) {
        if (aPointSize != null) {
            this.setPointSize(aPointSize);
        }
        this.currentGraphicsPanelType = GraphicsPanel.GraphicsPanelType.chromatogram;
        this.dataSetCounter = 0;
        this.initData(aXAxisData, aYAxisData, aXAxisLabel, aYAxisLabel);
        this.iSpecPanelListeners = new ArrayList();
        this.addListeners();
    }

    private void initData(double[] aXAxisData, double[] aYAxisData, String aXAxisLabel, String aYAxisLabel) {
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        this.processXAndYData(aXAxisData, aYAxisData, this.iChromatogramColor, this.iChromatogramPointColor);
        this.iXAxisLabel = aXAxisLabel == null ? "unknown" : aXAxisLabel;
        this.iYAxisLabel = aYAxisLabel == null ? "unknown" : aYAxisLabel;
    }

    public void addAdditionalDataset(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        this.processXAndYData(aXAxisData, aYAxisData, dataPointAndLineColor, areaUnderCurveColor);
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
    }

    public void setPointSize(Integer aPointSize) {
        if (aPointSize % 2 != 0) {
            Integer n = aPointSize;
            Integer n2 = aPointSize = Integer.valueOf(aPointSize - 1);
        }
        this.iPointSize = aPointSize;
    }
}

