/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.io.FTP;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class FTPClient {
    Logger logger = Logger.getLogger(FTPClient.class);
    private String iHost = null;
    private String iUser = null;
    private String iPassword = null;

    public FTPClient(String aHost, String aUser, String aPassword) {
        this.iHost = aHost;
        this.iUser = aUser;
        this.iPassword = aPassword;
    }

    public void sendTextFile(String aFilename) throws IOException {
        String[] temp = new String[]{aFilename};
        this.sendFiles(temp, false);
    }

    public void sendBinaryFile(String aFilename) throws IOException {
        String[] temp = new String[]{aFilename};
        this.sendFiles(temp, true);
    }

    public void sendFiles(String[] aFilenames, boolean[] aBinaryMode) throws IOException {
        FTP client = new FTP(this.iHost);
        client.setPassive(true);
        client.login(this.iUser, this.iPassword);
        for (int i = 0; i < aFilenames.length; ++i) {
            String lFilename = aFilenames[i];
            boolean lMode = aBinaryMode[i];
            File f = new File(lFilename);
            if (!f.exists()) {
                throw new IOException("Attempting to send non-existant file: '" + lFilename + "'!");
            }
            String name = f.getName();
            FileInputStream fis = new FileInputStream(f);
            if (lMode) {
                BufferedOutputStream bos = client.putBinary(name);
                int current = -1;
                while ((current = fis.read()) != -1) {
                    bos.write(current);
                }
                bos.flush();
                bos.close();
            } else {
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                PrintWriter pw = new PrintWriter(client.putAscii(name));
                String line = null;
                while ((line = br.readLine()) != null) {
                    pw.print(line + "\n");
                }
                br.close();
                pw.flush();
                pw.close();
            }
            fis.close();
        }
        client.closeServer();
    }

    public void sendFiles(String[] aFilenames, boolean aBinaryMode) throws IOException {
        boolean[] temp = new boolean[aFilenames.length];
        for (int i = 0; i < aFilenames.length; ++i) {
            temp[i] = aBinaryMode;
        }
        this.sendFiles(aFilenames, temp);
    }

    public void testFTPConnection() throws IOException {
        FTP client = new FTP(this.iHost);
        client.login(this.iUser, this.iPassword);
        client.closeServer();
    }
}

