/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.interfaces.PickUp;
import com.compomics.util.io.FTPClient;
import com.compomics.util.io.FilenameExtensionFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FolderMonitor
implements Runnable {
    static Logger logger = Logger.getLogger(FolderMonitor.class);
    public static final String HOST = "HOST";
    public static final String USER = "USER";
    public static final String PASSWORD = "PASSWORD";
    public static final String TEXTMODE = "TEXTMODE";
    public static final String PICKUP = "PICKUP";
    public static final String LIMIT = "LIMIT";
    public static final int FTP_TO_SPECIFIED_DESTINATION = 0;
    public static final int GATHER_FILES_FOR_PICKUP = 1;
    private Logger iLogger = null;
    private boolean iContinue = true;
    private HashMap iParams = null;
    private int iOperation = 0;
    private File iFolder = null;
    private FilenameFilter iFilter = null;
    private int iCurrentLength = 0;
    private Vector iToMonitor = null;
    private Vector iProcessed = null;
    private long iDelay = 0L;
    private HashMap iFileProps = null;
    private FTPClient iFTP = null;
    private boolean iRunning = false;
    private Vector iGatherPlace = null;
    private PickUp iPickUp = null;
    private long iLimit = -1L;

    public FolderMonitor(File aFolder, long aDelay, int aOperation, HashMap aParams) {
        this(aFolder, aDelay, null, aOperation, aParams, null);
    }

    public FolderMonitor(File aFolder, long aDelay, int aOperation, HashMap aParams, Logger aLogger) {
        this(aFolder, aDelay, null, aOperation, aParams, aLogger);
    }

    public FolderMonitor(File aFolder, long aDelay, String aFilter, int aOperation, HashMap aParams) {
        this(aFolder, aDelay, aFilter, aOperation, aParams, null);
    }

    public FolderMonitor(File aFolder, long aDelay, String aFilter, int aOperation, HashMap aParams, Logger aLogger) {
        if (!aFolder.exists() || !aFolder.isDirectory()) {
            throw new IllegalArgumentException("The File instance you passed does not " + (aFolder.exists() ? "point to a directory" : "exist") + " (" + aFolder.toString() + ")!");
        }
        this.iFolder = aFolder;
        switch (aOperation) {
            case 0: {
                this.iOperation = aOperation;
                if (aParams.get(HOST) == null || aParams.get(USER) == null || aParams.get(PASSWORD) == null) {
                    throw new IllegalArgumentException("You did not specify all necessary parameters for the FTP operation (I need host, user AND password)!");
                }
                this.iParams = aParams;
                this.iFTP = new FTPClient((String)this.iParams.get(HOST), (String)this.iParams.get(USER), (String)this.iParams.get(PASSWORD));
                break;
            }
            case 1: {
                this.iOperation = aOperation;
                if (aParams.get(PICKUP) == null) {
                    throw new IllegalArgumentException("You did not specify the PICKUP class for the gathered files!");
                }
                this.iPickUp = (PickUp)aParams.get(PICKUP);
                Object tempObject = aParams.get(LIMIT);
                this.iLimit = tempObject != null ? ((Number)tempObject).longValue() : -1L;
                this.iGatherPlace = new Vector();
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation you specified (code=" + aOperation + ") is not known to me!");
            }
        }
        if (aFilter != null) {
            this.iFilter = new FilenameExtensionFilter(aFilter);
        }
        this.iDelay = aDelay;
        this.iToMonitor = new Vector();
        this.iProcessed = new Vector();
        this.iFileProps = new HashMap();
        this.iLogger = aLogger;
    }

    @Override
    public void run() {
        this.iRunning = true;
        while (this.iContinue) {
            File lFile;
            int i;
            Vector<File> toProcess = new Vector<File>();
            File[] files = this.iFilter != null ? this.iFolder.listFiles(this.iFilter) : this.iFolder.listFiles();
            if (files != null && files.length != 0 && files.length > this.iCurrentLength) {
                for (int i2 = 0; i2 < files.length; ++i2) {
                    File lFile2 = files[i2];
                    if (lFile2.isDirectory() || this.iToMonitor.contains(lFile2) || this.iProcessed.contains(lFile2)) continue;
                    this.iToMonitor.add(lFile2);
                    if (this.iLogger == null) continue;
                    String time = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss").format(new Date());
                    this.iLogger.info((Object)(" - Added file: '" + lFile2.getName() + "' to the monitoring list (" + time + ")."));
                }
            }
            int liSize = this.iToMonitor.size();
            Vector<File> toRemove = new Vector<File>();
            for (i = 0; i < liSize; ++i) {
                lFile = (File)this.iToMonitor.elementAt(i);
                String lName = lFile.getName();
                if (!lFile.exists()) {
                    toRemove.add(lFile);
                    continue;
                }
                if (this.iFileProps.get(lName) == null) {
                    try {
                        this.iFileProps.put(lName, lFile.length());
                    }
                    catch (Exception e) {}
                    continue;
                }
                long previous = (Long)this.iFileProps.get(lName);
                try {
                    if (previous == lFile.length()) {
                        toProcess.add(lFile);
                        continue;
                    }
                    this.iFileProps.put(lName, lFile.length());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (i = 0; i < toRemove.size(); ++i) {
                lFile = (File)toRemove.elementAt(i);
                this.iToMonitor.remove(lFile);
                if (this.iLogger == null) continue;
                String time = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss").format(new Date());
                this.iLogger.info((Object)(" # Removed file '" + lFile.getName() + "' from the monitoring list since it was deleted (" + time + ")."));
            }
            toRemove = null;
            int processSize = toProcess.size();
            boolean processSuccessful = true;
            switch (this.iOperation) {
                case 0: {
                    try {
                        this.sendFilesViaFTP(toProcess);
                    }
                    catch (IOException ioe) {
                        if (this.iLogger != null) {
                            String time = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss").format(new Date());
                            this.iLogger.error((Object)(" IOException occurred while attempting to process files, message: " + ioe.getMessage() + "(" + time + ")!"));
                            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                        }
                        processSuccessful = false;
                    }
                    break;
                }
                case 1: {
                    if (processSize > 0) {
                        for (int i3 = 0; i3 < processSize; ++i3) {
                            this.iGatherPlace.add(toProcess.elementAt(i3));
                        }
                    }
                    if (this.iGatherPlace.size() <= 0) break;
                    this.sendGathered();
                }
            }
            if (processSuccessful) {
                for (int i4 = 0; i4 < processSize; ++i4) {
                    File lFile3 = (File)toProcess.elementAt(i4);
                    if (this.iLogger != null) {
                        String time = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss").format(new Date());
                        this.iLogger.info((Object)(" * Processed file '" + lFile3.getName() + "' (" + time + ")."));
                    }
                    this.iProcessed.add(lFile3);
                    this.iToMonitor.remove(lFile3);
                    this.iFileProps.remove(lFile3.getName());
                }
            }
            toProcess = null;
            files = null;
            try {
                Thread.sleep(this.iDelay);
            }
            catch (Exception e) {
                if (this.iLogger == null) continue;
                this.iLogger.info((Object)"FolderMonitor Thread interrupted.");
            }
        }
        this.iRunning = false;
    }

    public void signalStop() {
        this.iContinue = false;
    }

    public boolean isRunning() {
        return this.iRunning;
    }

    private void sendFilesViaFTP(Vector aFiles) throws IOException {
        boolean binary = true;
        if (this.iParams.containsKey(TEXTMODE)) {
            binary = false;
        }
        int liSize = aFiles.size();
        String[] allNames = new String[liSize];
        for (int i = 0; i < liSize; ++i) {
            File lFile = (File)aFiles.elementAt(i);
            allNames[i] = lFile.getAbsolutePath();
        }
        if (allNames.length > 0) {
            this.iFTP.sendFiles(allNames, binary);
        }
    }

    private void sendGathered() {
        while (this.iGatherPlace.size() > 0) {
            int size = this.iGatherPlace.size();
            boolean doLimitCheck = this.iLimit > 0L;
            Vector v = new Vector(size);
            for (int i = 0; !(i >= size || doLimitCheck && (long)i >= this.iLimit); ++i) {
                v.add(this.iGatherPlace.elementAt(i));
            }
            File[] result = new File[v.size()];
            v.toArray(result);
            this.iPickUp.sendIncoming(result);
            size = v.size();
            for (int i = 0; i < size; ++i) {
                this.iGatherPlace.remove(v.get(i));
            }
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> params2 = new HashMap<String, Object>(2);
        params2.put(PICKUP, new PickUp(){

            @Override
            public void sendIncoming(Object aObject) {
                try {
                    File[] files = (File[])aObject;
                    for (int i = 0; i < files.length; ++i) {
                        File lFile = files[i];
                        logger.info((Object)("File sent: " + lFile.getCanonicalPath()));
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        });
        params2.put(LIMIT, 5);
        FolderMonitor fm = new FolderMonitor(new File("f:/temp"), 1000L, 1, params2, null);
        Thread t = new Thread(fm);
        t.start();
    }
}

