/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.junit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class TestCaseLM {
    private TestCaseLM() {
    }

    public static Properties getPropertiesFile(String aFilename) throws IllegalArgumentException {
        Properties props = new Properties();
        try {
            ClassLoader cl = TestCaseLM.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(aFilename);
            if (is == null) {
                throw new IllegalArgumentException("File '" + aFilename + "' was not found in the classpath!");
            }
            props.load(is);
            is.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException for file '" + aFilename + "': " + ioe.getMessage());
        }
        return props;
    }

    public static String getFullFilePath(String aFilename) {
        String result = null;
        ClassLoader cl = TestCaseLM.class.getClassLoader();
        URL url = cl.getResource(aFilename);
        if (url == null) {
            throw new IllegalArgumentException("File '" + aFilename + "' was not found in the classpath!");
        }
        result = url.getFile();
        if (File.separatorChar != '/') {
            result = result.substring(1);
        }
        while (result.indexOf("%20") >= 0) {
            String temp;
            int start = result.indexOf("%20");
            result = temp = result.substring(0, start) + " " + result.substring(start + 3);
        }
        return result;
    }
}

