/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ModificationProfile
implements Serializable {
    static final long serialVersionUID = 342611308111304721L;
    private HashMap<String, String> modificationNames = new HashMap();
    private ArrayList<String> fixedModifications = new ArrayList();
    private ArrayList<String> variableModifications = new ArrayList();
    private ArrayList<String> refinementVariableModifications = new ArrayList();
    private ArrayList<String> refinementFixedModifications = new ArrayList();
    private ArrayList<String> refinementModifications = null;
    private HashMap<Integer, String> omssaIndexes = new HashMap();
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, PTM> backUp = new HashMap();

    public ModificationProfile() {
    }

    public ModificationProfile(ModificationProfile modificationProfile) {
        this.fixedModifications = modificationProfile.getFixedModifications();
        this.variableModifications = modificationProfile.getVariableModifications();
        this.refinementFixedModifications = modificationProfile.getRefinementFixedModifications();
        this.refinementVariableModifications = modificationProfile.getRefinementVariableModifications();
        this.omssaIndexes = modificationProfile.getOmssaIndexes();
        this.colors = modificationProfile.getColors();
        this.backUp = modificationProfile.getBackedUpPtmsMap();
    }

    public ArrayList<String> getVariableModifications() {
        return this.variableModifications;
    }

    public ArrayList<String> getFixedModifications() {
        return this.fixedModifications;
    }

    public ArrayList<String> getRefinementVariableModifications() {
        return this.refinementVariableModifications;
    }

    public ArrayList<String> getRefinementFixedModifications() {
        return this.refinementFixedModifications;
    }

    public ArrayList<String> getAllModifications() {
        this.compatibilityCheck();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.fixedModifications);
        result.addAll(this.variableModifications);
        if (this.refinementFixedModifications == null) {
            this.repair();
        }
        for (String ptmName : this.refinementFixedModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        for (String ptmName : this.refinementVariableModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        return result;
    }

    public ArrayList<String> getAllNotFixedModifications() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.variableModifications);
        for (String ptmName : this.refinementVariableModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        if (this.refinementFixedModifications == null) {
            this.repair();
        }
        for (String ptmName : this.fixedModifications) {
            if (this.refinementFixedModifications.contains(ptmName) || result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        for (String ptmName : this.refinementFixedModifications) {
            if (this.fixedModifications.contains(ptmName) || result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        return result;
    }

    public void addVariableModification(PTM modification) {
        String modName = modification.getName();
        if (!this.variableModifications.contains(modName)) {
            this.variableModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void addRefinementVariableModification(PTM modification) {
        String modName = modification.getName();
        if (!this.refinementVariableModifications.contains(modName)) {
            this.refinementVariableModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void addRefinementFixedModification(PTM modification) {
        String modName = modification.getName();
        if (!this.refinementFixedModifications.contains(modName)) {
            this.refinementFixedModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void addFixedModification(PTM modification) {
        String modName = modification.getName();
        if (!this.fixedModifications.contains(modName)) {
            this.fixedModifications.add(modName);
        }
        modification.setShortName(PTMFactory.getInstance().getShortName(modName));
        this.backUp.put(modName, modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.colors.put(expectedModification, color);
    }

    public Color getColor(String modification) {
        if (!this.colors.containsKey(modification)) {
            PTMFactory ptmFactory = PTMFactory.getInstance();
            this.setColor(modification, ptmFactory.getColor(modification));
        }
        return this.colors.get(modification);
    }

    public HashMap<String, Color> getColors() {
        return this.colors;
    }

    public void compatibilityCheck() {
        if (this.fixedModifications == null) {
            this.fixedModifications = new ArrayList();
        }
        if (this.variableModifications == null) {
            this.variableModifications = new ArrayList();
            for (String modName : this.modificationNames.values()) {
                this.variableModifications.add(modName);
            }
        }
        if (this.refinementVariableModifications == null) {
            this.refinementVariableModifications = new ArrayList();
        }
        if (this.refinementFixedModifications == null) {
            this.refinementFixedModifications = new ArrayList();
        }
        if (this.refinementModifications != null && !this.refinementModifications.isEmpty()) {
            for (String ptm : this.refinementFixedModifications) {
                if (this.refinementVariableModifications.contains(ptm)) continue;
                this.refinementVariableModifications.add(ptm);
            }
        }
        if (this.backUp == null) {
            this.backUp = new HashMap();
        }
    }

    public Set<String> getBackedUpPtms() {
        if (this.backUp == null) {
            this.repair();
        }
        return this.backUp.keySet();
    }

    public PTM getPtm(String modName) {
        return this.backUp.get(modName);
    }

    public HashMap<String, PTM> getBackedUpPtmsMap() {
        return this.backUp;
    }

    public void removeVariableModification(String modificationName) {
        while (this.variableModifications.contains(modificationName)) {
            this.variableModifications.remove(modificationName);
        }
    }

    public void removeFixedModification(String modificationName) {
        while (this.fixedModifications.contains(modificationName)) {
            this.fixedModifications.remove(modificationName);
        }
    }

    public void removeRefinementVariableModification(String modificationName) {
        while (this.refinementVariableModifications.contains(modificationName)) {
            this.refinementVariableModifications.remove(modificationName);
        }
    }

    public void removeRefinementFixedModification(String modificationName) {
        while (this.refinementVariableModifications.contains(modificationName)) {
            this.refinementVariableModifications.remove(modificationName);
        }
    }

    public void setOmssaIndex(String modificationName, int omssaIndex) {
        this.omssaIndexes.put(omssaIndex, modificationName);
    }

    public String getModification(int omssaIndex) {
        return this.omssaIndexes.get(omssaIndex);
    }

    public boolean hasOMSSAIndexes() {
        return this.omssaIndexes != null && !this.omssaIndexes.isEmpty();
    }

    public Integer getOmssaIndex(String modificationName) {
        for (int index : this.omssaIndexes.keySet()) {
            if (!modificationName.equalsIgnoreCase(this.omssaIndexes.get(index))) continue;
            return index;
        }
        return null;
    }

    public HashMap<Integer, String> getOmssaIndexes() {
        return this.omssaIndexes;
    }

    public boolean contains(String modificationName) {
        if (this.refinementVariableModifications == null) {
            this.repair();
        }
        return this.variableModifications.contains(modificationName) || this.fixedModifications.contains(modificationName) || this.refinementVariableModifications.contains(modificationName) || this.refinementFixedModifications.contains(modificationName);
    }

    public ArrayList<String> getSimilarNotFixedModifications(Double ptmMass) {
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> ptms = new ArrayList<String>();
        for (String ptmName : this.getAllNotFixedModifications()) {
            PTM ptm = ptmFactory.getPTM(ptmName);
            if (ptms.contains(ptmName) || ptm.getMass() != ptmMass.doubleValue()) continue;
            ptms.add(ptmName);
        }
        return ptms;
    }

    public boolean equals(ModificationProfile otherProfile) {
        if (otherProfile == null) {
            return false;
        }
        if (!this.getVariableModifications().equals(otherProfile.getVariableModifications())) {
            return false;
        }
        if (!this.getFixedModifications().equals(otherProfile.getFixedModifications())) {
            return false;
        }
        if (!this.getRefinementVariableModifications().equals(otherProfile.getRefinementVariableModifications())) {
            return false;
        }
        if (!this.getRefinementFixedModifications().equals(otherProfile.getRefinementFixedModifications())) {
            return false;
        }
        if (this.omssaIndexes.size() != otherProfile.omssaIndexes.size()) {
            return false;
        }
        for (Integer tempKey : this.omssaIndexes.keySet()) {
            if (!otherProfile.omssaIndexes.containsKey(tempKey)) {
                return false;
            }
            if (this.omssaIndexes.get(tempKey).equals(otherProfile.omssaIndexes.get(tempKey))) continue;
            return false;
        }
        if (this.colors.size() != otherProfile.colors.size()) {
            return false;
        }
        for (String tempKey : this.colors.keySet()) {
            if (!otherProfile.colors.containsKey(tempKey)) {
                return false;
            }
            if (this.colors.get(tempKey).equals(otherProfile.colors.get(tempKey))) continue;
            return false;
        }
        if (this.backUp.size() != otherProfile.backUp.size()) {
            return false;
        }
        for (String tempKey : this.backUp.keySet()) {
            if (otherProfile.backUp.containsKey(tempKey)) continue;
            return false;
        }
        return true;
    }

    public void repair() {
        if (this.fixedModifications == null) {
            this.fixedModifications = new ArrayList();
        }
        if (this.variableModifications == null) {
            this.variableModifications = new ArrayList();
        }
        if (this.refinementVariableModifications == null) {
            this.refinementVariableModifications = new ArrayList();
        }
        if (this.refinementFixedModifications == null) {
            this.refinementFixedModifications = new ArrayList();
            this.refinementFixedModifications.addAll(this.fixedModifications);
        }
        if (this.omssaIndexes == null) {
            this.omssaIndexes = new HashMap();
        }
        if (this.colors == null) {
            this.colors = new HashMap();
        }
        if (this.backUp == null) {
            this.backUp = new HashMap();
        }
    }
}

