/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class DualEnzyme
extends Enzyme {
    static Logger logger = Logger.getLogger(DualEnzyme.class);
    private HashMap iNtermCleavables = null;
    private HashMap iCtermCleavables = null;
    public static final int NTERMINAL = 0;
    public static final int CTERMINAL = 1;

    public DualEnzyme(String aTitle, String aNtermCleavage, String aCtermCleavage, String aRestrict, String aPosition, int aMiscleavages) {
        super(aTitle, "", aRestrict, aPosition, aMiscleavages);
        this.setCleavage(aNtermCleavage, 0);
        this.setCleavage(aCtermCleavage, 1);
    }

    public DualEnzyme(String aTitle, String aNtermCleavage, String aCtermCleavage, String aRestrict, String aPosition) {
        super(aTitle, "", aRestrict, aPosition);
        this.setCleavage(aNtermCleavage, 0);
        this.setCleavage(aCtermCleavage, 1);
    }

    @Override
    public void setCleavage(char[] aCleavage) {
        super.setCleavage(aCleavage);
        if (aCleavage != null) {
            this.iNtermCleavables = new HashMap(aCleavage.length);
            this.iCtermCleavables = new HashMap(aCleavage.length);
            for (int i = 0; i < aCleavage.length; ++i) {
                this.iNtermCleavables.put(Character.valueOf(aCleavage[i]), "1");
                this.iCtermCleavables.put(Character.valueOf(aCleavage[i]), "1");
            }
        } else {
            this.iNtermCleavables = new HashMap();
            this.iCtermCleavables = new HashMap();
        }
    }

    @Override
    public void setCleavage(String aCleavage) {
        char[] temp = null;
        if (aCleavage != null) {
            temp = aCleavage.toUpperCase().toCharArray();
        }
        this.setCleavage(temp);
    }

    public void setCleavage(char[] aCleavage, int aTerminus) {
        HashMap<Character, String> cleavables = null;
        if (aCleavage != null) {
            cleavables = new HashMap(aCleavage.length);
            for (int i = 0; i < aCleavage.length; ++i) {
                cleavables.put(Character.valueOf(aCleavage[i]), "1");
            }
        } else {
            cleavables = new HashMap<Character, String>();
        }
        switch (aTerminus) {
            case 0: {
                this.iNtermCleavables = cleavables;
                break;
            }
            case 1: {
                this.iCtermCleavables = cleavables;
                break;
            }
            default: {
                throw new IllegalArgumentException("You specified " + aTerminus + " as the terminus code, while it should be " + 0 + " (NTERMINAL) or " + 1 + " (CTERMINAL)!");
            }
        }
    }

    public void setCleavage(String aCleavage, int aTerminus) {
        char[] temp = null;
        if (aCleavage != null) {
            temp = aCleavage.toUpperCase().toCharArray();
        }
        this.setCleavage(temp, aTerminus);
    }

    public char[] getCleavage(int aTerminus) {
        Set keys = null;
        switch (aTerminus) {
            case 0: {
                keys = this.iNtermCleavables.keySet();
                break;
            }
            case 1: {
                keys = this.iCtermCleavables.keySet();
                break;
            }
            default: {
                throw new IllegalArgumentException("You specified " + aTerminus + " as the terminus code, while it should be " + 0 + " (NTERMINAL) or " + 1 + " (CTERMINAL)!");
            }
        }
        ArrayList lList = new ArrayList(keys);
        Collections.sort(lList);
        char[] result = new char[lList.size()];
        for (int i = 0; i < lList.size(); ++i) {
            char c;
            result[i] = c = ((Character)lList.get(i)).charValue();
        }
        return result;
    }

    @Override
    public char[] getCleavage() {
        Set nTermKeys = this.iNtermCleavables.keySet();
        Set cTermKeys = this.iCtermCleavables.keySet();
        char[] result = new char[nTermKeys.size() + cTermKeys.size() + 1];
        int counter = 0;
        for (Character lCharacter : nTermKeys) {
            result[counter] = lCharacter.charValue();
            ++counter;
        }
        result[counter] = 88;
        ++counter;
        for (Character lCharacter : cTermKeys) {
            result[counter] = lCharacter.charValue();
        }
        return result;
    }

    @Override
    public Object clone() {
        DualEnzyme de = (DualEnzyme)super.clone();
        if (de != null) {
            de.iCtermCleavables = this.iCtermCleavables;
            de.iNtermCleavables = this.iNtermCleavables;
        }
        return de;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String aPrepend) {
        StringBuffer result = new StringBuffer("\n" + aPrepend + "Hi, I'm the DualEnzyme '" + this.getTitle() + "'.\n");
        result.append(aPrepend + "I cleave at the sight of:\n");
        result.append(aPrepend + "\t- Nterminal: '" + new String(this.getCleavage(0)) + "'.\n");
        result.append(aPrepend + "\t- Cterminal: '" + new String(this.getCleavage(1)) + "'.\n");
        if (this.getRestrict() != null && this.getRestrict().length > 0) {
            result.append(aPrepend + "My activity is restricted by these residus: '" + new String(this.getRestrict()) + "'.\n");
        } else {
            result.append(aPrepend + "There are no residus that restrict my activity.\n");
        }
        result.append(aPrepend + "My position is '" + (this.getPosition() == 0 ? "C-terminal" : "N-terminal") + "'.\n");
        result.append(aPrepend + "I currently allow " + (this.getMiscleavages() == 0 ? "no" : "up to " + this.getMiscleavages()) + " missed cleavage" + (this.getMiscleavages() == 1 ? "" : "s") + ".\n");
        return result.toString();
    }

    public Protein[] oldCleave(Protein aProtein) {
        Protein[] result = null;
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        Header header = aProtein.getHeader();
        String seqString = aProtein.getSequence().getSequence();
        char[] sequence = seqString.toCharArray();
        int start = aProtein.getHeader().getStartLocation() - 1;
        if (start < 0) {
            start = 0;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (!this.isCleavable(sequence, i, this.iNtermCleavables, this.iRestrictors)) continue;
            int init = i;
            int countMC = 0;
            for (int tryout = i; tryout < sequence.length && countMC <= this.iMiscleavages; ++tryout) {
                if (!this.isCleavable(sequence, tryout, this.iCtermCleavables, this.iRestrictors) && tryout != sequence.length - 1) continue;
                ++countMC;
                Header h = (Header)header.clone();
                int tempStart = -1;
                int tempStop = -1;
                if (this.iPosition == 0) {
                    tempStart = init + 1;
                    tempStop = tryout + 1;
                } else if (this.iPosition == 1) {
                    tempStart = init;
                    tempStop = tryout;
                    if (tryout == sequence.length - 1) {
                        ++tempStop;
                    }
                }
                h.setLocation(start + tempStart + 1, start + tempStop);
                proteins.add(new Protein(h, new AASequenceImpl(seqString.substring(tempStart, tempStop))));
            }
        }
        result = new Protein[proteins.size()];
        proteins.toArray(result);
        return result;
    }

    @Override
    public Protein[] cleave(Protein aProtein) {
        Protein[] result = null;
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        Header header = aProtein.getHeader();
        String seqString = aProtein.getSequence().getSequence();
        char[] sequence = seqString.toCharArray();
        int start = aProtein.getHeader().getStartLocation() - 1;
        if (start < 0) {
            start = 0;
        }
        int previousCtermCleavagePosition = 0;
        int previousNtermCleavagePosition = 0;
        for (int i = 0; i < sequence.length; ++i) {
            if (!this.isCleavable(sequence, i, this.iNtermCleavables, this.iRestrictors)) continue;
            int init = i;
            int endLoc = -1;
            if (this.iPosition == 0) {
                endLoc = i + 1;
            } else if (this.iPosition == 1) {
                endLoc = i;
            }
            int startLoc = previousCtermCleavagePosition;
            if (previousCtermCleavagePosition > init) {
                startLoc = previousNtermCleavagePosition;
            }
            Header intermed = (Header)header.clone();
            intermed.setLocation(start + startLoc + 1, start + endLoc);
            proteins.add(new Protein(intermed, new AASequenceImpl(seqString.substring(startLoc, endLoc))));
            if (this.iPosition == 0) {
                previousNtermCleavagePosition = init + 1;
            } else if (this.iPosition == 1) {
                previousNtermCleavagePosition = init;
            }
            int countMC = 0;
            for (int tryout = i; tryout < sequence.length && countMC <= this.iMiscleavages; ++tryout) {
                if (!this.isCleavable(sequence, tryout, this.iCtermCleavables, this.iRestrictors) && tryout != sequence.length - 1) continue;
                ++countMC;
                Header h = (Header)header.clone();
                int tempStart = -1;
                int tempStop = -1;
                if (this.iPosition == 0) {
                    tempStart = init + 1;
                    tempStop = tryout + 1;
                } else if (this.iPosition == 1) {
                    tempStart = init;
                    tempStop = tryout;
                    if (tryout == sequence.length - 1) {
                        ++tempStop;
                    }
                }
                if (tempStart == tempStop) continue;
                if (countMC == 1) {
                    previousCtermCleavagePosition = tempStop;
                }
                h.setLocation(start + tempStart + 1, start + tempStop);
                proteins.add(new Protein(h, new AASequenceImpl(seqString.substring(tempStart, tempStop))));
            }
        }
        if (previousCtermCleavagePosition < sequence.length) {
            Header h = (Header)header.clone();
            h.setLocation(start + previousCtermCleavagePosition + 1, start + sequence.length);
            proteins.add(new Protein(h, new AASequenceImpl(seqString.substring(previousCtermCleavagePosition, sequence.length))));
        }
        result = new Protein[proteins.size()];
        proteins.toArray(result);
        return result;
    }

    @Override
    public int isEnzymaticProduct(String aParentSequence, int aStart, int aEnd) {
        int result = 0;
        if (--aStart < 0 || --aEnd < 0) {
            throw new IllegalArgumentException("Subsequence is not a subsequence of the parent!");
        }
        if (aEnd > aParentSequence.length() - 1) {
            throw new IllegalArgumentException("Subsequence end index out of parent length range (" + aEnd + ">" + (aParentSequence.length() - 1) + ")!");
        }
        if (aStart >= aEnd) {
            throw new IllegalArgumentException("Subsequence could not be retreived since start index is greater than or equal to end index (" + aStart + ">=" + aEnd + ")!");
        }
        int maxLength = aParentSequence.length();
        if (this.getPosition() == 0) {
            Character residue;
            if (aStart - 1 >= 0) {
                residue = Character.valueOf(aParentSequence.charAt(aStart - 1));
                Character possRestrict = Character.valueOf(aParentSequence.charAt(aStart));
                if (this.iNtermCleavables.get(residue) != null && this.iRestrictors.get(possRestrict) == null) {
                    ++result;
                }
            } else {
                ++result;
            }
            residue = Character.valueOf(aParentSequence.charAt(aEnd));
            if (this.iCtermCleavables.get(residue) != null || aEnd + 1 == maxLength) {
                if (aEnd + 1 < maxLength) {
                    if (this.iRestrictors.get(Character.valueOf(aParentSequence.charAt(aEnd + 1))) == null) {
                        result += 2;
                    }
                } else {
                    result += 2;
                }
            }
        } else {
            Character residue = Character.valueOf(aParentSequence.charAt(aStart));
            if (this.iNtermCleavables.get(residue) != null) {
                if (aStart + 1 >= maxLength || this.iRestrictors.get(Character.valueOf(aParentSequence.charAt(aStart + 1))) == null) {
                    ++result;
                }
            } else if (aStart == 0) {
                ++result;
            }
            if (aEnd + 1 < maxLength) {
                Character residue2 = Character.valueOf(aParentSequence.charAt(aEnd + 1));
                if (this.iCtermCleavables.get(residue2) != null) {
                    if (aEnd + 2 < maxLength) {
                        if (this.iRestrictors.get(Character.valueOf(aParentSequence.charAt(aEnd + 2))) == null) {
                            result += 2;
                        }
                    } else {
                        result += 2;
                    }
                }
            } else if (aEnd == maxLength - 1) {
                result += 2;
            }
        }
        switch (result) {
            case 0: {
                result = 4;
                break;
            }
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 3;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            default: {
                throw new RuntimeException("A number larger than 3 has been calculated for the 'enzymaticness' of a peptide.");
            }
        }
        return result;
    }

    private boolean isCleavable(char[] aSequence, int aPosition, HashMap aCleavables, HashMap aRestrictors) {
        boolean cleavable = false;
        if (aPosition >= aSequence.length || aPosition < 0) {
            throw new IllegalArgumentException("Your position (" + aPosition + ") was outside of sequence boundaries (0, " + (aSequence.length - 1) + ")!");
        }
        if (aCleavables.containsKey(Character.valueOf(aSequence[aPosition]))) {
            cleavable = aPosition + 1 >= aSequence.length || !aRestrictors.containsKey(Character.valueOf(aSequence[aPosition + 1]));
        }
        return cleavable;
    }

    public static void main(String[] args) {
        DualEnzyme dual = new DualEnzyme("TestDualEnzyme", "D", "R", "P", "Cterm", 0);
        Protein[] p = ((Enzyme)dual).cleave(new Protein(">sw|Q55645 (15-45)|TEST_HUMAN Test Protein for the cleave() method.", "FGHDKLMDTGKRVWRGHF"));
        for (int i = 0; i < p.length; ++i) {
            Protein lProtein = p[i];
            logger.info((Object)lProtein.getHeader().getFullHeaderWithAddenda());
            logger.info((Object)lProtein.getSequence().getSequence());
        }
    }
}

