package com.compomics.software.dialogs;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 * A dialog used to set up the connection to Relims.
 *
 * @deprecated the original relims is not used anymore
 * @author Harald Barsnes
 */
public class RelimsSetupDialog extends javax.swing.JDialog {

    /**
     * The utilities preferences.
     */
    private UtilitiesUserPreferences utilitiesUserPreferences;
    /**
     * The selected folder.
     */
    private String lastSelectedFolder = "";

    /**
     * Creates a new RelimsSetupDialog.
     * 
     * @param parent
     * @param modal
     * @throws FileNotFoundException
     * @throws IOException
     * @throws ClassNotFoundException 
     */
    public RelimsSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super(parent, modal);

        initComponents();

        utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        
        // display the current relims path
        if (utilitiesUserPreferences != null) {
            relimsInstallationJTextField.setText(utilitiesUserPreferences.getRelimsPath());
            lastSelectedFolder = utilitiesUserPreferences.getRelimsPath();
        }

        setLocationRelativeTo(parent);
        setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel2 = new javax.swing.JLabel();
        backgroundPanel = new javax.swing.JPanel();
        relimsInstallationPanel = new javax.swing.JPanel();
        relimsInstallationJTextField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        relimsJarFileHelpLabel = new javax.swing.JLabel();
        relimsDownloadPanel = new javax.swing.JPanel();
        relimsInfoLabel = new javax.swing.JLabel();
        relimsDownloadLinkLabel = new javax.swing.JLabel();
        relimsButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        jLabel2.setText("jLabel2");

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Relims Settings");
        setResizable(false);

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        relimsInstallationPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Relims Installation"));
        relimsInstallationPanel.setOpaque(false);

        relimsInstallationJTextField.setEditable(false);
        relimsInstallationJTextField.setToolTipText("The folder containing the Relims jar file.");

        browseButton.setText("Browse");
        browseButton.setToolTipText("The folder containing the Relims jar file.");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        relimsJarFileHelpLabel.setFont(relimsJarFileHelpLabel.getFont().deriveFont((relimsJarFileHelpLabel.getFont().getStyle() | java.awt.Font.ITALIC)));
        relimsJarFileHelpLabel.setText("Please locate the folder containing the Relims jar file.");

        javax.swing.GroupLayout relimsInstallationPanelLayout = new javax.swing.GroupLayout(relimsInstallationPanel);
        relimsInstallationPanel.setLayout(relimsInstallationPanelLayout);
        relimsInstallationPanelLayout.setHorizontalGroup(
            relimsInstallationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, relimsInstallationPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(relimsInstallationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(relimsInstallationPanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(relimsJarFileHelpLabel))
                    .addComponent(relimsInstallationJTextField))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(browseButton)
                .addContainerGap())
        );
        relimsInstallationPanelLayout.setVerticalGroup(
            relimsInstallationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(relimsInstallationPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(relimsInstallationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(relimsInstallationJTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(relimsJarFileHelpLabel)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        relimsDownloadPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Download Relims"));
        relimsDownloadPanel.setOpaque(false);

        relimsInfoLabel.setFont(relimsInfoLabel.getFont().deriveFont(relimsInfoLabel.getFont().getStyle() | java.awt.Font.BOLD));
        relimsInfoLabel.setText("Relims - re-analyze public PRIDE projects with user defined search parameters");

        relimsDownloadLinkLabel.setText("<html>Download here: <a href> http://compomics-relims.googlecode.com</a></html>");
        relimsDownloadLinkLabel.setToolTipText("Go to http://relims.googlecode.com");
        relimsDownloadLinkLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                relimsDownloadLinkLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                relimsDownloadLinkLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                relimsDownloadLinkLabelMouseExited(evt);
            }
        });

        relimsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/relims_logo.png"))); // NOI18N
        relimsButton.setToolTipText("Go to http://relims.googlecode.com");
        relimsButton.setBorderPainted(false);
        relimsButton.setContentAreaFilled(false);
        relimsButton.setFocusPainted(false);
        relimsButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                relimsButtonMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                relimsButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                relimsButtonMouseExited(evt);
            }
        });

        javax.swing.GroupLayout relimsDownloadPanelLayout = new javax.swing.GroupLayout(relimsDownloadPanel);
        relimsDownloadPanel.setLayout(relimsDownloadPanelLayout);
        relimsDownloadPanelLayout.setHorizontalGroup(
            relimsDownloadPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(relimsDownloadPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(relimsDownloadPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(relimsInfoLabel)
                    .addComponent(relimsDownloadLinkLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 60, Short.MAX_VALUE)
                .addComponent(relimsButton)
                .addContainerGap())
        );
        relimsDownloadPanelLayout.setVerticalGroup(
            relimsDownloadPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(relimsDownloadPanelLayout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addComponent(relimsInfoLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(relimsDownloadLinkLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addComponent(relimsButton)
        );

        okButton.setText("OK");
        okButton.setEnabled(false);
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(relimsDownloadPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(okButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelButton))
                    .addComponent(relimsInstallationPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        backgroundPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(relimsInstallationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(relimsDownloadPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Close the dialog without saving.
     *
     * @param evt
     */
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * Open a file chooser were the user can select the Relims jar file.
     *
     * @param evt
     */
    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
 
        File selectedFile = Util.getUserSelectedFile(this, ".jar", "Relims jar file (.jar)", "Select Relims Jar File", lastSelectedFolder, true);

        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", JOptionPane.WARNING_MESSAGE);
                okButton.setEnabled(false);
            } else if (selectedFile.getName().indexOf("relims") == -1) {
                JOptionPane.showMessageDialog(this, "The selected file is not a Relims jar file!", "Wrong File Selected", JOptionPane.WARNING_MESSAGE);
                okButton.setEnabled(false);
            } else {
                // file assumed to be ok
                lastSelectedFolder = selectedFile.getPath();
                relimsInstallationJTextField.setText(lastSelectedFolder);
                okButton.setEnabled(true);
            }
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    /**
     * Save the Relims mapping and close the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        utilitiesUserPreferences.setRelimsPath(relimsInstallationJTextField.getText());
        try {
            UtilitiesUserPreferences.saveUserPreferences(utilitiesUserPreferences);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", JOptionPane.WARNING_MESSAGE);
        }
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void relimsDownloadLinkLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsDownloadLinkLabelMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_relimsDownloadLinkLabelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void relimsDownloadLinkLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsDownloadLinkLabelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_relimsDownloadLinkLabelMouseExited

    /**
     * Opens the Relims web page.
     *
     * @param evt
     */
    private void relimsDownloadLinkLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsDownloadLinkLabelMouseClicked
        openRelimsWebPage();
    }//GEN-LAST:event_relimsDownloadLinkLabelMouseClicked

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void relimsButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_relimsButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void relimsButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_relimsButtonMouseExited

    /**
     * Opens the Relims web page.
     *
     * @param evt
     */
    private void relimsButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_relimsButtonMouseClicked
        openRelimsWebPage();
    }//GEN-LAST:event_relimsButtonMouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JButton browseButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton okButton;
    private javax.swing.JButton relimsButton;
    private javax.swing.JLabel relimsDownloadLinkLabel;
    private javax.swing.JPanel relimsDownloadPanel;
    private javax.swing.JLabel relimsInfoLabel;
    private javax.swing.JTextField relimsInstallationJTextField;
    private javax.swing.JPanel relimsInstallationPanel;
    private javax.swing.JLabel relimsJarFileHelpLabel;
    // End of variables declaration//GEN-END:variables

    /**
     * Opens the Relims web page.
     */
    private void openRelimsWebPage() {
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("http://compomics-relims.googlecode.com");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }
}
