package com.compomics.util.gui;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialogParent;
import java.awt.*;
import java.util.*;
import javax.swing.*;

/**
 * A dialog for creating and displaying Venn diagrams. (Work in progress...)
 *
 * @author Harald Barsnes
 */
public class VennDiagramDialog extends javax.swing.JDialog implements ExportGraphicsDialogParent {

    /**
     * The dialog parent.
     */
    private Frame dialogParent;
    /**
     * The last selected folder.
     */
    private String lastSelectedFolder = "user.home";
    /**
     * The normal icon for the parent dialog.
     */
    private Image normalIcon;
    /**
     * The icon to use when busy.
     */
    private Image waitingIcon;
    /**
     * The Venn diagram panel.
     */
    private VennDiagramPanel vennDiagramPanel;

    /**
     * Creates a new XYPlottingDialog.
     *
     * @param dialogParent the dialog parent
     * @param modal
     * @param normalIcon the normal icon for the parent dialog
     * @param waitingIcon the icon to use when busy
     */
    public VennDiagramDialog(java.awt.Frame dialogParent, Image normalIcon, Image waitingIcon, boolean modal) {
        super(dialogParent, modal);
        initComponents();
        this.dialogParent = dialogParent;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;

        // default dataset colors
        int alphaLevel = 150;
        datasetAColorJPanel.setBackground(new java.awt.Color(0, 0, 255, alphaLevel));
        datasetBColorJPanel.setBackground(new java.awt.Color(0, 255, 0, alphaLevel));
        datasetCColorJPanel.setBackground(new java.awt.Color(255, 255, 0, alphaLevel));
        datasetDColorJPanel.setBackground(new java.awt.Color(255, 0, 0, alphaLevel));

        setUpGUI();
        setLocationRelativeTo(dialogParent);

        plotLayeredPaneComponentResized(null);
        setVisible(true);
    }

    /**
     * Main method. For testing purposes only.
     *
     * @param args
     */
    public static void main(String args[]) {

        // set the look and feel
        try {
            UtilitiesGUIDefaults.setLookAndFeel();
        } catch (Exception e) {
            // ignore
        }

        new VennDiagramDialog(new JFrame(), null, null, true);
    }

    /**
     * Set up the GUI.
     */
    private void setUpGUI() {

        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        ArrayList<String> c = new ArrayList<String>();
        ArrayList<String> d = new ArrayList<String>();

        String datasetA = datasetATextArea.getText();
        if (datasetA.trim().length() > 0) {
            String[] lines = datasetA.split("\n");
            a.addAll(Arrays.asList(lines));
        }

        String datasetB = datasetBTextArea.getText();
        if (datasetB.trim().length() > 0) {
            String[] lines = datasetB.split("\n");
            b.addAll(Arrays.asList(lines));
        }

        String datasetC = datasetCTextArea.getText();
        if (datasetC.trim().length() > 0) {
            String[] lines = datasetC.split("\n");
            c.addAll(Arrays.asList(lines));
        }

        String datasetD = datasetDTextArea.getText();
        if (datasetD.trim().length() > 0) {
            String[] lines = datasetD.split("\n");
            d.addAll(Arrays.asList(lines));
        }
        
        vennDiagramPanel = new VennDiagramPanel(a, b, c, d,
                datasetATextField.getText(), datasetBTextField.getText(), datasetCTextField.getText(), datasetDTextField.getText(),
                datasetAColorJPanel.getBackground(), datasetBColorJPanel.getBackground(), datasetCColorJPanel.getBackground(), datasetDColorJPanel.getBackground());
        xyPlotPanel.removeAll();
        xyPlotPanel.add(vennDiagramPanel);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        plotPopupMenu = new javax.swing.JPopupMenu();
        exportPlotMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        legendCheckBoxMenuItem = new javax.swing.JCheckBoxMenuItem();
        legendLocationMenuItem = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        fontSizeMenu = new javax.swing.JMenu();
        valueFontSizeMenuItem = new javax.swing.JMenuItem();
        legendFontSizeMenuItem = new javax.swing.JMenuItem();
        backgroundPanel = new javax.swing.JPanel();
        plotLayeredPane = new javax.swing.JLayeredPane();
        xyPlotPanel = new javax.swing.JPanel();
        plotOptionsJButton = new javax.swing.JButton();
        plotHelpJButton = new javax.swing.JButton();
        contextMenuPlotBackgroundPanel = new javax.swing.JPanel();
        dataPanel = new javax.swing.JPanel();
        datasetAScrollPane = new javax.swing.JScrollPane();
        datasetATextArea = new javax.swing.JTextArea();
        datasetBScrollPane = new javax.swing.JScrollPane();
        datasetBTextArea = new javax.swing.JTextArea();
        datasetCScrollPane = new javax.swing.JScrollPane();
        datasetCTextArea = new javax.swing.JTextArea();
        datasetDScrollPane = new javax.swing.JScrollPane();
        datasetDTextArea = new javax.swing.JTextArea();
        datasetATextField = new javax.swing.JTextField();
        datasetBTextField = new javax.swing.JTextField();
        datasetCTextField = new javax.swing.JTextField();
        datasetDTextField = new javax.swing.JTextField();
        datasetAColorJPanel = new javax.swing.JPanel();
        datasetBColorJPanel = new javax.swing.JPanel();
        datasetCColorJPanel = new javax.swing.JPanel();
        datasetDColorJPanel = new javax.swing.JPanel();

        exportPlotMenuItem.setText("Export");
        exportPlotMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportPlotMenuItemActionPerformed(evt);
            }
        });
        plotPopupMenu.add(exportPlotMenuItem);
        plotPopupMenu.add(jSeparator1);

        legendCheckBoxMenuItem.setSelected(true);
        legendCheckBoxMenuItem.setText("Show Legend");
        legendCheckBoxMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                legendCheckBoxMenuItemActionPerformed(evt);
            }
        });
        plotPopupMenu.add(legendCheckBoxMenuItem);

        legendLocationMenuItem.setText("Legend Location");
        legendLocationMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                legendLocationMenuItemActionPerformed(evt);
            }
        });
        plotPopupMenu.add(legendLocationMenuItem);
        plotPopupMenu.add(jSeparator2);

        fontSizeMenu.setText("Font Size");

        valueFontSizeMenuItem.setText("Values");
        valueFontSizeMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                valueFontSizeMenuItemActionPerformed(evt);
            }
        });
        fontSizeMenu.add(valueFontSizeMenuItem);

        legendFontSizeMenuItem.setText("Legend");
        legendFontSizeMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                legendFontSizeMenuItemActionPerformed(evt);
            }
        });
        fontSizeMenu.add(legendFontSizeMenuItem);

        plotPopupMenu.add(fontSizeMenu);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Statistics");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        backgroundPanel.setBackground(new java.awt.Color(255, 255, 255));
        backgroundPanel.setPreferredSize(new java.awt.Dimension(600, 600));

        plotLayeredPane.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                plotLayeredPaneComponentResized(evt);
            }
        });

        xyPlotPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Venn Diagram"));
        xyPlotPanel.setOpaque(false);
        xyPlotPanel.setLayout(new javax.swing.BoxLayout(xyPlotPanel, javax.swing.BoxLayout.Y_AXIS));
        plotLayeredPane.add(xyPlotPanel);
        xyPlotPanel.setBounds(0, 0, 580, 360);

        plotOptionsJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/contextual_menu_gray.png"))); // NOI18N
        plotOptionsJButton.setToolTipText("Plot Options");
        plotOptionsJButton.setBorder(null);
        plotOptionsJButton.setBorderPainted(false);
        plotOptionsJButton.setContentAreaFilled(false);
        plotOptionsJButton.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/contextual_menu_black.png"))); // NOI18N
        plotOptionsJButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                plotOptionsJButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                plotOptionsJButtonMouseExited(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                plotOptionsJButtonMouseReleased(evt);
            }
        });
        plotLayeredPane.add(plotOptionsJButton);
        plotOptionsJButton.setBounds(550, 5, 10, 19);
        plotLayeredPane.setLayer(plotOptionsJButton, javax.swing.JLayeredPane.POPUP_LAYER);

        plotHelpJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help_no_frame_grey.png"))); // NOI18N
        plotHelpJButton.setToolTipText("Help");
        plotHelpJButton.setBorder(null);
        plotHelpJButton.setBorderPainted(false);
        plotHelpJButton.setContentAreaFilled(false);
        plotHelpJButton.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help_no_frame.png"))); // NOI18N
        plotHelpJButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                plotHelpJButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                plotHelpJButtonMouseExited(evt);
            }
        });
        plotHelpJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotHelpJButtonActionPerformed(evt);
            }
        });
        plotLayeredPane.add(plotHelpJButton);
        plotHelpJButton.setBounds(570, 0, 10, 19);
        plotLayeredPane.setLayer(plotHelpJButton, javax.swing.JLayeredPane.POPUP_LAYER);

        contextMenuPlotBackgroundPanel.setBackground(new java.awt.Color(255, 255, 255));

        javax.swing.GroupLayout contextMenuPlotBackgroundPanelLayout = new javax.swing.GroupLayout(contextMenuPlotBackgroundPanel);
        contextMenuPlotBackgroundPanel.setLayout(contextMenuPlotBackgroundPanelLayout);
        contextMenuPlotBackgroundPanelLayout.setHorizontalGroup(
            contextMenuPlotBackgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 30, Short.MAX_VALUE)
        );
        contextMenuPlotBackgroundPanelLayout.setVerticalGroup(
            contextMenuPlotBackgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 19, Short.MAX_VALUE)
        );

        plotLayeredPane.add(contextMenuPlotBackgroundPanel);
        contextMenuPlotBackgroundPanel.setBounds(550, 0, 30, 19);
        plotLayeredPane.setLayer(contextMenuPlotBackgroundPanel, javax.swing.JLayeredPane.POPUP_LAYER);

        dataPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Data"));
        dataPanel.setOpaque(false);

        datasetATextArea.setTabSize(4);
        datasetATextArea.setText("1\n2\n3\n4\n5");
        datasetATextArea.setToolTipText("");
        datasetATextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetATextAreaKeyReleased(evt);
            }
        });
        datasetAScrollPane.setViewportView(datasetATextArea);

        datasetBTextArea.setTabSize(4);
        datasetBTextArea.setText("3\n5\n6");
        datasetBTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetBTextAreaKeyReleased(evt);
            }
        });
        datasetBScrollPane.setViewportView(datasetBTextArea);

        datasetCTextArea.setColumns(2);
        datasetCTextArea.setTabSize(4);
        datasetCTextArea.setText("3\n6\n7");
        datasetCTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetCTextAreaKeyReleased(evt);
            }
        });
        datasetCScrollPane.setViewportView(datasetCTextArea);

        datasetDTextArea.setColumns(2);
        datasetDTextArea.setTabSize(4);
        datasetDTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetDTextAreaKeyReleased(evt);
            }
        });
        datasetDScrollPane.setViewportView(datasetDTextArea);

        datasetATextField.setText("Dataset A");
        datasetATextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetATextFieldKeyReleased(evt);
            }
        });

        datasetBTextField.setText("Dataset B");
        datasetBTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetBTextFieldKeyReleased(evt);
            }
        });

        datasetCTextField.setText("Dataset C");
        datasetCTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetCTextFieldKeyReleased(evt);
            }
        });

        datasetDTextField.setText("Dataset D");
        datasetDTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                datasetDTextFieldKeyReleased(evt);
            }
        });

        datasetAColorJPanel.setBackground(new java.awt.Color(0, 0, 255));
        datasetAColorJPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        datasetAColorJPanel.setToolTipText("The color used for Peptide A");
        datasetAColorJPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                datasetAColorJPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout datasetAColorJPanelLayout = new javax.swing.GroupLayout(datasetAColorJPanel);
        datasetAColorJPanel.setLayout(datasetAColorJPanelLayout);
        datasetAColorJPanelLayout.setHorizontalGroup(
            datasetAColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );
        datasetAColorJPanelLayout.setVerticalGroup(
            datasetAColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        datasetBColorJPanel.setBackground(new java.awt.Color(0, 255, 0));
        datasetBColorJPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        datasetBColorJPanel.setToolTipText("The color used for Peptide A");
        datasetBColorJPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                datasetBColorJPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout datasetBColorJPanelLayout = new javax.swing.GroupLayout(datasetBColorJPanel);
        datasetBColorJPanel.setLayout(datasetBColorJPanelLayout);
        datasetBColorJPanelLayout.setHorizontalGroup(
            datasetBColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );
        datasetBColorJPanelLayout.setVerticalGroup(
            datasetBColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        datasetCColorJPanel.setBackground(new java.awt.Color(255, 255, 0));
        datasetCColorJPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        datasetCColorJPanel.setToolTipText("The color used for Peptide A");
        datasetCColorJPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                datasetCColorJPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout datasetCColorJPanelLayout = new javax.swing.GroupLayout(datasetCColorJPanel);
        datasetCColorJPanel.setLayout(datasetCColorJPanelLayout);
        datasetCColorJPanelLayout.setHorizontalGroup(
            datasetCColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );
        datasetCColorJPanelLayout.setVerticalGroup(
            datasetCColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        datasetDColorJPanel.setBackground(new java.awt.Color(255, 0, 0));
        datasetDColorJPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        datasetDColorJPanel.setToolTipText("The color used for Peptide A");
        datasetDColorJPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                datasetDColorJPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout datasetDColorJPanelLayout = new javax.swing.GroupLayout(datasetDColorJPanel);
        datasetDColorJPanel.setLayout(datasetDColorJPanelLayout);
        datasetDColorJPanelLayout.setHorizontalGroup(
            datasetDColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );
        datasetDColorJPanelLayout.setVerticalGroup(
            datasetDColorJPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout dataPanelLayout = new javax.swing.GroupLayout(dataPanel);
        dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(
            dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dataPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(datasetAScrollPane)
                    .addGroup(dataPanelLayout.createSequentialGroup()
                        .addComponent(datasetATextField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(datasetAColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(datasetBScrollPane)
                    .addGroup(dataPanelLayout.createSequentialGroup()
                        .addComponent(datasetBTextField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(datasetBColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(datasetCScrollPane)
                    .addGroup(dataPanelLayout.createSequentialGroup()
                        .addComponent(datasetCTextField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(datasetCColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(datasetDScrollPane)
                    .addGroup(dataPanelLayout.createSequentialGroup()
                        .addComponent(datasetDTextField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(datasetDColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        dataPanelLayout.setVerticalGroup(
            dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dataPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(datasetATextField)
                    .addComponent(datasetAColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetBTextField)
                    .addComponent(datasetCTextField)
                    .addComponent(datasetDTextField)
                    .addComponent(datasetBColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetCColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetDColorJPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(dataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(datasetAScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 137, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetBScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 137, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetCScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 137, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(datasetDScrollPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 137, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        dataPanelLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {datasetATextField, datasetBTextField, datasetCTextField, datasetDTextField});

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(plotLayeredPane, javax.swing.GroupLayout.DEFAULT_SIZE, 580, Short.MAX_VALUE)
                    .addComponent(dataPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(plotLayeredPane, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dataPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(0, 0, 0))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Change the cursor into a hand cursor.
     *
     * @param evt
     */
    private void plotOptionsJButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotOptionsJButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_plotOptionsJButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void plotOptionsJButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotOptionsJButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_plotOptionsJButtonMouseExited

    /**
     * Show the options for the plot.
     *
     * @param evt
     */
    private void plotOptionsJButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotOptionsJButtonMouseReleased
        plotPopupMenu.show(plotOptionsJButton, evt.getX(), evt.getY());
    }//GEN-LAST:event_plotOptionsJButtonMouseReleased

    /**
     * Export the plot to file.
     *
     * @param evt
     */
    private void exportPlotMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportPlotMenuItemActionPerformed
        new ExportGraphicsDialog(this, this, true, vennDiagramPanel.getChartPanel());
    }//GEN-LAST:event_exportPlotMenuItemActionPerformed

    /**
     * Change the cursor into a hand cursor.
     *
     * @param evt
     */
    private void plotHelpJButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotHelpJButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_plotHelpJButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void plotHelpJButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotHelpJButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_plotHelpJButtonMouseExited

    /**
     * Open the help dialog.
     *
     * @param evt
     */
    private void plotHelpJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotHelpJButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        new HelpDialog(this, getClass().getResource("/helpFiles/VennDiagramDialog.html"), // @TODO: setup the help page
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                "Statistics - Help");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_plotHelpJButtonActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        System.exit(0); // @TODO: remove method when testing is done!
    }//GEN-LAST:event_formWindowClosing

    /**
     * Resize the layered pane.
     *
     * @param evt
     */
    private void plotLayeredPaneComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_plotLayeredPaneComponentResized
        // resize the layered panels
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {

                // move the icons
                plotLayeredPane.getComponent(0).setBounds(
                        plotLayeredPane.getWidth() - plotLayeredPane.getComponent(0).getWidth() - 22,
                        -2,
                        plotLayeredPane.getComponent(0).getWidth(),
                        plotLayeredPane.getComponent(0).getHeight());

                plotLayeredPane.getComponent(1).setBounds(
                        plotLayeredPane.getWidth() - plotLayeredPane.getComponent(1).getWidth() - 10,
                        -4,
                        plotLayeredPane.getComponent(1).getWidth(),
                        plotLayeredPane.getComponent(1).getHeight());

                plotLayeredPane.getComponent(2).setBounds(
                        plotLayeredPane.getWidth() - plotLayeredPane.getComponent(2).getWidth() - 5,
                        -3,
                        plotLayeredPane.getComponent(2).getWidth(),
                        plotLayeredPane.getComponent(2).getHeight());

                // resize the plot area
                plotLayeredPane.getComponent(3).setBounds(0, 0, plotLayeredPane.getWidth(), plotLayeredPane.getHeight());
                
                if (vennDiagramPanel != null) {
                    vennDiagramPanel.resizePlot(plotLayeredPane.getWidth(), plotLayeredPane.getHeight());
                }

                plotLayeredPane.revalidate();
                plotLayeredPane.repaint();
            }
        });
    }//GEN-LAST:event_plotLayeredPaneComponentResized

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetATextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetATextAreaKeyReleased
        setUpGUI();
        vennDiagramPanel.updatePlot();
        plotLayeredPaneComponentResized(null);
    }//GEN-LAST:event_datasetATextAreaKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetCTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetCTextAreaKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetCTextAreaKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetDTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetDTextAreaKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetDTextAreaKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetATextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetATextFieldKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetATextFieldKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetBTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetBTextFieldKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetBTextFieldKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetCTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetCTextFieldKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetCTextFieldKeyReleased

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetDTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetDTextFieldKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetDTextFieldKeyReleased

    /**
     * Change the color of dataset A.
     *
     * @param evt
     */
    private void datasetAColorJPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_datasetAColorJPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", datasetAColorJPanel.getBackground());

        if (newColor != null) {
            datasetAColorJPanel.setBackground(newColor);
            vennDiagramPanel.updatePlot();
        }
    }//GEN-LAST:event_datasetAColorJPanelMouseClicked

    /**
     * Change the color of dataset B.
     *
     * @param evt
     */
    private void datasetBColorJPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_datasetBColorJPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", datasetBColorJPanel.getBackground());

        if (newColor != null) {
            datasetBColorJPanel.setBackground(newColor);
            vennDiagramPanel.updatePlot();
        }
    }//GEN-LAST:event_datasetBColorJPanelMouseClicked

    /**
     * Change the color of dataset C.
     *
     * @param evt
     */
    private void datasetCColorJPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_datasetCColorJPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", datasetCColorJPanel.getBackground());

        if (newColor != null) {
            datasetCColorJPanel.setBackground(newColor);
            vennDiagramPanel.updatePlot();
        }
    }//GEN-LAST:event_datasetCColorJPanelMouseClicked

    /**
     * Change the color of dataset D.
     *
     * @param evt
     */
    private void datasetDColorJPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_datasetDColorJPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", datasetDColorJPanel.getBackground());

        if (newColor != null) {
            datasetDColorJPanel.setBackground(newColor);
            vennDiagramPanel.updatePlot();
        }
    }//GEN-LAST:event_datasetDColorJPanelMouseClicked

    /**
     * Turn the legend on/off.
     *
     * @param evt
     */
    private void legendCheckBoxMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_legendCheckBoxMenuItemActionPerformed
        vennDiagramPanel.setShowLegend(legendCheckBoxMenuItem.isSelected());
        vennDiagramPanel.updatePlot();
    }//GEN-LAST:event_legendCheckBoxMenuItemActionPerformed

    /**
     * Allow the user to change the value font size.
     *
     * @param evt
     */
    private void valueFontSizeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_valueFontSizeMenuItemActionPerformed
        String value = JOptionPane.showInputDialog(this, "Values Font Size:", vennDiagramPanel.getFontSize());

        if (value != null) {
            try {
                vennDiagramPanel.setFontSize(Integer.parseInt(value));
                vennDiagramPanel.updatePlot();
            } catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }//GEN-LAST:event_valueFontSizeMenuItemActionPerformed

    /**
     * Allow the user to change the legend font size.
     *
     * @param evt
     */
    private void legendFontSizeMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_legendFontSizeMenuItemActionPerformed
        String value = JOptionPane.showInputDialog(this, "Legend Font Size:", vennDiagramPanel.getFontSizeLegend());

        if (value != null) {
            try {
                vennDiagramPanel.setFontSizeLegend(Integer.parseInt(value));
                vennDiagramPanel.updatePlot();
            } catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Font size has to be an integer!", "Font Error", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }//GEN-LAST:event_legendFontSizeMenuItemActionPerformed

    /**
     * Update the plot.
     *
     * @param evt
     */
    private void datasetBTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_datasetBTextAreaKeyReleased
        datasetATextAreaKeyReleased(null);
    }//GEN-LAST:event_datasetBTextAreaKeyReleased

    /**
     * Open the legend location dialog.
     *
     * @param evt
     */
    private void legendLocationMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_legendLocationMenuItemActionPerformed
        new VennDiagramLegendLocationDialog(this, true);
    }//GEN-LAST:event_legendLocationMenuItemActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JPanel contextMenuPlotBackgroundPanel;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JPanel datasetAColorJPanel;
    private javax.swing.JScrollPane datasetAScrollPane;
    private javax.swing.JTextArea datasetATextArea;
    private javax.swing.JTextField datasetATextField;
    private javax.swing.JPanel datasetBColorJPanel;
    private javax.swing.JScrollPane datasetBScrollPane;
    private javax.swing.JTextArea datasetBTextArea;
    private javax.swing.JTextField datasetBTextField;
    private javax.swing.JPanel datasetCColorJPanel;
    private javax.swing.JScrollPane datasetCScrollPane;
    private javax.swing.JTextArea datasetCTextArea;
    private javax.swing.JTextField datasetCTextField;
    private javax.swing.JPanel datasetDColorJPanel;
    private javax.swing.JScrollPane datasetDScrollPane;
    private javax.swing.JTextArea datasetDTextArea;
    private javax.swing.JTextField datasetDTextField;
    private javax.swing.JMenuItem exportPlotMenuItem;
    private javax.swing.JMenu fontSizeMenu;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JCheckBoxMenuItem legendCheckBoxMenuItem;
    private javax.swing.JMenuItem legendFontSizeMenuItem;
    private javax.swing.JMenuItem legendLocationMenuItem;
    private javax.swing.JButton plotHelpJButton;
    private javax.swing.JLayeredPane plotLayeredPane;
    private javax.swing.JButton plotOptionsJButton;
    private javax.swing.JPopupMenu plotPopupMenu;
    private javax.swing.JMenuItem valueFontSizeMenuItem;
    private javax.swing.JPanel xyPlotPanel;
    // End of variables declaration//GEN-END:variables

    public void setSelectedExportFolder(String selectedFolder) {
        lastSelectedFolder = selectedFolder;
    }

    public String getDefaultExportFolder() {
        return lastSelectedFolder;
    }

    public Image getNormalIcon() {
        return Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/compomics-utilities.png"));
    }

    public Image getWaitingIcon() {
        return Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/compomics-utilities.png"));
    }
    
    /**
     * Returns the Venn diagram panel.
     * 
     * @return the Venn diagram panel
     */
    public VennDiagramPanel getVennDiagramPanel() {
        return vennDiagramPanel;
    }
}
