package com.compomics.util.gui.error_handlers.notification;

/**
 * An undecorated dialog for displaying notifications.
 *
 * @author Harald Barsnes
 */
public class NotificationDialog extends javax.swing.JDialog {

    /**
     * The notification dialog parent.
     */
    private NotificationDialogParent notificationDialogParent;
    /**
     * The notification type.
     */
    private String notificationType;

    /**
     * Creates a new NotificationDialog.
     *
     * @param parent the parent dialog
     * @param notificationDialogParent the notification dialog parent
     * @param modal
     * @param notificationCount the number of notifications
     * @param notificationType the notification type as a string
     */
    public NotificationDialog(java.awt.Frame parent, NotificationDialogParent notificationDialogParent, boolean modal, int notificationCount, String notificationType) {
        super(parent, modal);
        initComponents();
        this.notificationDialogParent = notificationDialogParent;
        this.notificationType = notificationType;
        notificationLabel.setText(notificationCount + " new " + notificationType + "!");
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        notificationPanel = new javax.swing.JPanel();
        notificationLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setUndecorated(true);

        notificationPanel.setBackground(new java.awt.Color(230, 230, 230));
        notificationPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        notificationPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                notificationPanelMouseReleased(evt);
            }
        });

        notificationLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        notificationLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        notificationLabel.setText("5 new tweets!");

        javax.swing.GroupLayout notificationPanelLayout = new javax.swing.GroupLayout(notificationPanel);
        notificationPanel.setLayout(notificationPanelLayout);
        notificationPanelLayout.setHorizontalGroup(
            notificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(notificationPanelLayout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(notificationLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 109, Short.MAX_VALUE)
                .addGap(10, 10, 10))
        );
        notificationPanelLayout.setVerticalGroup(
            notificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, notificationPanelLayout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(notificationLabel)
                .addGap(10, 10, 10))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(notificationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(notificationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Inform the notification dialog parent that the user clicked the
     * notification.
     *
     * @param evt
     */
    private void notificationPanelMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_notificationPanelMouseReleased
        notificationDialogParent.notificationClicked(notificationType);
    }//GEN-LAST:event_notificationPanelMouseReleased
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel notificationLabel;
    private javax.swing.JPanel notificationPanel;
    // End of variables declaration//GEN-END:variables
}
