package com.compomics.util.gui.filehandling;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;

/**
 * Dialog for showing a list of selected files with the option to remove files
 * from the list.
 *
 * @author Harald Barsnes
 */
public class FileDisplayDialog extends javax.swing.JDialog {

    /**
     * The list of files.
     */
    private ArrayList<File> files;
    /**
     * True if the dialog was canceled by the user.
     */
    private boolean canceled = true;

    /**
     * Creates a new FileSelectionDialog.
     *
     * @param parent
     * @param files
     * @param modal
     */
    public FileDisplayDialog(JFrame parent, ArrayList<File> files, boolean modal) {
        super(parent, modal);
        initComponents();
        this.files = files;
        updateFileListing();
        setLocationRelativeTo(parent);
        setVisible(true);
    }

    /**
     * Creates a new FileSelectionDialog.
     *
     * @param parent
     * @param files
     * @param modal
     */
    public FileDisplayDialog(JDialog parent, ArrayList<File> files, boolean modal) {
        super(parent, modal);
        initComponents();
        this.files = files;
        updateFileListing();
        setLocationRelativeTo(parent);
        setVisible(true);
    }

    /**
     * Update the file listing.
     */
    private void updateFileListing() {
        String fileListing = "<html><ol>";

        for (int i = 0; i < files.size(); i++) {
            fileListing += "<li>" + files.get(i).getName() + " - <a href=\"" + i + "\">remove</a></li>";
        }

        fileListing += "</ol></html>";
        selectedFilesEditorPane.setText(fileListing);
        selectedFilesEditorPane.setCaretPosition(0);
    }

    /**
     * Returns if the dialog was canceled by the user.
     *
     * @return true if the dialog was canceled by the user
     */
    public boolean canceled() {
        return canceled;
    }

    /**
     * Returns the list of selected files.
     *
     * @return the list of selected files
     */
    public ArrayList<File> getSelectedFiles() {
        return files;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        selectedFilesScrollPane = new javax.swing.JScrollPane();
        selectedFilesEditorPane = new javax.swing.JEditorPane();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Selected Files");
        setMinimumSize(new java.awt.Dimension(300, 300));

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        selectedFilesEditorPane.setEditable(false);
        selectedFilesEditorPane.setContentType("text/html"); // NOI18N
        selectedFilesEditorPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                selectedFilesEditorPaneHyperlinkUpdate(evt);
            }
        });
        selectedFilesScrollPane.setViewportView(selectedFilesEditorPane);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(selectedFilesScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(okButton)))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(selectedFilesScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 236, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(okButton)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Closes the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        canceled = false;
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Make the links active.
     *
     * @param evt
     */
    private void selectedFilesEditorPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_selectedFilesEditorPaneHyperlinkUpdate
        if (evt.getEventType().toString().equalsIgnoreCase(
                javax.swing.event.HyperlinkEvent.EventType.ENTERED.toString())) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        } else if (evt.getEventType().toString().equalsIgnoreCase(
                javax.swing.event.HyperlinkEvent.EventType.EXITED.toString())) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        } else if (evt.getEventType().toString().equalsIgnoreCase(
                javax.swing.event.HyperlinkEvent.EventType.ACTIVATED.toString())) {
            int selectedFileIndex = Integer.parseInt(evt.getDescription());
            files.remove(selectedFileIndex);
            updateFileListing();
            setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        }
    }//GEN-LAST:event_selectedFilesEditorPaneHyperlinkUpdate

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JEditorPane selectedFilesEditorPane;
    private javax.swing.JScrollPane selectedFilesScrollPane;
    // End of variables declaration//GEN-END:variables
}
