/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jimmc.jshortcut.JShellLink;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public abstract class FileDAO {
    public abstract boolean createDesktopShortcut(MavenJarFile var1, String var2, String var3, boolean var4) throws IOException;

    public boolean addShortcutAtDeskTop(MavenJarFile mavenJarFile) {
        return this.addShortcutAtDeskTop(mavenJarFile, null);
    }

    public boolean addShortcutAtDeskTop(MavenJarFile mavenJarFile, String iconName) throws NullPointerException, RuntimeException {
        JShellLink link = new JShellLink();
        link.setFolder(JShellLink.getDirectory((String)"desktop"));
        link.setName(mavenJarFile.getArtifactId() + "-" + mavenJarFile.getVersionNumber());
        if (iconName != null) {
            link.setIconLocation(new File(mavenJarFile.getAbsoluteFilePath()).getParentFile().getAbsolutePath() + "/resources/" + iconName);
        }
        link.setPath(mavenJarFile.getAbsoluteFilePath());
        link.save();
        return true;
    }

    public abstract File getLocationToDownloadOnDisk(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzipFile(ZipFile zip, File fileLocationOnDiskToDownloadTo) throws IOException {
        FileOutputStream dest = null;
        InputStream inStream = null;
        Enumeration<? extends ZipEntry> zipFileEnum = zip.entries();
        while (zipFileEnum.hasMoreElements()) {
            ZipEntry entry = zipFileEnum.nextElement();
            File destFile = new File(String.format("%s/%s", fileLocationOnDiskToDownloadTo, entry.getName()));
            if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                throw new IOException("could not create the folders to unzip in");
            }
            if (!entry.isDirectory()) {
                try {
                    dest = new FileOutputStream(destFile);
                    inStream = zip.getInputStream(entry);
                    IOUtils.copyLarge((InputStream)inStream, (OutputStream)dest);
                    continue;
                }
                finally {
                    if (dest != null) {
                        dest.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                    continue;
                }
            }
            if (destFile.exists() || destFile.mkdirs()) continue;
            throw new IOException("could not create folders to unzip file");
        }
        zip.close();
        return true;
    }

    public boolean unGzipAndUntarFile(GZIPInputStream in, File fileLocationOnDiskToDownloadTo, WaitingHandler waitingHandler) throws IOException {
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(fileLocationOnDiskToDownloadTo);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            in.close();
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            this.untar(fileLocationOnDiskToDownloadTo);
        }
        catch (IOException e) {
            if (waitingHandler != null) {
                waitingHandler.setRunCanceled();
            }
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean untar(File fileToUntar) throws FileNotFoundException, IOException {
        boolean fileUntarred = false;
        String untarLocation = fileToUntar.getParentFile().getAbsolutePath();
        TarArchiveInputStream tarStream = null;
        try {
            tarStream = new TarArchiveInputStream((InputStream)new FileInputStream(fileToUntar));
            BufferedReader bufferedTarReader = null;
            try {
                ArchiveEntry entry;
                bufferedTarReader = new BufferedReader(new InputStreamReader((InputStream)tarStream));
                while ((entry = tarStream.getNextEntry()) != null) {
                    byte[] buffer = new byte[8192];
                    File tempFile = new File(String.format("%s/%s", untarLocation, entry.getName()));
                    if (entry.isDirectory()) {
                        if (tempFile.exists()) continue;
                        tempFile.mkdir();
                        continue;
                    }
                    FileOutputStream output = new FileOutputStream(tempFile);
                    try {
                        int bytesRead;
                        while ((bytesRead = tarStream.read(buffer)) != -1) {
                            ((OutputStream)output).write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        ((OutputStream)output).close();
                    }
                    tempFile.setExecutable(true);
                }
            }
            finally {
                if (bufferedTarReader != null) {
                    bufferedTarReader.close();
                }
            }
        }
        finally {
            if (tarStream != null) {
                tarStream.close();
            }
        }
        return fileUntarred;
    }

    public MavenJarFile getMavenJarFileFromFolderWithArtifactId(File folder, String artifactId) throws IOException {
        MavenJarFile mainJarFile = null;
        for (File aFile : folder.listFiles()) {
            if (aFile.isDirectory()) {
                mainJarFile = this.getMavenJarFileFromFolderWithArtifactId(aFile, artifactId);
                if (mainJarFile == null) continue;
                break;
            }
            if (!aFile.getName().contains(artifactId) || !aFile.getName().contains("jar")) continue;
            mainJarFile = new MavenJarFile(aFile);
            break;
        }
        return mainJarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToDisk(InputStream in, String name, File outputLocationFolder) throws FileNotFoundException, IOException {
        if (!outputLocationFolder.exists() && !outputLocationFolder.mkdirs()) {
            throw new IOException("could not create the folders to write stream to disk");
        }
        File outputFile = new File(outputLocationFolder, name);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        in.close();
        return outputFile;
    }
}

