/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Peptide
extends ExperimentObject {
    static final long serialVersionUID = 5632064601627536034L;
    private String sequence;
    private Double mass = null;
    private ArrayList<String> parentProteins = null;
    private ArrayList<ModificationMatch> modifications = new ArrayList();
    public static final String MODIFICATION_LOCALIZATION_SEPARATOR = "-ATAA-";
    public static final String MODIFICATION_SEPARATOR = "_";

    public Peptide() {
    }

    public Peptide(String aSequence, ArrayList<String> parentProteins, ArrayList<ModificationMatch> modifications) throws IllegalArgumentException {
        this(aSequence, modifications);
        this.setParentProteins(parentProteins);
    }

    public Peptide(String aSequence, ArrayList<ModificationMatch> modifications) throws IllegalArgumentException {
        this.sequence = aSequence;
        this.sequence = this.sequence.replaceAll("[#*$%&]", "");
        HashMap ptmToPositionsMap = new HashMap();
        for (ModificationMatch mod : modifications) {
            if (mod.getTheoreticPtm().contains(MODIFICATION_SEPARATOR)) {
                throw new IllegalArgumentException("PTM names containing '_' are not supported. Conflicting name: " + mod.getTheoreticPtm());
            }
            if (mod.getTheoreticPtm().contains(MODIFICATION_LOCALIZATION_SEPARATOR)) {
                throw new IllegalArgumentException("PTM names containing '-ATAA-' are not supported. Conflicting name: " + mod.getTheoreticPtm());
            }
            String modName = mod.getTheoreticPtm();
            int position = mod.getModificationSite();
            if (!ptmToPositionsMap.containsKey(modName)) {
                ptmToPositionsMap.put(modName, new ArrayList());
            }
            ((ArrayList)ptmToPositionsMap.get(modName)).add(position);
            this.modifications.add(mod);
        }
    }

    public Peptide(String aSequence, Double mass, ArrayList<String> parentProteins, ArrayList<ModificationMatch> modifications) {
        this.sequence = aSequence;
        this.sequence = this.sequence.replaceAll("[#*$%&]", "");
        this.mass = mass;
        HashMap ptmToPositionsMap = new HashMap();
        for (ModificationMatch mod : modifications) {
            String modName = mod.getTheoreticPtm();
            int position = mod.getModificationSite();
            if (!ptmToPositionsMap.containsKey(modName)) {
                ptmToPositionsMap.put(modName, new ArrayList());
            }
            ((ArrayList)ptmToPositionsMap.get(modName)).add(position);
            this.modifications.add(mod);
        }
        this.setParentProteins(parentProteins);
    }

    public Double getMass() {
        if (this.mass == null) {
            this.estimateTheoreticMass();
        }
        return this.mass;
    }

    public ArrayList<ModificationMatch> getModificationMatches() {
        return this.modifications;
    }

    public void clearModificationMatches() {
        this.modifications.clear();
    }

    public void addModificationMatch(ModificationMatch modificationMatch) {
        this.modifications.add(modificationMatch);
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getNMissedCleavages(Enzyme enzyme) {
        return enzyme.getNmissedCleavages(this.sequence);
    }

    public static int getNMissedCleavages(String sequence, Enzyme enzyme) {
        int mc = 0;
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            if (enzyme.getAminoAcidBefore().contains(Character.valueOf(sequence.charAt(aa))) && !enzyme.getRestrictionAfter().contains(Character.valueOf(sequence.charAt(aa + 1)))) {
                ++mc;
            }
            if (!enzyme.getAminoAcidAfter().contains(Character.valueOf(sequence.charAt(aa + 1))) || enzyme.getAminoAcidBefore().contains(Character.valueOf(sequence.charAt(aa)))) continue;
            ++mc;
        }
        return mc;
    }

    public ArrayList<String> getParentProteins(boolean remap, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, ClassNotFoundException, InterruptedException, SQLException {
        if (!remap || this.parentProteins != null) {
            return this.parentProteins;
        }
        return this.getParentProteins(remap, matchingType, massTolerance, SequenceFactory.getInstance().getDefaultProteinTree());
    }

    public ArrayList<String> getParentProteins(AminoAcidPattern.MatchingType matchingType, Double massTolerance, ProteinTree proteinTree) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        return this.getParentProteins(true, matchingType, massTolerance, proteinTree);
    }

    public ArrayList<String> getParentProteins(AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        return this.getParentProteins(true, matchingType, massTolerance);
    }

    public ArrayList<String> getParentProteins(boolean remap, AminoAcidPattern.MatchingType matchingType, Double massTolerance, ProteinTree proteinTree) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        if (remap && this.parentProteins == null) {
            HashMap<String, HashMap<String, ArrayList<Integer>>> proteinMapping = proteinTree.getProteinMapping(this.sequence, matchingType, massTolerance, true);
            this.parentProteins = new ArrayList();
            for (String peptideSequence : proteinMapping.keySet()) {
                double xShare = (double)Util.getOccurrence(peptideSequence, 'X') / (double)this.sequence.length();
                if (!(xShare <= 0.25)) continue;
                HashMap<String, ArrayList<Integer>> subMapping = proteinMapping.get(peptideSequence);
                for (String accession : subMapping.keySet()) {
                    if (this.parentProteins.contains(accession)) continue;
                    this.parentProteins.add(accession);
                }
            }
            Collections.sort(this.parentProteins);
        }
        return this.parentProteins;
    }

    public ArrayList<String> getParentProteinsNoRemapping() {
        return this.parentProteins;
    }

    public void setParentProteins(ArrayList<String> parentProteins) {
        this.parentProteins = parentProteins;
    }

    public String getMatchingKey(AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        String matchingSequence = AminoAcid.getMatchingSequence(this.sequence, matchingType, massTolerance);
        return Peptide.getKey(matchingSequence, this.modifications);
    }

    public String getKey() {
        ArrayList<String> tempModifications = new ArrayList<String>();
        for (ModificationMatch mod : this.getModificationMatches()) {
            if (!mod.isVariable()) continue;
            if (mod.getTheoreticPtm() != null) {
                if (mod.isConfident() || mod.isInferred()) {
                    tempModifications.add(mod.getTheoreticPtm() + MODIFICATION_LOCALIZATION_SEPARATOR + mod.getModificationSite());
                    continue;
                }
                tempModifications.add(mod.getTheoreticPtm());
                continue;
            }
            tempModifications.add("unknown-modification");
        }
        Collections.sort(tempModifications);
        String result = this.sequence;
        for (String mod : tempModifications) {
            result = result + MODIFICATION_SEPARATOR + mod;
        }
        return result;
    }

    public static String getKey(String sequence, ArrayList<ModificationMatch> modificationMatches) {
        ArrayList<String> tempModifications = new ArrayList<String>();
        for (ModificationMatch mod : modificationMatches) {
            if (!mod.isVariable()) continue;
            if (mod.getTheoreticPtm() != null) {
                if (mod.isConfident() || mod.isInferred()) {
                    tempModifications.add(mod.getTheoreticPtm() + MODIFICATION_LOCALIZATION_SEPARATOR + mod.getModificationSite());
                    continue;
                }
                tempModifications.add(mod.getTheoreticPtm());
                continue;
            }
            tempModifications.add("unknown-modification");
        }
        Collections.sort(tempModifications);
        String result = sequence;
        for (String mod : tempModifications) {
            result = result + MODIFICATION_SEPARATOR + mod;
        }
        return result;
    }

    public static boolean isModified(String peptideKey) {
        return peptideKey.contains(MODIFICATION_SEPARATOR);
    }

    public static boolean isModified(String peptideKey, String modification) {
        return peptideKey.contains(modification);
    }

    public static int getModificationCount(String peptideKey, String modification) {
        String test = peptideKey + MODIFICATION_SEPARATOR;
        return test.split(modification).length - 1;
    }

    public int getNVariableModifications(double modificationMass) {
        int n = 0;
        for (ModificationMatch modificationMatch : this.modifications) {
            PTM ptm;
            if (!modificationMatch.isVariable() || (ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm())).getMass() != modificationMass) continue;
            ++n;
        }
        return n;
    }

    public static ArrayList<Integer> getNModificationLocalized(String peptideKey, String modification) {
        String test = peptideKey;
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean first = true;
        for (String modificationSplit : test.split(MODIFICATION_SEPARATOR)) {
            if (!first) {
                String[] localizationSplit = modificationSplit.split(MODIFICATION_LOCALIZATION_SEPARATOR);
                if (localizationSplit.length != 2 || !localizationSplit[0].equals(modification)) continue;
                try {
                    result.add(Integer.valueOf(localizationSplit[1]));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse modification localization " + localizationSplit.toString() + " for modification " + modification + " in peptide key " + peptideKey);
                }
            }
            first = false;
        }
        return result;
    }

    public static String getSequence(String peptideKey) {
        int index = peptideKey.indexOf(MODIFICATION_SEPARATOR);
        if (index > 0) {
            return peptideKey.substring(0, peptideKey.indexOf(MODIFICATION_SEPARATOR));
        }
        return peptideKey;
    }

    public static ArrayList<String> getModificationFamily(String peptideKey) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parsedKey = peptideKey.split(MODIFICATION_SEPARATOR);
        for (int i = 1; i < parsedKey.length; ++i) {
            String[] parsedMod = parsedKey[i].split(MODIFICATION_LOCALIZATION_SEPARATOR);
            result.add(parsedMod[0]);
        }
        return result;
    }

    public boolean isModifiable(PTM ptm, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        AminoAcidPattern pattern = ptm.getPattern();
        int patternLength = pattern.length();
        switch (ptm.getType()) {
            case 0: {
                int target = pattern.getTarget();
                if (target >= 0 && patternLength - target <= 1) {
                    return pattern.matches(this.sequence);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.matches(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                return true;
            }
            case 5: {
                return true;
            }
            case 3: {
                return !this.isCterm(matchingType, massTolerance).isEmpty();
            }
            case 1: {
                return !this.isNterm(matchingType, massTolerance).isEmpty();
            }
            case 4: {
                if (this.isCterm(matchingType, massTolerance).isEmpty()) {
                    return false;
                }
            }
            case 8: {
                int target = pattern.getTarget();
                if (target == patternLength - 1 && this.sequence.length() >= patternLength) {
                    return pattern.isEnding(this.sequence);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isEnding(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                if (this.isNterm(matchingType, massTolerance).isEmpty()) {
                    return false;
                }
            }
            case 6: {
                int target = pattern.getTarget();
                if (target == 0 && this.sequence.length() >= patternLength) {
                    return pattern.isStarting(this.sequence);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isStarting(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public ArrayList<Integer> getPotentialModificationSites(Double ptmMass, AminoAcidPattern.MatchingType matchingType, Double massTolerance, ModificationProfile modificationProfile) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        ArrayList<Integer> sites = new ArrayList<Integer>();
        for (String ptmName : modificationProfile.getAllNotFixedModifications()) {
            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
            if (!(Math.abs(ptm.getMass() - ptmMass) < massTolerance)) continue;
            for (int site : this.getPotentialModificationSites(ptm, matchingType, massTolerance)) {
                if (sites.contains(site)) continue;
                sites.add(site);
            }
        }
        return sites;
    }

    public ArrayList<Integer> getPotentialModificationSites(PTM ptm, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern pattern = ptm.getPattern();
        int patternLength = pattern.length();
        switch (ptm.getType()) {
            case 0: {
                int target = pattern.getTarget();
                if (target >= 0 && patternLength - target <= 1) {
                    return pattern.getIndexes(this.sequence);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.matches(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        for (int tempIndex : pattern.getIndexes(tempSequence)) {
                            Integer sequenceIndex = tempIndex - target;
                            if (possibleSites.contains(sequenceIndex)) continue;
                            possibleSites.add(tempIndex);
                        }
                    }
                }
                return possibleSites;
            }
            case 3: {
                if (this.isCterm(matchingType, massTolerance).isEmpty()) {
                    return possibleSites;
                }
            }
            case 7: {
                possibleSites.add(this.sequence.length());
                return possibleSites;
            }
            case 1: {
                if (this.isNterm(matchingType, massTolerance).isEmpty()) {
                    return possibleSites;
                }
            }
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: {
                if (this.isCterm(matchingType, massTolerance).isEmpty()) {
                    return possibleSites;
                }
            }
            case 8: {
                int target = pattern.getTarget();
                if (target == patternLength - 1 && this.sequence.length() >= patternLength) {
                    if (pattern.isEnding(this.sequence)) {
                        possibleSites.add(this.sequence.length());
                    }
                    return possibleSites;
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isEnding(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        possibleSites.add(this.sequence.length());
                        return possibleSites;
                    }
                }
                return possibleSites;
            }
            case 2: {
                if (this.isNterm(matchingType, massTolerance).isEmpty()) {
                    return possibleSites;
                }
            }
            case 6: {
                int target = pattern.getTarget();
                if (target == 0 && this.sequence.length() >= patternLength) {
                    if (pattern.isStarting(this.sequence)) {
                        possibleSites.add(1);
                    }
                    return possibleSites;
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, matchingType, massTolerance)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isStarting(tempSequence = protein.getSequence().substring(beginIndex, endIndex))) continue;
                        possibleSites.add(1);
                        return possibleSites;
                    }
                }
                return possibleSites;
            }
        }
        return possibleSites;
    }

    public static ArrayList<Integer> getPotentialModificationSites(String sequence, PTM ptm) throws IllegalArgumentException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern pattern = ptm.getPattern();
        int patternLength = pattern.length();
        switch (ptm.getType()) {
            case 0: {
                int target = pattern.getTarget();
                if (target >= 0 && patternLength - target <= 1) {
                    return pattern.getIndexes(sequence);
                }
                throw new IllegalArgumentException("Pattern " + pattern + " cannot be fully comprised in " + sequence);
            }
            case 3: 
            case 7: {
                possibleSites.add(sequence.length());
                return possibleSites;
            }
            case 1: 
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: 
            case 8: {
                int target = pattern.getTarget();
                if (target == patternLength - 1 && sequence.length() >= patternLength) {
                    if (pattern.isStarting(sequence)) {
                        possibleSites.add(sequence.length());
                    }
                    return possibleSites;
                }
                throw new IllegalArgumentException("Pattern " + pattern + " cannot be fully comprised in " + sequence);
            }
            case 2: 
            case 6: {
                int target = pattern.getTarget();
                if (target == 0 && sequence.length() >= patternLength) {
                    if (pattern.isStarting(sequence)) {
                        possibleSites.add(1);
                    }
                    return possibleSites;
                }
                throw new IllegalArgumentException("Pattern " + pattern + " cannot be fully comprised in " + sequence);
            }
        }
        return possibleSites;
    }

    public boolean isSameSequenceAndModificationStatus(Peptide anotherPeptide, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        return this.isSameSequence(anotherPeptide, matchingType, massTolerance) && this.isSameModificationStatus(anotherPeptide);
    }

    public boolean isSameSequence(Peptide anotherPeptide, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        AminoAcidPattern pattern = new AminoAcidPattern(anotherPeptide.getSequence());
        return pattern.length() == this.sequence.length() && pattern.matches(this.sequence, matchingType, massTolerance);
    }

    public boolean isSameModificationStatus(Peptide anotherPeptide) {
        if (anotherPeptide.getModificationMatches().size() != this.modifications.size()) {
            return false;
        }
        ArrayList<String> modifications1 = Peptide.getModificationFamily(this.getKey());
        Collections.sort(modifications1);
        ArrayList<String> modifications2 = Peptide.getModificationFamily(anotherPeptide.getKey());
        Collections.sort(modifications2);
        for (int i = 0; i < modifications1.size(); ++i) {
            if (modifications1.get(i).equals(modifications2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean sameModificationsAs(Peptide anotherPeptide, ArrayList<String> ptms) {
        int position;
        String modName;
        if (anotherPeptide.getModificationMatches().size() != this.modifications.size()) {
            return false;
        }
        HashMap ptmToPositionsMap1 = new HashMap();
        HashMap ptmToPositionsMap2 = new HashMap();
        for (ModificationMatch modificationMatch : this.modifications) {
            modName = modificationMatch.getTheoreticPtm();
            if (!ptms.contains(modName)) continue;
            if (!ptmToPositionsMap1.containsKey(modName)) {
                ptmToPositionsMap1.put(modName, new ArrayList());
            }
            position = modificationMatch.getModificationSite();
            ((ArrayList)ptmToPositionsMap1.get(modName)).add(position);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getModificationMatches()) {
            modName = modificationMatch.getTheoreticPtm();
            if (!ptms.contains(modName)) continue;
            if (!ptmToPositionsMap2.containsKey(modName)) {
                ptmToPositionsMap2.put(modName, new ArrayList());
            }
            position = modificationMatch.getModificationSite();
            ((ArrayList)ptmToPositionsMap2.get(modName)).add(position);
        }
        for (String modName2 : ptmToPositionsMap1.keySet()) {
            if (!ptmToPositionsMap2.containsKey(modName2)) {
                return false;
            }
            ArrayList sites1 = (ArrayList)ptmToPositionsMap1.get(modName2);
            ArrayList sites2 = (ArrayList)ptmToPositionsMap2.get(modName2);
            if (sites1.size() != sites2.size()) {
                return false;
            }
            Collections.sort(sites1);
            Collections.sort(sites2);
            for (int i = 0; i < sites1.size(); ++i) {
                if (sites1.get(i) == sites2.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameModificationsAs(Peptide anotherPeptide) {
        String modName;
        ArrayList<String> ptms = new ArrayList<String>();
        for (ModificationMatch modificationMatch : this.modifications) {
            modName = modificationMatch.getTheoreticPtm();
            if (ptms.contains(modName)) continue;
            ptms.add(modName);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getModificationMatches()) {
            modName = modificationMatch.getTheoreticPtm();
            if (ptms.contains(modName)) continue;
            ptms.add(modName);
        }
        return this.sameModificationsAs(anotherPeptide, ptms);
    }

    public String getNTerminal() {
        String nTerm = "NH2";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.modifications.size(); ++i) {
            PTM ptm;
            if (this.modifications.get(i).getModificationSite() != 1 || (ptm = ptmFactory.getPTM(this.modifications.get(i).getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
            nTerm = ptmFactory.getShortName(this.modifications.get(i).getTheoreticPtm());
        }
        nTerm = nTerm.replaceAll("-", " ");
        return nTerm;
    }

    public String getCTerminal() {
        String cTerm = "COOH";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.modifications.size(); ++i) {
            PTM ptm;
            if (this.modifications.get(i).getModificationSite() != this.sequence.length() || (ptm = ptmFactory.getPTM(this.modifications.get(i).getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
            cTerm = ptmFactory.getShortName(this.modifications.get(i).getTheoreticPtm());
        }
        cTerm = cTerm.replaceAll("-", " ");
        return cTerm;
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> mainModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        for (ModificationMatch modMatch : this.modifications) {
            String modName = modMatch.getTheoreticPtm();
            int modSite = modMatch.getModificationSite();
            if (modMatch.isVariable()) {
                if (modMatch.isConfident()) {
                    if (!mainModificationSites.containsKey(modSite)) {
                        mainModificationSites.put(modSite, new ArrayList());
                    }
                    mainModificationSites.get(modSite).add(modName);
                    continue;
                }
                if (!secondaryModificationSites.containsKey(modSite)) {
                    secondaryModificationSites.put(modSite, new ArrayList());
                }
                secondaryModificationSites.get(modSite).add(modName);
                continue;
            }
            if (excludeAllFixedPtms) continue;
            if (!fixedModificationSites.containsKey(modSite)) {
                fixedModificationSites.put(modSite, new ArrayList());
            }
            fixedModificationSites.get(modSite).add(modName);
        }
        return Peptide.getTaggedModifiedSequence(modificationProfile, this, mainModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, includeHtmlStartEndTags, useShortName);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        return this.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, false);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, Peptide peptide, HashMap<Integer, ArrayList<String>> mainModificationSites, HashMap<Integer, ArrayList<String>> secondaryModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        if (mainModificationSites == null) {
            mainModificationSites = new HashMap();
        }
        if (secondaryModificationSites == null) {
            secondaryModificationSites = new HashMap();
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap();
        }
        String modifiedSequence = "";
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + peptide.getNTerminal() + "-";
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern(peptide.sequence);
        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedModifiedSequence(modificationProfile, aminoAcidPattern, mainModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
        modifiedSequence = modifiedSequence + "-" + peptide.getCTerminal();
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public ArrayList<Integer> getModifiedIndexes() {
        return this.getModifiedIndexes(true);
    }

    public ArrayList<Integer> getModifiedIndexes(boolean excludeFixed) {
        ArrayList<Integer> modifiedResidues = new ArrayList<Integer>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.sequence.length(); ++i) {
            for (int j = 0; j < this.modifications.size(); ++j) {
                PTM ptm = ptmFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
                if (ptm.getType() != 0 || !this.modifications.get(j).isVariable() && excludeFixed || this.modifications.get(j).getModificationSite() != i + 1) continue;
                modifiedResidues.add(i + 1);
            }
        }
        return modifiedResidues;
    }

    public HashMap<Integer, ArrayList<String>> getIndexedFixedModifications() {
        HashMap<Integer, ArrayList<String>> result = new HashMap<Integer, ArrayList<String>>();
        for (ModificationMatch modificationMatch : this.modifications) {
            if (modificationMatch.isVariable()) continue;
            int aa = modificationMatch.getModificationSite();
            if (!result.containsKey(aa)) {
                result.put(aa, new ArrayList());
            }
            result.get(aa).add(modificationMatch.getTheoreticPtm());
        }
        return result;
    }

    public void estimateTheoreticMass() throws IllegalArgumentException {
        this.mass = Atom.H.getMonoisotopicMass();
        for (int aa = 0; aa < this.sequence.length(); ++aa) {
            try {
                AminoAcid currentAA = AminoAcid.getAminoAcid(this.sequence.charAt(aa));
                if (currentAA != null) {
                    this.mass = this.mass + currentAA.monoisotopicMass;
                    continue;
                }
                System.out.println("Unknown amino acid: " + this.sequence.charAt(aa) + "!");
                continue;
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Unknown amino acid: " + this.sequence.charAt(aa) + "!");
            }
        }
        this.mass = this.mass + (Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass());
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (ModificationMatch ptmMatch : this.modifications) {
            this.mass = this.mass + ptmFactory.getPTM(ptmMatch.getTheoreticPtm()).getMass();
        }
    }

    public ArrayList<String> isNterm(AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentProteins == null) {
            this.getParentProteins(matchingType, massTolerance);
        }
        for (String accession : this.parentProteins) {
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isNTerm(this.sequence, matchingType, massTolerance)) continue;
            result.add(accession);
        }
        return result;
    }

    public ArrayList<String> isCterm(AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentProteins == null) {
            this.getParentProteins(matchingType, massTolerance);
        }
        for (String accession : this.parentProteins) {
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isCTerm(this.sequence, matchingType, massTolerance)) continue;
            result.add(accession);
        }
        return result;
    }

    public AminoAcidPattern getSequenceAsPattern() {
        return Peptide.getSequenceAsPattern(this.sequence);
    }

    public static AminoAcidPattern getSequenceAsPattern(String sequence) {
        return new AminoAcidPattern(sequence);
    }

    public boolean isDecoy(AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        if (this.parentProteins == null) {
            this.getParentProteins(matchingType, massTolerance);
        }
        for (String accession : this.parentProteins) {
            if (!SequenceFactory.getInstance().isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    public static Peptide getNoModPeptide(Peptide peptide, ArrayList<PTM> ptms) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        Peptide noModPeptide = new Peptide(peptide.getSequence(), new ArrayList<ModificationMatch>());
        noModPeptide.setParentProteins(peptide.getParentProteinsNoRemapping());
        for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
            boolean found = false;
            for (PTM ptm : ptms) {
                if (!modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            noModPeptide.addModificationMatch(modificationMatch);
        }
        return noModPeptide;
    }
}

