/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import java.util.ArrayList;

public class PeptideMatch
extends IdentificationMatch {
    static final long serialVersionUID = 7195830246336841081L;
    private Peptide theoreticPeptide;
    private String matchKey;
    private String mainMatchKey;
    private ArrayList<String> spectrumMatches = new ArrayList();
    private Boolean isDecoy = null;

    public PeptideMatch() {
    }

    @Override
    public String getKey() {
        if (this.matchKey == null) {
            return this.theoreticPeptide.getKey();
        }
        return this.matchKey;
    }

    public PeptideMatch(Peptide peptide, String matchKey) {
        this.theoreticPeptide = peptide;
        this.matchKey = matchKey;
    }

    public PeptideMatch(Peptide peptide, String spectrumMatchKey, String matchKey) {
        this.theoreticPeptide = peptide;
        this.mainMatchKey = spectrumMatchKey;
        this.spectrumMatches.add(spectrumMatchKey);
        this.matchKey = matchKey;
    }

    public Peptide getTheoreticPeptide() {
        return this.theoreticPeptide;
    }

    public void setTheoreticPeptide(Peptide theoreticPeptide) {
        this.theoreticPeptide = theoreticPeptide;
    }

    public String getMainMatchKey() {
        return this.mainMatchKey;
    }

    public void setMainMatch(String spectrumMatchKey) {
        this.mainMatchKey = spectrumMatchKey;
    }

    public ArrayList<String> getSpectrumMatches() {
        return this.spectrumMatches;
    }

    public void addSpectrumMatch(String spectrumMatchKey) {
        if (this.spectrumMatches.contains(spectrumMatchKey)) {
            throw new IllegalArgumentException("Trying to add two times the same spectrum match (" + spectrumMatchKey + ") to the same peptide match (" + this.getKey() + ").");
        }
        this.spectrumMatches.add(spectrumMatchKey);
    }

    public int getSpectrumCount() {
        return this.spectrumMatches.size();
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Peptide;
    }
}

